/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.languagetool.Language;
import org.languagetool.language.Contributor;
import org.languagetool.rules.patterns.AbstractPatternRule;

abstract class DynamicLanguage
extends Language {
    protected final String name;
    protected final String code;
    protected final File dictPath;

    DynamicLanguage(String name, String code2, File dictPath) {
        this.name = Objects.requireNonNull(name);
        this.code = Objects.requireNonNull(code2);
        this.dictPath = Objects.requireNonNull(dictPath);
    }

    @Override
    public String getShortCode() {
        return this.code.replaceFirst("-.*", "");
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> getRuleFileNames() {
        return Collections.emptyList();
    }

    @Override
    protected List<AbstractPatternRule> getPatternRules() {
        return Collections.emptyList();
    }

    @Override
    public String getCommonWordsPath() {
        return new File(this.dictPath.getParentFile(), "common_words.txt").getAbsolutePath();
    }

    @Override
    public String[] getCountries() {
        return new String[0];
    }

    @Override
    public Contributor[] getMaintainers() {
        return new Contributor[0];
    }

    @Override
    public boolean isSpellcheckOnlyLanguage() {
        return true;
    }
}

