/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.languagetool.JLanguageTool;

public final class SimpleReplaceDataLoader {
    public Map<String, List<String>> loadWords(String path) {
        InputStream stream = JLanguageTool.getDataBroker().getFromRulesDirAsStream(path);
        HashMap<String, List<String>> map2 = new HashMap<String, List<String>>();
        try (Scanner scanner = new Scanner(stream, "utf-8");){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (line.isEmpty() || line.charAt(0) == '#') continue;
                String[] parts = line.split("=");
                if (parts.length != 2) {
                    throw new RuntimeException("Could not load simple replacement data from: " + path + ". Error in line '" + line + "', expected format 'word=replacement'");
                }
                if (parts[1].trim().isEmpty()) {
                    throw new RuntimeException("Could not load simple replacement data from: " + path + ". Error in line '" + line + "', replacement cannot be empty");
                }
                String[] wrongForms = parts[0].split("\\|");
                List<String> replacements = Arrays.asList(parts[1].split("\\|"));
                for (String wrongForm : wrongForms) {
                    map2.put(wrongForm, replacements);
                }
            }
        }
        return Collections.unmodifiableMap(map2);
    }
}

