/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import org.languagetool.language.NewZealandEnglish;
import org.languagetool.rules.AbstractSimpleReplaceRule2;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;

public class NewZealandReplaceRule
extends AbstractSimpleReplaceRule2 {
    public static final String NEW_ZEALAND_SIMPLE_REPLACE_RULE = "EN_NZ_SIMPLE_REPLACE";
    private static final Locale EN_NZ_LOCALE = new Locale("en-NZ");
    private final String PATH;

    @Override
    public List<String> getFileNames() {
        return Collections.singletonList(this.PATH);
    }

    public NewZealandReplaceRule(ResourceBundle messages, String path) {
        super(messages, new NewZealandEnglish());
        this.PATH = Objects.requireNonNull(path);
        super.setCategory(Categories.STYLE.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.LocaleViolation);
        this.addExamplePair(Example.wrong("A <marker>sidewalk</marker> is a path along the side of a road."), Example.fixed("A <marker>footpath</marker> is a path along the side of a road."));
    }

    @Override
    public final String getId() {
        return NEW_ZEALAND_SIMPLE_REPLACE_RULE;
    }

    @Override
    public String getDescription() {
        return "English words easily confused in New Zealand English";
    }

    @Override
    public String getShort() {
        return "Not a New Zealand English word";
    }

    @Override
    public String getMessage() {
        return "'$match' is a non-standard expression. Consider using expressions more common to New Zealand English.";
    }

    @Override
    public Locale getLocale() {
        return EN_NZ_LOCALE;
    }
}

