/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en;

import com.hankcs.algorithm.AhoCorasickDoubleArrayTrie;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Supplier;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.LinguServices;
import org.languagetool.UserConfig;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.en.MorfologikAmericanSpellerRule;
import org.languagetool.rules.ngrams.Probability;
import org.languagetool.rules.patterns.PatternRuleBuilderHelper;
import org.languagetool.rules.patterns.PatternToken;
import org.languagetool.rules.patterns.PatternTokenBuilder;
import org.languagetool.rules.spelling.CachingWordListLoader;
import org.languagetool.tagging.disambiguation.rules.DisambiguationPatternRule;
import org.languagetool.tools.StringTools;

public class UpperCaseNgramRule
extends Rule {
    public static final int THRESHOLD = 50;
    private static MorfologikAmericanSpellerRule spellerRule;
    private static LinguServices linguServices;
    private static final Set<String> exceptions;
    private static final AhoCorasickDoubleArrayTrie<String> exceptionTrie;
    private static final List<List<PatternToken>> ANTI_PATTERNS;
    private final Language lang;
    private final LanguageModel lm;
    private final Supplier<List<DisambiguationPatternRule>> antiPatterns;

    public UpperCaseNgramRule(ResourceBundle messages, LanguageModel lm, Language lang, UserConfig userConfig) {
        super(messages);
        super.setCategory(Categories.CASING.getCategory(messages));
        this.lm = lm;
        this.lang = lang;
        this.setLocQualityIssueType(ITSIssueType.Misspelling);
        this.addExamplePair(Example.wrong("This <marker>Prototype</marker> was developed by Miller et al."), Example.fixed("This <marker>prototype</marker> was developed by Miller et al."));
        this.antiPatterns = UpperCaseNgramRule.cacheAntiPatterns(lang, ANTI_PATTERNS);
        if (userConfig != null && linguServices == null) {
            linguServices = userConfig.getLinguServices();
            this.initTrie();
        }
        if (spellerRule == null) {
            this.initTrie();
            try {
                spellerRule = new MorfologikAmericanSpellerRule(messages, lang);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initTrie() {
        CachingWordListLoader cachingWordListLoader = new CachingWordListLoader();
        ArrayList<String> words = new ArrayList<String>();
        words.addAll(cachingWordListLoader.loadWords("en/specific_case.txt"));
        words.addAll(cachingWordListLoader.loadWords("spelling_global.txt"));
        HashMap<String, String> map2 = new HashMap<String, String>();
        for (String word : words) {
            map2.put(word, word);
        }
        AhoCorasickDoubleArrayTrie<String> ahoCorasickDoubleArrayTrie = exceptionTrie;
        synchronized (ahoCorasickDoubleArrayTrie) {
            exceptionTrie.build(map2);
        }
    }

    @Override
    public List<DisambiguationPatternRule> getAntiPatterns() {
        return this.antiPatterns.get();
    }

    @Override
    public final String getId() {
        return "EN_UPPER_CASE_NGRAM";
    }

    @Override
    public String getDescription() {
        return "Checks wrong uppercase spelling of words that are not proper nouns";
    }

    @Override
    public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        ArrayList<RuleMatch> matches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = this.getSentenceWithImmunization(sentence).getTokensWithoutWhitespace();
        boolean atSentStart = true;
        boolean isSentence = this.isSentence(tokens);
        if (!isSentence) {
            return this.toRuleMatchArray(matches);
        }
        for (int i2 = 0; i2 < tokens.length; ++i2) {
            AnalyzedTokenReadings token = tokens[i2];
            String tokenStr = token.getToken();
            if (!(tokenStr.length() <= 0 || token.isImmunized() || !Character.isUpperCase(tokenStr.charAt(0)) || StringTools.isAllUppercase(tokenStr) || atSentStart || !token.hasPosTagStartingWith("VB") || token.hasPosTagStartingWith("NNP") || !token.isTagged() || this.prevIsUpperCase(tokens, i2) && (!this.prevIsUpperCase(tokens, i2) || i2 != 2) || this.nextIsUpperCase(tokens, i2) || this.prevIsOneOf(tokens, i2, Arrays.asList(":", "n\u00e9e", "of", "\"", "'")) || this.nextIsOneOfThenUppercase(tokens, i2, Arrays.asList("of")) || tokenStr.matches("I") || exceptions.contains(tokenStr) || this.trieMatches(sentence.getText(), token) || this.maybeTitle(tokens, i2) || this.isMisspelled(StringTools.lowercaseFirstChar(tokenStr)) || i2 + 1 >= tokens.length)) {
                List<String> ucList = Arrays.asList(tokens[i2 - 1].getToken(), tokenStr, tokens[i2 + 1].getToken());
                List<String> lcList = Arrays.asList(tokens[i2 - 1].getToken(), StringTools.lowercaseFirstChar(tokenStr), tokens[i2 + 1].getToken());
                Probability ucProb = this.lm.getPseudoProbability(ucList);
                Probability lcProb = this.lm.getPseudoProbability(lcList);
                double ratio = lcProb.getProb() / ucProb.getProb();
                if (ratio > 50.0) {
                    String msg = "Only proper nouns start with an uppercase character (there are exceptions for headlines).";
                    RuleMatch match = new RuleMatch(this, sentence, token.getStartPos(), token.getEndPos(), msg);
                    match.setSuggestedReplacement(StringTools.lowercaseFirstChar(tokenStr));
                    matches.add(match);
                }
            }
            if (token.isSentenceStart() || tokenStr.isEmpty() || token.isNonWord()) continue;
            atSentStart = false;
        }
        return this.toRuleMatchArray(matches);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isMisspelled(String word) throws IOException {
        MorfologikAmericanSpellerRule morfologikAmericanSpellerRule = spellerRule;
        synchronized (morfologikAmericanSpellerRule) {
            return linguServices == null ? spellerRule.isMisspelled(word) : !linguServices.isCorrectSpell(word, this.lang);
        }
    }

    boolean maybeTitle(AnalyzedTokenReadings[] tokens, int i2) {
        return this.firstLongWordToLeftIsUppercase(tokens, i2) || this.firstLongWordToRightIsUppercase(tokens, i2);
    }

    boolean firstLongWordToLeftIsUppercase(AnalyzedTokenReadings[] tokens, int pos) {
        for (int i2 = pos - 1; i2 > 1; --i2) {
            if (this.isShortWord(tokens[i2])) continue;
            return StringTools.startsWithUppercase(tokens[i2].getToken());
        }
        return false;
    }

    boolean firstLongWordToRightIsUppercase(AnalyzedTokenReadings[] tokens, int pos) {
        for (int i2 = pos + 1; i2 < tokens.length; ++i2) {
            if (this.isShortWord(tokens[i2])) continue;
            return StringTools.startsWithUppercase(tokens[i2].getToken());
        }
        return false;
    }

    private boolean isShortWord(AnalyzedTokenReadings token) {
        return token.getToken().trim().isEmpty() || token.getToken().matches("and|or|the|of|on|with|to|it|in|for|as|at|his|her|its|into|&|/");
    }

    private boolean trieMatches(String text2, AnalyzedTokenReadings token) {
        List<AhoCorasickDoubleArrayTrie.Hit<String>> hits = exceptionTrie.parseText(text2);
        for (AhoCorasickDoubleArrayTrie.Hit<String> hit : hits) {
            if (hit.begin > token.getStartPos() || hit.end < token.getEndPos()) continue;
            return true;
        }
        return false;
    }

    private boolean prevIsOneOf(AnalyzedTokenReadings[] tokens, int i2, List<String> strings) {
        return i2 > 0 && strings.contains(tokens[i2 - 1].getToken());
    }

    private boolean nextIsOneOfThenUppercase(AnalyzedTokenReadings[] tokens, int i2, List<String> strings) {
        return i2 + 2 < tokens.length && strings.contains(tokens[i2 + 1].getToken()) && StringTools.startsWithUppercase(tokens[i2 + 2].getToken());
    }

    private boolean prevIsUpperCase(AnalyzedTokenReadings[] tokens, int i2) {
        return i2 > 0 && StringTools.startsWithUppercase(tokens[i2 - 1].getToken());
    }

    private boolean nextIsUpperCase(AnalyzedTokenReadings[] tokens, int i2) {
        return i2 + 1 < tokens.length && StringTools.startsWithUppercase(tokens[i2 + 1].getToken());
    }

    private boolean isSentence(AnalyzedTokenReadings[] tokens) {
        boolean isSentence = false;
        for (int i2 = tokens.length - 1; i2 > 0; --i2) {
            if (tokens[i2].getToken().matches("[.!?:]")) {
                isSentence = true;
                break;
            }
            if (!tokens[i2].isParagraphEnd() && !tokens[i2].isNonWord()) break;
        }
        return isSentence;
    }

    static {
        linguServices = null;
        exceptions = new HashSet<String>(Arrays.asList("Bin", "Spot", "Go", "French", "Roman", "Hawking", "Square", "Japan", "Premier", "Allied"));
        exceptionTrie = new AhoCorasickDoubleArrayTrie();
        ANTI_PATTERNS = Arrays.asList(Arrays.asList(PatternRuleBuilderHelper.token("Hugs"), PatternRuleBuilderHelper.token("and"), PatternRuleBuilderHelper.token("Kisses")), Arrays.asList(PatternRuleBuilderHelper.token("go"), PatternRuleBuilderHelper.token("to"), PatternRuleBuilderHelper.tokenRegex("[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex("[A-Z].+"), PatternRuleBuilderHelper.token(","), PatternRuleBuilderHelper.tokenRegex("[Aa]nd|[Oo]r|&"), PatternRuleBuilderHelper.tokenRegex("[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex("[A-Z].+"), PatternRuleBuilderHelper.token(","), PatternRuleBuilderHelper.tokenRegex("[A-Z].+"), PatternRuleBuilderHelper.tokenRegex("[Aa]nd|[Oo]r|&|,"), PatternRuleBuilderHelper.tokenRegex("[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex("[A-Z].+"), PatternRuleBuilderHelper.token(")"), PatternRuleBuilderHelper.token(","), PatternRuleBuilderHelper.tokenRegex("[A-Z].+"), PatternRuleBuilderHelper.tokenRegex("[Aa]nd|[Oo]r|&|,"), PatternRuleBuilderHelper.tokenRegex("[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.csRegex("[A-Z].+"), new PatternTokenBuilder().token("-").min(0).build(), PatternRuleBuilderHelper.token(">"), PatternRuleBuilderHelper.csRegex("[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.csRegex("[A-Z].+"), PatternRuleBuilderHelper.tokenRegex("[\u2192\u21fe\u21c9\u21d2]"), PatternRuleBuilderHelper.csRegex("[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.pos("SENT_START"), PatternRuleBuilderHelper.tokenRegex("[A-Z].+"), PatternRuleBuilderHelper.tokenRegex("[A-Z].+"), PatternRuleBuilderHelper.tokenRegex("[\\!\\?]")), Arrays.asList(PatternRuleBuilderHelper.pos("SENT_START"), PatternRuleBuilderHelper.tokenRegex(".*\\w.*"), PatternRuleBuilderHelper.tokenRegex("-|\u2013"), PatternRuleBuilderHelper.tokenRegex("[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.pos("SENT_START"), PatternRuleBuilderHelper.tokenRegex(".*\\w.*"), PatternRuleBuilderHelper.tokenRegex("[0-9]+"), PatternRuleBuilderHelper.tokenRegex("-|\u2013"), PatternRuleBuilderHelper.tokenRegex("[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.pos("SENT_START"), PatternRuleBuilderHelper.token("#"), PatternRuleBuilderHelper.tokenRegex("[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.pos("SENT_START"), PatternRuleBuilderHelper.token("#"), PatternRuleBuilderHelper.token("#"), PatternRuleBuilderHelper.tokenRegex("[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.pos("SENT_START"), PatternRuleBuilderHelper.token("#"), PatternRuleBuilderHelper.token("#"), PatternRuleBuilderHelper.token("#"), PatternRuleBuilderHelper.tokenRegex("[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex("[A-Z].+"), PatternRuleBuilderHelper.tokenRegex("\\d+"), PatternRuleBuilderHelper.tokenRegex("-|\u2013|,"), PatternRuleBuilderHelper.tokenRegex("[A-Z].+"), PatternRuleBuilderHelper.tokenRegex("\\d+")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex("\\d+"), PatternRuleBuilderHelper.token("."), PatternRuleBuilderHelper.tokenRegex("-|\u2013"), PatternRuleBuilderHelper.tokenRegex("[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex("\u00ab"), PatternRuleBuilderHelper.tokenRegex("[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex("H[1-6]"), PatternRuleBuilderHelper.tokenRegex("[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.pos("SENT_START"), PatternRuleBuilderHelper.tokenRegex("[a-z]{1,2}"), PatternRuleBuilderHelper.token(")"), PatternRuleBuilderHelper.tokenRegex("[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.pos("SENT_START"), PatternRuleBuilderHelper.token("\u2022"), PatternRuleBuilderHelper.tokenRegex("[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex("-|\u2013"), PatternRuleBuilderHelper.tokenRegex("[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex("Step|Grade|Phase|Reason"), PatternRuleBuilderHelper.tokenRegex("\\d+")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex("the|our|their"), PatternRuleBuilderHelper.tokenRegex("[A-Z].+"), PatternRuleBuilderHelper.tokenRegex("team|department")), Arrays.asList(PatternRuleBuilderHelper.pos("SENT_START"), PatternRuleBuilderHelper.tokenRegex("\\d+"), PatternRuleBuilderHelper.tokenRegex("\\.|/"), PatternRuleBuilderHelper.tokenRegex("\\d+"), PatternRuleBuilderHelper.tokenRegex("[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.pos("SENT_START"), PatternRuleBuilderHelper.tokenRegex(".*\\w.*"), PatternRuleBuilderHelper.token("#"), PatternRuleBuilderHelper.tokenRegex("[0-9]+"), PatternRuleBuilderHelper.tokenRegex("-|\u2013"), PatternRuleBuilderHelper.tokenRegex("[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.token("BBC"), PatternRuleBuilderHelper.token("Culture")), Arrays.asList(PatternRuleBuilderHelper.token("Time"), PatternRuleBuilderHelper.tokenRegex("magazines?")), Arrays.asList(PatternRuleBuilderHelper.token("Dublin"), PatternRuleBuilderHelper.token("Murders")), Arrays.asList(PatternRuleBuilderHelper.token("Amazon"), PatternRuleBuilderHelper.token("Live")), Arrays.asList(PatternRuleBuilderHelper.token("Volvo"), PatternRuleBuilderHelper.token("Buses")), Arrays.asList(PatternRuleBuilderHelper.token("Heavy"), PatternRuleBuilderHelper.token("Rain")), Arrays.asList(PatternRuleBuilderHelper.csRegex("[A-Z].+"), PatternRuleBuilderHelper.token("/"), PatternRuleBuilderHelper.csRegex("[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.csRegex("[A-Z].+"), PatternRuleBuilderHelper.token("#"), PatternRuleBuilderHelper.tokenRegex("\\d+")), Arrays.asList(PatternRuleBuilderHelper.csRegex("[A-Z].+"), PatternRuleBuilderHelper.token("."), PatternRuleBuilderHelper.tokenRegex("com?|de|us|gov|net|info|org|es|mx|ca|uk|at|ch|it|pl|ru|nl|ie|be|fr|ai|dev|io|pt|mil|club|jp|es|se|dk|no")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex("[A-Z].+"), PatternRuleBuilderHelper.token("("), PatternRuleBuilderHelper.tokenRegex("[A-Z].+"), PatternRuleBuilderHelper.token(")")), Arrays.asList(PatternRuleBuilderHelper.token("["), PatternRuleBuilderHelper.tokenRegex("[A-Z].+"), PatternRuleBuilderHelper.token("]")), Arrays.asList(PatternRuleBuilderHelper.token("Pay"), PatternRuleBuilderHelper.token("per"), PatternRuleBuilderHelper.tokenRegex("[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex("Hi|Hello|Heya?"), PatternRuleBuilderHelper.token(","), PatternRuleBuilderHelper.tokenRegex("[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex("[A-Z]"), PatternRuleBuilderHelper.tokenRegex("is|stands"), PatternRuleBuilderHelper.token("for"), PatternRuleBuilderHelper.tokenRegex("[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.pos("SENT_START"), PatternRuleBuilderHelper.tokenRegex("[A-Z].+"), PatternRuleBuilderHelper.tokenRegex("[A-Z].+"), PatternRuleBuilderHelper.token(":")), Arrays.asList(PatternRuleBuilderHelper.pos("SENT_START"), PatternRuleBuilderHelper.tokenRegex("[A-Z].+"), PatternRuleBuilderHelper.token("&"), PatternRuleBuilderHelper.tokenRegex("[A-Z].+"), PatternRuleBuilderHelper.token(":")), Arrays.asList(PatternRuleBuilderHelper.pos("SENT_START"), PatternRuleBuilderHelper.tokenRegex("[A-Z].+"), PatternRuleBuilderHelper.tokenRegex("[a-z].+"), PatternRuleBuilderHelper.tokenRegex("[A-Z].+"), PatternRuleBuilderHelper.token(":")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex("[A-Z].+"), PatternRuleBuilderHelper.tokenRegex("\\d+%?"), PatternRuleBuilderHelper.tokenRegex("[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex("[0-9]+"), PatternRuleBuilderHelper.tokenRegex("[)\\]]"), PatternRuleBuilderHelper.tokenRegex("[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex("[a-z]"), PatternRuleBuilderHelper.tokenRegex("[)\\]]"), PatternRuleBuilderHelper.tokenRegex("[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex("[\\(\\]]"), PatternRuleBuilderHelper.tokenRegex("[a-z0-9]"), PatternRuleBuilderHelper.tokenRegex("[)\\]]")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex("[A-Z].+"), PatternRuleBuilderHelper.tokenRegex("[0-9]+"), PatternRuleBuilderHelper.tokenRegex("."), PatternRuleBuilderHelper.tokenRegex("[0-9]+")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex("[A-Z].*"), PatternRuleBuilderHelper.tokenRegex("['\u2019`\u00b4\u2018]"), PatternRuleBuilderHelper.tokenRegex("t|d|ve|s|re|m|ll"), PatternRuleBuilderHelper.tokenRegex("[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex("[A-Z].+"), PatternRuleBuilderHelper.token(","), PatternRuleBuilderHelper.tokenRegex("[A-Z].+"), PatternRuleBuilderHelper.token(","), PatternRuleBuilderHelper.tokenRegex("[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex("The"), PatternRuleBuilderHelper.tokenRegex("[A-Z].+"), PatternRuleBuilderHelper.token("is"), PatternRuleBuilderHelper.tokenRegex("[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.token("Professor"), PatternRuleBuilderHelper.tokenRegex("[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.token("Time"), PatternRuleBuilderHelper.token("magazine")), Arrays.asList(PatternRuleBuilderHelper.token("name"), PatternRuleBuilderHelper.token("is"), PatternRuleBuilderHelper.tokenRegex("[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex("calls?|called|calling|name[ds]?|naming"), PatternRuleBuilderHelper.token("it|him|her|them|me|us|that|this"), PatternRuleBuilderHelper.tokenRegex("[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex("some(thing|body|one)"), PatternRuleBuilderHelper.tokenRegex("called|named"), PatternRuleBuilderHelper.csRegex("[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.csRegex("is|was|been|were|are"), PatternRuleBuilderHelper.csRegex("calls?|called|calling|name[ds]?|naming"), PatternRuleBuilderHelper.csRegex("[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex("Who|What"), PatternRuleBuilderHelper.tokenRegex("is|are|was|were"), PatternRuleBuilderHelper.tokenRegex("[A-Z].+"), PatternRuleBuilderHelper.token("?")), Arrays.asList(PatternRuleBuilderHelper.token("name"), PatternRuleBuilderHelper.tokenRegex("is|was"), PatternRuleBuilderHelper.tokenRegex("[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex("[A-Z].*"), PatternRuleBuilderHelper.token("Group")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex("Enter|Escape|Shift|Control|Meta|Backspace"), PatternRuleBuilderHelper.token("key")), Arrays.asList(PatternRuleBuilderHelper.pos("NNP"), PatternRuleBuilderHelper.tokenRegex("or|and|&"), PatternRuleBuilderHelper.tokenRegex("[A-Z].*")), Arrays.asList(PatternRuleBuilderHelper.token("#"), PatternRuleBuilderHelper.tokenRegex("[A-Z].*")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex("Teams|Maps|Canvas|Remind|Tile|Switch|Gems?|Glamour|Divvy|Solo|Splash|Phrase||Spotlight|Outreach|Grab")), Arrays.asList(PatternRuleBuilderHelper.pos("SENT_START"), PatternRuleBuilderHelper.tokenRegex("[A-Z].*"), PatternRuleBuilderHelper.tokenRegex("or|and|&"), PatternRuleBuilderHelper.tokenRegex("[A-Z].*"), PatternRuleBuilderHelper.pos("SENT_END")), Arrays.asList(PatternRuleBuilderHelper.csRegex("click(ed|s)?|type(d|s)|hit"), PatternRuleBuilderHelper.tokenRegex("[A-Z].*")), Arrays.asList(PatternRuleBuilderHelper.csRegex("click(ed|s)?"), PatternRuleBuilderHelper.tokenRegex("on|at"), PatternRuleBuilderHelper.tokenRegex("[A-Z].*")), Arrays.asList(PatternRuleBuilderHelper.csRegex("Chronicle"), PatternRuleBuilderHelper.token("of"), PatternRuleBuilderHelper.tokenRegex("the|an?"), PatternRuleBuilderHelper.tokenRegex("[A-Z].*")), Arrays.asList(PatternRuleBuilderHelper.csRegex("[A-Z].*"), PatternRuleBuilderHelper.tokenRegex("\\d+")), Arrays.asList(PatternRuleBuilderHelper.csRegex("[A-Z].*"), PatternRuleBuilderHelper.token("#"), PatternRuleBuilderHelper.tokenRegex("\\d+")), Arrays.asList(PatternRuleBuilderHelper.csRegex("Finance|Marketing|Engineering|Controlling|Support|Accounting")), Arrays.asList(PatternRuleBuilderHelper.csRegex("[A-Z].*"), PatternRuleBuilderHelper.token("."), PatternRuleBuilderHelper.tokenRegex("js")), Arrays.asList(PatternRuleBuilderHelper.csRegex("Wed")), Arrays.asList(new PatternTokenBuilder().posRegex("NN.*").csTokenRegex("[A-Z].+").build(), PatternRuleBuilderHelper.token("'s"), PatternRuleBuilderHelper.csRegex("[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.csRegex("How"), PatternRuleBuilderHelper.csRegex("to"), new PatternTokenBuilder().pos("VB").csTokenRegex("[A-Z].+").build(), PatternRuleBuilderHelper.csRegex("an?|my|y?our|her|his|the|from|by|about"), PatternRuleBuilderHelper.csRegex("[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.csRegex("Do|Does|Did|Can|[CW]ould"), PatternRuleBuilderHelper.csRegex("n't"), new PatternTokenBuilder().pos("VB").csTokenRegex("[A-Z].+").build(), PatternRuleBuilderHelper.pos("IN"), PatternRuleBuilderHelper.csRegex("[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.csRegex("Let"), PatternRuleBuilderHelper.csRegex("'s"), new PatternTokenBuilder().pos("VB").csTokenRegex("[A-Z].+").build(), PatternRuleBuilderHelper.pos("IN"), PatternRuleBuilderHelper.csRegex("[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.csRegex("Enter|Return|Escape|Shift")), Arrays.asList(PatternRuleBuilderHelper.csRegex("[A-Z].+"), PatternRuleBuilderHelper.csRegex("Ca|Wo|Do|Should|[CW]ould|Must|Did|Does|Need"), PatternRuleBuilderHelper.csRegex("n't"), PatternRuleBuilderHelper.csRegex("[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.csRegex("Ca|Wo|Do|Should|[CW]ould|Must|Did|Does|Need"), PatternRuleBuilderHelper.csRegex("n't"), PatternRuleBuilderHelper.csRegex("[A-Z].+")));
    }
}

