/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.extensions;

import com.intellij.openapi.application.PathManager;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.extensions.CodeFenceGeneratingProvider;
import org.intellij.plugins.markdown.ui.preview.html.MarkdownCodeFencePluginCacheCollector;
import org.intellij.plugins.markdown.ui.preview.html.MarkdownUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\b\u001a\u00020\tJ\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fR\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004\u00a8\u0006\u000f"}, d2={"Lorg/intellij/plugins/markdown/extensions/MarkdownCodeFenceCacheableProvider;", "Lorg/intellij/plugins/markdown/extensions/CodeFenceGeneratingProvider;", "collector", "Lorg/intellij/plugins/markdown/ui/preview/html/MarkdownCodeFencePluginCacheCollector;", "(Lorg/intellij/plugins/markdown/ui/preview/html/MarkdownCodeFencePluginCacheCollector;)V", "getCollector", "()Lorg/intellij/plugins/markdown/ui/preview/html/MarkdownCodeFencePluginCacheCollector;", "setCollector", "getCacheRootPath", "Ljava/nio/file/Path;", "getUniqueFile", "language", "", "text", "extension", "intellij.markdown.core"})
public abstract class MarkdownCodeFenceCacheableProvider
implements CodeFenceGeneratingProvider {
    @Nullable
    private MarkdownCodeFencePluginCacheCollector collector;

    @NotNull
    public final Path getCacheRootPath() {
        Path path = Paths.get(PathManager.getSystemPath(), "markdown", this.getClass().getSimpleName()).toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"Paths.get(PathManager.ge\u2026pleName).toAbsolutePath()");
        return path;
    }

    @NotNull
    public final Path getUniqueFile(@NotNull String language, @NotNull String text, @NotNull String extension) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        MarkdownCodeFencePluginCacheCollector markdownCodeFencePluginCacheCollector = this.collector;
        String collectorKey = MarkdownUtil.INSTANCE.md5(markdownCodeFencePluginCacheCollector != null && (markdownCodeFencePluginCacheCollector = markdownCodeFencePluginCacheCollector.getFile()) != null ? markdownCodeFencePluginCacheCollector.getPath() : null, "markdown-md5-file-path");
        String fileKey = MarkdownUtil.INSTANCE.md5(text, language + "." + extension);
        Path path = this.getCacheRootPath().resolve(collectorKey).resolve(fileKey + "." + extension);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getCacheRootPath().resol\u2026ve(\"$fileKey.$extension\")");
        return path;
    }

    @Nullable
    public final MarkdownCodeFencePluginCacheCollector getCollector() {
        return this.collector;
    }

    public final void setCollector(@Nullable MarkdownCodeFencePluginCacheCollector markdownCodeFencePluginCacheCollector) {
        this.collector = markdownCodeFencePluginCacheCollector;
    }

    public MarkdownCodeFenceCacheableProvider(@Nullable MarkdownCodeFencePluginCacheCollector collector) {
        this.collector = collector;
    }

    @Override
    public void onLaFChanged() {
        CodeFenceGeneratingProvider.DefaultImpls.onLaFChanged(this);
    }
}

