/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.extensions.common.plantuml;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.extensions.MarkdownBrowserPreviewExtension;
import org.intellij.plugins.markdown.extensions.MarkdownCodeFenceCacheableProvider;
import org.intellij.plugins.markdown.extensions.MarkdownExtensionWithDownloadableFiles;
import org.intellij.plugins.markdown.extensions.common.plantuml.PlantUMLCodeGeneratingProvider;
import org.intellij.plugins.markdown.extensions.common.plantuml.PlantUMLJarManager;
import org.intellij.plugins.markdown.ui.preview.MarkdownHtmlPanel;
import org.intellij.plugins.markdown.ui.preview.html.MarkdownCodeFencePluginCacheCollector;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u0000 *2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001*B\u0011\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\bH\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010 \u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001aH\u0002J \u0010#\u001a\u00020\b2\u0006\u0010$\u001a\u00020\b2\u0006\u0010%\u001a\u00020\b2\u0006\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020)2\u0006\u0010$\u001a\u00020\bH\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0010R\u0014\u0010\u0014\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\n\u00a8\u0006+"}, d2={"Lorg/intellij/plugins/markdown/extensions/common/plantuml/PlantUMLCodeGeneratingProvider;", "Lorg/intellij/plugins/markdown/extensions/MarkdownCodeFenceCacheableProvider;", "Lorg/intellij/plugins/markdown/extensions/MarkdownExtensionWithDownloadableFiles;", "Lorg/intellij/plugins/markdown/extensions/MarkdownBrowserPreviewExtension$Provider;", "collector", "Lorg/intellij/plugins/markdown/ui/preview/html/MarkdownCodeFencePluginCacheCollector;", "(Lorg/intellij/plugins/markdown/ui/preview/html/MarkdownCodeFencePluginCacheCollector;)V", "description", "", "getDescription", "()Ljava/lang/String;", "displayName", "getDisplayName", "externalFiles", "", "getExternalFiles", "()Ljava/lang/Iterable;", "filesToDownload", "Lorg/intellij/plugins/markdown/extensions/MarkdownExtensionWithDownloadableFiles$FileEntry;", "getFilesToDownload", "id", "getId", "beforeCleanup", "", "cacheDiagram", "path", "Ljava/io/File;", "text", "createBrowserExtension", "Lorg/intellij/plugins/markdown/extensions/MarkdownBrowserPreviewExtension;", "panel", "Lorg/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanel;", "generateDiagram", "", "diagramPath", "generateHtml", "language", "raw", "node", "Lorg/intellij/markdown/ast/ASTNode;", "isApplicable", "", "Companion", "intellij.markdown.core"})
@ApiStatus.Internal
public final class PlantUMLCodeGeneratingProvider
extends MarkdownCodeFenceCacheableProvider
implements MarkdownExtensionWithDownloadableFiles,
MarkdownBrowserPreviewExtension.Provider {
    @NotNull
    private final String id;
    @NotNull
    public static final String jarFilename = "plantuml.jar";
    private static final List<String> ownFiles;
    private static final List<MarkdownExtensionWithDownloadableFiles.FileEntry> dowloadableFiles;
    @NotNull
    public static final Companion Companion;

    @Override
    @NotNull
    public Iterable<String> getExternalFiles() {
        return ownFiles;
    }

    @Override
    @NotNull
    public Iterable<MarkdownExtensionWithDownloadableFiles.FileEntry> getFilesToDownload() {
        return dowloadableFiles;
    }

    @Override
    public boolean isApplicable(@NotNull String language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        return this.isEnabled() && this.isAvailable() && (Intrinsics.areEqual((Object)language, (Object)"puml") || Intrinsics.areEqual((Object)language, (Object)"plantuml"));
    }

    @Override
    @NotNull
    public String generateHtml(@NotNull String language, @NotNull String raw, @NotNull ASTNode node) {
        File key;
        block0: {
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            File file = key = this.getUniqueFile(language, raw, "png").toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"key");
            this.cacheDiagram(file, raw);
            MarkdownCodeFencePluginCacheCollector markdownCodeFencePluginCacheCollector = this.getCollector();
            if (markdownCodeFencePluginCacheCollector == null) break block0;
            MarkdownCodeFencePluginCacheCollector.addAliveCachedFile$default(markdownCodeFencePluginCacheCollector, this, key, 0L, 4, null);
        }
        return "<img src=\"" + key.toURI() + "\"/>";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = MarkdownBundle.message("markdown.extensions.plantuml.display.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MarkdownBundle.message(\"\u2026s.plantuml.display.name\")");
        return string;
    }

    @Override
    @NotNull
    public String getDescription() {
        String string = MarkdownBundle.message("markdown.extensions.plantuml.description", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MarkdownBundle.message(\"\u2026ns.plantuml.description\")");
        return string;
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    public void beforeCleanup() {
        PlantUMLJarManager.Companion.getInstance().dropCache();
    }

    @Override
    @Nullable
    public MarkdownBrowserPreviewExtension createBrowserExtension(@NotNull MarkdownHtmlPanel panel2) {
        Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
        return null;
    }

    private final void cacheDiagram(File path, String text) {
        if (!path.exists()) {
            this.generateDiagram(text, path);
        }
    }

    private final void generateDiagram(CharSequence text, File diagramPath) throws IOException {
        String string = ((Object)text).toString();
        Object innerText = ((Object)StringsKt.trim((CharSequence)string)).toString();
        if (!StringsKt.startsWith$default((String)innerText, (String)"@startuml", (boolean)false, (int)2, null)) {
            innerText = "@startuml\n" + (String)innerText;
        }
        if (!StringsKt.endsWith$default((String)innerText, (String)"@enduml", (boolean)false, (int)2, null)) {
            innerText = (String)innerText + "\n@enduml";
        }
        FileUtil.createParentDirs((File)diagramPath);
        PlantUMLCodeGeneratingProvider.Companion.storeDiagram((String)innerText, diagramPath);
    }

    public PlantUMLCodeGeneratingProvider(@Nullable MarkdownCodeFencePluginCacheCollector collector) {
        super(collector);
        this.id = "PlantUMLLanguageExtension";
    }

    public /* synthetic */ PlantUMLCodeGeneratingProvider(MarkdownCodeFencePluginCacheCollector markdownCodeFencePluginCacheCollector, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            markdownCodeFencePluginCacheCollector = null;
        }
        this(markdownCodeFencePluginCacheCollector);
    }

    public PlantUMLCodeGeneratingProvider() {
        this(null, 1, null);
    }

    static {
        Companion = new Companion(null);
        ownFiles = CollectionsKt.listOf((Object)jarFilename);
        dowloadableFiles = CollectionsKt.listOf((Object)new MarkdownExtensionWithDownloadableFiles.FileEntry(jarFilename, Companion.dowloadableFiles.1.INSTANCE));
    }

    @Override
    public boolean downloadFiles(@Nullable Project project) {
        return MarkdownExtensionWithDownloadableFiles.DefaultImpls.downloadFiles(this, project);
    }

    @Override
    public boolean isAvailable() {
        return MarkdownExtensionWithDownloadableFiles.DefaultImpls.isAvailable(this);
    }

    @Override
    public boolean isEnabled() {
        return MarkdownExtensionWithDownloadableFiles.DefaultImpls.isEnabled(this);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/intellij/plugins/markdown/extensions/common/plantuml/PlantUMLCodeGeneratingProvider$Companion;", "", "()V", "dowloadableFiles", "", "Lorg/intellij/plugins/markdown/extensions/MarkdownExtensionWithDownloadableFiles$FileEntry;", "jarFilename", "", "ownFiles", "storeDiagram", "", "source", "file", "Ljava/io/File;", "intellij.markdown.core"})
    public static final class Companion {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void storeDiagram(String source, File file) {
            try {
                Object object = file;
                object = new FileOutputStream((File)object);
                int n = 8192;
                object = object instanceof BufferedOutputStream ? (BufferedOutputStream)object : new BufferedOutputStream((OutputStream)object, n);
                Throwable throwable = null;
                try {
                    BufferedOutputStream it = (BufferedOutputStream)object;
                    boolean bl = false;
                    PlantUMLJarManager.Companion.getInstance().generateImage(source, it);
                    it = Unit.INSTANCE;
                }
                catch (Throwable it) {
                    throwable = it;
                    throw it;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            }
            catch (Exception exception) {
                Companion $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(Companion.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
                logger.warn("Cannot save diagram PlantUML diagram. ", (Throwable)exception);
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

