/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.frontmatter.header;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.testFramework.LightVirtualFile;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.SchemaType;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.frontmatter.FrontMatterBundle;
import org.intellij.plugins.markdown.lang.parser.frontmatter.FrontMatterHeaderMarkerProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLFileType;
import org.jetbrains.yaml.YAMLLanguage;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u0016J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/intellij/plugins/markdown/frontmatter/header/FrontMatterHeaderJsonSchemaFileProvider;", "Lcom/jetbrains/jsonSchema/extension/JsonSchemaFileProvider;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getName", "", "getSchemaFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getSchemaType", "Lcom/jetbrains/jsonSchema/extension/SchemaType;", "isAvailable", "", "file", "isInjectedFrontMatter", "Companion", "intellij.markdown.frontmatter"})
public final class FrontMatterHeaderJsonSchemaFileProvider
implements JsonSchemaFileProvider {
    private final Project project;
    private static final String schema = "\n    {\n      \"properties\": {\n        \"title\": {\n          \"type\": \"string\"\n        },\n        \"layout\": {\n          \"type\": [\"string\", \"null\"]\n        },\n        \"permalink\": {\n          \"type\": \"string\"\n        },\n        \"published\": {\n          \"type\": \"boolean\"\n        },\n        \"date\": {\n          \"type\": \"string\"\n        },\n        \"category\": {\n          \"type\": \"string\"\n        },\n        \"categories\": {\n          \"type\": \"array\",\n          \"items\": {\n            \"type\": \"string\"\n          },\n          \"uniqueItems\": true\n        },\n        \"tags\": {\n          \"type\": \"array\",\n          \"items\": {\n            \"type\": \"string\"\n          },\n          \"uniqueItems\": true\n        }\n      }\n    }\n    ";
    @NotNull
    public static final Companion Companion = new Companion(null);

    public boolean isAvailable(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!FrontMatterHeaderMarkerProvider.Companion.isFrontMatterSupportEnabled()) {
            return false;
        }
        if (!FileTypeManager.getInstance().isFileOfType(file, (FileType)YAMLFileType.YML)) {
            return false;
        }
        boolean $i$f$runReadAction = false;
        return (Boolean)ApplicationManager.getApplication().runReadAction(new Computable(this, file){
            final /* synthetic */ FrontMatterHeaderJsonSchemaFileProvider this$0;
            final /* synthetic */ VirtualFile $file$inlined;
            {
                this.this$0 = frontMatterHeaderJsonSchemaFileProvider;
                this.$file$inlined = virtualFile;
            }

            public final T compute() {
                boolean bl = false;
                return (T)Boolean.valueOf(FrontMatterHeaderJsonSchemaFileProvider.access$isInjectedFrontMatter(this.this$0, this.$file$inlined));
            }
        });
    }

    private final boolean isInjectedFrontMatter(VirtualFile file) {
        PsiFile psiFile = PsiManager.getInstance((Project)this.project).findFile(file);
        if (psiFile == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"PsiManager.getInstance(p\u2026ile(file) ?: return false");
        PsiFile psiFile2 = psiFile;
        return Intrinsics.areEqual((Object)psiFile2.getLanguage(), (Object)YAMLLanguage.INSTANCE);
    }

    @NotNull
    public String getName() {
        return FrontMatterBundle.message("markdown.frontmatter.header.json.schema.name", new Object[0]);
    }

    @NotNull
    public VirtualFile getSchemaFile() {
        return (VirtualFile)new LightVirtualFile("generic_front_matter_header_schema.json", (CharSequence)schema);
    }

    @NotNull
    public SchemaType getSchemaType() {
        return SchemaType.schema;
    }

    public FrontMatterHeaderJsonSchemaFileProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    public static final /* synthetic */ boolean access$isInjectedFrontMatter(FrontMatterHeaderJsonSchemaFileProvider $this, VirtualFile file) {
        return $this.isInjectedFrontMatter(file);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/intellij/plugins/markdown/frontmatter/header/FrontMatterHeaderJsonSchemaFileProvider$Companion;", "", "()V", "schema", "", "intellij.markdown.frontmatter"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

