/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.psi.impl;

import com.intellij.icons.AllIcons;
import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import javax.swing.Icon;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.psi.MarkdownElementVisitor;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownCompositePsiElementBase;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownListItem;
import org.intellij.plugins.markdown.util.MarkdownPsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkdownList
extends MarkdownCompositePsiElementBase {
    private static final String ORDERED_LIST_TEXT = "Ordered list";
    private static final String UNORDERED_LIST_TEXT = "Unordered list";

    public MarkdownList(@NotNull ASTNode node) {
        if (node == null) {
            MarkdownList.$$$reportNull$$$0(0);
        }
        super(node);
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            MarkdownList.$$$reportNull$$$0(1);
        }
        if (visitor instanceof MarkdownElementVisitor) {
            ((MarkdownElementVisitor)visitor).visitList(this);
            return;
        }
        super.accept(visitor);
    }

    @Override
    public String getPresentableTagName() {
        return this.getNode().getElementType() == MarkdownElementTypes.ORDERED_LIST ? "ol" : "ul";
    }

    @Override
    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            public String getPresentableText() {
                ItemPresentation nestedPresentation = MarkdownList.getSimpleNestedPresentation(MarkdownList.this);
                if (nestedPresentation != null) {
                    return nestedPresentation.getPresentableText();
                }
                return MarkdownList.this.getNode().getElementType() == MarkdownElementTypes.ORDERED_LIST ? MarkdownList.ORDERED_LIST_TEXT : MarkdownList.UNORDERED_LIST_TEXT;
            }

            public String getLocationString() {
                ItemPresentation nestedPresentation = MarkdownList.getSimpleNestedPresentation(MarkdownList.this);
                if (nestedPresentation != null) {
                    return nestedPresentation.getLocationString();
                }
                return null;
            }

            public Icon getIcon(boolean open) {
                return MarkdownPsiUtil.isSimpleNestedList(MarkdownList.this.getParent().getChildren()) ? null : AllIcons.Actions.ListFiles;
            }
        };
    }

    @Nullable
    private static ItemPresentation getSimpleNestedPresentation(@NotNull MarkdownList element2) {
        PsiElement parent;
        if (element2 == null) {
            MarkdownList.$$$reportNull$$$0(2);
        }
        if (MarkdownPsiUtil.isSimpleNestedList((parent = element2.getParent()).getChildren()) && parent instanceof MarkdownListItem) {
            return ((MarkdownListItem)parent).getPresentation();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "org/intellij/plugins/markdown/lang/psi/impl/MarkdownList";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "accept";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getSimpleNestedPresentation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

