/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.projectTree;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import com.intellij.refactoring.rename.naming.AutomaticRenamerFactory;
import com.intellij.usageView.UsageInfo;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownFile;
import org.intellij.plugins.markdown.ui.projectTree.MarkdownRenamer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\b\u0010\f\u001a\u00020\bH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000eH\u0016\u00a8\u0006\u0013"}, d2={"Lorg/intellij/plugins/markdown/ui/projectTree/MarkdownRenamerFactory;", "Lcom/intellij/refactoring/rename/naming/AutomaticRenamerFactory;", "()V", "createRenamer", "Lcom/intellij/refactoring/rename/naming/AutomaticRenamer;", "element", "Lcom/intellij/psi/PsiElement;", "newName", "", "usages", "", "Lcom/intellij/usageView/UsageInfo;", "getOptionName", "isApplicable", "", "isEnabled", "setEnabled", "", "enabled", "intellij.markdown.core"})
public final class MarkdownRenamerFactory
implements AutomaticRenamerFactory {
    public boolean isApplicable(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        if (!(element2 instanceof MarkdownFile)) {
            return false;
        }
        List<PsiFile> boundDocuments = MarkdownRenamer.Companion.findBoundDocument((MarkdownFile)element2);
        Collection collection = boundDocuments;
        return !collection.isEmpty();
    }

    @NotNull
    public String getOptionName() {
        String string = MarkdownBundle.message("markdown.rename.factory.option.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MarkdownBundle.message(\"\u2026ame.factory.option.name\")");
        return string;
    }

    public boolean isEnabled() {
        return true;
    }

    public void setEnabled(boolean enabled) {
    }

    @NotNull
    public AutomaticRenamer createRenamer(@NotNull PsiElement element2, @NotNull String newName, @NotNull Collection<UsageInfo> usages) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        Intrinsics.checkNotNullParameter(usages, (String)"usages");
        boolean bl = element2 instanceof MarkdownFile;
        if (!bl) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        return new MarkdownRenamer((MarkdownFile)element2, newName);
    }
}

