/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.search;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.TextFieldCompletionProviderDumbAware;
import java.util.List;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.data.GHLabel;
import org.jetbrains.plugins.github.api.data.GHUser;
import org.jetbrains.plugins.github.api.data.GithubIssueState;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestRequestedReviewer;
import org.jetbrains.plugins.github.api.data.request.search.GithubIssueSearchSort;
import org.jetbrains.plugins.github.pullrequest.data.GHPRSearchQuery;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRRepositoryDataService;
import org.jetbrains.plugins.github.pullrequest.search.GHPRSearchCompletionProvider;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000I\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\b*\u0001\b\u0018\u0000 !2\u00020\u0001:\u0001!B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J(\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\rH\u0002J\u001c\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\rH\u0002J\u001a\u0010\u001c\u001a\u0004\u0018\u00010\r2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\rH\u0014J\u0014\u0010\u001f\u001a\u00020\u000b*\u00020\u00122\u0006\u0010 \u001a\u00020\u001aH\u0002R\u0010\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/plugins/github/pullrequest/search/GHPRSearchCompletionProvider;", "Lcom/intellij/util/TextFieldCompletionProviderDumbAware;", "project", "Lcom/intellij/openapi/project/Project;", "repositoryDataService", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRRepositoryDataService;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRRepositoryDataService;)V", "addColonInsertHandler", "org/jetbrains/plugins/github/pullrequest/search/GHPRSearchCompletionProvider$addColonInsertHandler$1", "Lorg/jetbrains/plugins/github/pullrequest/search/GHPRSearchCompletionProvider$addColonInsertHandler$1;", "addCompletionVariants", "", "text", "", "offset", "", "prefix", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "addExcludable", "addUnexcludable", "addValues", "qualifierName", "createLookupElement", "Lcom/intellij/codeInsight/lookup/LookupElementBuilder;", "lookupObject", "", "typeText", "getCurrentQualifierName", "getPrefix", "currentTextPrefix", "addElement", "variant", "Companion", "intellij.vcs.github"})
public final class GHPRSearchCompletionProvider
extends TextFieldCompletionProviderDumbAware {
    private final addColonInsertHandler.1 addColonInsertHandler;
    private final GHPRRepositoryDataService repositoryDataService;
    private static final String EXCLUDE = "-";
    private static final String TYPE_USER = "username";
    private static final String TYPE_DATE = "YYYY-MM-DD";
    private static final String TYPE_LABEL = "label name";
    private static final String USER_ME = "@me";
    @NotNull
    public static final Companion Companion = new Companion(null);

    protected void addCompletionVariants(@NotNull String text, int offset, @NotNull String prefix, @NotNull CompletionResultSet result) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        String qualifierName = this.getCurrentQualifierName(text, offset);
        if (qualifierName == null) {
            if (Intrinsics.areEqual((Object)prefix, (Object)EXCLUDE)) {
                CompletionResultSet completionResultSet = result.withPrefixMatcher(PrefixMatcher.ALWAYS_TRUE);
                Intrinsics.checkNotNullExpressionValue((Object)completionResultSet, (String)"result.withPrefixMatcher\u2026refixMatcher.ALWAYS_TRUE)");
                this.addExcludable(completionResultSet);
            } else {
                this.addExcludable(result);
                this.addUnexcludable(result);
            }
        } else {
            this.addValues(result, qualifierName);
        }
    }

    private final void addExcludable(CompletionResultSet result) {
        CompletionResultSet $this$with = result;
        boolean bl = false;
        $this$with.addElement((LookupElement)GHPRSearchCompletionProvider.createLookupElement$default(this, (Object)GHPRSearchQuery.QualifierName.state, null, 2, null));
        $this$with.addElement((LookupElement)this.createLookupElement((Object)GHPRSearchQuery.QualifierName.author, TYPE_USER));
        $this$with.addElement((LookupElement)this.createLookupElement((Object)GHPRSearchQuery.QualifierName.assignee, TYPE_USER));
        $this$with.addElement((LookupElement)this.createLookupElement((Object)GHPRSearchQuery.QualifierName.reviewedBy, TYPE_USER));
        $this$with.addElement((LookupElement)this.createLookupElement((Object)GHPRSearchQuery.QualifierName.reviewRequested, TYPE_USER));
        $this$with.addElement((LookupElement)this.createLookupElement((Object)GHPRSearchQuery.QualifierName.label, TYPE_LABEL));
    }

    private final void addUnexcludable(CompletionResultSet result) {
        CompletionResultSet $this$with = result;
        boolean bl = false;
        $this$with.addElement((LookupElement)this.createLookupElement((Object)GHPRSearchQuery.QualifierName.after, TYPE_DATE));
        $this$with.addElement((LookupElement)this.createLookupElement((Object)GHPRSearchQuery.QualifierName.before, TYPE_DATE));
        $this$with.addElement((LookupElement)GHPRSearchCompletionProvider.createLookupElement$default(this, (Object)GHPRSearchQuery.QualifierName.sortBy, null, 2, null));
    }

    private final void addValues(CompletionResultSet result, String qualifierName) {
        block7: {
            block11: {
                block10: {
                    block9: {
                        block8: {
                            block6: {
                                if (!StringsKt.equals((String)qualifierName, (String)GHPRSearchQuery.QualifierName.assignee.name(), (boolean)true)) break block6;
                                for (GHUser user : (List)ProgressIndicatorUtils.awaitWithCheckCanceled((Future)this.repositoryDataService.getIssuesAssignees())) {
                                    this.addElement(result, user.getLogin());
                                }
                                this.addElement(result, USER_ME);
                                break block7;
                            }
                            if (!StringsKt.equals((String)qualifierName, (String)GHPRSearchQuery.QualifierName.author.name(), (boolean)true)) break block8;
                            for (GHUser user : (List)ProgressIndicatorUtils.awaitWithCheckCanceled((Future)this.repositoryDataService.getCollaborators())) {
                                this.addElement(result, user.getLogin());
                            }
                            this.addElement(result, USER_ME);
                            break block7;
                        }
                        if (!StringsKt.equals((String)qualifierName, (String)GHPRSearchQuery.QualifierName.label.name(), (boolean)true)) break block9;
                        for (GHLabel label2 : (List)ProgressIndicatorUtils.awaitWithCheckCanceled((Future)this.repositoryDataService.getLabels())) {
                            String quoted;
                            String string;
                            String it = string = label2.getName();
                            boolean bl = false;
                            Intrinsics.checkNotNullExpressionValue((Object)(StringUtil.containsWhitespaces((CharSequence)it) ? StringUtil.wrapWithDoubleQuote((String)it) : it), (String)"label.name.let {\n       \u2026e(it) else it\n          }");
                            quoted = quoted;
                            result.addElement((LookupElement)LookupElementBuilder.create((String)quoted));
                        }
                        break block7;
                    }
                    if (!StringsKt.equals((String)qualifierName, (String)GHPRSearchQuery.QualifierName.reviewedBy.toString(), (boolean)true) && !StringsKt.equals((String)qualifierName, (String)GHPRSearchQuery.QualifierName.reviewRequested.toString(), (boolean)true)) break block10;
                    for (GHPullRequestRequestedReviewer user : (List)ProgressIndicatorUtils.awaitWithCheckCanceled((Future)this.repositoryDataService.getPotentialReviewers())) {
                        this.addElement(result, user.getShortName());
                    }
                    this.addElement(result, USER_ME);
                    break block7;
                }
                if (!StringsKt.equals((String)qualifierName, (String)GHPRSearchQuery.QualifierName.state.name(), (boolean)true)) break block11;
                for (GithubIssueState state2 : GithubIssueState.values()) {
                    this.addElement(result, state2.name());
                }
                break block7;
            }
            if (!StringsKt.equals((String)qualifierName, (String)GHPRSearchQuery.QualifierName.sortBy.name(), (boolean)true)) break block7;
            for (GithubIssueSearchSort sort : GithubIssueSearchSort.values()) {
                this.addElement(result, sort.name());
            }
        }
    }

    @NotNull
    protected String getPrefix(@NotNull String currentTextPrefix) {
        Intrinsics.checkNotNullParameter((Object)currentTextPrefix, (String)"currentTextPrefix");
        int spaceIdx = StringsKt.lastIndexOf$default((CharSequence)currentTextPrefix, (char)' ', (int)0, (boolean)false, (int)6, null);
        int colonIdx = StringsKt.indexOf$default((CharSequence)currentTextPrefix, (char)':', (int)RangesKt.coerceAtLeast((int)spaceIdx, (int)0), (boolean)false, (int)4, null);
        String string = currentTextPrefix;
        int n = RangesKt.coerceAtLeast((int)spaceIdx, (int)colonIdx) + 1;
        String string2 = string.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
        return string2;
    }

    private final String getCurrentQualifierName(String text, int offset) {
        int spaceIdx = StringsKt.lastIndexOf$default((CharSequence)text, (char)' ', (int)(offset - 1), (boolean)false, (int)4, null);
        int colonIdx = StringsKt.indexOf$default((CharSequence)text, (char)':', (int)RangesKt.coerceAtLeast((int)spaceIdx, (int)0), (boolean)false, (int)4, null);
        if (colonIdx < 0 || spaceIdx > colonIdx) {
            return null;
        }
        String string = text;
        int n = spaceIdx + 1;
        String string2 = string.substring(n, colonIdx);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        return StringsKt.removePrefix((String)string2, (CharSequence)EXCLUDE);
    }

    private final LookupElementBuilder createLookupElement(Object lookupObject, String typeText) {
        LookupElementBuilder lookupElementBuilder;
        LookupElementBuilder it = lookupElementBuilder = LookupElementBuilder.create((Object)lookupObject).withTailText(":").withInsertHandler((InsertHandler)this.addColonInsertHandler);
        boolean bl = false;
        LookupElementBuilder lookupElementBuilder2 = typeText != null ? it.withTypeText(typeText, true) : it;
        Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder2, (String)"LookupElementBuilder.cre\u2026typeText, true) else it }");
        return lookupElementBuilder2;
    }

    static /* synthetic */ LookupElementBuilder createLookupElement$default(GHPRSearchCompletionProvider gHPRSearchCompletionProvider, Object object, String string, int n, Object object2) {
        if ((n & 2) != 0) {
            string = null;
        }
        return gHPRSearchCompletionProvider.createLookupElement(object, string);
    }

    private final void addElement(CompletionResultSet $this$addElement, Object variant) {
        $this$addElement.addElement((LookupElement)LookupElementBuilder.create((Object)variant));
    }

    public GHPRSearchCompletionProvider(@NotNull Project project, @NotNull GHPRRepositoryDataService repositoryDataService) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)repositoryDataService, (String)"repositoryDataService");
        super(true);
        this.repositoryDataService = repositoryDataService;
        this.addColonInsertHandler = new InsertHandler<LookupElement>(project){
            final /* synthetic */ Project $project;

            public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item2) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)item2, (String)"item");
                if (context.getCompletionChar() == ':') {
                    return;
                }
                Editor editor = context.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"context.editor");
                Editor editor2 = editor;
                if (!this.isAtColon(context)) {
                    EditorModificationUtil.insertStringAtCaret((Editor)editor2, (String)":");
                    context.commitDocument();
                }
                AutoPopupController.getInstance((Project)this.$project).autoPopupMemberLookup(editor2, null);
            }

            private final boolean isAtColon(InsertionContext context) {
                int startOffset = context.getStartOffset();
                Document document = context.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"context.document");
                Document document2 = document;
                return document2.getTextLength() > startOffset && document2.getCharsSequence().charAt(startOffset) == ':';
            }
            {
                this.$project = $captured_local_variable$0;
            }
        };
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/search/GHPRSearchCompletionProvider$Companion;", "", "()V", "EXCLUDE", "", "TYPE_DATE", "TYPE_LABEL", "TYPE_USER", "USER_ME", "intellij.vcs.github"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

