/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison;

import com.intellij.diff.comparison.ByWordRt;
import com.intellij.diff.comparison.CancellationChecker;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.ComparisonUtil;
import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.util.Side;
import com.intellij.util.text.MergingCharSequence;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\r\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\nH\u0002J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0016\u001a\u00020\u0017J.\u0010\u0018\u001a\u00020\u00032\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\bR\u0012\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\b\u00a8\u0006 "}, d2={"Lcom/intellij/diff/comparison/GreedyHelper;", "", "leftText", "", "baseText", "rightText", "(Ljava/lang/CharSequence;Ljava/lang/CharSequence;Ljava/lang/CharSequence;)V", "getBaseText", "()Ljava/lang/CharSequence;", "index1", "", "index2", "lastBaseOffset", "getLeftText", "newContent", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getRightText", "appendBase", "", "endOffset", "execute", "policy", "Lcom/intellij/diff/comparison/ComparisonPolicy;", "getInsertedContent", "fragments", "", "Lcom/intellij/diff/fragments/DiffFragment;", "start", "end", "side", "Lcom/intellij/diff/util/Side;", "intellij.platform.util.diff"})
final class GreedyHelper {
    private final StringBuilder newContent;
    private int lastBaseOffset;
    private int index1;
    private int index2;
    @NotNull
    private final CharSequence leftText;
    @NotNull
    private final CharSequence baseText;
    @NotNull
    private final CharSequence rightText;

    @Nullable
    public final CharSequence execute(@NotNull ComparisonPolicy policy) {
        block10: {
            Intrinsics.checkNotNullParameter((Object)((Object)policy), (String)"policy");
            List<DiffFragment> list = ByWordRt.compare(this.baseText, this.leftText, policy, CancellationChecker.EMPTY);
            Intrinsics.checkNotNullExpressionValue(list, (String)"ByWordRt.compare(baseTex\u2026ancellationChecker.EMPTY)");
            List<DiffFragment> fragments1 = list;
            List<DiffFragment> list2 = ByWordRt.compare(this.baseText, this.rightText, policy, CancellationChecker.EMPTY);
            Intrinsics.checkNotNullExpressionValue(list2, (String)"ByWordRt.compare(baseTex\u2026ancellationChecker.EMPTY)");
            List<DiffFragment> fragments2 = list2;
            while (true) {
                boolean next12;
                Object next2;
                int changeStart2;
                DiffFragment diffFragment = (DiffFragment)CollectionsKt.getOrNull(fragments1, (int)this.index1);
                int changeStart1 = diffFragment != null ? diffFragment.getStartOffset1() : -1;
                DiffFragment diffFragment2 = (DiffFragment)CollectionsKt.getOrNull(fragments2, (int)this.index2);
                int n = changeStart2 = diffFragment2 != null ? diffFragment2.getStartOffset1() : -1;
                if (changeStart1 == -1 && changeStart2 == -1) break block10;
                if (changeStart1 != -1 && changeStart2 != -1) {
                    this.appendBase(Math.min(changeStart1, changeStart2));
                } else if (changeStart1 != -1) {
                    this.appendBase(changeStart1);
                } else {
                    this.appendBase(changeStart2);
                }
                int baseOffsetEnd = this.lastBaseOffset;
                int end1 = this.index1;
                int end2 = this.index2;
                while (true) {
                    DiffFragment next12 = (DiffFragment)CollectionsKt.getOrNull(fragments1, (int)end1);
                    next2 = (DiffFragment)CollectionsKt.getOrNull(fragments2, (int)end2);
                    if (next12 != null && next12.getStartOffset1() <= baseOffsetEnd) {
                        baseOffsetEnd = Math.max(baseOffsetEnd, next12.getEndOffset1());
                        ++end1;
                        continue;
                    }
                    if (next2 == null || next2.getStartOffset1() > baseOffsetEnd) break;
                    baseOffsetEnd = Math.max(baseOffsetEnd, next2.getEndOffset1());
                    ++end2;
                }
                boolean bl = next12 = this.index1 != end1 || this.index2 != end2;
                if (_Assertions.ENABLED && !next12) {
                    next2 = "Assertion failed";
                    throw new AssertionError(next2);
                }
                CharSequence inserted1 = this.getInsertedContent(fragments1, this.index1, end1, Side.LEFT);
                CharSequence inserted2 = this.getInsertedContent(fragments2, this.index2, end2, Side.RIGHT);
                this.index1 = end1;
                this.index2 = end2;
                this.lastBaseOffset = baseOffsetEnd;
                CharSequence charSequence = inserted1;
                if (charSequence.length() == 0 && (charSequence = inserted2).length() == 0) continue;
                charSequence = inserted2;
                if (charSequence.length() == 0) {
                    this.newContent.append(inserted1);
                    continue;
                }
                charSequence = inserted1;
                if (charSequence.length() == 0) {
                    this.newContent.append(inserted2);
                    continue;
                }
                if (!ComparisonUtil.isEqualTexts(inserted1, inserted2, policy)) break;
                CharSequence inserted = inserted1.length() <= inserted2.length() ? inserted1 : inserted2;
                this.newContent.append(inserted);
            }
            return null;
        }
        this.appendBase(this.baseText.length());
        return this.newContent;
    }

    private final void appendBase(int endOffset) {
        if (this.lastBaseOffset == endOffset) {
            return;
        }
        this.newContent.append(this.baseText.subSequence(this.lastBaseOffset, endOffset));
        this.lastBaseOffset = endOffset;
    }

    /*
     * WARNING - void declaration
     */
    private final CharSequence getInsertedContent(List<? extends DiffFragment> fragments, int start, int end, Side side) {
        CharSequence charSequence = side.select(this.leftText, this.rightText);
        Intrinsics.checkNotNull((Object)charSequence);
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"side.select(leftText, rightText)!!");
        CharSequence text = charSequence;
        CharSequence empty = "";
        Iterable $this$fold$iv = fragments.subList(start, end);
        boolean $i$f$fold = false;
        CharSequence accumulator$iv = empty;
        for (Object element$iv : $this$fold$iv) {
            void fragment;
            DiffFragment diffFragment = (DiffFragment)element$iv;
            CharSequence prefix = accumulator$iv;
            boolean bl = false;
            accumulator$iv = new MergingCharSequence(prefix, text.subSequence(fragment.getStartOffset2(), fragment.getEndOffset2()));
        }
        return accumulator$iv;
    }

    @NotNull
    public final CharSequence getLeftText() {
        return this.leftText;
    }

    @NotNull
    public final CharSequence getBaseText() {
        return this.baseText;
    }

    @NotNull
    public final CharSequence getRightText() {
        return this.rightText;
    }

    public GreedyHelper(@NotNull CharSequence leftText, @NotNull CharSequence baseText, @NotNull CharSequence rightText) {
        Intrinsics.checkNotNullParameter((Object)leftText, (String)"leftText");
        Intrinsics.checkNotNullParameter((Object)baseText, (String)"baseText");
        Intrinsics.checkNotNullParameter((Object)rightText, (String)"rightText");
        this.leftText = leftText;
        this.baseText = baseText;
        this.rightText = rightText;
        this.newContent = new StringBuilder();
    }
}

