/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.folding;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingBuilderEx;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.folding.LanguageFolding;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeFoldingBuilder
extends FoldingBuilderEx
implements PossiblyDumbAware {
    private final List<? extends FoldingBuilder> myBuilders;

    CompositeFoldingBuilder(List<? extends FoldingBuilder> builders) {
        this.myBuilders = builders;
    }

    @Override
    public FoldingDescriptor @NotNull [] buildFoldRegions(@NotNull PsiElement root, @NotNull Document document, boolean quick) {
        if (root == null) {
            CompositeFoldingBuilder.$$$reportNull$$$0(0);
        }
        if (document == null) {
            CompositeFoldingBuilder.$$$reportNull$$$0(1);
        }
        ArrayList<FoldingDescriptorWrapper> descriptors = new ArrayList<FoldingDescriptorWrapper>();
        HashSet<TextRange> rangesCoveredByDescriptors = new HashSet<TextRange>();
        for (FoldingBuilder foldingBuilder : DumbService.getInstance(root.getProject()).filterByDumbAwareness(this.myBuilders)) {
            for (FoldingDescriptor descriptor : LanguageFolding.buildFoldingDescriptorsNoPlaceholderCaching(foldingBuilder, root, document, quick)) {
                if (!rangesCoveredByDescriptors.add(descriptor.getRange())) continue;
                descriptors.add(new FoldingDescriptorWrapper(descriptor, foldingBuilder));
            }
        }
        FoldingDescriptor[] foldingDescriptorArray = descriptors.toArray(FoldingDescriptor.EMPTY);
        if (foldingDescriptorArray == null) {
            CompositeFoldingBuilder.$$$reportNull$$$0(2);
        }
        return foldingDescriptorArray;
    }

    @Override
    public String getPlaceholderText(@NotNull ASTNode node, @NotNull TextRange range) {
        if (node == null) {
            CompositeFoldingBuilder.$$$reportNull$$$0(3);
        }
        if (range == null) {
            CompositeFoldingBuilder.$$$reportNull$$$0(4);
        }
        return node.getText();
    }

    @Override
    public String getPlaceholderText(@NotNull ASTNode node) {
        if (node == null) {
            CompositeFoldingBuilder.$$$reportNull$$$0(5);
        }
        return node.getText();
    }

    @Override
    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            CompositeFoldingBuilder.$$$reportNull$$$0(6);
        }
        return false;
    }

    @Override
    public boolean isCollapsedByDefault(@NotNull FoldingDescriptor foldingDescriptor) {
        if (foldingDescriptor == null) {
            CompositeFoldingBuilder.$$$reportNull$$$0(7);
        }
        FoldingBuilder builder = ((FoldingDescriptorWrapper)foldingDescriptor).myBuilder;
        return CompositeFoldingBuilder.mayUseBuilder(foldingDescriptor.getElement(), builder) && builder.isCollapsedByDefault(foldingDescriptor);
    }

    private static boolean mayUseBuilder(@NotNull ASTNode node, @Nullable FoldingBuilder builder) {
        if (node == null) {
            CompositeFoldingBuilder.$$$reportNull$$$0(8);
        }
        if (builder == null) {
            return false;
        }
        if (DumbService.isDumbAware(builder)) {
            return true;
        }
        Project project = CompositeFoldingBuilder.getProjectByNode(node);
        return project == null || !DumbService.isDumb(project);
    }

    @Nullable
    private static Project getProjectByNode(@NotNull ASTNode node) {
        PsiElement psi;
        if (node == null) {
            CompositeFoldingBuilder.$$$reportNull$$$0(9);
        }
        if ((psi = node.getPsi()) == null) {
            ASTNode parent = node.getTreeParent();
            psi = parent == null ? null : parent.getPsi();
        }
        return psi == null ? null : psi.getProject();
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.myBuilders;
    }

    @Override
    public boolean isDumbAware() {
        for (FoldingBuilder foldingBuilder : this.myBuilders) {
            if (!DumbService.isDumbAware(foldingBuilder)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static FoldingBuilder getOriginalBuilder(@NotNull FoldingDescriptor foldingDescriptor) {
        if (foldingDescriptor == null) {
            CompositeFoldingBuilder.$$$reportNull$$$0(10);
        }
        if (foldingDescriptor instanceof FoldingDescriptorWrapper) {
            return ((FoldingDescriptorWrapper)foldingDescriptor).myBuilder;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/folding/CompositeFoldingBuilder";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foldingDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/folding/CompositeFoldingBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFoldRegions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildFoldRegions";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceholderText";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isCollapsedByDefault";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "mayUseBuilder";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getProjectByNode";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalBuilder";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FoldingDescriptorWrapper
    extends FoldingDescriptor {
        @NotNull
        private final FoldingDescriptor myFoldingDescriptor;
        @NotNull
        private final FoldingBuilder myBuilder;

        FoldingDescriptorWrapper(@NotNull FoldingDescriptor foldingDescriptor, @NotNull FoldingBuilder builder) {
            if (foldingDescriptor == null) {
                FoldingDescriptorWrapper.$$$reportNull$$$0(0);
            }
            if (builder == null) {
                FoldingDescriptorWrapper.$$$reportNull$$$0(1);
            }
            super(foldingDescriptor.getElement(), foldingDescriptor.getRange(), foldingDescriptor.getGroup(), foldingDescriptor.getDependencies(), foldingDescriptor.isNonExpandable(), FoldingDescriptorWrapper.choosePlaceholderText(foldingDescriptor), foldingDescriptor.isCollapsedByDefault());
            this.myFoldingDescriptor = foldingDescriptor;
            this.myBuilder = builder;
        }

        private static String choosePlaceholderText(@NotNull FoldingDescriptor foldingDescriptor) {
            if (foldingDescriptor == null) {
                FoldingDescriptorWrapper.$$$reportNull$$$0(2);
            }
            String cachedText = foldingDescriptor.getCachedPlaceholderText();
            String textFromGetText = foldingDescriptor.getPlaceholderText();
            boolean placeholderTextIsFallback = Objects.equals(textFromGetText, foldingDescriptor.getElement().getText());
            return placeholderTextIsFallback ? cachedText : textFromGetText;
        }

        @Override
        @NotNull
        public Set<Object> getDependencies() {
            Set<Object> set = this.myFoldingDescriptor.getDependencies();
            if (set == null) {
                FoldingDescriptorWrapper.$$$reportNull$$$0(3);
            }
            return set;
        }

        @Override
        protected String calcPlaceholderText() {
            ASTNode element = this.getElement();
            return !CompositeFoldingBuilder.mayUseBuilder(element, this.myBuilder) ? element.getText() : (this.myBuilder instanceof FoldingBuilderEx ? ((FoldingBuilderEx)this.myBuilder).getPlaceholderText(element, this.getRange()) : this.myBuilder.getPlaceholderText(element));
        }

        @Override
        public boolean canBeRemovedWhenCollapsed() {
            return this.myFoldingDescriptor.canBeRemovedWhenCollapsed();
        }

        @Override
        public void setCanBeRemovedWhenCollapsed(boolean canBeRemovedWhenCollapsed) {
            this.myFoldingDescriptor.setCanBeRemovedWhenCollapsed(canBeRemovedWhenCollapsed);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "foldingDescriptor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/folding/CompositeFoldingBuilder$FoldingDescriptorWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/folding/CompositeFoldingBuilder$FoldingDescriptorWrapper";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDependencies";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "choosePlaceholderText";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

