/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.util.lang.DirectByteBufferPool;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public interface ZipFile
extends AutoCloseable {
    @Nullable
    public InputStream getInputStream(@NotNull String var1) throws IOException;

    @Nullable
    public ByteBuffer getByteBuffer(@NotNull String var1) throws IOException;

    public byte @Nullable [] getData(String var1) throws IOException;

    @Nullable
    public ZipResource getResource(String var1);

    public void processResources(@NotNull String var1, @NotNull Predicate<? super String> var2, @NotNull BiConsumer<? super String, ? super InputStream> var3) throws IOException;

    default public void releaseBuffer(ByteBuffer buffer) {
        if (!buffer.isReadOnly()) {
            DirectByteBufferPool.DEFAULT_POOL.release(buffer);
        }
    }

    public static interface ZipResource {
        public int getUncompressedSize();

        @NotNull
        public String getPath();

        @NotNull
        public ByteBuffer getByteBuffer() throws IOException;

        public byte @NotNull [] getData() throws IOException;

        @NotNull
        public InputStream getInputStream() throws IOException;
    }
}

