/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower.loops.handlers;

import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.lower.loops.handlers.ArrayIterationHandler;
import org.jetbrains.kotlin.backend.common.lower.loops.handlers.IndexedGetIterationHandler;
import org.jetbrains.kotlin.backend.common.lower.matchers.IrCallMatcherContainer;
import org.jetbrains.kotlin.backend.common.lower.matchers.IrCallMatcherKt;
import org.jetbrains.kotlin.backend.common.lower.matchers.Quantifier;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\f\u0010\u0017\u001a\u00020\b*\u00020\u000bH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\u00020\n*\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0018\u0010\u000e\u001a\u00020\u000f*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0018\u0010\u0012\u001a\u00020\n*\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\r\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/loops/handlers/ArrayIterationHandler;", "Lorg/jetbrains/kotlin/backend/common/lower/loops/handlers/IndexedGetIterationHandler;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "reversedArrayMatcher", "Lorg/jetbrains/kotlin/backend/common/lower/matchers/IrCallMatcherContainer;", "supportsUnsignedArrays", "", "getFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "Lorg/jetbrains/kotlin/ir/types/IrType;", "getGetFunction", "(Lorg/jetbrains/kotlin/ir/types/IrType;)Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "getFunctionName", "Lorg/jetbrains/kotlin/name/Name;", "getGetFunctionName", "(Lorg/jetbrains/kotlin/ir/types/IrType;)Lorg/jetbrains/kotlin/name/Name;", "sizePropertyGetter", "getSizePropertyGetter", "matchIterable", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "isArrayType", "ir.backend.common"})
public final class ArrayIterationHandler
extends IndexedGetIterationHandler {
    private final boolean supportsUnsignedArrays;
    @NotNull
    private final IrCallMatcherContainer reversedArrayMatcher;

    public ArrayIterationHandler(@NotNull CommonBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, true);
        this.supportsUnsignedArrays = context.getOptimizeLoopsOverUnsignedArrays();
        this.reversedArrayMatcher = IrCallMatcherKt.createIrCallMatcher(Quantifier.ANY, (Function1<? super IrCallMatcherContainer, Unit>)((Function1)reversedArrayMatcher.1.INSTANCE));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean matchIterable(@NotNull IrExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        IrType $this$matchIterable_u24lambda_u2d0 = expression.getType();
        boolean bl = false;
        if (this.isArrayType($this$matchIterable_u24lambda_u2d0)) return true;
        IrExpression $this$matchIterable_u24lambda_u2d1 = expression;
        boolean bl2 = false;
        if (!($this$matchIterable_u24lambda_u2d1 instanceof IrCall)) return false;
        if (this.reversedArrayMatcher.invoke((IrCall)$this$matchIterable_u24lambda_u2d1) == false) return false;
        return true;
    }

    @Override
    @NotNull
    public IrSimpleFunction getSizePropertyGetter(@NotNull IrType $this$sizePropertyGetter) {
        Intrinsics.checkNotNullParameter((Object)$this$sizePropertyGetter, (String)"<this>");
        IrClass irClass = IrTypesKt.getClass($this$sizePropertyGetter);
        Intrinsics.checkNotNull((Object)irClass);
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = AdditionalIrUtilsKt.getPropertyGetter(irClass, "size");
        Intrinsics.checkNotNull((Object)irSimpleFunctionSymbol);
        return (IrSimpleFunction)irSimpleFunctionSymbol.getOwner();
    }

    private final boolean isArrayType(IrType $this$isArrayType) {
        return IrTypePredicatesKt.isArray($this$isArrayType) || IrTypeUtilsKt.isPrimitiveArray($this$isArrayType) || this.supportsUnsignedArrays && IrTypeUtilsKt.isUnsignedArray($this$isArrayType);
    }

    private final Name getGetFunctionName(IrType $this$getFunctionName) {
        Name it = this.getContext().getIr().getSymbols().getGetWithoutBoundCheckName();
        boolean bl = false;
        return this.isArrayType($this$getFunctionName) && it != null ? it : OperatorNameConventions.GET;
    }

    @Override
    @NotNull
    public IrSimpleFunction getGetFunction(@NotNull IrType $this$getFunction) {
        Intrinsics.checkNotNullParameter((Object)$this$getFunction, (String)"<this>");
        IrClass irClass = IrTypesKt.getClass($this$getFunction);
        Intrinsics.checkNotNull((Object)irClass);
        Sequence<IrSimpleFunction> $this$single$iv = IrUtilsKt.getFunctions(irClass);
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            IrSimpleFunction it = (IrSimpleFunction)element$iv;
            boolean bl = false;
            boolean bl2 = Intrinsics.areEqual((Object)it.getName(), (Object)this.getGetFunctionName($this$getFunction)) && it.getValueParameters().size() == 1 && IrTypePredicatesKt.isInt(it.getValueParameters().get(0).getType());
            if (!bl2) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        return single$iv;
    }
}

