/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower.optimizations;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrGeneratorWithScope;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrPossiblyExternalDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetFieldImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrSetFieldImpl;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.DeepCopyIrTreeWithSymbols;
import org.jetbrains.kotlin.ir.util.DeepCopySymbolRemapper;
import org.jetbrains.kotlin.ir.util.DeepCopyTypeRemapper;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.SymbolRemapper;
import org.jetbrains.kotlin.ir.util.TypeRemapper;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0014\u0010\u000b\u001a\u00020\f*\u00020\r2\u0006\u0010\u000e\u001a\u00020\nH\u0016J\n\u0010\u000f\u001a\u00020\f*\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/optimizations/PropertyAccessorInlineLowering;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "lower", "", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "isSafeToInline", "", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "accessContainer", "isSafeToInlineInClosedWorld", "AccessorInliner", "ir.backend.common"})
public class PropertyAccessorInlineLowering
implements BodyLoweringPass {
    @NotNull
    private final CommonBackendContext context;

    public PropertyAccessorInlineLowering(@NotNull CommonBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isSafeToInlineInClosedWorld(@NotNull IrProperty $this$isSafeToInlineInClosedWorld) {
        Intrinsics.checkNotNullParameter((Object)$this$isSafeToInlineInClosedWorld, (String)"<this>");
        if (org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.isTopLevel($this$isSafeToInlineInClosedWorld)) return true;
        if ($this$isSafeToInlineInClosedWorld.getModality() == Modality.FINAL) return true;
        if (Intrinsics.areEqual((Object)$this$isSafeToInlineInClosedWorld.getVisibility(), (Object)DescriptorVisibilities.PRIVATE)) return true;
        IrDeclarationParent irDeclarationParent = $this$isSafeToInlineInClosedWorld.getParent();
        Intrinsics.checkNotNull((Object)irDeclarationParent, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
        if (((IrClass)irDeclarationParent).getModality() != Modality.FINAL) return false;
        return true;
    }

    public boolean isSafeToInline(@NotNull IrProperty $this$isSafeToInline, @NotNull IrDeclaration accessContainer) {
        Intrinsics.checkNotNullParameter((Object)$this$isSafeToInline, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)accessContainer, (String)"accessContainer");
        return this.isSafeToInlineInClosedWorld($this$isSafeToInline);
    }

    @Override
    public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container) {
        Intrinsics.checkNotNullParameter((Object)irBody, (String)"irBody");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        IrElementTransformerVoidKt.transformChildrenVoid(irBody, new AccessorInliner(container));
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        BodyLoweringPass.DefaultImpls.lower(this, irFile);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\"\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\"\u0010\u0015\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/optimizations/PropertyAccessorInlineLowering$AccessorInliner;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "(Lorg/jetbrains/kotlin/backend/common/lower/optimizations/PropertyAccessorInlineLowering;Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;)V", "getContainer", "()Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "unitType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "canBeInlined", "", "callee", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "isSimpleGetter", "backingField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "isSimpleSetter", "tryInlineSimpleGetter", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "tryInlineSimpleSetter", "visitCall", "expression", "ir.backend.common"})
    private final class AccessorInliner
    extends IrElementTransformerVoid {
        @NotNull
        private final IrDeclaration container;
        @NotNull
        private final IrType unitType;

        public AccessorInliner(IrDeclaration container) {
            Intrinsics.checkNotNullParameter((Object)container, (String)"container");
            this.container = container;
            this.unitType = PropertyAccessorInlineLowering.this.context.getIrBuiltIns().getUnitType();
        }

        @NotNull
        public final IrDeclaration getContainer() {
            return this.container;
        }

        private final boolean canBeInlined(IrSimpleFunction callee) {
            Object object = callee.getCorrespondingPropertySymbol();
            if (object == null || (object = (IrProperty)object.getOwner()) == null) {
                return false;
            }
            Object property = object;
            if (!PropertyAccessorInlineLowering.this.isSafeToInline((IrProperty)property, this.container)) {
                return false;
            }
            IrDeclarationParent parent = property.getParent();
            if (parent instanceof IrClass) {
                if (((IrClass)parent).isExpect() || ((IrProperty)property).isExpect()) {
                    return false;
                }
                if (((IrClass)parent).getParent() instanceof IrExternalPackageFragment) {
                    return false;
                }
                if (PropertyAccessorInlineLowering.this.context.getInlineClassesUtils().isClassInlineLike((IrClass)parent)) {
                    return false;
                }
            }
            return !IrUtilsKt.isEffectivelyExternal((IrPossiblyExternalDeclaration)property);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public IrExpression visitCall(@NotNull IrCall expression) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            IrElementTransformerVoidKt.transformChildrenVoid(expression, this);
            IrSimpleFunction callee = (IrSimpleFunction)expression.getSymbol().getOwner();
            if (!this.canBeInlined(callee)) {
                return expression;
            }
            IrSimpleFunction analyzedCallee = callee;
            while (analyzedCallee.isFakeOverride()) {
                if ((IrSimpleFunction)IrFakeOverrideUtilsKt.resolveFakeOverride$default(analyzedCallee, false, null, 3, null) != null) continue;
                return expression;
            }
            if (!this.canBeInlined(analyzedCallee)) {
                return expression;
            }
            Object object = analyzedCallee.getCorrespondingPropertySymbol();
            if (object == null || (object = (IrProperty)object.getOwner()) == null) {
                return expression;
            }
            Object property = object;
            IrField irField = ((IrProperty)property).getBackingField();
            if (irField == null) {
                return expression;
            }
            IrField backingField2 = irField;
            if (((IrProperty)property).isConst()) {
                IrGeneratorWithScope p1;
                DeepCopyTypeRemapper typeRemapper$iv;
                IrExpressionBody irExpressionBody = backingField2.getInitializer();
                if (irExpressionBody == null) {
                    throw new IllegalStateException("Constant property has to have a backing field with initializer".toString());
                }
                IrExpressionBody initializer2 = irExpressionBody;
                IrElement $this$deepCopyWithSymbols_u24default$iv = initializer2.getExpression();
                IrDeclarationParent initialParent$iv = null;
                boolean $i$f$deepCopyWithSymbols = false;
                DeepCopySymbolRemapper symbolRemapper$iv = new DeepCopySymbolRemapper(null, 1, null);
                IrVisitorsKt.acceptVoid($this$deepCopyWithSymbols_u24default$iv, symbolRemapper$iv);
                TypeRemapper typeRemapper = typeRemapper$iv = new DeepCopyTypeRemapper(symbolRemapper$iv);
                DeepCopySymbolRemapper deepCopySymbolRemapper = symbolRemapper$iv;
                IrElement irElement = $this$deepCopyWithSymbols_u24default$iv;
                boolean bl = false;
                typeRemapper = typeRemapper;
                SymbolRemapper p02 = deepCopySymbolRemapper;
                IrElement irElement2 = PatchDeclarationParentsKt.patchDeclarationParents(irElement.transform(new DeepCopyIrTreeWithSymbols(p02, (TypeRemapper)((Object)p1)), null), initialParent$iv);
                if (irElement2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
                }
                IrExpression constExpression = (IrExpression)((IrElement)((IrExpression)irElement2));
                IrExpression receiver = expression.getDispatchReceiver();
                if (receiver != null && !org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.isPure$default(receiver, true, false, null, 6, null)) {
                    void this_$iv$iv$iv;
                    void startOffset$iv$iv;
                    void $this$irBlock$iv$iv;
                    DeclarationIrBuilder builder = LowerUtilsKt.createIrBuilder(PropertyAccessorInlineLowering.this.context, (IrSymbol)expression.getSymbol(), expression.getStartOffset(), expression.getEndOffset());
                    IrGeneratorWithScope $this$irBlock_u24default$iv = builder;
                    IrStatementOrigin origin$iv = null;
                    IrType resultType$iv = ((IrExpression)expression).getType();
                    boolean $i$f$irBlock = false;
                    p1 = $this$irBlock_u24default$iv;
                    int p02 = ((IrExpression)expression).getStartOffset();
                    int endOffset$iv$iv = ((IrExpression)expression).getEndOffset();
                    boolean $i$f$irBlock2 = false;
                    IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock$iv$iv.getContext(), $this$irBlock$iv$iv.getScope(), (int)startOffset$iv$iv, endOffset$iv$iv, origin$iv, resultType$iv, false, 64, null);
                    boolean $i$f$block = false;
                    void $this$visitCall_u24lambda_u2d0 = this_$iv$iv$iv;
                    boolean bl2 = false;
                    $this$visitCall_u24lambda_u2d0.unaryPlus(receiver);
                    $this$visitCall_u24lambda_u2d0.unaryPlus(constExpression);
                    return this_$iv$iv$iv.doBuild();
                }
                return constExpression;
            }
            if (((IrProperty)property).getGetter() == analyzedCallee) {
                IrExpression irExpression = this.tryInlineSimpleGetter(expression, analyzedCallee, backingField2);
                if (irExpression == null) {
                    irExpression = expression;
                }
                return irExpression;
            }
            if (((IrProperty)property).getSetter() == analyzedCallee) {
                IrExpression irExpression = this.tryInlineSimpleSetter(expression, analyzedCallee, backingField2);
                if (irExpression == null) {
                    irExpression = expression;
                }
                return irExpression;
            }
            return expression;
        }

        private final IrExpression tryInlineSimpleGetter(IrCall call, IrSimpleFunction callee, IrField backingField2) {
            if (!this.isSimpleGetter(callee, backingField2)) {
                return null;
            }
            DeclarationIrBuilder builder = LowerUtilsKt.createIrBuilder(PropertyAccessorInlineLowering.this.context, (IrSymbol)call.getSymbol(), call.getStartOffset(), call.getEndOffset());
            IrCall $this$tryInlineSimpleGetter_u24lambda_u2d1 = call;
            boolean bl = false;
            IrGetFieldImpl getField = new IrGetFieldImpl($this$tryInlineSimpleGetter_u24lambda_u2d1.getStartOffset(), $this$tryInlineSimpleGetter_u24lambda_u2d1.getEndOffset(), backingField2.getSymbol(), backingField2.getType(), call.getDispatchReceiver(), $this$tryInlineSimpleGetter_u24lambda_u2d1.getOrigin(), null, 64, null);
            return !Intrinsics.areEqual((Object)backingField2.getType(), (Object)call.getType()) ? (IrExpression)ExpressionHelpersKt.irImplicitCast(builder, getField, call.getType()) : (IrExpression)getField;
        }

        private final boolean isSimpleGetter(IrSimpleFunction callee, IrField backingField2) {
            IrBody irBody = callee.getBody();
            if (irBody == null) {
                return false;
            }
            IrBody it = irBody;
            boolean bl = false;
            IrBlockBody body2 = (IrBlockBody)it;
            IrStatement irStatement = (IrStatement)CollectionsKt.singleOrNull(body2.getStatements());
            if (irStatement == null) {
                return false;
            }
            IrStatement stmt = irStatement;
            IrReturn irReturn = stmt instanceof IrReturn ? (IrReturn)stmt : null;
            if (irReturn == null) {
                return false;
            }
            IrReturn returnStmt = irReturn;
            IrExpression irExpression = returnStmt.getValue();
            IrGetField irGetField = irExpression instanceof IrGetField ? (IrGetField)irExpression : null;
            if (irGetField == null) {
                return false;
            }
            IrGetField getFieldStmt = irGetField;
            if (getFieldStmt.getSymbol() != backingField2.getSymbol()) {
                return false;
            }
            IrExpression receiver = getFieldStmt.getReceiver();
            if (receiver == null) {
                boolean bl2;
                boolean bl3 = bl2 = callee.getDispatchReceiverParameter() == null;
                if (_Assertions.ENABLED && !bl2) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                return true;
            }
            if (receiver instanceof IrGetValue) {
                return ((IrGetValue)receiver).getSymbol().getOwner() == callee.getDispatchReceiverParameter();
            }
            return false;
        }

        private final IrExpression tryInlineSimpleSetter(IrCall call, IrSimpleFunction callee, IrField backingField2) {
            if (!this.isSimpleSetter(callee, backingField2)) {
                return null;
            }
            IrCall $this$tryInlineSimpleSetter_u24lambda_u2d3 = call;
            boolean bl = false;
            IrExpression irExpression = $this$tryInlineSimpleSetter_u24lambda_u2d3.getValueArgument(0);
            if (irExpression == null) {
                throw new IllegalStateException("Setter should have a value argument".toString());
            }
            IrExpression value = irExpression;
            return new IrSetFieldImpl($this$tryInlineSimpleSetter_u24lambda_u2d3.getStartOffset(), $this$tryInlineSimpleSetter_u24lambda_u2d3.getEndOffset(), backingField2.getSymbol(), call.getDispatchReceiver(), value, this.unitType, $this$tryInlineSimpleSetter_u24lambda_u2d3.getOrigin(), null, 128, null);
        }

        private final boolean isSimpleSetter(IrSimpleFunction callee, IrField backingField2) {
            boolean statementsSizeCheck;
            IrBody irBody = callee.getBody();
            if (irBody == null) {
                return false;
            }
            IrElement it = irBody;
            boolean bl = false;
            IrBlockBody body2 = (IrBlockBody)it;
            switch (body2.getStatements().size()) {
                case 1: {
                    boolean bl2 = true;
                    break;
                }
                case 2: {
                    boolean bl2;
                    it = body2.getStatements().get(1);
                    Object object = it instanceof IrReturn ? (IrReturn)it : null;
                    if (object != null && (object = ((IrReturn)object).getValue()) != null && (object = ((IrExpression)object).getType()) != null) {
                        if (IrTypePredicatesKt.isUnit((IrType)object)) {
                            bl2 = true;
                            break;
                        }
                        bl2 = false;
                        break;
                    }
                    bl2 = false;
                    break;
                }
                default: {
                    boolean bl2 = statementsSizeCheck = false;
                }
            }
            if (!statementsSizeCheck) {
                return false;
            }
            IrStatement stmt = body2.getStatements().get(0);
            IrSetField irSetField = stmt instanceof IrSetField ? (IrSetField)stmt : null;
            if (irSetField == null) {
                return false;
            }
            IrSetField setFieldStmt = irSetField;
            if (setFieldStmt.getSymbol() != backingField2.getSymbol()) {
                return false;
            }
            IrExpression irExpression = setFieldStmt.getValue();
            IrGetValue irGetValue = irExpression instanceof IrGetValue ? (IrGetValue)irExpression : null;
            if (irGetValue == null) {
                return false;
            }
            IrGetValue setValue = irGetValue;
            IrValueParameterSymbol valueSymbol = ((IrValueParameter)CollectionsKt.single(callee.getValueParameters())).getSymbol();
            if (setValue.getSymbol() != valueSymbol) {
                return false;
            }
            IrExpression receiver = setFieldStmt.getReceiver();
            if (receiver == null) {
                boolean bl3;
                boolean bl4 = bl3 = callee.getDispatchReceiverParameter() == null;
                if (_Assertions.ENABLED && !bl3) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                return true;
            }
            if (receiver instanceof IrGetValue) {
                return ((IrGetValue)receiver).getSymbol().getOwner() == callee.getDispatchReceiverParameter();
            }
            return false;
        }
    }
}

