/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.serialization.KlibIrVersion;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\u0010\b\n\u0000\u001a\u0012\u0010\u0005\u001a\u00020\u00012\n\u0010\u0006\u001a\u00020\u0007\"\u00020\b\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\t"}, d2={"metadataVersion", "Lorg/jetbrains/kotlin/backend/common/serialization/KlibIrVersion;", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "getMetadataVersion", "(Lorg/jetbrains/kotlin/library/KotlinLibrary;)Lorg/jetbrains/kotlin/backend/common/serialization/KlibIrVersion;", "KlibIrVersion", "values", "", "", "ir.serialization.common"})
public final class KlibIrVersionKt {
    @NotNull
    public static final KlibIrVersion KlibIrVersion(int ... values) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        if (values.length != 3) {
            throw new IllegalStateException(("Ir version should be in major.minor.patch format: " + values).toString());
        }
        return new KlibIrVersion(values[0], values[1], values[2]);
    }

    @NotNull
    public static final KlibIrVersion getMetadataVersion(@NotNull KotlinLibrary $this$metadataVersion) {
        Intrinsics.checkNotNullParameter((Object)$this$metadataVersion, (String)"<this>");
        String versionString = $this$metadataVersion.getManifestProperties().getProperty("ir_version");
        Intrinsics.checkNotNullExpressionValue((Object)versionString, (String)"versionString");
        int[] nArray = BinaryVersion.Companion.parseVersionArray(versionString);
        if (nArray == null) {
            throw new IllegalStateException(("Could not parse ir version: " + versionString).toString());
        }
        int[] versionIntArray = nArray;
        return KlibIrVersionKt.KlibIrVersion(Arrays.copyOf(versionIntArray, versionIntArray.length));
    }
}

