/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.panels.management.packagedetails;

import com.jetbrains.packagesearch.api.v2.ApiStandardPackage;
import com.jetbrains.packagesearch.intellij.plugin.PackageSearchBundle;
import com.jetbrains.packagesearch.intellij.plugin.UtilsKt;
import com.jetbrains.packagesearch.intellij.plugin.ui.PackageSearchUI;
import com.jetbrains.packagesearch.intellij.plugin.ui.PackageSearchUIKt;
import com.jetbrains.packagesearch.intellij.plugin.ui.components.BrowsableLinkLabel;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.KnownRepositories;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.PackageModel;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.PackageVersion;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.RepositoryModel;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.panels.management.packagedetails.GitHubInfoPanel;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.panels.management.packagedetails.InfoLink;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.panels.management.packagedetails.LinkExtractor;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.panels.management.packagedetails.PackageDetailsInfoPanel;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.panels.management.packagedetails.PackageKotlinPlatformsPanel;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.panels.management.packagedetails.PackageUsagesPanel;
import com.jetbrains.packagesearch.intellij.plugin.ui.util.BordersKt;
import com.jetbrains.packagesearch.intellij.plugin.ui.util.IntScalingExtensionsKt;
import com.jetbrains.packagesearch.intellij.plugin.ui.util.MigLayoutExtensionsKt;
import com.jetbrains.packagesearch.intellij.plugin.ui.util.StringStylingExtensionsKt;
import com.jetbrains.packagesearch.intellij.plugin.ui.util.SwingUtilsKt;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001@B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u000e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aJ\u0018\u0010\u001b\u001a\u00020\u00172\u000e\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001dH\u0002J\u0010\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020!H\u0002J\u0012\u0010\"\u001a\u00020\u00172\b\u0010#\u001a\u0004\u0018\u00010$H\u0002J\u0012\u0010%\u001a\u00020\u00172\b\u0010&\u001a\u0004\u0018\u00010'H\u0002J\u0012\u0010(\u001a\u00020\u00172\b\u0010)\u001a\u0004\u0018\u00010!H\u0002J\u0016\u0010*\u001a\u00020\u00172\f\u0010+\u001a\b\u0012\u0004\u0012\u00020,0\u001dH\u0002J\u0012\u0010-\u001a\u00020\u00172\b\u0010.\u001a\u0004\u0018\u00010/H\u0002J\u0012\u00100\u001a\u00020\u00172\b\u00101\u001a\u0004\u0018\u000102H\u0002J\u001a\u00103\u001a\u00020\u00172\b\u00104\u001a\u0004\u0018\u0001052\u0006\u00106\u001a\u000207H\u0002J\u0010\u00108\u001a\u00020\u00172\u0006\u00109\u001a\u00020:H\u0002J#\u0010;\u001a\u0002H<\"\b\b\u0000\u0010<*\u00020=*\u0002H<2\u0006\u0010>\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010?R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000f\u0010\u0002R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/packagedetails/PackageDetailsInfoPanel;", "Ljavax/swing/JPanel;", "()V", "authorsLabel", "Ljavax/swing/JLabel;", "descriptionLabel", "documentationLinkLabel", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/components/BrowsableLinkLabel;", "gitHubPanel", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/packagedetails/GitHubInfoPanel;", "kotlinPlatformsPanel", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/packagedetails/PackageKotlinPlatformsPanel;", "licensesLinkLabel", "maxRowHeight", "", "getMaxRowHeight$annotations", "noDataLabel", "projectWebsiteLinkLabel", "readmeLinkLabel", "repositoriesLabel", "usagesPanel", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/packagedetails/PackageUsagesPanel;", "clearPanelContents", "", "display", "viewModel", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/packagedetails/PackageDetailsInfoPanel$ViewModel;", "displayAuthorsIfAny", "authors", "", "Lcom/jetbrains/packagesearch/api/v2/ApiStandardPackage$ApiAuthor;", "displayDescriptionIfAny", "remoteInfo", "Lcom/jetbrains/packagesearch/api/v2/ApiStandardPackage;", "displayDocumentationIfAny", "documentationLink", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/packagedetails/InfoLink$Documentation;", "displayGitHubInfoIfAny", "scmInfoLink", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/packagedetails/InfoLink$ScmRepository;", "displayKotlinPlatformsIfAny", "packageDetails", "displayLicensesIfAny", "licenseInfoLink", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/packagedetails/InfoLink$License;", "displayProjectWebsiteIfAny", "projectWebsiteLink", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/packagedetails/InfoLink$ProjectWebsite;", "displayReadmeIfAny", "readmeLink", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/packagedetails/InfoLink$Readme;", "displayRepositoriesIfAny", "selectedVersionInfo", "Lcom/jetbrains/packagesearch/api/v2/ApiStandardPackage$ApiStandardVersion;", "allKnownRepositories", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/KnownRepositories$All;", "displayUsagesIfAny", "packageModel", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/PackageModel;", "withMaxHeight", "T", "Ljavax/swing/JComponent;", "maxHeight", "(Ljavax/swing/JComponent;I)Ljavax/swing/JComponent;", "ViewModel", "intellij.packageSearch"})
public final class PackageDetailsInfoPanel
extends JPanel {
    private final int maxRowHeight = IntScalingExtensionsKt.scaled(180);
    private final JLabel noDataLabel = (JLabel)this.withMaxHeight((JComponent)PackageSearchUI.createLabel$default(PackageSearchUI.INSTANCE, null, noDataLabel.1.INSTANCE, 1, null), this.maxRowHeight);
    private final JLabel descriptionLabel = PackageSearchUI.createLabel$default(PackageSearchUI.INSTANCE, null, null, 3, null);
    private final JLabel repositoriesLabel = (JLabel)this.withMaxHeight((JComponent)PackageSearchUI.createLabel$default(PackageSearchUI.INSTANCE, null, null, 3, null), this.maxRowHeight);
    private final GitHubInfoPanel gitHubPanel = (GitHubInfoPanel)this.withMaxHeight((JComponent)new GitHubInfoPanel(), this.maxRowHeight);
    private final BrowsableLinkLabel licensesLinkLabel = (BrowsableLinkLabel)((Object)this.withMaxHeight((JComponent)((Object)PackageSearchUI.createLabelWithLink$intellij_packageSearch$default(PackageSearchUI.INSTANCE, null, 1, null)), this.maxRowHeight));
    private final BrowsableLinkLabel projectWebsiteLinkLabel = PackageSearchUI.createLabelWithLink$intellij_packageSearch$default(PackageSearchUI.INSTANCE, null, 1, null);
    private final BrowsableLinkLabel documentationLinkLabel = PackageSearchUI.createLabelWithLink$intellij_packageSearch$default(PackageSearchUI.INSTANCE, null, 1, null);
    private final BrowsableLinkLabel readmeLinkLabel = PackageSearchUI.createLabelWithLink$intellij_packageSearch$default(PackageSearchUI.INSTANCE, null, 1, null);
    private final PackageKotlinPlatformsPanel kotlinPlatformsPanel = new PackageKotlinPlatformsPanel();
    private final PackageUsagesPanel usagesPanel = new PackageUsagesPanel();
    private final JLabel authorsLabel = PackageSearchUI.createLabel$default(PackageSearchUI.INSTANCE, null, null, 3, null);

    private static /* synthetic */ void getMaxRowHeight$annotations() {
    }

    public final void display(@NotNull ViewModel viewModel) {
        Object v0;
        block3: {
            Iterable iterable;
            Intrinsics.checkNotNullParameter((Object)viewModel, (String)"viewModel");
            this.clearPanelContents();
            this.displayUsagesIfAny(viewModel.getPackageModel());
            if (viewModel.getPackageModel().getRemoteInfo() == null) {
                return;
            }
            this.noDataLabel.setVisible(false);
            this.displayDescriptionIfAny(viewModel.getPackageModel().getRemoteInfo());
            Iterable iterable2 = iterable = (Iterable)viewModel.getPackageModel().getRemoteInfo().getVersions();
            for (Object t : iterable2) {
                ApiStandardPackage.ApiStandardVersion it = (ApiStandardPackage.ApiStandardVersion)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getVersion(), (Object)viewModel.getSelectedVersion().getVersionName())) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        ApiStandardPackage.ApiStandardVersion selectedVersionInfo = v0;
        this.displayRepositoriesIfAny(selectedVersionInfo, viewModel.getAllKnownRepositories());
        this.displayAuthorsIfAny(viewModel.getPackageModel().getRemoteInfo().getAuthors());
        LinkExtractor linkExtractor = new LinkExtractor(viewModel.getPackageModel().getRemoteInfo());
        this.displayGitHubInfoIfAny(linkExtractor.scm());
        this.displayLicensesIfAny(linkExtractor.licenses());
        this.displayProjectWebsiteIfAny(linkExtractor.projectWebsite());
        this.displayDocumentationIfAny(linkExtractor.documentation());
        this.displayReadmeIfAny(linkExtractor.readme());
        this.displayKotlinPlatformsIfAny(viewModel.getPackageModel().getRemoteInfo());
        PackageSearchUIKt.updateAndRepaint(this);
        Container container = this.getParent();
        if (container == null) {
            throw new NullPointerException("null cannot be cast to non-null type javax.swing.JComponent");
        }
        PackageSearchUIKt.updateAndRepaint((JComponent)container);
    }

    private final void clearPanelContents() {
        this.noDataLabel.setVisible(true);
        this.descriptionLabel.setVisible(false);
        this.repositoriesLabel.setVisible(false);
        this.authorsLabel.setVisible(false);
        this.gitHubPanel.setVisible(false);
        this.licensesLinkLabel.setVisible(false);
        this.projectWebsiteLinkLabel.setVisible(false);
        this.documentationLinkLabel.setVisible(false);
        this.readmeLinkLabel.setVisible(false);
        this.kotlinPlatformsPanel.setVisible(false);
        this.usagesPanel.setVisible(false);
        this.kotlinPlatformsPanel.clear();
        this.usagesPanel.clear();
        PackageSearchUIKt.updateAndRepaint(this);
    }

    private final void displayDescriptionIfAny(ApiStandardPackage remoteInfo) {
        String description = remoteInfo.getDescription();
        CharSequence charSequence = description;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || Intrinsics.areEqual((Object)description, (Object)remoteInfo.getName())) {
            this.descriptionLabel.setVisible(false);
            return;
        }
        this.descriptionLabel.setVisible(true);
        String string = UtilsKt.normalizeWhitespace(description);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"description.normalizeWhitespace()");
        this.descriptionLabel.setText(StringStylingExtensionsKt.withHtmlStyling$default(string, true, null, 2, null));
    }

    /*
     * WARNING - void declaration
     */
    private final void displayRepositoriesIfAny(ApiStandardPackage.ApiStandardVersion selectedVersionInfo, KnownRepositories.All allKnownRepositories) {
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        if (selectedVersionInfo == null) {
            this.repositoriesLabel.setVisible(false);
            return;
        }
        Iterable iterable = selectedVersionInfo.getRepositoryIds();
        boolean $i$f$mapNotNull = false;
        void var6_5 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String repoId = (String)element$iv$iv;
            boolean bl2 = false;
            RepositoryModel repositoryModel = allKnownRepositories.findById(repoId);
            String string2 = repositoryModel != null ? repositoryModel.getDisplayName() : null;
            if (string2 == null) continue;
            String it$iv$iv = string = string2;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$filterNot = false;
        $this$mapNotNullTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (StringsKt.isBlank((CharSequence)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List repositoryNames = (List)destination$iv$iv;
        String repositoryNamesToDisplay = CollectionsKt.joinToString$default((Iterable)repositoryNames, null, null, null, (int)0, null, null, (int)63, null);
        this.repositoriesLabel.setText(StringStylingExtensionsKt.withHtmlStyling$default(repositoryNames.size() == 1 ? PackageSearchBundle.INSTANCE.message("packagesearch.ui.toolwindow.packages.details.info.repository", repositoryNamesToDisplay) : PackageSearchBundle.INSTANCE.message("packagesearch.ui.toolwindow.packages.details.info.repositories", repositoryNamesToDisplay), true, null, 2, null));
        this.repositoriesLabel.setVisible(true);
    }

    /*
     * WARNING - void declaration
     */
    private final void displayAuthorsIfAny(List<ApiStandardPackage.ApiAuthor> authors) {
        void $this$mapTo$iv$iv;
        ApiStandardPackage.ApiAuthor it;
        Iterable $this$filterNotTo$iv$iv;
        Collection collection = authors;
        if (collection == null || collection.isEmpty()) {
            this.authorsLabel.setVisible(false);
            return;
        }
        Iterable $this$filterNot$iv = authors;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (ApiStandardPackage.ApiAuthor)element$iv$iv;
            boolean bl = false;
            CharSequence charSequence = it.getName();
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterNotTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ApiStandardPackage.ApiAuthor)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            String string = UtilsKt.normalizeWhitespace(it.getName());
            collection2.add(string);
        }
        List authorNames = (List)destination$iv$iv;
        String authorsString = authorNames.size() == 1 ? PackageSearchBundle.INSTANCE.message("packagesearch.ui.toolwindow.packages.details.info.author", CollectionsKt.joinToString$default((Iterable)authorNames, null, null, null, (int)0, null, null, (int)63, null)) : PackageSearchBundle.INSTANCE.message("packagesearch.ui.toolwindow.packages.details.info.authors", CollectionsKt.joinToString$default((Iterable)authorNames, null, null, null, (int)0, null, null, (int)63, null));
        this.authorsLabel.setText(StringStylingExtensionsKt.withHtmlStyling$default(authorsString, true, null, 2, null));
        this.authorsLabel.setVisible(true);
    }

    private final void displayGitHubInfoIfAny(InfoLink.ScmRepository scmInfoLink) {
        if (!(scmInfoLink instanceof InfoLink.ScmRepository.GitHub) || !scmInfoLink.hasBrowsableUrl()) {
            this.gitHubPanel.setVisible(false);
            return;
        }
        this.gitHubPanel.setVisible(true);
        this.gitHubPanel.setText(scmInfoLink.getDisplayNameCapitalized());
        this.gitHubPanel.setUrl(scmInfoLink.getUrl());
        this.gitHubPanel.setStars(((InfoLink.ScmRepository.GitHub)scmInfoLink).getStars());
    }

    private final void displayLicensesIfAny(List<InfoLink.License> licenseInfoLink) {
        InfoLink.License mainLicense = (InfoLink.License)CollectionsKt.firstOrNull(licenseInfoLink);
        if (mainLicense == null || !mainLicense.hasBrowsableUrl()) {
            this.licensesLinkLabel.setVisible(false);
            return;
        }
        this.licensesLinkLabel.setVisible(true);
        this.licensesLinkLabel.setUrl(mainLicense.getUrl());
        this.licensesLinkLabel.setDisplayText(mainLicense.getLicenseName() != null ? PackageSearchBundle.INSTANCE.message("packagesearch.ui.toolwindow.packages.details.info.license", mainLicense.getLicenseName()) : mainLicense.getDisplayNameCapitalized());
        this.licensesLinkLabel.setUrlClickedListener((Function0<Unit>)((Function0)displayLicensesIfAny.1.INSTANCE));
    }

    private final void displayProjectWebsiteIfAny(InfoLink.ProjectWebsite projectWebsiteLink) {
        if (projectWebsiteLink == null || !projectWebsiteLink.hasBrowsableUrl()) {
            this.projectWebsiteLinkLabel.setVisible(false);
            return;
        }
        this.projectWebsiteLinkLabel.setVisible(true);
        this.projectWebsiteLinkLabel.setUrl(projectWebsiteLink.getUrl());
        this.projectWebsiteLinkLabel.setDisplayText(projectWebsiteLink.getDisplayNameCapitalized());
        this.projectWebsiteLinkLabel.setUrlClickedListener((Function0<Unit>)((Function0)displayProjectWebsiteIfAny.1.INSTANCE));
    }

    private final void displayDocumentationIfAny(InfoLink.Documentation documentationLink) {
        if (documentationLink == null || !documentationLink.hasBrowsableUrl()) {
            this.documentationLinkLabel.setVisible(false);
            return;
        }
        this.documentationLinkLabel.setVisible(true);
        this.documentationLinkLabel.setUrl(documentationLink.getUrl());
        this.documentationLinkLabel.setDisplayText(documentationLink.getDisplayNameCapitalized());
        this.documentationLinkLabel.setUrlClickedListener((Function0<Unit>)((Function0)displayDocumentationIfAny.1.INSTANCE));
    }

    private final void displayReadmeIfAny(InfoLink.Readme readmeLink) {
        if (readmeLink == null || !readmeLink.hasBrowsableUrl()) {
            this.readmeLinkLabel.setVisible(false);
            return;
        }
        this.readmeLinkLabel.setVisible(true);
        this.readmeLinkLabel.setUrl(readmeLink.getUrl());
        this.readmeLinkLabel.setDisplayText(readmeLink.getDisplayNameCapitalized());
        this.readmeLinkLabel.setUrlClickedListener((Function0<Unit>)((Function0)displayReadmeIfAny.1.INSTANCE));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void displayKotlinPlatformsIfAny(ApiStandardPackage packageDetails) {
        boolean isKotlinMultiplatform;
        ApiStandardPackage apiStandardPackage = packageDetails;
        boolean bl = isKotlinMultiplatform = (apiStandardPackage != null ? apiStandardPackage.getMpp() : null) != null;
        if (isKotlinMultiplatform) {
            Object object = packageDetails;
            if (object != null && (object = ((ApiStandardPackage)object).getPlatforms()) != null) {
                Collection collection = (Collection)object;
                if (!collection.isEmpty()) {
                    List list = packageDetails.getPlatforms();
                    if (list == null) {
                        list = CollectionsKt.emptyList();
                    }
                    this.kotlinPlatformsPanel.display(list);
                    this.kotlinPlatformsPanel.setVisible(true);
                    return;
                }
            }
        }
        this.kotlinPlatformsPanel.clear();
        this.kotlinPlatformsPanel.setVisible(false);
    }

    private final void displayUsagesIfAny(PackageModel packageModel) {
        if (packageModel instanceof PackageModel.Installed) {
            this.usagesPanel.display((PackageModel.Installed)packageModel);
            this.usagesPanel.setVisible(true);
        } else {
            this.usagesPanel.clear();
            this.usagesPanel.setVisible(false);
        }
    }

    private final <T extends JComponent> T withMaxHeight(T $this$withMaxHeight, int maxHeight) {
        $this$withMaxHeight.setMaximumSize(new Dimension(Integer.MAX_VALUE, maxHeight));
        return $this$withMaxHeight;
    }

    public PackageDetailsInfoPanel() {
        LC lC = new LC().fillX();
        Intrinsics.checkNotNullExpressionValue((Object)lC, (String)"LC().fillX()");
        LC lC2 = MigLayoutExtensionsKt.noInsets(lC);
        Intrinsics.checkNotNullExpressionValue((Object)lC2, (String)"LC().fillX()\n                .noInsets()");
        this.setLayout((LayoutManager)new MigLayout(MigLayoutExtensionsKt.skipInvisibleComponents(lC2).gridGap("0", IntScalingExtensionsKt.scaledAsString(8)), new AC().grow(), new AC().fill().gap().fill().gap().fill().gap().fill().gap().fill().gap().fill().gap().fill().gap().fill().gap()));
        this.setBackground(PackageSearchUI.INSTANCE.getUsualBackgroundColor$intellij_packageSearch());
        this.setAlignmentX(0.0f);
        int horizontalBorder = 12;
        this.setBorder((Border)BordersKt.emptyBorder$default(0, horizontalBorder, 20, horizontalBorder, 1, null));
        this.add((Component)this.noDataLabel, new CC().wrap());
        this.add((Component)this.repositoriesLabel, new CC().wrap());
        this.add((Component)this.descriptionLabel, new CC().wrap());
        this.add((Component)this.gitHubPanel, new CC().wrap());
        this.add((Component)((Object)this.licensesLinkLabel), SwingUtilsKt.compensateForHighlightableComponentMarginLeft(new CC()).wrap());
        this.add((Component)((Object)this.projectWebsiteLinkLabel), SwingUtilsKt.compensateForHighlightableComponentMarginLeft(new CC()).wrap());
        this.add((Component)((Object)this.documentationLinkLabel), SwingUtilsKt.compensateForHighlightableComponentMarginLeft(new CC()).wrap());
        this.add((Component)((Object)this.readmeLinkLabel), SwingUtilsKt.compensateForHighlightableComponentMarginLeft(new CC()).wrap());
        this.add((Component)this.kotlinPlatformsPanel, new CC().wrap());
        this.add((Component)this.usagesPanel, new CC().wrap());
        this.add((Component)this.authorsLabel, new CC().wrap());
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/packagedetails/PackageDetailsInfoPanel$ViewModel;", "", "packageModel", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/PackageModel;", "selectedVersion", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/PackageVersion;", "allKnownRepositories", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/KnownRepositories$All;", "(Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/PackageModel;Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/PackageVersion;Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/KnownRepositories$All;)V", "getAllKnownRepositories", "()Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/KnownRepositories$All;", "getPackageModel", "()Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/PackageModel;", "getSelectedVersion", "()Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/PackageVersion;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.packageSearch"})
    public static final class ViewModel {
        @NotNull
        private final PackageModel packageModel;
        @NotNull
        private final PackageVersion selectedVersion;
        @NotNull
        private final KnownRepositories.All allKnownRepositories;

        @NotNull
        public final PackageModel getPackageModel() {
            return this.packageModel;
        }

        @NotNull
        public final PackageVersion getSelectedVersion() {
            return this.selectedVersion;
        }

        @NotNull
        public final KnownRepositories.All getAllKnownRepositories() {
            return this.allKnownRepositories;
        }

        public ViewModel(@NotNull PackageModel packageModel, @NotNull PackageVersion selectedVersion, @NotNull KnownRepositories.All allKnownRepositories) {
            Intrinsics.checkNotNullParameter((Object)packageModel, (String)"packageModel");
            Intrinsics.checkNotNullParameter((Object)selectedVersion, (String)"selectedVersion");
            Intrinsics.checkNotNullParameter((Object)allKnownRepositories, (String)"allKnownRepositories");
            this.packageModel = packageModel;
            this.selectedVersion = selectedVersion;
            this.allKnownRepositories = allKnownRepositories;
        }

        @NotNull
        public final PackageModel component1() {
            return this.packageModel;
        }

        @NotNull
        public final PackageVersion component2() {
            return this.selectedVersion;
        }

        @NotNull
        public final KnownRepositories.All component3() {
            return this.allKnownRepositories;
        }

        @NotNull
        public final ViewModel copy(@NotNull PackageModel packageModel, @NotNull PackageVersion selectedVersion, @NotNull KnownRepositories.All allKnownRepositories) {
            Intrinsics.checkNotNullParameter((Object)packageModel, (String)"packageModel");
            Intrinsics.checkNotNullParameter((Object)selectedVersion, (String)"selectedVersion");
            Intrinsics.checkNotNullParameter((Object)allKnownRepositories, (String)"allKnownRepositories");
            return new ViewModel(packageModel, selectedVersion, allKnownRepositories);
        }

        public static /* synthetic */ ViewModel copy$default(ViewModel viewModel, PackageModel packageModel, PackageVersion packageVersion, KnownRepositories.All all2, int n, Object object) {
            if ((n & 1) != 0) {
                packageModel = viewModel.packageModel;
            }
            if ((n & 2) != 0) {
                packageVersion = viewModel.selectedVersion;
            }
            if ((n & 4) != 0) {
                all2 = viewModel.allKnownRepositories;
            }
            return viewModel.copy(packageModel, packageVersion, all2);
        }

        @NotNull
        public String toString() {
            return "ViewModel(packageModel=" + this.packageModel + ", selectedVersion=" + this.selectedVersion + ", allKnownRepositories=" + this.allKnownRepositories + ")";
        }

        public int hashCode() {
            PackageModel packageModel = this.packageModel;
            PackageVersion packageVersion = this.selectedVersion;
            KnownRepositories.All all2 = this.allKnownRepositories;
            return ((packageModel != null ? packageModel.hashCode() : 0) * 31 + (packageVersion != null ? packageVersion.hashCode() : 0)) * 31 + (all2 != null ? ((Object)all2).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ViewModel)) break block3;
                    ViewModel viewModel = (ViewModel)object;
                    if (!Intrinsics.areEqual((Object)this.packageModel, (Object)viewModel.packageModel) || !Intrinsics.areEqual((Object)this.selectedVersion, (Object)viewModel.selectedVersion) || !Intrinsics.areEqual((Object)this.allKnownRepositories, (Object)viewModel.allKnownRepositories)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

