/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesBrowserUseCase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.branchConfig.SelectBranchPopup;
import org.jetbrains.idea.svn.integrate.MergerFactory;
import org.jetbrains.idea.svn.integrate.SelectedCommittedStuffChecker;
import org.jetbrains.idea.svn.integrate.SvnIntegrateChangesActionPerformer;

public abstract class AbstractIntegrateChangesAction<T extends SelectedCommittedStuffChecker>
extends AnAction
implements DumbAware {
    private final boolean myCheckUseCase;

    protected AbstractIntegrateChangesAction(boolean checkUseCase) {
        this.myCheckUseCase = checkUseCase;
    }

    @NotNull
    protected abstract MergerFactory createMergerFactory(T var1);

    @NotNull
    protected abstract T createChecker();

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            AbstractIntegrateChangesAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public final void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AbstractIntegrateChangesAction.$$$reportNull$$$0(1);
        }
        Project project = e.getProject();
        CommittedChangesBrowserUseCase useCase = (CommittedChangesBrowserUseCase)e.getData(CommittedChangesBrowserUseCase.DATA_KEY);
        Presentation presentation = e.getPresentation();
        if (project == null || this.myCheckUseCase && (useCase == null || !CommittedChangesBrowserUseCase.COMMITTED.equals((Object)useCase))) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        presentation.setText(SvnBundle.messagePointer("action.Subversion.integrate.changes.actionname", new Object[0]));
        presentation.setDescription(SvnBundle.messagePointer("action.Subversion.integrate.changes.description", new Object[0]));
        T checker2 = this.createChecker();
        checker2.execute(e);
        presentation.setVisible(true);
        presentation.setEnabled(checker2.isValid());
        if (presentation.isVisible() && presentation.isEnabled() && ProjectLevelVcsManager.getInstance((Project)project).isBackgroundVcsOperationRunning()) {
            presentation.setEnabled(false);
        }
        this.updateWithChecker(e, (SelectedCommittedStuffChecker)checker2);
    }

    protected void updateWithChecker(AnActionEvent e, SelectedCommittedStuffChecker checker2) {
    }

    @Nullable
    protected abstract Url getSelectedBranchUrl(SelectedCommittedStuffChecker var1);

    @Nullable
    protected abstract String getSelectedBranchLocalPath(SelectedCommittedStuffChecker var1);

    @NlsContexts.DialogTitle
    @Nullable
    protected abstract String getDialogTitle();

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            AbstractIntegrateChangesAction.$$$reportNull$$$0(2);
        }
        DataContext dataContext = e.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        T checker2 = this.createChecker();
        checker2.execute(e);
        if (!checker2.isValid()) {
            Messages.showErrorDialog((String)SvnBundle.message("dialog.message.integrate.changes.error.no.available.files", new Object[0]), (String)SvnBundle.message("dialog.title.integrate.to.branch", new Object[0]));
            return;
        }
        SvnIntegrateChangesActionPerformer changesActionPerformer = new SvnIntegrateChangesActionPerformer(project, checker2.getSameBranch(), this.createMergerFactory(checker2));
        Url selectedBranchUrl = this.getSelectedBranchUrl((SelectedCommittedStuffChecker)checker2);
        if (selectedBranchUrl == null) {
            SelectBranchPopup.showForBranchRoot(project, checker2.getRoot(), changesActionPerformer, SvnBundle.message("popup.title.select.branch.to.integrate.to", new Object[0]));
        } else {
            changesActionPerformer.onBranchSelected(selectedBranchUrl, this.getSelectedBranchLocalPath((SelectedCommittedStuffChecker)checker2), this.getDialogTitle());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/actions/AbstractIntegrateChangesAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/actions/AbstractIntegrateChangesAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

