/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.branchConfig;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationNew;

@State(name="SvnBranchMapperManager", storages={@Storage(value="other.xml")})
public class SvnBranchMapperManager
implements PersistentStateComponent<SvnBranchMapperHolder> {
    private SvnBranchMapperHolder myStateHolder = new SvnBranchMapperHolder();

    public static SvnBranchMapperManager getInstance() {
        return (SvnBranchMapperManager)ApplicationManager.getApplication().getService(SvnBranchMapperManager.class);
    }

    public SvnBranchMapperHolder getState() {
        return this.myStateHolder;
    }

    public void loadState(@NotNull SvnBranchMapperHolder state) {
        if (state == null) {
            SvnBranchMapperManager.$$$reportNull$$$0(0);
        }
        this.myStateHolder = state;
    }

    public void put(@NotNull Url url, @NotNull File file) {
        if (url == null) {
            SvnBranchMapperManager.$$$reportNull$$$0(1);
        }
        if (file == null) {
            SvnBranchMapperManager.$$$reportNull$$$0(2);
        }
        this.myStateHolder.put(url.toDecodedString(), file.getAbsolutePath());
    }

    public void remove(@NotNull Url url, @NotNull File value) {
        Set<String> set;
        if (url == null) {
            SvnBranchMapperManager.$$$reportNull$$$0(3);
        }
        if (value == null) {
            SvnBranchMapperManager.$$$reportNull$$$0(4);
        }
        if ((set = this.myStateHolder.get(url.toDecodedString())) != null) {
            set.remove(value.getAbsolutePath());
        }
    }

    public void notifyBranchesChanged(Project project, VirtualFile vcsRoot, SvnBranchConfigurationNew configuration) {
        for (Map.Entry<Url, File> entry : configuration.getUrl2FileMappings(project, vcsRoot).entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Set<String> get(@NotNull Url url) {
        if (url == null) {
            SvnBranchMapperManager.$$$reportNull$$$0(5);
        }
        return this.myStateHolder.get(url.toDecodedString());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/svn/branchConfig/SvnBranchMapperManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "put";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "remove";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "get";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class SvnBranchMapperHolder {
        public Map<String, Set<String>> myMapping = new HashMap<String, Set<String>>();

        public void put(String key, String value) {
            Set<String> files = this.myMapping.get(key);
            if (files == null) {
                files = new HashSet<String>();
                this.myMapping.put(key, files);
            }
            files.add(value);
        }

        public Set<String> get(String key) {
            return this.myMapping.get(key);
        }
    }
}

