/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.execution.testFrameworks;

import com.intellij.rt.execution.junit.ComparisonFailureData;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AbstractExpectedPatterns {
    private static final Pattern ASSERT_EQUALS_PATTERN = Pattern.compile("expected:<(.*)> but was:<(.*)>", 34);
    private static final Pattern ASSERT_EQUALS_CHAINED_PATTERN = Pattern.compile("but was:<(.*)>", 34);

    protected static void registerPatterns(String[] patternStrings, List<Pattern> patterns) {
        for (String string : patternStrings) {
            patterns.add(Pattern.compile(string, 34));
        }
    }

    protected static ComparisonFailureData createExceptionNotification(String message, List<Pattern> patterns) {
        ComparisonFailureData assertEqualsNotification = AbstractExpectedPatterns.createExceptionNotification(message, ASSERT_EQUALS_PATTERN);
        if (assertEqualsNotification != null) {
            return ASSERT_EQUALS_CHAINED_PATTERN.matcher(assertEqualsNotification.getExpected()).find() ? null : assertEqualsNotification;
        }
        for (Pattern pattern : patterns) {
            ComparisonFailureData notification = AbstractExpectedPatterns.createExceptionNotification(message, pattern);
            if (notification == null) continue;
            return notification;
        }
        return null;
    }

    protected static ComparisonFailureData createExceptionNotification(String message, Pattern pattern) {
        Matcher matcher = pattern.matcher(message);
        if (matcher.find() && matcher.end() == message.length()) {
            return new ComparisonFailureData(matcher.group(1).replaceAll("\\\\n", "\n"), matcher.group(2).replaceAll("\\\\n", "\n"));
        }
        return null;
    }
}

