/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.rename;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.sh.highlighting.ShTextOccurrencesUtil;
import com.intellij.sh.lexer.ShTokenTypes;
import com.intellij.sh.psi.ShFile;
import com.intellij.sh.psi.ShFunctionDefinition;
import com.intellij.sh.rename.ShRenameAllOccurrencesHandler;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;

public class ShRenameHandler
implements RenameHandler {
    public boolean isAvailableOnDataContext(@NotNull DataContext dataContext) {
        Editor editor;
        if (dataContext == null) {
            ShRenameHandler.$$$reportNull$$$0(0);
        }
        return (editor = (Editor)dataContext.getData(CommonDataKeys.EDITOR)) != null && ShRenameAllOccurrencesHandler.INSTANCE.isEnabled(editor, editor.getCaretModel().getPrimaryCaret(), dataContext) && ShRenameHandler.isRenameAvailable(editor, dataContext);
    }

    private static boolean isRenameAvailable(@NotNull Editor editor, @NotNull DataContext dataContext) {
        PsiElement element;
        ShFile file;
        if (editor == null) {
            ShRenameHandler.$$$reportNull$$$0(1);
        }
        if (dataContext == null) {
            ShRenameHandler.$$$reportNull$$$0(2);
        }
        if ((file = (ShFile)((Object)ObjectUtils.tryCast((Object)dataContext.getData(CommonDataKeys.PSI_FILE), ShFile.class))) == null) {
            return false;
        }
        if (editor.getCaretModel().getPrimaryCaret().hasSelection()) {
            return true;
        }
        TextRange textRange = ShTextOccurrencesUtil.findTextRangeOfIdentifierAtCaret(editor);
        return textRange == null || (element = file.findElementAt(textRange.getStartOffset())) == null || !ShTokenTypes.keywords.contains(PsiUtilCore.getElementType((PsiElement)element));
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        PsiElement element;
        if (project == null) {
            ShRenameHandler.$$$reportNull$$$0(3);
        }
        if ((element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext)) instanceof ShFunctionDefinition) {
            PsiElementRenameHandler.invoke((PsiElement)element, (Project)project, (PsiElement)file, (Editor)editor);
        } else {
            ShRenameAllOccurrencesHandler.INSTANCE.execute(editor, editor.getCaretModel().getPrimaryCaret(), null);
        }
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        if (project == null) {
            ShRenameHandler.$$$reportNull$$$0(4);
        }
        if (elements == null) {
            ShRenameHandler.$$$reportNull$$$0(5);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sh/rename/ShRenameHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailableOnDataContext";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isRenameAvailable";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

