/*
 * Decompiled with CFR 0.152.
 */
package circlet.common.calendar;

import circlet.common.calendar.CalendarEventSpec;
import circlet.common.calendar.EventCountersKt;
import circlet.common.calendar.RecurrenceRule;
import circlet.common.calendar.SpecInstance;
import circlet.platform.api.ADateJvmKt;
import circlet.platform.api.ADateKt;
import circlet.platform.api.ATimeZone;
import circlet.platform.api.KotlinXDate;
import circlet.platform.api.KotlinXDateTime;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a,\u0010\u0000\u001a\n\u0018\u00010\u0001j\u0004\u0018\u0001`\u00022\u0006\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0001j\u0002`\u00022\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u001a\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\nj\u0002`\u000b\u001a(\u0010\f\u001a\f\u0012\b\u0012\u00060\nj\u0002`\u000b0\r2\n\u0010\u000e\u001a\u00060\nj\u0002`\u000b2\n\u0010\u000f\u001a\u00060\nj\u0002`\u000b\u001a\u0014\u0010\u0010\u001a\u00020\u0007*\u00020\u00042\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u001a(\u0010\u0010\u001a\u00020\u0007*\u0016\u0012\b\u0012\u00060\u0001j\u0002`\u0002\u0012\b\u0012\u00060\u0001j\u0002`\u00020\u00132\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u001a(\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\r*\u00020\u00042\n\u0010\u000e\u001a\u00060\nj\u0002`\u000b2\n\u0010\u000f\u001a\u00060\nj\u0002`\u000b\u001a(\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\r*\u00020\u00042\n\u0010\u000e\u001a\u00060\u0001j\u0002`\u00022\n\u0010\u000f\u001a\u00060\u0001j\u0002`\u0002\u001a \u0010\u0016\u001a\u00020\u0004*\u00020\u00042\n\u0010\u0005\u001a\u00060\nj\u0002`\u000b2\b\b\u0002\u0010\u0017\u001a\u00020\u0012\u001a\n\u0010\u0018\u001a\u00020\u0004*\u00020\u0015\u00a8\u0006\u0019"}, d2={"getRecurringMeetingStart", "Lcirclet/platform/api/KotlinXDateTime;", "Lcirclet/platform/api/ADateTime;", "occurrence", "Lcirclet/common/calendar/CalendarEventSpec;", "date", "lookBehind", "", "isRecurrentMeetingPresent", "", "Lcirclet/platform/api/KotlinXDate;", "Lcirclet/platform/api/ADate;", "iterateDays", "", "start", "end", "durationInDays", "timezone", "Lcirclet/platform/api/ATimeZone;", "Lkotlin/Pair;", "instancesForPeriod", "Lcirclet/common/calendar/SpecInstance;", "shiftedSpec", "timeZone", "toShiftedSpec", "common"})
public final class SpecInstancesKt {
    @NotNull
    public static final List<SpecInstance> instancesForPeriod(@NotNull CalendarEventSpec $this$instancesForPeriod, @NotNull KotlinXDate start2, @NotNull KotlinXDate end) {
        Intrinsics.checkNotNullParameter((Object)$this$instancesForPeriod, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        return SpecInstancesKt.instancesForPeriod($this$instancesForPeriod, ADateJvmKt.toDateTimeAtStartOfDay(start2), ADateJvmKt.plusDays(ADateJvmKt.toDateTimeAtStartOfDay(end), 1));
    }

    @NotNull
    public static final CalendarEventSpec toShiftedSpec(@NotNull SpecInstance $this$toShiftedSpec) {
        Intrinsics.checkNotNullParameter((Object)$this$toShiftedSpec, (String)"<this>");
        KotlinXDate date2 = ADateJvmKt.toDate(ADateJvmKt.withZone($this$toShiftedSpec.getStart(), $this$toShiftedSpec.getSpec().getTimezone()));
        CalendarEventSpec shifted = SpecInstancesKt.shiftedSpec($this$toShiftedSpec.getSpec(), date2, $this$toShiftedSpec.getSpec().getTimezone());
        return CalendarEventSpec.copy$default(shifted, $this$toShiftedSpec.getStart(), $this$toShiftedSpec.getEnd(), null, false, null, null, null, null, null, 508, null);
    }

    @NotNull
    public static final List<SpecInstance> instancesForPeriod(@NotNull CalendarEventSpec $this$instancesForPeriod, @NotNull KotlinXDateTime start2, @NotNull KotlinXDateTime end) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)$this$instancesForPeriod, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        KotlinXDateTime convertedStart = ADateJvmKt.withZone(start2, $this$instancesForPeriod.getTimezone());
        KotlinXDateTime convertedEnd = ADateJvmKt.withZone(end, $this$instancesForPeriod.getTimezone());
        int between = ADateJvmKt.daysBetween(convertedStart, convertedEnd);
        if ($this$instancesForPeriod.getRecurrenceRule() == null) {
            list2 = convertedStart.compareTo($this$instancesForPeriod.getStart()) <= 0 && $this$instancesForPeriod.getStart().compareTo(convertedEnd) < 0 ? CollectionsKt.listOf((Object)new SpecInstance(ADateJvmKt.withZone($this$instancesForPeriod.getStart(), ADateJvmKt.getClientTimeZone()), ADateJvmKt.withZone($this$instancesForPeriod.getEnd(), ADateJvmKt.getClientTimeZone()), $this$instancesForPeriod)) : CollectionsKt.emptyList();
        } else {
            CalendarEventSpec shiftedSpec;
            KotlinXDateTime localStartAtDay;
            KotlinXDate kotlinXDate;
            List result2 = new ArrayList();
            KotlinXDateTime kotlinXDateTime = SpecInstancesKt.getRecurringMeetingStart$default($this$instancesForPeriod, convertedStart, 0, 4, null);
            if (kotlinXDateTime == null) {
                kotlinXDate = null;
            } else {
                KotlinXDateTime kotlinXDateTime2 = ADateJvmKt.withZone(kotlinXDateTime, $this$instancesForPeriod.getTimezone());
                kotlinXDate = kotlinXDateTime2 == null ? null : ADateJvmKt.toDate(kotlinXDateTime2);
            }
            KotlinXDate kotlinXDate2 = kotlinXDate;
            KotlinXDate nextOccurrence = kotlinXDate2 == null ? EventCountersKt.nextOccurrence$default($this$instancesForPeriod, convertedStart, false, 4, null) : kotlinXDate2;
            int day = -1;
            while (nextOccurrence != null && ++day <= between + 1 && (localStartAtDay = ADateJvmKt.withZone((shiftedSpec = SpecInstancesKt.shiftedSpec($this$instancesForPeriod, nextOccurrence, $this$instancesForPeriod.getTimezone())).getStart(), ADateJvmKt.getClientTimeZone())).compareTo(convertedEnd) <= 0) {
                KotlinXDate following;
                KotlinXDateTime localEndAtDay = ADateJvmKt.withZone(shiftedSpec.getEnd(), ADateJvmKt.getClientTimeZone());
                if (shiftedSpec.getAllDay()) {
                    localStartAtDay = ADateJvmKt.toDateTimeAtStartOfDay(ADateJvmKt.toDate(localStartAtDay));
                    localEndAtDay = ADateJvmKt.plusDays(localStartAtDay, SpecInstancesKt.durationInDays$default(shiftedSpec, null, 1, null) + 1);
                }
                if (localEndAtDay.compareTo(convertedStart) >= 0) {
                    result2.add(new SpecInstance(localStartAtDay, localEndAtDay, $this$instancesForPeriod));
                }
                KotlinXDateTime fromDateTime = ADateJvmKt.plusDays(localStartAtDay, 1);
                KotlinXDate next = EventCountersKt.nextOccurrence$default($this$instancesForPeriod, fromDateTime, false, 4, null);
                while (next != null && next.compareTo(nextOccurrence) <= 0 && ((following = EventCountersKt.nextOccurrence$default($this$instancesForPeriod, fromDateTime = ADateJvmKt.plusDays(fromDateTime, 1), false, 4, null)) == null || following.compareTo(next) > 0)) {
                    next = following;
                }
                if (next != null && next.compareTo(nextOccurrence) <= 0) break;
                nextOccurrence = next;
            }
            list2 = result2;
        }
        return list2;
    }

    @NotNull
    public static final List<KotlinXDate> iterateDays(@NotNull KotlinXDate start2, @NotNull KotlinXDate end) {
        Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        KotlinXDate current2 = start2;
        List result2 = new ArrayList();
        while (current2.compareTo(end) <= 0) {
            result2.add(current2);
            current2 = ADateJvmKt.plusDays(current2, 1);
        }
        return result2;
    }

    @Nullable
    public static final KotlinXDateTime getRecurringMeetingStart(@NotNull CalendarEventSpec occurrence, @NotNull KotlinXDateTime date2, int lookBehind) {
        int daysBetween;
        CalendarEventSpec shiftedSpec;
        KotlinXDate behindOne;
        Intrinsics.checkNotNullParameter((Object)occurrence, (String)"occurrence");
        Intrinsics.checkNotNullParameter((Object)date2, (String)"date");
        if (lookBehind == 0 && (behindOne = EventCountersKt.nextOccurrence$default(occurrence, ADateJvmKt.plusDays(date2, -1), false, 4, null)) != null && (shiftedSpec = SpecInstancesKt.shiftedSpec(occurrence, behindOne, occurrence.getTimezone())).getEnd().compareTo(date2) > 0) {
            return shiftedSpec.getStart();
        }
        KotlinXDate next = EventCountersKt.nextOccurrence$default(occurrence, date2, false, 4, null);
        if (next != null) {
            shiftedSpec = SpecInstancesKt.shiftedSpec(occurrence, next, occurrence.getTimezone());
            if (shiftedSpec.getEnd().compareTo(date2) < 0) {
                return null;
            }
            int n = 0;
            if (n <= lookBehind) {
                int i;
                do {
                    i = n++;
                    if (shiftedSpec.getStart().compareTo(ADateJvmKt.plusDays(date2, i)) > 0 || shiftedSpec.getEnd().compareTo(ADateJvmKt.plusDays(date2, i)) < 0) continue;
                    return shiftedSpec.getStart();
                } while (i != lookBehind);
            }
        }
        if ((daysBetween = SpecInstancesKt.durationInDays(occurrence, occurrence.getTimezone())) < 1 || lookBehind > daysBetween) {
            return null;
        }
        return SpecInstancesKt.getRecurringMeetingStart(occurrence, ADateJvmKt.plusDays(date2, -1), lookBehind + 1);
    }

    public static /* synthetic */ KotlinXDateTime getRecurringMeetingStart$default(CalendarEventSpec calendarEventSpec, KotlinXDateTime kotlinXDateTime, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        return SpecInstancesKt.getRecurringMeetingStart(calendarEventSpec, kotlinXDateTime, n);
    }

    public static final boolean isRecurrentMeetingPresent(@NotNull CalendarEventSpec occurrence, @NotNull KotlinXDate date2) {
        Intrinsics.checkNotNullParameter((Object)occurrence, (String)"occurrence");
        Intrinsics.checkNotNullParameter((Object)date2, (String)"date");
        return Intrinsics.areEqual((Object)SpecInstancesKt.getRecurringMeetingStart$default(occurrence, ADateJvmKt.toDateTimeAtStartOfDay(date2), 0, 4, null), (Object)ADateJvmKt.toDateTimeAtStartOfDay(date2));
    }

    @NotNull
    public static final CalendarEventSpec shiftedSpec(@NotNull CalendarEventSpec $this$shiftedSpec, @NotNull KotlinXDate date2, @NotNull ATimeZone timeZone) {
        RecurrenceRule recurrenceRule;
        Intrinsics.checkNotNullParameter((Object)$this$shiftedSpec, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)date2, (String)"date");
        Intrinsics.checkNotNullParameter((Object)timeZone, (String)"timeZone");
        KotlinXDate targetDate = Intrinsics.areEqual((Object)timeZone, (Object)$this$shiftedSpec.getTimezone()) ? date2 : ADateJvmKt.toDate(ADateJvmKt.withZone(ADateJvmKt.plusMinutes(ADateJvmKt.toDateTimeAtStartOfDay(date2, timeZone), ADateKt.toLocalMinutesOnDate($this$shiftedSpec.getStart(), $this$shiftedSpec.getTimezone(), date2, timeZone)), $this$shiftedSpec.getTimezone()));
        KotlinXDateTime newStart = $this$shiftedSpec.getAllDay() ? ADateJvmKt.toDateTimeAtStartOfDay(date2, timeZone) : ADateKt.toLocalTimeOnDate($this$shiftedSpec.getStart(), $this$shiftedSpec.getTimezone(), targetDate, $this$shiftedSpec.getTimezone());
        KotlinXDateTime kotlinXDateTime = ADateJvmKt.plusMinutes(newStart, EventCountersKt.durationInMinutes($this$shiftedSpec));
        if ($this$shiftedSpec.getAllDay()) {
            recurrenceRule = $this$shiftedSpec.getRecurrenceRule();
        } else {
            RecurrenceRule recurrenceRule2 = $this$shiftedSpec.getRecurrenceRule();
            recurrenceRule = recurrenceRule2 == null ? null : RecurrenceRule.copy$default(recurrenceRule2, EventCountersKt.fix($this$shiftedSpec.getRecurrenceRule().getFreq(), newStart, $this$shiftedSpec.getTimezone()), null, 2, null);
        }
        return CalendarEventSpec.copy$default($this$shiftedSpec, newStart, kotlinXDateTime, recurrenceRule, false, null, null, null, null, null, 504, null);
    }

    public static /* synthetic */ CalendarEventSpec shiftedSpec$default(CalendarEventSpec calendarEventSpec, KotlinXDate kotlinXDate, ATimeZone aTimeZone, int n, Object object) {
        if ((n & 2) != 0) {
            aTimeZone = ADateJvmKt.getClientTimeZone();
        }
        return SpecInstancesKt.shiftedSpec(calendarEventSpec, kotlinXDate, aTimeZone);
    }

    public static final int durationInDays(@NotNull CalendarEventSpec $this$durationInDays, @NotNull ATimeZone timezone) {
        KotlinXDateTime endDate;
        Intrinsics.checkNotNullParameter((Object)$this$durationInDays, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)timezone, (String)"timezone");
        KotlinXDateTime kotlinXDateTime = endDate = ADateJvmKt.getMinuteOfDay($this$durationInDays.getEnd()) == 0 ? ADateJvmKt.plusMinutes($this$durationInDays.getEnd(), -1) : $this$durationInDays.getEnd();
        if ($this$durationInDays.getAllDay()) {
            return ADateJvmKt.daysBetween(ADateJvmKt.withZone($this$durationInDays.getStart(), $this$durationInDays.getTimezone()), ADateJvmKt.withZone(endDate, $this$durationInDays.getTimezone()));
        }
        return ADateJvmKt.daysBetween(ADateJvmKt.toDate(ADateJvmKt.withZone($this$durationInDays.getStart(), timezone)), ADateJvmKt.toDate(ADateJvmKt.withZone(endDate, timezone)));
    }

    public static /* synthetic */ int durationInDays$default(CalendarEventSpec calendarEventSpec, ATimeZone aTimeZone, int n, Object object) {
        if ((n & 1) != 0) {
            aTimeZone = ADateJvmKt.getClientTimeZone();
        }
        return SpecInstancesKt.durationInDays(calendarEventSpec, aTimeZone);
    }

    public static final int durationInDays(@NotNull Pair<? extends KotlinXDateTime, ? extends KotlinXDateTime> $this$durationInDays, @NotNull ATimeZone timezone) {
        Intrinsics.checkNotNullParameter($this$durationInDays, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)timezone, (String)"timezone");
        KotlinXDateTime endDate = ADateJvmKt.getMinuteOfDay((KotlinXDateTime)$this$durationInDays.getSecond()) == 0 ? ADateJvmKt.plusMinutes((KotlinXDateTime)$this$durationInDays.getSecond(), -1) : (KotlinXDateTime)$this$durationInDays.getSecond();
        return ADateJvmKt.daysBetween(ADateJvmKt.toDate(ADateJvmKt.withZone((KotlinXDateTime)$this$durationInDays.getFirst(), timezone)), ADateJvmKt.toDate(ADateJvmKt.withZone(endDate, timezone)));
    }

    public static /* synthetic */ int durationInDays$default(Pair pair, ATimeZone aTimeZone, int n, Object object) {
        if ((n & 1) != 0) {
            aTimeZone = ADateJvmKt.getClientTimeZone();
        }
        return SpecInstancesKt.durationInDays((Pair<? extends KotlinXDateTime, ? extends KotlinXDateTime>)pair, aTimeZone);
    }
}

