/*
 * Decompiled with CFR 0.152.
 */
package circlet.platform.api;

import circlet.platform.api.ADateJvmKt;
import circlet.platform.api.ATimeZone;
import circlet.platform.api.KotlinXDate;
import circlet.platform.api.KotlinXDateTime;
import circlet.platform.api.Weekday;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.Clock;
import kotlinx.datetime.Instant;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000V\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000e\u001a\n\u0010\u001a\u001a\u00020\u0006*\u00020\u0006\u001a$\u0010\u001b\u001a\u00020\u001c*\u00060\u001dj\u0002`\u001e2\n\u0010\u001f\u001a\u00060\u001dj\u0002`\u001e2\b\b\u0002\u0010 \u001a\u00020!\u001a\u001a\u0010\"\u001a\u00060\u0001j\u0002`\u0002*\u00060\u0001j\u0002`\u00022\u0006\u0010#\u001a\u00020$\u001a\u001a\u0010%\u001a\u00020!*\u00060\u0001j\u0002`\u00022\n\u0010\u001f\u001a\u00060\u0001j\u0002`\u0002\u001a\u000e\u0010&\u001a\u00020!*\u00060\u0001j\u0002`\u0002\u001a\u000e\u0010'\u001a\u00020!*\u00060\u0001j\u0002`\u0002\u001a\u001a\u0010(\u001a\u00020\u0015*\u00060\u001dj\u0002`\u001e2\n\u0010\u001f\u001a\u00060\u001dj\u0002`\u001e\u001a\u001a\u0010)\u001a\u00020\u0015*\u00060\u001dj\u0002`\u001e2\n\u0010\u001f\u001a\u00060\u001dj\u0002`\u001e\u001a\u0012\u0010*\u001a\u00020\n*\u00020\u00062\u0006\u0010+\u001a\u00020,\u001a\u001a\u0010-\u001a\u00060\u0001j\u0002`\u0002*\u00060\u0001j\u0002`\u00022\u0006\u0010#\u001a\u00020$\u001a\u0012\u0010.\u001a\u00060\u001dj\u0002`\u001e*\u00060\u0001j\u0002`\u0002\u001a\u001a\u0010.\u001a\u00060\u001dj\u0002`\u001e*\u00060\u0001j\u0002`\u00022\u0006\u0010/\u001a\u00020\u0006\u001a@\u00100\u001a\u00060\u001dj\u0002`\u001e*\u00060\u0001j\u0002`\u00022\u0006\u00101\u001a\u00020\u00152\u0006\u00102\u001a\u00020\u00062\u0010\b\u0002\u00103\u001a\n\u0018\u00010\u0001j\u0004\u0018\u0001`\u00022\n\b\u0002\u00104\u001a\u0004\u0018\u00010\u0006\u001a4\u00105\u001a\u00020\u0015*\u00060\u001dj\u0002`\u001e2\u0006\u00102\u001a\u00020\u00062\u0010\b\u0002\u00103\u001a\n\u0018\u00010\u0001j\u0004\u0018\u0001`\u00022\n\b\u0002\u00104\u001a\u0004\u0018\u00010\u0006\u001a8\u00106\u001a\u00060\u001dj\u0002`\u001e*\u00060\u001dj\u0002`\u001e2\u0006\u00102\u001a\u00020\u00062\u0010\b\u0002\u00103\u001a\n\u0018\u00010\u0001j\u0004\u0018\u0001`\u00022\n\b\u0002\u00104\u001a\u0004\u0018\u00010\u0006\u001a\u001e\u00107\u001a\n\u0018\u00010\u0001j\u0004\u0018\u0001`\u0002*\u00060\u0001j\u0002`\u00022\u0006\u00108\u001a\u00020\u0015\"\u0015\u0010\u0000\u001a\u00060\u0001j\u0002`\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0015\u0010\t\u001a\u00020\u0006*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\"\u001d\u0010\r\u001a\u00060\u0001j\u0002`\u0002*\u00060\u0001j\u0002`\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\"\u0015\u0010\u0010\u001a\u00020\u0011*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\"\u0019\u0010\u0014\u001a\u00020\u0015*\u00060\u0001j\u0002`\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\"\u001d\u0010\u0018\u001a\u00060\u0001j\u0002`\u0002*\u00060\u0001j\u0002`\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u000f*\n\u00109\"\u00020\n2\u00020\n\u00a8\u0006:"}, d2={"aTomorrow", "Lcirclet/platform/api/KotlinXDate;", "Lcirclet/platform/api/ADate;", "getATomorrow", "()Lcirclet/platform/api/KotlinXDate;", "utcTimeZone", "Lcirclet/platform/api/ATimeZone;", "getUtcTimeZone", "()Lcirclet/platform/api/ATimeZone;", "aTimeZone", "", "getATimeZone", "(Ljava/lang/String;)Lcirclet/platform/api/ATimeZone;", "endOfMonth", "getEndOfMonth", "(Lcirclet/platform/api/KotlinXDate;)Lcirclet/platform/api/KotlinXDate;", "kotlin", "Lkotlinx/datetime/TimeZone;", "getKotlin", "(Lcirclet/platform/api/ATimeZone;)Lkotlinx/datetime/TimeZone;", "numberOfDaysInMonth", "", "getNumberOfDaysInMonth", "(Lcirclet/platform/api/KotlinXDate;)I", "startOfMonth", "getStartOfMonth", "asOffset", "differenceInMs", "", "Lcirclet/platform/api/KotlinXDateTime;", "Lcirclet/platform/api/ADateTime;", "other", "abs", "", "endOfWeek", "firstDayOfWeek", "Lcirclet/platform/api/Weekday;", "isSame", "isToday", "isTomorrow", "minutesDifference", "minutesDifferenceAbs", "offsetToString", "instant", "Lkotlinx/datetime/Instant;", "startOfWeek", "toDateTimeAtEndOfDay", "zone", "toDateTimeFromClientLocalMinutes", "minutes", "timezone", "targetDate", "clientZone", "toLocalMinutesOnDate", "toLocalTimeOnDate", "withDayIfExist", "day", "AYearMonth", "platform-api"})
public final class ADateKt {
    @NotNull
    private static final ATimeZone utcTimeZone = new ATimeZone("UTC");

    @NotNull
    public static final TimeZone getKotlin(@NotNull ATimeZone $this$kotlin) {
        Intrinsics.checkNotNullParameter((Object)$this$kotlin, (String)"<this>");
        return TimeZone.Companion.of($this$kotlin.getId());
    }

    @NotNull
    public static final ATimeZone getUtcTimeZone() {
        return utcTimeZone;
    }

    public static final int getNumberOfDaysInMonth(@NotNull KotlinXDate $this$numberOfDaysInMonth) {
        Intrinsics.checkNotNullParameter((Object)$this$numberOfDaysInMonth, (String)"<this>");
        return ADateJvmKt.getLastMonthDay($this$numberOfDaysInMonth);
    }

    @Nullable
    public static final KotlinXDate withDayIfExist(@NotNull KotlinXDate $this$withDayIfExist, int day) {
        Intrinsics.checkNotNullParameter((Object)$this$withDayIfExist, (String)"<this>");
        int maxDay = ADateJvmKt.getLastMonthDay($this$withDayIfExist);
        return day <= maxDay ? ADateJvmKt.withDay($this$withDayIfExist, day) : null;
    }

    @NotNull
    public static final KotlinXDate startOfWeek(@NotNull KotlinXDate $this$startOfWeek, @NotNull Weekday firstDayOfWeek) {
        Intrinsics.checkNotNullParameter((Object)$this$startOfWeek, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)firstDayOfWeek, (String)"firstDayOfWeek");
        Weekday currentWeekday = ADateJvmKt.getWeekday($this$startOfWeek);
        return ADateJvmKt.getWeekday($this$startOfWeek) == firstDayOfWeek ? $this$startOfWeek : ADateJvmKt.minusDays($this$startOfWeek, (currentWeekday.getOrderNumber() + Weekday.values().length - firstDayOfWeek.getOrderNumber()) % Weekday.values().length);
    }

    @NotNull
    public static final KotlinXDate endOfWeek(@NotNull KotlinXDate $this$endOfWeek, @NotNull Weekday firstDayOfWeek) {
        Intrinsics.checkNotNullParameter((Object)$this$endOfWeek, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)firstDayOfWeek, (String)"firstDayOfWeek");
        return ADateJvmKt.plusDays($this$endOfWeek, (Weekday.values().length + firstDayOfWeek.getOrderNumber() - ADateJvmKt.getWeekday($this$endOfWeek).getOrderNumber() - 1) % Weekday.values().length);
    }

    @NotNull
    public static final KotlinXDate getStartOfMonth(@NotNull KotlinXDate $this$startOfMonth) {
        Intrinsics.checkNotNullParameter((Object)$this$startOfMonth, (String)"<this>");
        int day = ADateJvmKt.getDayOfMonth($this$startOfMonth);
        return day == 1 ? $this$startOfMonth : ADateJvmKt.minusDays($this$startOfMonth, day - 1);
    }

    @NotNull
    public static final KotlinXDate getEndOfMonth(@NotNull KotlinXDate $this$endOfMonth) {
        Intrinsics.checkNotNullParameter((Object)$this$endOfMonth, (String)"<this>");
        int diffDays = ADateKt.getNumberOfDaysInMonth($this$endOfMonth) - ADateJvmKt.getDayOfMonth($this$endOfMonth);
        return diffDays == 0 ? $this$endOfMonth : ADateJvmKt.plusDays($this$endOfMonth, diffDays);
    }

    @NotNull
    public static final KotlinXDateTime toDateTimeAtEndOfDay(@NotNull KotlinXDate $this$toDateTimeAtEndOfDay, @NotNull ATimeZone zone) {
        Intrinsics.checkNotNullParameter((Object)$this$toDateTimeAtEndOfDay, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)zone, (String)"zone");
        return ADateJvmKt.plusSeconds(ADateJvmKt.toDateTimeAtStartOfDay(ADateJvmKt.plusDays($this$toDateTimeAtEndOfDay, 1), zone), -1);
    }

    @NotNull
    public static final KotlinXDateTime toDateTimeAtEndOfDay(@NotNull KotlinXDate $this$toDateTimeAtEndOfDay) {
        Intrinsics.checkNotNullParameter((Object)$this$toDateTimeAtEndOfDay, (String)"<this>");
        return ADateJvmKt.plusSeconds(ADateJvmKt.toDateTimeAtStartOfDay(ADateJvmKt.plusDays($this$toDateTimeAtEndOfDay, 1)), -1);
    }

    @NotNull
    public static final String offsetToString(@NotNull ATimeZone $this$offsetToString, @NotNull Instant instant) {
        Intrinsics.checkNotNullParameter((Object)$this$offsetToString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
        return TimeZoneKt.offsetAt((TimeZone)ADateKt.getKotlin($this$offsetToString), (Instant)instant).toString();
    }

    @NotNull
    public static final ATimeZone asOffset(@NotNull ATimeZone $this$asOffset) {
        Intrinsics.checkNotNullParameter((Object)$this$asOffset, (String)"<this>");
        return new ATimeZone(TimeZoneKt.offsetAt((TimeZone)ADateKt.getKotlin($this$asOffset), (Instant)Clock.System.INSTANCE.now()).toString());
    }

    @NotNull
    public static final ATimeZone getATimeZone(@NotNull String $this$aTimeZone) {
        Intrinsics.checkNotNullParameter((Object)$this$aTimeZone, (String)"<this>");
        return new ATimeZone($this$aTimeZone);
    }

    @NotNull
    public static final KotlinXDate getATomorrow() {
        return ADateJvmKt.plusDays(ADateJvmKt.getToday(), 1);
    }

    public static final boolean isSame(@NotNull KotlinXDate $this$isSame, @NotNull KotlinXDate other) {
        Intrinsics.checkNotNullParameter((Object)$this$isSame, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return ADateJvmKt.getYear($this$isSame) == ADateJvmKt.getYear(other) && ADateJvmKt.getMonth($this$isSame) == ADateJvmKt.getMonth(other) && ADateJvmKt.getDayOfMonth($this$isSame) == ADateJvmKt.getDayOfMonth(other);
    }

    public static final boolean isToday(@NotNull KotlinXDate $this$isToday) {
        Intrinsics.checkNotNullParameter((Object)$this$isToday, (String)"<this>");
        return ADateKt.isSame($this$isToday, ADateJvmKt.getToday());
    }

    public static final boolean isTomorrow(@NotNull KotlinXDate $this$isTomorrow) {
        Intrinsics.checkNotNullParameter((Object)$this$isTomorrow, (String)"<this>");
        return ADateKt.isSame($this$isTomorrow, ADateKt.getATomorrow());
    }

    public static final int minutesDifferenceAbs(@NotNull KotlinXDateTime $this$minutesDifferenceAbs, @NotNull KotlinXDateTime other) {
        Intrinsics.checkNotNullParameter((Object)$this$minutesDifferenceAbs, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return (int)(ADateKt.differenceInMs($this$minutesDifferenceAbs, other, true) / (long)1000 / (long)60);
    }

    public static final int minutesDifference(@NotNull KotlinXDateTime $this$minutesDifference, @NotNull KotlinXDateTime other) {
        Intrinsics.checkNotNullParameter((Object)$this$minutesDifference, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return (int)(ADateKt.differenceInMs($this$minutesDifference, other, false) / (long)1000 / (long)60);
    }

    public static final long differenceInMs(@NotNull KotlinXDateTime $this$differenceInMs, @NotNull KotlinXDateTime other, boolean abs) {
        Intrinsics.checkNotNullParameter((Object)$this$differenceInMs, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        long diff = ADateJvmKt.getMillis(other) - ADateJvmKt.getMillis($this$differenceInMs);
        return abs ? Math.abs(diff) : diff;
    }

    public static /* synthetic */ long differenceInMs$default(KotlinXDateTime kotlinXDateTime, KotlinXDateTime kotlinXDateTime2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return ADateKt.differenceInMs(kotlinXDateTime, kotlinXDateTime2, bl);
    }

    public static final int toLocalMinutesOnDate(@NotNull KotlinXDateTime $this$toLocalMinutesOnDate, @NotNull ATimeZone timezone, @Nullable KotlinXDate targetDate, @Nullable ATimeZone clientZone) {
        Intrinsics.checkNotNullParameter((Object)$this$toLocalMinutesOnDate, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)timezone, (String)"timezone");
        KotlinXDateTime thisInTimezone = ADateJvmKt.withZone($this$toLocalMinutesOnDate, timezone);
        KotlinXDate thisDateInTimezone = ADateJvmKt.toDate(thisInTimezone);
        KotlinXDate kotlinXDate = targetDate;
        if (kotlinXDate == null) {
            kotlinXDate = ADateJvmKt.toDate(ADateJvmKt.withZone(ADateJvmKt.getANow(), timezone));
        }
        KotlinXDate targetDateInTimezone = kotlinXDate;
        int daySinceStart = ADateJvmKt.daysBetween(thisDateInTimezone, targetDateInTimezone);
        KotlinXDateTime kotlinXDateTime = ADateJvmKt.plusDays(thisInTimezone, daySinceStart);
        ATimeZone aTimeZone = clientZone;
        if (aTimeZone == null) {
            aTimeZone = ADateJvmKt.getClientTimeZone();
        }
        KotlinXDateTime desiredStartTime = ADateJvmKt.withZone(kotlinXDateTime, aTimeZone);
        return ADateJvmKt.getHour(desiredStartTime) * 60 + ADateJvmKt.getMinute(desiredStartTime);
    }

    public static /* synthetic */ int toLocalMinutesOnDate$default(KotlinXDateTime kotlinXDateTime, ATimeZone aTimeZone, KotlinXDate kotlinXDate, ATimeZone aTimeZone2, int n, Object object) {
        if ((n & 2) != 0) {
            kotlinXDate = ADateJvmKt.toDate(kotlinXDateTime);
        }
        if ((n & 4) != 0) {
            aTimeZone2 = null;
        }
        return ADateKt.toLocalMinutesOnDate(kotlinXDateTime, aTimeZone, kotlinXDate, aTimeZone2);
    }

    @NotNull
    public static final KotlinXDateTime toLocalTimeOnDate(@NotNull KotlinXDateTime $this$toLocalTimeOnDate, @NotNull ATimeZone timezone, @Nullable KotlinXDate targetDate, @Nullable ATimeZone clientZone) {
        Intrinsics.checkNotNullParameter((Object)$this$toLocalTimeOnDate, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)timezone, (String)"timezone");
        KotlinXDateTime thisInTimezone = ADateJvmKt.withZone($this$toLocalTimeOnDate, timezone);
        KotlinXDate thisDateInTimezone = ADateJvmKt.toDate(thisInTimezone);
        KotlinXDate kotlinXDate = targetDate;
        if (kotlinXDate == null) {
            kotlinXDate = ADateJvmKt.toDate(ADateJvmKt.withZone(ADateJvmKt.getANow(), timezone));
        }
        KotlinXDate targetDateInTimezone = kotlinXDate;
        int daySinceStart = ADateJvmKt.daysBetween(thisDateInTimezone, targetDateInTimezone);
        KotlinXDateTime kotlinXDateTime = ADateJvmKt.plusDays(thisInTimezone, daySinceStart);
        ATimeZone aTimeZone = clientZone;
        if (aTimeZone == null) {
            aTimeZone = ADateJvmKt.getClientTimeZone();
        }
        return ADateJvmKt.withZone(kotlinXDateTime, aTimeZone);
    }

    public static /* synthetic */ KotlinXDateTime toLocalTimeOnDate$default(KotlinXDateTime kotlinXDateTime, ATimeZone aTimeZone, KotlinXDate kotlinXDate, ATimeZone aTimeZone2, int n, Object object) {
        if ((n & 2) != 0) {
            kotlinXDate = null;
        }
        if ((n & 4) != 0) {
            aTimeZone2 = null;
        }
        return ADateKt.toLocalTimeOnDate(kotlinXDateTime, aTimeZone, kotlinXDate, aTimeZone2);
    }

    @NotNull
    public static final KotlinXDateTime toDateTimeFromClientLocalMinutes(@NotNull KotlinXDate $this$toDateTimeFromClientLocalMinutes, int minutes, @NotNull ATimeZone timezone, @Nullable KotlinXDate targetDate, @Nullable ATimeZone clientZone) {
        ATimeZone aTimeZone;
        Intrinsics.checkNotNullParameter((Object)$this$toDateTimeFromClientLocalMinutes, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)timezone, (String)"timezone");
        KotlinXDate kotlinXDate = targetDate;
        if (kotlinXDate == null) {
            kotlinXDate = ADateJvmKt.getToday();
        }
        if ((aTimeZone = clientZone) == null) {
            aTimeZone = ADateJvmKt.getClientTimeZone();
        }
        KotlinXDateTime todayInTimezone = ADateJvmKt.withZone(ADateJvmKt.withTime(ADateJvmKt.toDateTimeAtStartOfDay(kotlinXDate, aTimeZone), minutes / 60, minutes % 60, 0, 0), timezone);
        KotlinXDate dateInTimezone = ADateJvmKt.toDate(todayInTimezone);
        int days = ADateJvmKt.daysBetween($this$toDateTimeFromClientLocalMinutes, dateInTimezone);
        return ADateJvmKt.plusDays(todayInTimezone, -days);
    }

    public static /* synthetic */ KotlinXDateTime toDateTimeFromClientLocalMinutes$default(KotlinXDate kotlinXDate, int n, ATimeZone aTimeZone, KotlinXDate kotlinXDate2, ATimeZone aTimeZone2, int n2, Object object) {
        if ((n2 & 4) != 0) {
            kotlinXDate2 = null;
        }
        if ((n2 & 8) != 0) {
            aTimeZone2 = null;
        }
        return ADateKt.toDateTimeFromClientLocalMinutes(kotlinXDate, n, aTimeZone, kotlinXDate2, aTimeZone2);
    }
}

