/*
 * Decompiled with CFR 0.152.
 */
package circlet.platform.api;

import circlet.platform.api.ARecord;
import circlet.platform.api.Arena;
import circlet.platform.api.ArenaTypesRegistry;
import circlet.platform.api.ArenasKt;
import circlet.platform.api.CallContext;
import circlet.platform.api.ExtArena;
import circlet.platform.api.ExtRecord;
import circlet.platform.api.Ref;
import circlet.platform.api.RefSelector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import libraries.basics.Sync;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0017\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\tJ\"\u0010\u0016\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u00182\u000e\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u0012H\u0016J,\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001b2\u0006\u0010\u001c\u001a\u00020\t2\u0016\u0010\u0019\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u001d0\u0012H\u0016J#\u0010\u001e\u001a\u00020\u001f\"\n\b\u0000\u0010 \u0018\u0001*\u00020\u00102\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H 0\u0007H\u0086\bJ,\u0010\u001e\u001a\u00020\u001f\"\b\b\u0000\u0010 *\u00020\u00102\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H 0\u00072\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H 0\u0012J_\u0010!\u001a\u00020\u001f2\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00072K\u0010\"\u001aG\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\bJ#\u0010#\u001a\u00020\u001f\"\n\b\u0000\u0010 \u0018\u0001*\u00020\u00102\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H 0\u0007H\u0086\bJ,\u0010#\u001a\u00020\u001f\"\b\b\u0000\u0010 *\u00020\u00102\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H 0\u00122\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H 0\u0007J+\u0010$\u001a\u0002H \"\b\b\u0000\u0010 *\u00020\u00102\f\u0010%\u001a\b\u0012\u0004\u0012\u0002H 0&2\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0002\u0010'J\u0016\u0010(\u001a\u00020\u00132\u000e\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000Rc\u0010\u0005\u001aW\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012I\u0012G\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0011\u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u0012\u0012\u0004\u0012\u00020\u00130\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\u0014\u001a \u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u00150\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcirclet/platform/api/ClientArenaRegistry;", "Lcirclet/platform/api/ArenaTypesRegistry;", "()V", "arenaPrefixMaxLength", "", "arenaTSRegistry", "", "Lcirclet/platform/api/Arena;", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "arenaId", "id", "Lcirclet/platform/api/CallContext;", "context", "Lcirclet/platform/api/ARecord;", "arenaTSSelectors", "Lkotlin/reflect/KClass;", "Lcirclet/platform/api/RefSelector;", "arenaTypes", "", "arenas", "arena", "", "type", "extArena", "Lcirclet/platform/api/ExtArena;", "parentArenaId", "Lcirclet/platform/api/ExtRecord;", "registerArena", "", "T", "registerTombstone", "ts", "registerTombstoneSelector", "tombstone", "ref", "Lcirclet/platform/api/Ref;", "(Lcirclet/platform/api/Ref;Lcirclet/platform/api/CallContext;)Lcirclet/platform/api/ARecord;", "tombstoneSelector", "platform-api"})
public final class ClientArenaRegistry
implements ArenaTypesRegistry {
    @NotNull
    private final Map<Integer, Arena<?>> arenas = new LinkedHashMap();
    @NotNull
    private final Map<KClass<? extends ARecord>, List<Arena<?>>> arenaTypes = new LinkedHashMap();
    private int arenaPrefixMaxLength;
    @NotNull
    private final Map<Arena<?>, Function3<String, String, CallContext, ARecord>> arenaTSRegistry = new LinkedHashMap();
    @NotNull
    private final Map<KClass<? extends ARecord>, RefSelector> arenaTSSelectors = new LinkedHashMap();

    public final /* synthetic */ <T extends ARecord> void registerArena(Arena<T> arena2) {
        Intrinsics.checkNotNullParameter(arena2, (String)"arena");
        boolean $i$f$registerArena = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        this.registerArena(arena2, Reflection.getOrCreateKotlinClass(ARecord.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T extends ARecord> void registerArena(@NotNull Arena<T> arena2, @NotNull KClass<T> type) {
        Intrinsics.checkNotNullParameter(arena2, (String)"arena");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Sync sync = Sync.INSTANCE;
        Map<Integer, Arena<?>> lock$iv = this.arenas;
        boolean $i$f$exec = false;
        synchronized (lock$iv) {
            boolean bl = false;
            int prefixHash = arena2.getPrefix().hashCode();
            Arena<?> registered = this.arenas.get(prefixHash);
            if (!(registered == null || Intrinsics.areEqual(registered, arena2))) {
                boolean bl2 = false;
                String string2 = "Arena's hash collision '" + prefixHash + "': trying to add " + arena2 + ", in cache " + registered;
                throw new IllegalArgumentException(string2.toString());
            }
            if (registered == null) {
                Map<Integer, Object> map2 = this.arenas;
                Object object = prefixHash;
                map2.put((Integer)object, arena2);
                map2 = this.arenaTypes;
                object = this.arenaTypes.get(type);
                object = CollectionsKt.plus((Collection)((Collection)(object == null ? (List)new ArrayList() : object)), arena2);
                map2.put((Integer)type, object);
                int n = this.arenaPrefixMaxLength;
                int n2 = arena2.getPrefix().length();
                this.arenaPrefixMaxLength = Math.max(n, n2);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public final Arena<?> arena(@NotNull String arenaId) {
        Intrinsics.checkNotNullParameter((Object)arenaId, (String)"arenaId");
        Sync sync = Sync.INSTANCE;
        Map<Integer, Arena<?>> lock$iv = this.arenas;
        boolean $i$f$exec = false;
        synchronized (lock$iv) {
            boolean bl = false;
            int n = Math.min(this.arenaPrefixMaxLength, arenaId.length());
            if (1 <= n) {
                do {
                    int end;
                    int prefixHash;
                    Arena<?> arena2;
                    if ((arena2 = this.arenas.get(prefixHash = arenaId.subSequence(0, end = n--).hashCode())) == null) continue;
                    return arena2;
                } while (1 <= n);
            }
            Unit unit = Unit.INSTANCE;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Collection<Arena<?>> arenas(@NotNull KClass<? extends ARecord> type) {
        List<Arena<?>> list2;
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Sync sync = Sync.INSTANCE;
        Map<Integer, Arena<?>> lock$iv = this.arenas;
        boolean $i$f$exec = false;
        synchronized (lock$iv) {
            boolean bl = false;
            List<Arena<?>> list3 = this.arenaTypes.get(type);
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl10 : MonitorExitStatement: MONITOREXIT : lock$iv
            list2 = list3;
        }
        if (list2 == null) {
            throw new IllegalStateException(("Arena record type " + type.getSimpleName() + " is not registered").toString());
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ExtArena<?> extArena(@NotNull String parentArenaId, @NotNull KClass<? extends ExtRecord<? extends ARecord>> type) {
        Intrinsics.checkNotNullParameter((Object)parentArenaId, (String)"parentArenaId");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Sync sync = Sync.INSTANCE;
        Map<Integer, Arena<?>> lock$iv = this.arenas;
        boolean $i$f$exec = false;
        synchronized (lock$iv) {
            boolean bl = false;
            Arena<?> arena2 = this.arena(parentArenaId);
            if (arena2 == null) {
                throw new IllegalStateException(("Arena for id '" + parentArenaId + "' is not found").toString());
            }
            Arena<?> parentArena = arena2;
            List<Arena<?>> list2 = this.arenaTypes.get(type);
            if (list2 == null) {
                throw new IllegalStateException(("Arena record type '" + type.getSimpleName() + "' is not registered").toString());
            }
            List<Arena<?>> extensionArenas = list2;
            for (Arena<?> extArena : extensionArenas) {
                if (!(extArena instanceof ExtArena) || !Intrinsics.areEqual(((ExtArena)extArena).getParent(), parentArena)) continue;
                ExtArena extArena2 = (ExtArena)extArena;
                return extArena2;
            }
            throw new IllegalStateException(("Ext arena with parent '" + parentArena + "' and types of records '" + type.getSimpleName() + "' is not found").toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerTombstone(@NotNull Arena<?> arena2, @NotNull Function3<? super String, ? super String, ? super CallContext, ? extends ARecord> ts) {
        Intrinsics.checkNotNullParameter(arena2, (String)"arena");
        Intrinsics.checkNotNullParameter(ts, (String)"ts");
        Sync sync = Sync.INSTANCE;
        Map<Arena<?>, Function3<String, String, CallContext, ARecord>> lock$iv = this.arenaTSRegistry;
        boolean $i$f$exec = false;
        synchronized (lock$iv) {
            boolean bl = false;
            Function3<? super String, ? super String, ? super CallContext, ? extends ARecord> function3 = this.arenaTSRegistry.put(arena2, ts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final <T extends ARecord> T tombstone(@NotNull Ref<? extends T> ref2, @NotNull CallContext context2) {
        ARecord aRecord;
        Intrinsics.checkNotNullParameter(ref2, (String)"ref");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Sync sync = Sync.INSTANCE;
        Map<Arena<?>, Function3<String, String, CallContext, ARecord>> lock$iv = this.arenaTSRegistry;
        boolean $i$f$exec = false;
        synchronized (lock$iv) {
            Object v0;
            block5: {
                void $this$sortedByDescending$iv;
                boolean bl = false;
                Iterable iterable = this.arenaTSRegistry.keySet();
                boolean $i$f$sortedByDescending = false;
                for (Object t : (Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        Arena it = (Arena)b;
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(it.getPrefix().length());
                        it = (Arena)a;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getPrefix().length()));
                    }
                })) {
                    Arena it = (Arena)t;
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)it.getPrefix(), (Object)ref2.getArenaId()) || !it.getSingle() && StringsKt.startsWith$default((String)ref2.getArenaId(), (String)it.getPrefix(), (boolean)false, (int)2, null))) continue;
                    v0 = t;
                    break block5;
                }
                v0 = null;
            }
            Arena arena2 = v0;
            if (arena2 == null) {
                throw new IllegalStateException(("Tombstone for arena " + ref2.getArenaId() + " is not found").toString());
            }
            Arena arena3 = arena2;
            Function3<String, String, CallContext, ARecord> function3 = this.arenaTSRegistry.get(arena3);
            Intrinsics.checkNotNull(function3);
            aRecord = (ARecord)function3.invoke((Object)ref2.getArenaId(), (Object)ref2.getId(), (Object)context2);
        }
        return (T)aRecord;
    }

    public final /* synthetic */ <T extends ARecord> void registerTombstoneSelector(Arena<T> arena2) {
        Intrinsics.checkNotNullParameter(arena2, (String)"arena");
        boolean $i$f$registerTombstoneSelector = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        this.registerTombstoneSelector(Reflection.getOrCreateKotlinClass(ARecord.class), arena2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T extends ARecord> void registerTombstoneSelector(@NotNull KClass<T> type, @NotNull Arena<T> arena2) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter(arena2, (String)"arena");
        Sync sync = Sync.INSTANCE;
        Map<KClass<? extends ARecord>, RefSelector> lock$iv = this.arenaTSSelectors;
        boolean $i$f$exec = false;
        synchronized (lock$iv) {
            boolean bl = false;
            RefSelector refSelector = this.arenaTSSelectors.put(type, new RefSelector(ArenasKt.tombstoneId(arena2), "__TS__"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final RefSelector tombstoneSelector(@NotNull KClass<? extends ARecord> type) {
        RefSelector refSelector;
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Sync sync = Sync.INSTANCE;
        Map<KClass<? extends ARecord>, RefSelector> lock$iv = this.arenaTSSelectors;
        boolean $i$f$exec = false;
        synchronized (lock$iv) {
            boolean bl = false;
            refSelector = (RefSelector)MapsKt.getValue(this.arenaTSSelectors, type);
        }
        return refSelector;
    }

    @Override
    @NotNull
    public ExtArena<?> extArena(@NotNull ARecord record, @NotNull KClass<? extends ExtRecord<? extends ARecord>> type) {
        return ArenaTypesRegistry.DefaultImpls.extArena((ArenaTypesRegistry)this, record, type);
    }

    @Override
    @NotNull
    public ExtArena<?> extArena(@NotNull Ref<? extends ARecord> ref2, @NotNull KClass<? extends ExtRecord<? extends ARecord>> type) {
        return ArenaTypesRegistry.DefaultImpls.extArena((ArenaTypesRegistry)this, ref2, type);
    }
}

