/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.joda.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.StreamReadCapability;
import com.fasterxml.jackson.core.io.NumberInput;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.datatype.joda.cfg.FormatConfig;
import com.fasterxml.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import com.fasterxml.jackson.datatype.joda.deser.JodaDateDeserializerBase;
import java.io.IOException;
import org.joda.time.LocalTime;

public class LocalTimeDeserializer
extends JodaDateDeserializerBase<LocalTime> {
    private static final long serialVersionUID = 1L;

    public LocalTimeDeserializer() {
        this(FormatConfig.DEFAULT_LOCAL_TIMEONLY_PARSER);
    }

    public LocalTimeDeserializer(JacksonJodaDateFormat format2) {
        super(LocalTime.class, format2);
    }

    @Override
    public JodaDateDeserializerBase<?> withFormat(JacksonJodaDateFormat format2) {
        return new LocalTimeDeserializer(format2);
    }

    public LocalTime deserialize(JsonParser p2, DeserializationContext ctxt) throws IOException {
        switch (p2.currentTokenId()) {
            case 7: {
                return new LocalTime(p2.getLongValue());
            }
            case 6: {
                return this._fromString(p2, ctxt, p2.getText());
            }
            case 1: {
                return this._fromString(p2, ctxt, ctxt.extractScalarFromObject(p2, (JsonDeserializer)this, this.handledType()));
            }
        }
        if (p2.isExpectedStartArrayToken()) {
            return this._fromArray(p2, ctxt);
        }
        return (LocalTime)ctxt.handleUnexpectedToken(this.handledType(), p2.currentToken(), p2, "expected JSON Array, String or Number", new Object[0]);
    }

    protected LocalTime _fromString(JsonParser p2, DeserializationContext ctxt, String value2) throws IOException {
        if ((value2 = value2.trim()).isEmpty()) {
            return (LocalTime)this._fromEmptyString(p2, ctxt, value2);
        }
        if (ctxt.isEnabled(StreamReadCapability.UNTYPED_SCALARS) && this._isValidTimestampString(value2)) {
            return new LocalTime(NumberInput.parseLong((String)value2));
        }
        return this._format.createParser(ctxt).parseLocalTime(value2);
    }

    protected LocalTime _fromArray(JsonParser p2, DeserializationContext ctxt) throws IOException {
        p2.nextToken();
        int hour = p2.getIntValue();
        p2.nextToken();
        int minute = p2.getIntValue();
        p2.nextToken();
        int second = p2.getIntValue();
        p2.nextToken();
        int millis = 0;
        if (p2.currentToken() != JsonToken.END_ARRAY) {
            millis = p2.getIntValue();
            p2.nextToken();
        }
        if (p2.currentToken() != JsonToken.END_ARRAY) {
            throw ctxt.wrongTokenException(p2, this.handledType(), JsonToken.END_ARRAY, "after LocalTime ints");
        }
        return new LocalTime(hour, minute, second, millis);
    }
}

