/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.vcs.chat.editor;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.space.vcs.chat.editor.SpaceChatEditor;
import com.intellij.space.vcs.chat.editor.SpaceChatFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/intellij/space/vcs/chat/editor/SpaceChatEditorProvider;", "Lcom/intellij/openapi/fileEditor/FileEditorProvider;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "accept", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "createEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "disposeEditor", "", "editor", "getEditorTypeId", "", "getPolicy", "Lcom/intellij/openapi/fileEditor/FileEditorPolicy;", "intellij.space.vcs"})
public final class SpaceChatEditorProvider
implements FileEditorProvider,
DumbAware {
    public boolean accept(@NotNull Project project2, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return file2 instanceof SpaceChatFile;
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project2, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return (FileEditor)new SpaceChatEditor(project2, (SpaceChatFile)file2);
    }

    @NotNull
    public String getEditorTypeId() {
        return "SpaceChatEditor";
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        return FileEditorPolicy.HIDE_DEFAULT_EDITOR;
    }

    public void disposeEditor(@NotNull FileEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        VirtualFile virtualFile = editor.getFile();
        if (Intrinsics.areEqual((Object)(virtualFile != null ? (Boolean)virtualFile.getUserData(FileEditorManagerImpl.CLOSING_TO_REOPEN) : null), (Object)true) ^ true) {
            Disposer.dispose((Disposable)((Disposable)editor));
        }
        super.disposeEditor(editor);
    }
}

