/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.vcs.review.create;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.space.messages.SpaceBundle;
import com.intellij.space.vcs.SpaceProjectContext;
import com.intellij.space.vcs.SpaceProjectContextKt;
import com.intellij.space.vcs.SpaceProjectInfo;
import com.intellij.space.vcs.SpaceRepoInfo;
import com.intellij.space.vcs.review.SpaceReviewTabController;
import com.intellij.space.vcs.review.SpaceReviewUserDataKeys;
import com.intellij.space.vcs.review.create.BranchData;
import com.intellij.space.vcs.review.create.CommitsData;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.VcsLogData;
import git4idea.GitBranch;
import git4idea.GitRemoteBranch;
import git4idea.branch.GitBranchesCollection;
import git4idea.rebase.log.GitCommitEditingActionBase;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000H\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001b\u0010\u0000\u001a\r\u0012\t\u0012\u00070\u0002\u00a2\u0006\u0002\b\u00030\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a*\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00152\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0018\u0010\u0017\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0018"}, d2={"allRemoteBranches", "", "", "Lorg/jetbrains/annotations/NotNull;", "repository", "Lgit4idea/repo/GitRepository;", "findBranch", "Lcom/intellij/space/vcs/review/create/BranchData;", "project", "Lcom/intellij/openapi/project/Project;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "findCommits", "Lcom/intellij/space/vcs/review/create/CommitsData;", "projectInfo", "Lcom/intellij/space/vcs/SpaceProjectInfo;", "searchBranchesQuickly", "", "getReviewTabController", "Lcom/intellij/space/vcs/review/SpaceReviewTabController;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "getReviewToolWindow", "isCommitsSuitableForCodeReview", "intellij.space.vcs"})
public final class SpaceCreateReviewActionsKt {
    private static final SpaceReviewTabController getReviewTabController(ToolWindow toolWindow) {
        ContentManager contentManager = toolWindow.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"toolWindow.contentManager");
        Content content2 = contentManager.getSelectedContent();
        if (content2 == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)content2, (String)"toolWindow.contentManage\u2026tedContent ?: return null");
        Content selectedContent = content2;
        return (SpaceReviewTabController)SpaceReviewUserDataKeys.INSTANCE.getREVIEW_TAB_CONTROLLER$intellij_space_vcs().get((UserDataHolder)selectedContent);
    }

    private static final SpaceReviewTabController getReviewTabController(AnActionEvent e) {
        Project project2 = e.getProject();
        if (project2 == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"e.project ?: return null");
        Project project3 = project2;
        ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(project3).getToolWindow("Space Code Reviews");
        if (toolWindow == null) {
            return null;
        }
        ToolWindow toolWindow2 = toolWindow;
        return SpaceCreateReviewActionsKt.getReviewTabController(toolWindow2);
    }

    private static final ToolWindow getReviewToolWindow(Project project2) {
        return ToolWindowManager.Companion.getInstance(project2).getToolWindow("Space Code Reviews");
    }

    private static final BranchData findBranch(Project project2, AnActionEvent e) {
        GitBranch branch2;
        GitBranch gitBranch;
        Object v5;
        block6: {
            int selectedCommits2;
            Object object = (VcsLog)e.getData(VcsLogDataKeys.VCS_LOG);
            int n = object != null && (object = object.getSelectedCommits()) != null ? object.size() : (selectedCommits2 = 0);
            if (selectedCommits2 > 1) {
                String string2 = SpaceBundle.message("review.create.merge.request.action.description.error.multiple.selection", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"SpaceBundle.message(\"rev\u2026rror.multiple.selection\")");
                return new BranchData.ErrorDescription(string2);
            }
            List list2 = (List)e.getData(VcsLogDataKeys.VCS_LOG_BRANCHES);
            if (list2 == null) {
                return new BranchData.ErrorDescription("");
            }
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"e.getData(VcsLogDataKeys\u2026Data.ErrorDescription(\"\")");
            List vcsRefs = list2;
            Iterable $this$firstOrNull$iv = vcsRefs;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                VcsRef it = (VcsRef)element$iv;
                boolean bl = false;
                VcsRef vcsRef = it;
                Intrinsics.checkNotNullExpressionValue((Object)vcsRef, (String)"it");
                if (!(Intrinsics.areEqual((Object)vcsRef.getName(), (Object)"HEAD") ^ true)) continue;
                v5 = element$iv;
                break block6;
            }
            v5 = null;
        }
        VcsRef vcsRef = v5;
        if (vcsRef != null) {
            VcsRef vcsRef2;
            VcsRef it = vcsRef2 = vcsRef;
            boolean bl = false;
            GitRepository repository2 = (GitRepository)GitRepositoryManager.getInstance((Project)project2).getRepositoryForRootQuick(it.getRoot());
            GitRepository gitRepository = repository2;
            gitBranch = gitRepository != null && (gitRepository = gitRepository.getBranches()) != null ? gitRepository.findBranchByName(it.getName()) : null;
        } else {
            gitBranch = branch2 = null;
        }
        if (branch2 != null) {
            return new BranchData.Branch(branch2);
        }
        String string3 = SpaceBundle.message("review.create.merge.request.action.description.error", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"SpaceBundle.message(\"rev\u2026ction.description.error\")");
        return new BranchData.ErrorDescription(string3);
    }

    private static final boolean isCommitsSuitableForCodeReview(AnActionEvent e, SpaceProjectInfo projectInfo2) {
        Project project2 = e.getProject();
        if (project2 == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"e.project ?: return false");
        Project project3 = project2;
        return SpaceCreateReviewActionsKt.findCommits(project3, e, projectInfo2, true) instanceof CommitsData.RepoAndCommits;
    }

    /*
     * WARNING - void declaration
     */
    private static final CommitsData findCommits(Project project2, AnActionEvent e, SpaceProjectInfo projectInfo2, boolean searchBranchesQuickly) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        boolean allCommitsOnRemote;
        Set commitBranches;
        Iterable $this$all$iv;
        Map.Entry<SpaceRepoInfo, SpaceProjectInfo> spaceRepoInfo;
        List commits2;
        block16: {
            boolean bl;
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Iterator it;
            Map<SpaceRepoInfo, SpaceProjectInfo> $this$mapTo$iv$iv2;
            VcsLog vcsLog = (VcsLog)e.getData(VcsLogDataKeys.VCS_LOG);
            if (vcsLog == null) {
                return CommitsData.Empty.INSTANCE;
            }
            Intrinsics.checkNotNullExpressionValue((Object)vcsLog, (String)"e.getData(VcsLogDataKeys\u2026 return CommitsData.Empty");
            VcsLog vcsLog2 = vcsLog;
            Object object = e.getData(VcsLogDataKeys.VCS_LOG_DATA_PROVIDER);
            if (!(object instanceof VcsLogData)) {
                object = null;
            }
            VcsLogData vcsLogData = (VcsLogData)object;
            if (vcsLogData == null) {
                return CommitsData.Empty.INSTANCE;
            }
            VcsLogData logDataProvider = vcsLogData;
            List list2 = vcsLog2.getSelectedShortDetails();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"vcsLog.selectedShortDetails");
            commits2 = list2;
            GitRepositoryManager gitRepositoryManager = GitRepositoryManager.getInstance((Project)project2);
            Intrinsics.checkNotNullExpressionValue((Object)gitRepositoryManager, (String)"GitRepositoryManager.getInstance(project)");
            GitRepositoryManager repositoryManager = gitRepositoryManager;
            Iterable $this$map$iv2 = commits2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv2;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo22 = false;
            Iterator iterator2 = $this$mapTo$iv$iv2.iterator();
            while (iterator2.hasNext()) {
                Object item$iv$iv = iterator2.next();
                VcsCommitMetadata vcsCommitMetadata = (VcsCommitMetadata)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl2 = false;
                void v5 = it;
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"it");
                VirtualFile virtualFile = v5.getRoot();
                collection2.add(virtualFile);
            }
            VirtualFile virtualFile = (VirtualFile)CollectionsKt.firstOrNull((List)CollectionsKt.distinct((Iterable)((List)destination$iv$iv)));
            if (virtualFile == null) {
                return CommitsData.Empty.INSTANCE;
            }
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"commits.map { it.root }.\u2026 return CommitsData.Empty");
            VirtualFile root2 = virtualFile;
            GitRepository gitRepository = (GitRepository)repositoryManager.getRepositoryForRootQuick(root2);
            if (gitRepository == null) {
                return CommitsData.Empty.INSTANCE;
            }
            Intrinsics.checkNotNullExpressionValue((Object)gitRepository, (String)"repositoryManager.getRep\u2026 return CommitsData.Empty");
            GitRepository repository2 = gitRepository;
            $this$mapTo$iv$iv2 = SpaceProjectContext.Companion.findProjectMappings(project2, repository2);
            boolean $i$f$filter = false;
            void $i$f$mapTo22 = $this$filter$iv;
            Map destination$iv$iv2 = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            it = $this$filterTo$iv$iv.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it2 = element$iv$iv = it.next();
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)((SpaceProjectInfo)it2.getValue()), (Object)projectInfo2)) continue;
                destination$iv$iv2.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            Map.Entry<SpaceRepoInfo, SpaceProjectInfo> entry = SpaceProjectContextKt.firstMappingOrNull(destination$iv$iv2);
            if (entry == null || (entry = entry.getKey()) == null) {
                return CommitsData.Empty.INSTANCE;
            }
            spaceRepoInfo = entry;
            Set<String> remoteBranches = SpaceCreateReviewActionsKt.allRemoteBranches(repository2);
            $this$all$iv = commits2;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Collection collection3;
                    Collection bl3;
                    VcsCommitMetadata commitData = (VcsCommitMetadata)element$iv;
                    boolean bl4 = false;
                    if (searchBranchesQuickly) {
                        VcsCommitMetadata vcsCommitMetadata = commitData;
                        Intrinsics.checkNotNullExpressionValue((Object)vcsCommitMetadata, (String)"commitData");
                        Hash hash = (Hash)vcsCommitMetadata.getId();
                        Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"commitData.id");
                        bl3 = GitCommitEditingActionBase.Companion.findContainingBranchesQuickly(logDataProvider, root2, hash);
                        collection3 = bl3;
                        if (collection3 == null) {
                            collection3 = CollectionsKt.emptyList();
                        }
                    } else {
                        VcsCommitMetadata vcsCommitMetadata = commitData;
                        Intrinsics.checkNotNullExpressionValue((Object)vcsCommitMetadata, (String)"commitData");
                        Hash hash = (Hash)vcsCommitMetadata.getId();
                        Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"commitData.id");
                        collection3 = GitCommitEditingActionBase.Companion.findContainingBranches(logDataProvider, root2, hash);
                    }
                    if (!(bl3 = (Collection)CollectionsKt.intersect((Iterable)(commitBranches = CollectionsKt.toSet((Iterable)collection3)), (Iterable)remoteBranches)).isEmpty()) continue;
                    bl = false;
                    break block16;
                }
                bl = allCommitsOnRemote = true;
            }
        }
        if (!allCommitsOnRemote) {
            return CommitsData.Empty.INSTANCE;
        }
        $this$all$iv = commits2;
        Map.Entry<SpaceRepoInfo, SpaceProjectInfo> entry = spaceRepoInfo;
        boolean $i$f$map = false;
        void $i$f$filterTo = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string2;
            void it;
            commitBranches = (VcsCommitMetadata)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            void v15 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v15, (String)"it");
            Intrinsics.checkNotNullExpressionValue((Object)((Hash)v15.getId()).asString(), (String)"it.id.asString()");
            collection.add(string2);
        }
        collection = (List)destination$iv$iv;
        List list3 = collection;
        Map.Entry<SpaceRepoInfo, SpaceProjectInfo> entry2 = entry;
        return new CommitsData.RepoAndCommits((SpaceRepoInfo)((Object)entry2), list3);
    }

    static /* synthetic */ CommitsData findCommits$default(Project project2, AnActionEvent anActionEvent, SpaceProjectInfo spaceProjectInfo, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        return SpaceCreateReviewActionsKt.findCommits(project2, anActionEvent, spaceProjectInfo, bl);
    }

    /*
     * WARNING - void declaration
     */
    private static final Set<String> allRemoteBranches(GitRepository repository2) {
        void $this$mapTo$iv$iv;
        GitBranchesCollection gitBranchesCollection = repository2.getBranches();
        Intrinsics.checkNotNullExpressionValue((Object)gitBranchesCollection, (String)"repository.branches");
        Collection collection = gitBranchesCollection.getRemoteBranches();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"repository.branches.remoteBranches");
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            GitRemoteBranch gitRemoteBranch = (GitRemoteBranch)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            void v2 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"it");
            String string2 = v2.getNameForLocalOperations();
            collection2.add(string2);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    public static final /* synthetic */ SpaceReviewTabController access$getReviewTabController(AnActionEvent e) {
        return SpaceCreateReviewActionsKt.getReviewTabController(e);
    }

    public static final /* synthetic */ BranchData access$findBranch(Project project2, AnActionEvent e) {
        return SpaceCreateReviewActionsKt.findBranch(project2, e);
    }

    public static final /* synthetic */ ToolWindow access$getReviewToolWindow(Project project2) {
        return SpaceCreateReviewActionsKt.getReviewToolWindow(project2);
    }

    public static final /* synthetic */ SpaceReviewTabController access$getReviewTabController(ToolWindow toolWindow) {
        return SpaceCreateReviewActionsKt.getReviewTabController(toolWindow);
    }

    public static final /* synthetic */ boolean access$isCommitsSuitableForCodeReview(AnActionEvent e, SpaceProjectInfo projectInfo2) {
        return SpaceCreateReviewActionsKt.isCommitsSuitableForCodeReview(e, projectInfo2);
    }
}

