/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.vcs.review.details;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.space.messages.SpaceBundle;
import com.intellij.space.stats.SpaceStatsCounterCollector;
import com.intellij.space.vcs.SpaceRepoInfo;
import com.intellij.space.vcs.review.details.MergeRequestBranchInfo;
import com.intellij.space.vcs.review.details.MergeRequestDetailsVm;
import com.intellij.space.vcs.review.details.SpaceReviewCheckoutBranchActionKt;
import git4idea.GitLocalBranch;
import git4idea.branch.GitBranchUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/space/vcs/review/details/SpaceReviewUpdateBranchAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.space.vcs"})
public final class SpaceReviewUpdateBranchAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        MergeRequestDetailsVm detailsVm = SpaceReviewCheckoutBranchActionKt.access$getMergeRequestVm(e);
        if (detailsVm == null) {
            Presentation presentation2 = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"e.presentation");
            presentation2.setEnabledAndVisible(false);
            return;
        }
        SpaceRepoInfo repoInfo2 = detailsVm.getRepoInfo().getValue();
        if (repoInfo2 == null) {
            Presentation presentation3 = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation3, (String)"e.presentation");
            presentation3.setEnabledAndVisible(false);
            return;
        }
        MergeRequestBranchInfo mergeRequestBranchInfo = detailsVm.getMergeRequestBranchInfo().getValue();
        if (mergeRequestBranchInfo.getLocalBranch() != null && mergeRequestBranchInfo.isCurrentBranch()) {
            Presentation presentation4 = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation4, (String)"e.presentation");
            presentation4.setEnabledAndVisible(true);
            return;
        }
        Presentation presentation5 = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation5, (String)"e.presentation");
        presentation5.setEnabledAndVisible(false);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"e.project ?: return");
        Project project3 = project2;
        MergeRequestDetailsVm mergeRequestDetailsVm = SpaceReviewCheckoutBranchActionKt.access$getMergeRequestVm(e);
        if (mergeRequestDetailsVm == null) {
            return;
        }
        MergeRequestDetailsVm detailsVm = mergeRequestDetailsVm;
        SpaceRepoInfo spaceRepoInfo = detailsVm.getRepoInfo().getValue();
        if (spaceRepoInfo == null || (spaceRepoInfo = spaceRepoInfo.getRepository()) == null) {
            return;
        }
        SpaceRepoInfo gitRepository = spaceRepoInfo;
        GitLocalBranch gitLocalBranch = detailsVm.getMergeRequestBranchInfo().getValue().getLocalBranch();
        if (gitLocalBranch == null) {
            return;
        }
        GitLocalBranch localBranch = gitLocalBranch;
        SpaceStatsCounterCollector.UPDATE_BRANCH.log();
        GitBranchUtil.updateBranches((Project)project3, (List)CollectionsKt.listOf((Object)gitRepository), (List)CollectionsKt.listOf((Object)localBranch.getName()));
    }

    public SpaceReviewUpdateBranchAction() {
        super(SpaceBundle.messagePointer("review.actions.update.branch", new Object[0]));
    }
}

