/*
 * Decompiled with CFR 0.152.
 */
package libraries.io.channels;

import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import libraries.io.channels.FileChannelsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016R\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Llibraries/io/channels/TemporaryFileReadableChannel;", "Ljava/nio/channels/ReadableByteChannel;", "filePath", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "delegate", "close", "", "isOpen", "", "read", "", "dst", "Ljava/nio/ByteBuffer;", "libraries-io"})
public final class TemporaryFileReadableChannel
implements ReadableByteChannel {
    @NotNull
    private final Path filePath;
    @NotNull
    private final ReadableByteChannel delegate;

    public TemporaryFileReadableChannel(@NotNull Path filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        this.filePath = filePath;
        this.delegate = FileChannelsKt.readableChannel$default(this.filePath, 0L, 1, null);
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public int read(@Nullable ByteBuffer dst) {
        return this.delegate.read(dst);
    }

    @Override
    public void close() {
        this.delegate.close();
        Files.deleteIfExists(this.filePath);
    }
}

