/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.event;

import java.util.Arrays;
import javax.swing.event.EventListenerList;
import org.apache.ivy.core.event.FilteredIvyListener;
import org.apache.ivy.core.event.IvyEvent;
import org.apache.ivy.core.event.IvyEventFilter;
import org.apache.ivy.core.event.IvyListener;
import org.apache.ivy.plugins.repository.TransferEvent;
import org.apache.ivy.plugins.repository.TransferListener;
import org.apache.ivy.util.filter.Filter;

public class EventManager
implements TransferListener {
    private EventListenerList listeners = new EventListenerList();

    public void addIvyListener(IvyListener listener2) {
        this.listeners.add(IvyListener.class, listener2);
    }

    public void addIvyListener(IvyListener listener2, String eventName) {
        this.addIvyListener(listener2, new IvyEventFilter(eventName, null, null));
    }

    public void addIvyListener(IvyListener listener2, Filter<IvyEvent> filter2) {
        this.listeners.add(IvyListener.class, new FilteredIvyListener(listener2, filter2));
    }

    public void removeIvyListener(IvyListener listener2) {
        IvyListener[] listeners;
        this.listeners.remove(IvyListener.class, listener2);
        for (IvyListener listen : listeners = (IvyListener[])this.listeners.getListeners(IvyListener.class)) {
            if (!(listen instanceof FilteredIvyListener) || !listener2.equals(((FilteredIvyListener)listen).getIvyListener())) continue;
            this.listeners.remove(IvyListener.class, listen);
        }
    }

    public boolean hasIvyListener(IvyListener listener2) {
        IvyListener[] listeners;
        for (IvyListener listen : listeners = (IvyListener[])this.listeners.getListeners(IvyListener.class)) {
            if (!(listen instanceof FilteredIvyListener) || !listener2.equals(((FilteredIvyListener)listen).getIvyListener())) continue;
            return true;
        }
        return false;
    }

    public void fireIvyEvent(IvyEvent evt) {
        Object[] listeners = this.listeners.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IvyListener.class) continue;
            ((IvyListener)listeners[i + 1]).progress(evt);
        }
    }

    public void addTransferListener(TransferListener listener2) {
        this.listeners.add(TransferListener.class, listener2);
    }

    public void removeTransferListener(TransferListener listener2) {
        this.listeners.remove(TransferListener.class, listener2);
    }

    public boolean hasTransferListener(TransferListener listener2) {
        return Arrays.asList(this.listeners.getListeners(TransferListener.class)).contains(listener2);
    }

    protected void fireTransferEvent(TransferEvent evt) {
        Object[] listeners = this.listeners.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TransferListener.class) continue;
            ((TransferListener)listeners[i + 1]).transferProgress(evt);
        }
    }

    @Override
    public void transferProgress(TransferEvent evt) {
        this.fireTransferEvent(evt);
        this.fireIvyEvent(evt);
    }
}

