/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.sort;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.sort.CollectionOfModulesToSort;
import org.apache.ivy.core.sort.ModuleInSort;
import org.apache.ivy.core.sort.NonMatchingVersionReporter;
import org.apache.ivy.plugins.circular.CircularDependencyException;
import org.apache.ivy.plugins.circular.CircularDependencyStrategy;
import org.apache.ivy.plugins.version.VersionMatcher;
import org.apache.ivy.util.Message;

public class ModuleDescriptorSorter {
    private final CollectionOfModulesToSort moduleDescriptors;
    private final List<ModuleDescriptor> sorted = new LinkedList<ModuleDescriptor>();
    private final CircularDependencyStrategy circularDepStrategy;

    public ModuleDescriptorSorter(Collection<ModuleDescriptor> modulesDescriptorsToSort, VersionMatcher matcher2, NonMatchingVersionReporter nonMatchingVersionReporter, CircularDependencyStrategy circularDepStrategy) {
        this.circularDepStrategy = circularDepStrategy;
        this.moduleDescriptors = new CollectionOfModulesToSort(modulesDescriptorsToSort, matcher2, nonMatchingVersionReporter);
    }

    public List<ModuleDescriptor> sortModuleDescriptors() throws CircularDependencyException {
        Message.debug("Nbr of module to sort : " + this.moduleDescriptors.size());
        for (ModuleInSort m2 : this.moduleDescriptors) {
            this.sortModuleDescriptorsHelp(m2, m2);
        }
        return this.sorted;
    }

    private void sortModuleDescriptorsHelp(ModuleInSort current2, ModuleInSort caller) throws CircularDependencyException {
        if (current2.isProcessed()) {
            return;
        }
        if (current2.checkLoop(caller, this.circularDepStrategy)) {
            return;
        }
        DependencyDescriptor[] descriptors = current2.getDependencies();
        Message.debug("Sort dependencies of : " + current2.toString() + " / Number of dependencies = " + descriptors.length);
        current2.setCaller(caller);
        for (DependencyDescriptor descriptor2 : descriptors) {
            ModuleInSort child = this.moduleDescriptors.getModuleDescriptorDependency(descriptor2);
            if (child == null) continue;
            this.sortModuleDescriptorsHelp(child, current2);
        }
        current2.endOfCall();
        Message.debug("Sort done for : " + current2.toString());
        current2.addToSortedListIfRequired(this.sorted);
    }
}

