/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.report;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.ivy.core.cache.ResolutionCacheManager;
import org.apache.ivy.core.report.ConfigurationResolveReport;
import org.apache.ivy.core.report.ResolveReport;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.plugins.report.ReportOutputter;
import org.apache.ivy.plugins.report.XmlReportWriter;
import org.apache.ivy.util.FileUtil;
import org.apache.ivy.util.Message;

public class XmlReportOutputter
implements ReportOutputter {
    private XmlReportWriter writer = new XmlReportWriter();

    @Override
    public String getName() {
        return "xml";
    }

    @Override
    public void output(ResolveReport report2, ResolutionCacheManager cacheMgr, ResolveOptions options2) throws IOException {
        String[] confs;
        for (String conf : confs = report2.getConfigurations()) {
            this.output(report2.getConfigurationReport(conf), report2.getResolveId(), confs, cacheMgr);
        }
    }

    public void output(ConfigurationResolveReport report2, String resolveId, String[] confs, ResolutionCacheManager cacheMgr) throws IOException {
        File reportFile = cacheMgr.getConfigurationResolveReportInCache(resolveId, report2.getConfiguration());
        File reportParentDir = reportFile.getParentFile();
        reportParentDir.mkdirs();
        FileOutputStream stream = new FileOutputStream(reportFile);
        this.writer.output(report2, confs, stream);
        ((OutputStream)stream).close();
        Message.verbose("\treport for " + report2.getModuleDescriptor().getModuleRevisionId() + " " + report2.getConfiguration() + " produced in " + reportFile);
        File reportXsl = new File(reportParentDir, "ivy-report.xsl");
        File reportCss = new File(reportParentDir, "ivy-report.css");
        if (!reportXsl.exists()) {
            FileUtil.copy(XmlReportOutputter.class.getResourceAsStream("ivy-report.xsl"), reportXsl, null);
        }
        if (!reportCss.exists()) {
            FileUtil.copy(XmlReportOutputter.class.getResourceAsStream("ivy-report.css"), reportCss, null);
        }
    }
}

