/*
 * Decompiled with CFR 0.152.
 */
package runtime.batchSource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.channels.ClosedReceiveChannelException;
import libraries.coroutines.extra.CoroutineBuildersCommonKt;
import libraries.coroutines.extra.Lifetime;
import libraries.coroutines.extra.LifetimeSource;
import libraries.coroutines.extra.LifetimeUtilsKt;
import libraries.coroutines.extra.Lifetimed;
import libraries.klogging.KLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.DispatchJvmKt;
import runtime.async.AtomicBoolean;
import runtime.async.AtomicInteger;
import runtime.async.AtomicKt;
import runtime.batchSource.BatchSource;
import runtime.batchSource.BatchSourceBase;
import runtime.batchSource.BatchSourceKt;
import runtime.batchSource.ChannelItem;
import runtime.batchSource.Result;
import runtime.reactive.MutableProperty;
import runtime.reactive.Property;
import runtime.reactive.PropertyKt;
import runtime.reactive.SequentialLifetimes;
import runtime.reactive.SignalImpl;
import runtime.reactive.SignalKt;
import runtime.reactive.Source;
import runtime.reactive.SourceKt;
import runtime.reactive.property.FlatMapKt;
import runtime.reactive.property.MapKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000f\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u00046789B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J,\u0010&\u001a\u00020\u001b2\u0006\u0010\u0003\u001a\u00020\u00042\u0012\u0010'\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000)0(2\u0006\u0010*\u001a\u00020+H$J\u0019\u0010,\u001a\u00020\u001b2\n\b\u0002\u0010-\u001a\u0004\u0018\u00010+H\u0004\u00a2\u0006\u0002\u0010.J\u0013\u0010/\u001a\u0004\u0018\u00018\u0000H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00100J\r\u00101\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u00102J\u0010\u00103\u001a\u00020\u001b2\u0006\u00104\u001a\u00020+H\u0016J\b\u00105\u001a\u00020\u001bH\u0016R\u001a\u0010\b\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00068TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\nR\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u0014\u0010\u0015\u001a\u00020\u00068TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\nR\u001c\u0010#\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010%0$X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006:"}, d2={"Lruntime/batchSource/BatchSourceBase;", "T", "Lruntime/batchSource/BatchSource;", "lifetime", "Llibraries/coroutines/extra/Lifetime;", "updatedWrapper", "", "(Llibraries/coroutines/extra/Lifetime;Z)V", "first", "getFirst", "()Z", "setFirst", "(Z)V", "hanging", "Lruntime/reactive/Property;", "getHanging", "()Lruntime/reactive/Property;", "hangingAtStart", "getHangingAtStart", "hasMore", "getHasMore", "ignorable", "getIgnorable", "getLifetime", "()Llibraries/coroutines/extra/Lifetime;", "resurrected", "Lruntime/reactive/Source;", "", "getResurrected", "()Lruntime/reactive/Source;", "sl", "Lruntime/reactive/SequentialLifetimes;", "sourceState", "Lruntime/batchSource/BatchSourceBase$State;", "getUpdatedWrapper", "wrapper", "Lruntime/reactive/MutableProperty;", "Lruntime/batchSource/BatchSourceBase$ChannelWrapper;", "launchReadChannel", "ch", "Lkotlinx/coroutines/channels/Channel;", "Lruntime/batchSource/ChannelItem;", "ask", "", "launchReadChannelImpl", "firstBatch", "(Ljava/lang/Integer;)V", "peek", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "pop", "()Ljava/lang/Object;", "reload", "batch", "reset", "ChannelWrapper", "ChannelWrapperNew", "ChannelWrapperOld", "State", "platform-ui"})
public abstract class BatchSourceBase<T>
implements BatchSource<T> {
    @NotNull
    private final Lifetime lifetime;
    private final boolean updatedWrapper;
    @NotNull
    private final SequentialLifetimes sl;
    @NotNull
    private final MutableProperty<ChannelWrapper<T>> wrapper;
    @NotNull
    private final Property<State> sourceState;
    @NotNull
    private final Property<Boolean> hasMore;
    @NotNull
    private final Property<Boolean> hanging;
    @NotNull
    private final Source<Unit> resurrected;
    private boolean first;

    public BatchSourceBase(@NotNull Lifetime lifetime, boolean updatedWrapper) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        this.lifetime = lifetime;
        this.updatedWrapper = updatedWrapper;
        this.sl = new SequentialLifetimes(this.lifetime);
        this.wrapper = PropertyKt.mutableProperty(null);
        this.sourceState = FlatMapKt.flatMap(this.lifetime, (Property)this.wrapper, (Function2)sourceState.1.INSTANCE);
        this.hasMore = MapKt.map((Lifetimed)this.lifetime, this.sourceState, (Function2)hasMore.1.INSTANCE);
        this.hanging = MapKt.map((Lifetimed)this.lifetime, this.sourceState, (Function2)hanging.1.INSTANCE);
        this.resurrected = SourceKt.flatMap((Source)this.wrapper, resurrected.1.INSTANCE);
        this.first = true;
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    public final boolean getUpdatedWrapper() {
        return this.updatedWrapper;
    }

    @Override
    @NotNull
    public Property<Boolean> getHasMore() {
        return this.hasMore;
    }

    @Override
    @NotNull
    public Property<Boolean> getHanging() {
        return this.hanging;
    }

    @Override
    @NotNull
    public Source<Unit> getResurrected() {
        return this.resurrected;
    }

    protected abstract void launchReadChannel(@NotNull Lifetime var1, @NotNull Channel<ChannelItem<T>> var2, int var3);

    protected boolean getIgnorable() {
        return false;
    }

    protected boolean getHangingAtStart() {
        return false;
    }

    public final boolean getFirst() {
        return this.first;
    }

    public final void setFirst(boolean bl) {
        this.first = bl;
    }

    protected final void launchReadChannelImpl(@Nullable Integer firstBatch) {
        Lifetime lt2 = this.sl.next();
        ChannelWrapper wr = this.updatedWrapper ? (ChannelWrapper)new ChannelWrapperNew(lt2, this.getIgnorable(), this.getHangingAtStart()) : (ChannelWrapper)new ChannelWrapperOld(lt2, this.getIgnorable(), this.getHangingAtStart(), this.first);
        this.first = false;
        this.wrapper.setValue(wr);
        Integer n = firstBatch;
        int ask = n == null ? 30 : n;
        this.launchReadChannel(lt2, wr.getCh(), ask);
    }

    public static /* synthetic */ void launchReadChannelImpl$default(BatchSourceBase batchSourceBase, Integer n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: launchReadChannelImpl");
        }
        if ((n2 & 1) != 0) {
            n = null;
        }
        batchSourceBase.launchReadChannelImpl(n);
    }

    @Override
    public void reset() {
        ChannelWrapper<T> channelWrapper = this.wrapper.getValue();
        if (channelWrapper != null) {
            channelWrapper.reset();
        }
    }

    @Override
    public void reload(int batch2) {
        int n;
        KLogger this_$iv = BatchSourceKt.access$getLog$p();
        boolean $i$f$debug = false;
        if (this_$iv.isDebugEnabled()) {
            KLogger kLogger = this_$iv;
            boolean bl = false;
            kLogger.debug(Intrinsics.stringPlus((String)"Reload bucket ", (Object)this));
        }
        ChannelWrapper<T> channelWrapper = this.wrapper.getValue();
        int requestBatchCount = Math.max(channelWrapper == null ? 0 : (n = channelWrapper.getChannelCacheSize()), batch2);
        this.launchReadChannelImpl(requestBatchCount);
    }

    @Override
    @Nullable
    public Object peek(@NotNull Continuation<? super T> $completion) {
        return BatchSourceBase.peek$suspendImpl(this, $completion);
    }

    static /* synthetic */ Object peek$suspendImpl(BatchSourceBase this_, Continuation $completion) {
        ChannelWrapper channelWrapper = this_.wrapper.getValue();
        if (channelWrapper != null) {
            return channelWrapper.peek($completion);
        }
        return null;
    }

    @Override
    public T pop() {
        ChannelWrapper<T> channelWrapper = this.wrapper.getValue();
        Intrinsics.checkNotNull(channelWrapper);
        return channelWrapper.pop();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\bb\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002J\u0013\u0010\u0016\u001a\u0004\u0018\u00018\u0001H\u00a6@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017J\r\u0010\u0018\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010\u0019J\b\u0010\u001a\u001a\u00020\u000eH&R\u001e\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001b"}, d2={"Lruntime/batchSource/BatchSourceBase$ChannelWrapper;", "T", "Llibraries/coroutines/extra/Lifetimed;", "ch", "Lkotlinx/coroutines/channels/Channel;", "Lruntime/batchSource/ChannelItem;", "getCh", "()Lkotlinx/coroutines/channels/Channel;", "channelCacheSize", "", "getChannelCacheSize", "()I", "resurrected", "Lruntime/reactive/Source;", "", "getResurrected", "()Lruntime/reactive/Source;", "state", "Lruntime/reactive/Property;", "Lruntime/batchSource/BatchSourceBase$State;", "getState", "()Lruntime/reactive/Property;", "peek", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "pop", "()Ljava/lang/Object;", "reset", "platform-ui"})
    private static interface ChannelWrapper<T>
    extends Lifetimed {
        @NotNull
        public Channel<ChannelItem<T>> getCh();

        @NotNull
        public Source<Unit> getResurrected();

        @NotNull
        public Property<State> getState();

        public int getChannelCacheSize();

        @Nullable
        public Object peek(@NotNull Continuation<? super T> var1);

        public T pop();

        public void reset();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ.\u0010(\u001a\u00020\u001f2\u0014\u0010)\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010*0\u001b2\u0006\u0010+\u001a\u00020\n2\u0006\u0010,\u001a\u00020\u0004H\u0002J\u0013\u0010-\u001a\u0004\u0018\u00018\u0001H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010.J\r\u0010/\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u00100J\b\u00101\u001a\u00020\u001fH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\r0\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00010\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001f0#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001c0%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00062"}, d2={"Lruntime/batchSource/BatchSourceBase$ChannelWrapperNew;", "T", "Lruntime/batchSource/BatchSourceBase$ChannelWrapper;", "lifetime", "Llibraries/coroutines/extra/Lifetime;", "ignorable", "", "hangingAtStart", "(Llibraries/coroutines/extra/Lifetime;ZZ)V", "bufferIsEmpty", "Lruntime/async/AtomicBoolean;", "ch", "Lkotlinx/coroutines/channels/Channel;", "Lruntime/batchSource/ChannelItem;", "getCh", "()Lkotlinx/coroutines/channels/Channel;", "channelCacheSize", "", "getChannelCacheSize", "()I", "current", "Lruntime/async/AtomicInteger;", "elements", "", "getLifetime", "()Llibraries/coroutines/extra/Lifetime;", "mutableState", "Lruntime/reactive/MutableProperty;", "Lruntime/batchSource/BatchSourceBase$State;", "resurrected", "Lruntime/reactive/Source;", "", "getResurrected", "()Lruntime/reactive/Source;", "resurrectedSignal", "Lruntime/reactive/SignalImpl;", "state", "Lruntime/reactive/Property;", "getState", "()Lruntime/reactive/Property;", "handleHangingState", "ret", "Lruntime/batchSource/Result;", "hasTimedOut", "timeoutAwaiterLt", "peek", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "pop", "()Ljava/lang/Object;", "reset", "platform-ui"})
    private static final class ChannelWrapperNew<T>
    implements ChannelWrapper<T> {
        @NotNull
        private final Lifetime lifetime;
        private final boolean ignorable;
        private final boolean hangingAtStart;
        @NotNull
        private final List<T> elements;
        @NotNull
        private final AtomicInteger current;
        @NotNull
        private final MutableProperty<State> mutableState;
        @NotNull
        private final SignalImpl<Unit> resurrectedSignal;
        @NotNull
        private final AtomicBoolean bufferIsEmpty;
        @NotNull
        private final Channel<ChannelItem<T>> ch;

        public ChannelWrapperNew(@NotNull Lifetime lifetime, boolean ignorable, boolean hangingAtStart) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            this.lifetime = lifetime;
            this.ignorable = ignorable;
            this.hangingAtStart = hangingAtStart;
            this.elements = new ArrayList();
            this.current = AtomicKt.atomicInt(0);
            this.mutableState = PropertyKt.mutableProperty(State.HasMore);
            this.resurrectedSignal = new SignalImpl();
            this.bufferIsEmpty = AtomicKt.atomicBoolean(true);
            this.ch = ChannelKt.Channel$default((int)1, null, null, (int)6, null);
        }

        @Override
        @NotNull
        public Lifetime getLifetime() {
            return this.lifetime;
        }

        @Override
        @NotNull
        public Channel<ChannelItem<T>> getCh() {
            return this.ch;
        }

        @Override
        @NotNull
        public Source<Unit> getResurrected() {
            return this.resurrectedSignal;
        }

        @Override
        @NotNull
        public Property<State> getState() {
            return this.mutableState;
        }

        @Override
        public int getChannelCacheSize() {
            return ((Collection)this.elements).size();
        }

        /*
         * Unable to fully structure code
         */
        @Override
        @Nullable
        public Object peek(@NotNull Continuation<? super T> var1_1) {
            if (!(var1_1 instanceof peek.1)) ** GOTO lbl-1000
            var8_2 = var1_1;
            if ((var8_2.label & -2147483648) != 0) {
                var8_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var1_1){
                    /* synthetic */ Object result;
                    final /* synthetic */ ChannelWrapperNew<T> this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.peek((Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var9_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    if (this.current.getValue() < ((Collection)this.elements).size()) {
                        return this.elements.get(this.current.getValue());
                    }
                    var2_5 = BatchSourceKt.access$getLog$p();
                    condition$iv = this.current.getValue() == ((Collection)this.elements).size();
                    $i$f$assert = false;
                    if (!condition$iv) {
                        var6_10 = $this$assert$iv;
                        $i$a$-assert-BatchSourceBase$ChannelWrapperNew$peek$2 = false;
                        var6_10.error("current == elements.count() but was " + this.current + " == " + ((Collection)this.elements).size());
                    }
                    if (this.getState().getValue() != State.HasMore) {
                        return null;
                    }
                    hasTimedOut = AtomicKt.atomicBoolean(false);
                    ret = PropertyKt.mutableProperty(null);
                    timeoutAwaiterLt = LifetimeUtilsKt.nested(this.getLifetime());
                    CoroutineBuildersCommonKt.launch$default(this.getLifetime(), DispatchJvmKt.getUi(), null, null, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, timeoutAwaiterLt, hasTimedOut, ret, null){
                        int label;
                        final /* synthetic */ ChannelWrapperNew<T> this$0;
                        final /* synthetic */ LifetimeSource $timeoutAwaiterLt;
                        final /* synthetic */ AtomicBoolean $hasTimedOut;
                        final /* synthetic */ MutableProperty<Result<T>> $ret;
                        {
                            this.this$0 = $receiver;
                            this.$timeoutAwaiterLt = $timeoutAwaiterLt;
                            this.$hasTimedOut = $hasTimedOut;
                            this.$ret = $ret;
                            super(2, $completion);
                        }

                        /*
                         * Unable to fully structure code
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object var1_1) {
                            var7_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)var1_1);
                                    this.label = 1;
                                    v0 = this.this$0.getCh().receive((Continuation)this);
                                    ** if (v0 != var7_2) goto lbl11
lbl10:
                                    // 1 sources

                                    return var7_2;
lbl11:
                                    // 1 sources

                                    ** GOTO lbl17
                                }
                                case 1: {
                                    try {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
lbl17:
                                        // 2 sources

                                        var3_3 = v0;
                                        var4_4 = this.this$0;
                                        it = var3_3;
                                        $i$a$-also-BatchSourceBase$ChannelWrapperNew$peek$3$el$1 = false;
                                        ChannelWrapperNew.access$getElements$p(var4_4).add(it.getItem());
                                    }
                                    catch (ClosedReceiveChannelException var4_5) {
                                        var3_3 = null;
                                    }
                                    el = var3_3;
                                    this.$timeoutAwaiterLt.terminate();
                                    if (this.$hasTimedOut.getValue()) {
                                        if (el != null) {
                                            ChannelWrapperNew.access$getMutableState$p(this.this$0).setValue(State.HasMore);
                                            SignalKt.fire(ChannelWrapperNew.access$getResurrectedSignal$p(this.this$0));
                                        }
                                    } else {
                                        v1 = el;
                                        this.$ret.setValue(new Result<T>(v1 == null ? null : v1.getItem()));
                                    }
                                    if (el == null) {
                                        ChannelWrapperNew.access$getMutableState$p(this.this$0).setValue(State.Completed);
                                    }
                                    v2 = var2_9;
                                    ChannelWrapperNew.access$getBufferIsEmpty$p(this.this$0).set(v2 == null ? true : (var4_6 = v2.getBufferIsEmpty()));
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }, 12, null);
                    if (this.ignorable) {
                        if (this.bufferIsEmpty.getValue() && this.hangingAtStart) {
                            this.handleHangingState(ret, hasTimedOut, timeoutAwaiterLt);
                        } else {
                            CoroutineBuildersCommonKt.launch$default(timeoutAwaiterLt, DispatchJvmKt.getUi(), null, null, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, ret, hasTimedOut, timeoutAwaiterLt, null){
                                int label;
                                final /* synthetic */ ChannelWrapperNew<T> this$0;
                                final /* synthetic */ MutableProperty<Result<T>> $ret;
                                final /* synthetic */ AtomicBoolean $hasTimedOut;
                                final /* synthetic */ LifetimeSource $timeoutAwaiterLt;
                                {
                                    this.this$0 = $receiver;
                                    this.$ret = $ret;
                                    this.$hasTimedOut = $hasTimedOut;
                                    this.$timeoutAwaiterLt = $timeoutAwaiterLt;
                                    super(2, $completion);
                                }

                                /*
                                 * Unable to fully structure code
                                 */
                                @Nullable
                                public final Object invokeSuspend(@NotNull Object var1_1) {
                                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)var1_1);
                                            this.label = 1;
                                            v0 = CoroutineBuildersCommonKt.delay(2000, (Continuation<? super Unit>)((Continuation)this));
                                            if (v0 == var2_2) {
                                                return var2_2;
                                            }
                                            ** GOTO lbl13
                                        }
                                        case 1: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v0 = $result;
lbl13:
                                            // 2 sources

                                            ChannelWrapperNew.access$handleHangingState(this.this$0, this.$ret, this.$hasTimedOut, this.$timeoutAwaiterLt);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, 12, null);
                        }
                    }
                    $continuation.label = 1;
                    v0 = SourceKt.awaitFirst(SourceKt.filterNotNull((Source)ret), this.getLifetime(), $continuation);
                    if (v0 == var9_4) {
                        return var9_4;
                    }
                    ** GOTO lbl43
                }
                case 1: {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl43:
                    // 2 sources

                    return ((Result)v0).getResult();
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        @Override
        public T pop() {
            return this.elements.get(this.current.getAndIncrement());
        }

        @Override
        public void reset() {
            this.current.set(0);
            if (this.getState().getValue() != State.HasMore && this.getChannelCacheSize() > 0) {
                this.mutableState.setValue(State.HasMore);
            }
        }

        private final void handleHangingState(MutableProperty<Result<T>> ret, AtomicBoolean hasTimedOut, Lifetime timeoutAwaiterLt) {
            if (!timeoutAwaiterLt.isTerminated()) {
                hasTimedOut.set(true);
                this.mutableState.setValue(State.Hanging);
                ret.setValue(new Result<Object>(null));
            }
        }

        public static final /* synthetic */ MutableProperty access$getMutableState$p(ChannelWrapperNew $this) {
            return $this.mutableState;
        }

        public static final /* synthetic */ SignalImpl access$getResurrectedSignal$p(ChannelWrapperNew $this) {
            return $this.resurrectedSignal;
        }

        public static final /* synthetic */ AtomicBoolean access$getBufferIsEmpty$p(ChannelWrapperNew $this) {
            return $this.bufferIsEmpty;
        }

        public static final /* synthetic */ List access$getElements$p(ChannelWrapperNew $this) {
            return $this.elements;
        }

        public static final /* synthetic */ void access$handleHangingState(ChannelWrapperNew $this, MutableProperty ret, AtomicBoolean hasTimedOut, Lifetime timeoutAwaiterLt) {
            $this.handleHangingState(ret, hasTimedOut, timeoutAwaiterLt);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\tJ.\u0010)\u001a\u00020 2\u0014\u0010*\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010+0\u001c2\u0006\u0010,\u001a\u00020\u00182\u0006\u0010-\u001a\u00020\u0004H\u0002J\u0013\u0010.\u001a\u0004\u0018\u00018\u0001H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010/J\r\u00100\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u00101J\b\u00102\u001a\u00020 H\u0016R \u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\f0\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00010\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020 0$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001d0&8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00063"}, d2={"Lruntime/batchSource/BatchSourceBase$ChannelWrapperOld;", "T", "Lruntime/batchSource/BatchSourceBase$ChannelWrapper;", "lifetime", "Llibraries/coroutines/extra/Lifetime;", "ignorable", "", "hangingAtStart", "firstItem", "(Llibraries/coroutines/extra/Lifetime;ZZZ)V", "ch", "Lkotlinx/coroutines/channels/Channel;", "Lruntime/batchSource/ChannelItem;", "getCh", "()Lkotlinx/coroutines/channels/Channel;", "channelCacheSize", "", "getChannelCacheSize", "()I", "current", "Lruntime/async/AtomicInteger;", "elements", "", "first", "Lruntime/async/AtomicBoolean;", "getLifetime", "()Llibraries/coroutines/extra/Lifetime;", "mutableState", "Lruntime/reactive/MutableProperty;", "Lruntime/batchSource/BatchSourceBase$State;", "resurrected", "Lruntime/reactive/Source;", "", "getResurrected", "()Lruntime/reactive/Source;", "resurrectedSignal", "Lruntime/reactive/SignalImpl;", "state", "Lruntime/reactive/Property;", "getState", "()Lruntime/reactive/Property;", "handleHangingState", "ret", "Lruntime/batchSource/Result;", "hasTimedOut", "timeoutAwaiterLt", "peek", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "pop", "()Ljava/lang/Object;", "reset", "platform-ui"})
    private static final class ChannelWrapperOld<T>
    implements ChannelWrapper<T> {
        @NotNull
        private final Lifetime lifetime;
        private final boolean ignorable;
        private final boolean hangingAtStart;
        @NotNull
        private final List<T> elements;
        @NotNull
        private final AtomicInteger current;
        @NotNull
        private final AtomicBoolean first;
        @NotNull
        private final MutableProperty<State> mutableState;
        @NotNull
        private final SignalImpl<Unit> resurrectedSignal;
        @NotNull
        private final Channel<ChannelItem<T>> ch;

        public ChannelWrapperOld(@NotNull Lifetime lifetime, boolean ignorable, boolean hangingAtStart, boolean firstItem) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            this.lifetime = lifetime;
            this.ignorable = ignorable;
            this.hangingAtStart = hangingAtStart;
            this.elements = new ArrayList();
            this.current = AtomicKt.atomicInt(0);
            this.first = AtomicKt.atomicBoolean(firstItem);
            this.mutableState = PropertyKt.mutableProperty(State.HasMore);
            this.resurrectedSignal = new SignalImpl();
            this.ch = ChannelKt.Channel$default((int)1, null, null, (int)6, null);
        }

        @Override
        @NotNull
        public Lifetime getLifetime() {
            return this.lifetime;
        }

        @Override
        @NotNull
        public Channel<ChannelItem<T>> getCh() {
            return this.ch;
        }

        @Override
        @NotNull
        public Source<Unit> getResurrected() {
            return this.resurrectedSignal;
        }

        @Override
        @NotNull
        public Property<State> getState() {
            return this.mutableState;
        }

        @Override
        public int getChannelCacheSize() {
            return ((Collection)this.elements).size();
        }

        /*
         * Unable to fully structure code
         */
        @Override
        @Nullable
        public Object peek(@NotNull Continuation<? super T> var1_1) {
            if (!(var1_1 instanceof peek.1)) ** GOTO lbl-1000
            var8_2 = var1_1;
            if ((var8_2.label & -2147483648) != 0) {
                var8_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var1_1){
                    /* synthetic */ Object result;
                    final /* synthetic */ ChannelWrapperOld<T> this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.peek((Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var9_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    if (this.current.getValue() < ((Collection)this.elements).size()) {
                        return this.elements.get(this.current.getValue());
                    }
                    var2_5 = BatchSourceKt.access$getLog$p();
                    condition$iv = this.current.getValue() == ((Collection)this.elements).size();
                    $i$f$assert = false;
                    if (!condition$iv) {
                        var6_10 = $this$assert$iv;
                        $i$a$-assert-BatchSourceBase$ChannelWrapperOld$peek$2 = false;
                        var6_10.error("current == elements.count() but was " + this.current + " == " + ((Collection)this.elements).size());
                    }
                    if (this.getState().getValue() != State.HasMore) {
                        return null;
                    }
                    hasTimedOut = AtomicKt.atomicBoolean(false);
                    ret = PropertyKt.mutableProperty(null);
                    timeoutAwaiterLt = LifetimeUtilsKt.nested(this.getLifetime());
                    CoroutineBuildersCommonKt.launch$default(this.getLifetime(), DispatchJvmKt.getUi(), null, null, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, timeoutAwaiterLt, hasTimedOut, ret, null){
                        int label;
                        final /* synthetic */ ChannelWrapperOld<T> this$0;
                        final /* synthetic */ LifetimeSource $timeoutAwaiterLt;
                        final /* synthetic */ AtomicBoolean $hasTimedOut;
                        final /* synthetic */ MutableProperty<Result<T>> $ret;
                        {
                            this.this$0 = $receiver;
                            this.$timeoutAwaiterLt = $timeoutAwaiterLt;
                            this.$hasTimedOut = $hasTimedOut;
                            this.$ret = $ret;
                            super(2, $completion);
                        }

                        /*
                         * Unable to fully structure code
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object var1_1) {
                            var7_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)var1_1);
                                    this.label = 1;
                                    v0 = this.this$0.getCh().receive((Continuation)this);
                                    ** if (v0 != var7_2) goto lbl11
lbl10:
                                    // 1 sources

                                    return var7_2;
lbl11:
                                    // 1 sources

                                    ** GOTO lbl17
                                }
                                case 1: {
                                    try {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
lbl17:
                                        // 2 sources

                                        var3_3 = v0;
                                        var4_4 = this.this$0;
                                        it = var3_3;
                                        $i$a$-also-BatchSourceBase$ChannelWrapperOld$peek$3$el$1 = false;
                                        ChannelWrapperOld.access$getElements$p(var4_4).add(it.getItem());
                                    }
                                    catch (ClosedReceiveChannelException var4_5) {
                                        var3_3 = null;
                                    }
                                    el = var3_3;
                                    this.$timeoutAwaiterLt.terminate();
                                    if (this.$hasTimedOut.getValue()) {
                                        if (el != null) {
                                            ChannelWrapperOld.access$getMutableState$p(this.this$0).setValue(State.HasMore);
                                            SignalKt.fire(ChannelWrapperOld.access$getResurrectedSignal$p(this.this$0));
                                        }
                                    } else {
                                        v1 = el;
                                        this.$ret.setValue(new Result<T>(v1 == null ? null : v1.getItem()));
                                    }
                                    if (el == null) {
                                        ChannelWrapperOld.access$getMutableState$p(this.this$0).setValue(State.Completed);
                                    }
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }, 12, null);
                    if (this.ignorable) {
                        if (this.first.getValue() && this.hangingAtStart) {
                            this.handleHangingState(ret, hasTimedOut, timeoutAwaiterLt);
                        } else {
                            CoroutineBuildersCommonKt.launch$default(timeoutAwaiterLt, DispatchJvmKt.getUi(), null, null, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, ret, hasTimedOut, timeoutAwaiterLt, null){
                                int label;
                                final /* synthetic */ ChannelWrapperOld<T> this$0;
                                final /* synthetic */ MutableProperty<Result<T>> $ret;
                                final /* synthetic */ AtomicBoolean $hasTimedOut;
                                final /* synthetic */ LifetimeSource $timeoutAwaiterLt;
                                {
                                    this.this$0 = $receiver;
                                    this.$ret = $ret;
                                    this.$hasTimedOut = $hasTimedOut;
                                    this.$timeoutAwaiterLt = $timeoutAwaiterLt;
                                    super(2, $completion);
                                }

                                /*
                                 * Unable to fully structure code
                                 */
                                @Nullable
                                public final Object invokeSuspend(@NotNull Object var1_1) {
                                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)var1_1);
                                            this.label = 1;
                                            v0 = CoroutineBuildersCommonKt.delay(2000, (Continuation<? super Unit>)((Continuation)this));
                                            if (v0 == var2_2) {
                                                return var2_2;
                                            }
                                            ** GOTO lbl13
                                        }
                                        case 1: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v0 = $result;
lbl13:
                                            // 2 sources

                                            ChannelWrapperOld.access$handleHangingState(this.this$0, this.$ret, this.$hasTimedOut, this.$timeoutAwaiterLt);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, 12, null);
                        }
                    }
                    $continuation.label = 1;
                    v0 = SourceKt.awaitFirst(SourceKt.filterNotNull((Source)ret), this.getLifetime(), $continuation);
                    if (v0 == var9_4) {
                        return var9_4;
                    }
                    ** GOTO lbl43
                }
                case 1: {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl43:
                    // 2 sources

                    return ((Result)v0).getResult();
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        @Override
        public T pop() {
            return this.elements.get(this.current.getAndIncrement());
        }

        @Override
        public void reset() {
            this.current.set(0);
            if (this.getState().getValue() != State.HasMore && this.getChannelCacheSize() > 0) {
                this.mutableState.setValue(State.HasMore);
            }
        }

        private final void handleHangingState(MutableProperty<Result<T>> ret, AtomicBoolean hasTimedOut, Lifetime timeoutAwaiterLt) {
            this.first.set(false);
            if (!timeoutAwaiterLt.isTerminated()) {
                hasTimedOut.set(true);
                this.mutableState.setValue(State.Hanging);
                ret.setValue(new Result<Object>(null));
            }
        }

        public static final /* synthetic */ MutableProperty access$getMutableState$p(ChannelWrapperOld $this) {
            return $this.mutableState;
        }

        public static final /* synthetic */ SignalImpl access$getResurrectedSignal$p(ChannelWrapperOld $this) {
            return $this.resurrectedSignal;
        }

        public static final /* synthetic */ List access$getElements$p(ChannelWrapperOld $this) {
            return $this.elements;
        }

        public static final /* synthetic */ void access$handleHangingState(ChannelWrapperOld $this, MutableProperty ret, AtomicBoolean hasTimedOut, Lifetime timeoutAwaiterLt) {
            $this.handleHangingState(ret, hasTimedOut, timeoutAwaiterLt);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lruntime/batchSource/BatchSourceBase$State;", "", "(Ljava/lang/String;I)V", "HasMore", "Completed", "Hanging", "platform-ui"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State HasMore = new State();
        public static final /* enum */ State Completed = new State();
        public static final /* enum */ State Hanging = new State();
        private static final /* synthetic */ State[] $VALUES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value2) {
            return Enum.valueOf(State.class, value2);
        }

        static {
            $VALUES = stateArray = new State[]{State.HasMore, State.Completed, State.Hanging};
        }
    }
}

