/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.out;

import com.fasterxml.aalto.impl.ErrorConsts;
import com.fasterxml.aalto.io.UTF8Writer;
import com.fasterxml.aalto.out.CharWName;
import com.fasterxml.aalto.out.OutputCharTypes;
import com.fasterxml.aalto.out.WName;
import com.fasterxml.aalto.out.WriterConfig;
import com.fasterxml.aalto.out.XmlWriter;
import com.fasterxml.aalto.util.XmlCharTypes;
import java.io.IOException;
import java.io.Writer;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.ri.typed.AsciiValueEncoder;

public final class CharXmlWriter
extends XmlWriter {
    static final int DEFAULT_SMALL_SIZE = 200;
    static final int DEFAULT_FULL_BUFFER_SIZE = 1000;
    protected final int mSmallWriteSize;
    protected Writer _out;
    protected char[] _outputBuffer;
    protected int _outputPtr;
    protected final int _outputBufferLen;
    private final int mEncHighChar;
    private final int mTableCheckEnd;
    final XmlCharTypes mCharTypes;

    public CharXmlWriter(WriterConfig cfg, Writer out) {
        super(cfg);
        this._out = out;
        this._outputBuffer = cfg.allocFullCBuffer(1000);
        this._outputBufferLen = this._outputBuffer.length;
        this.mSmallWriteSize = 200;
        this._outputPtr = 0;
        int bitsize = CharXmlWriter.guessEncodingBitSize(cfg);
        this.mEncHighChar = bitsize < 16 ? 1 << bitsize : 65534;
        this.mTableCheckEnd = Math.min(256, this.mEncHighChar);
        this.mCharTypes = bitsize < 8 ? OutputCharTypes.getAsciiCharTypes() : OutputCharTypes.getLatin1CharTypes();
    }

    @Override
    protected int getOutputPtr() {
        return this._outputPtr;
    }

    @Override
    public int getHighestEncodable() {
        return this.mEncHighChar;
    }

    @Override
    public WName constructName(String localName) {
        return new CharWName(localName);
    }

    @Override
    public WName constructName(String prefix, String localName) {
        return new CharWName(prefix, localName);
    }

    @Override
    public void _releaseBuffers() {
        super._releaseBuffers();
        if (this._outputBuffer != null) {
            this._config.freeFullCBuffer(this._outputBuffer);
            this._outputBuffer = null;
        }
    }

    @Override
    public void _closeTarget(boolean doClose) throws IOException {
        if (this._out != null && (doClose || this._out instanceof UTF8Writer)) {
            this._out.close();
            this._out = null;
        }
    }

    @Override
    public final void flush() throws IOException {
        if (this._out != null) {
            this.flushBuffer();
            this._out.flush();
        }
    }

    @Override
    public void writeRaw(char[] cbuf, int offset, int len) throws IOException {
        if (this._out == null) {
            return;
        }
        if (len < this.mSmallWriteSize) {
            if (this._outputPtr + len > this._outputBufferLen) {
                this.flushBuffer();
            }
            System.arraycopy(cbuf, offset, this._outputBuffer, this._outputPtr, len);
            this._outputPtr += len;
            return;
        }
        int ptr = this._outputPtr;
        if (ptr > 0) {
            if (ptr < this.mSmallWriteSize) {
                int needed = this.mSmallWriteSize - ptr;
                System.arraycopy(cbuf, offset, this._outputBuffer, ptr, needed);
                this._outputPtr = ptr + needed;
                len -= needed;
                offset += needed;
            }
            this.flushBuffer();
        }
        this._out.write(cbuf, offset, len);
    }

    @Override
    public void writeRaw(String str, int offset, int len) throws IOException {
        if (this._out == null) {
            return;
        }
        if (len < this.mSmallWriteSize) {
            if (this._outputPtr + len >= this._outputBufferLen) {
                this.flushBuffer();
            }
            str.getChars(offset, offset + len, this._outputBuffer, this._outputPtr);
            this._outputPtr += len;
            return;
        }
        int ptr = this._outputPtr;
        if (ptr > 0) {
            if (ptr < this.mSmallWriteSize) {
                int needed = this.mSmallWriteSize - ptr;
                str.getChars(offset, offset + needed, this._outputBuffer, ptr);
                this._outputPtr = ptr + needed;
                len -= needed;
                offset += needed;
            }
            this.flushBuffer();
        }
        this._out.write(str, offset, len);
    }

    public final void writeCDataStart() throws IOException {
        this.fastWriteRaw("<![CDATA[");
    }

    public final void writeCDataEnd() throws IOException {
        this.fastWriteRaw("]]>");
    }

    public final void writeCommentStart() throws IOException {
        this.fastWriteRaw("<!--");
    }

    public final void writeCommentEnd() throws IOException {
        this.fastWriteRaw("-->");
    }

    @Override
    public int writeCData(String data2) throws IOException, XMLStreamException {
        int len2;
        this.writeCDataStart();
        int offset = 0;
        for (int len = data2.length(); len > 0; len -= len2) {
            char[] buf = this._copyBuffer;
            int blen = buf.length;
            len2 = len < blen ? len : blen;
            data2.getChars(offset, offset + len2, buf, 0);
            int cix = this.writeCDataContents(buf, 0, len2);
            if (cix >= 0) {
                return offset + cix;
            }
            offset += len2;
        }
        this.writeCDataEnd();
        return -1;
    }

    @Override
    public int writeCData(char[] cbuf, int offset, int len) throws IOException, XMLStreamException {
        this.writeCDataStart();
        int ix = this.writeCDataContents(cbuf, offset, len);
        if (ix < 0) {
            this.writeCDataEnd();
        }
        return -1;
    }

    private int writeCDataContents(char[] cbuf, int offset, int len) throws IOException, XMLStreamException {
        len += offset;
        int start = offset;
        block6: while (offset < len) {
            char ch;
            int[] charTypes = this.mCharTypes.OTHER_CHARS;
            int limit = this.mTableCheckEnd;
            while ((ch = cbuf[offset]) < limit && charTypes[ch] == 0) {
                if (this._outputPtr >= this._outputBufferLen) {
                    this.flushBuffer();
                }
                this._outputBuffer[this._outputPtr++] = ch;
                if (++offset < len) continue;
                break block6;
            }
            if ((ch = cbuf[offset++]) < limit) {
                switch (charTypes[ch]) {
                    case 1: {
                        this.reportInvalidChar(ch);
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                    case 4: {
                        this.reportFailedEscaping("CDATA block", ch);
                    }
                    case 17: {
                        if (offset - start < 3 || cbuf[offset - 2] != ']' || cbuf[offset - 3] != ']') break;
                        --offset;
                        this.writeCDataEnd();
                        this.writeCDataStart();
                    }
                }
            } else if (ch >= this.mEncHighChar) {
                this.reportFailedEscaping("CDATA block", ch);
            }
            if (this._outputPtr >= this._outputBufferLen) {
                this.flushBuffer();
            }
            this._outputBuffer[this._outputPtr++] = ch;
        }
        return -1;
    }

    @Override
    public void writeCharacters(String text) throws IOException, XMLStreamException {
        int len2;
        if (this._out == null) {
            return;
        }
        int offset = 0;
        for (int len = text.length(); len > 0; len -= len2) {
            char[] buf = this._copyBuffer;
            int blen = buf.length;
            len2 = len < blen ? len : blen;
            text.getChars(offset, offset + len2, buf, 0);
            this.writeCharacters(buf, 0, len2);
            offset += len2;
        }
    }

    @Override
    public void writeCharacters(char[] cbuf, int offset, int len) throws IOException, XMLStreamException {
        if (this._out == null) {
            return;
        }
        len += offset;
        block6: while (offset < len) {
            char ch;
            block14: {
                block13: {
                    int[] charTypes = this.mCharTypes.TEXT_CHARS;
                    int limit = this.mTableCheckEnd;
                    while ((ch = cbuf[offset]) < limit && charTypes[ch] == 0) {
                        if (this._outputPtr >= this._outputBufferLen) {
                            this.flushBuffer();
                        }
                        this._outputBuffer[this._outputPtr++] = ch;
                        if (++offset < len) continue;
                        break block6;
                    }
                    if ((ch = cbuf[offset++]) >= limit) break block13;
                    switch (charTypes[ch]) {
                        case 1: {
                            this.reportInvalidChar(ch);
                        }
                        case 11: {
                            if (offset < len && cbuf[offset] != '>') break;
                        }
                        case 4: 
                        case 9: 
                        case 10: {
                            this.writeAsEntity(ch);
                            continue block6;
                        }
                        case 2: {
                            if (this._config.willEscapeCR()) {
                                this.writeAsEntity(ch);
                                continue block6;
                            } else {
                                break;
                            }
                        }
                    }
                    break block14;
                }
                if (ch >= this.mEncHighChar) {
                    this.writeAsEntity(ch);
                    continue;
                }
            }
            if (this._outputPtr >= this._outputBufferLen) {
                this.flushBuffer();
            }
            this._outputBuffer[this._outputPtr++] = ch;
        }
    }

    @Override
    public void writeSpace(String data2) throws IOException, XMLStreamException {
        int len2;
        if (this._out == null) {
            return;
        }
        int offset = 0;
        for (int len = data2.length(); len > 0; len -= len2) {
            char[] buf = this._copyBuffer;
            int blen = buf.length;
            len2 = len < blen ? len : blen;
            data2.getChars(offset, offset + len2, buf, 0);
            this.writeSpace(buf, 0, len2);
            offset += len2;
        }
    }

    @Override
    public void writeSpace(char[] cbuf, int offset, int len) throws IOException, XMLStreamException {
        if (this._out == null) {
            return;
        }
        len += offset;
        while (offset < len) {
            char ch;
            if ((ch = cbuf[offset++]) > ' ' && (!this._config.isXml11() || ch != '\u0085' && ch != '\u2028')) {
                this.reportNwfContent(ErrorConsts.WERR_SPACE_CONTENT, ch, offset - 1);
            }
            if (this._outputPtr >= this._outputBufferLen) {
                this.flushBuffer();
            }
            this._outputBuffer[this._outputPtr++] = ch;
        }
    }

    @Override
    public int writeComment(String data2) throws IOException, XMLStreamException {
        int blen;
        if (this._out == null) {
            return -1;
        }
        this.writeCommentStart();
        int offset = 0;
        int cix = -1;
        for (int len = data2.length(); len > 0; len -= blen) {
            char[] buf = this._copyBuffer;
            blen = buf.length;
            if (blen > len) {
                blen = len;
            }
            data2.getChars(offset, offset + blen, buf, 0);
            cix = this.writeCommentContents(buf, 0, blen, false);
            if (cix >= 0) break;
            offset += blen;
        }
        if (cix >= 0) {
            return offset + cix;
        }
        this.writeCommentEnd();
        return -1;
    }

    private int writeCommentContents(char[] cbuf, int offset, int len, boolean last2) throws IOException, XMLStreamException {
        len += offset;
        block6: while (offset < len) {
            char ch;
            int[] charTypes = this.mCharTypes.OTHER_CHARS;
            int limit = this.mTableCheckEnd;
            while ((ch = cbuf[offset]) < limit && charTypes[ch] == 0) {
                if (this._outputPtr >= this._outputBufferLen) {
                    this.flushBuffer();
                }
                this._outputBuffer[this._outputPtr++] = ch;
                if (++offset < len) continue;
                break block6;
            }
            if ((ch = cbuf[offset++]) < limit) {
                switch (charTypes[ch]) {
                    case 1: {
                        this.reportInvalidChar(ch);
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                    case 4: {
                        this.reportFailedEscaping("comment", ch);
                    }
                    case 13: {
                        if (offset != len && cbuf[offset] != '-') break;
                        if (!this._config.willFixContent()) {
                            return offset - 1;
                        }
                        if (this._outputPtr >= this._outputBufferLen) {
                            this.flushBuffer();
                        }
                        this._outputBuffer[this._outputPtr++] = 32;
                    }
                }
            } else if (ch >= this.mEncHighChar) {
                this.reportFailedEscaping("comment", ch);
            }
            if (this._outputPtr >= this._outputBufferLen) {
                this.flushBuffer();
            }
            this._outputBuffer[this._outputPtr++] = ch;
        }
        return -1;
    }

    @Override
    public void writeDTD(String data2) throws IOException, XMLStreamException {
        this.writeRaw(data2, 0, data2.length());
    }

    @Override
    public void writeDTD(WName rootName, String systemId, String publicId, String internalSubset) throws IOException, XMLStreamException {
        this.fastWriteRaw("<!DOCTYPE ");
        this.writeName(rootName);
        if (systemId != null) {
            if (publicId != null) {
                this.fastWriteRaw(" PUBLIC \"");
                this.fastWriteRaw(publicId);
                this.fastWriteRaw("\" \"");
            } else {
                this.fastWriteRaw(" SYSTEM \"");
            }
            this.fastWriteRaw(systemId);
            this.fastWriteRaw('\"');
        }
        if (internalSubset != null && internalSubset.length() > 0) {
            this.fastWriteRaw(' ', '[');
            this.fastWriteRaw(internalSubset);
            this.fastWriteRaw(']');
        }
        this.fastWriteRaw('>');
    }

    @Override
    public void writeEntityReference(WName name) throws IOException, XMLStreamException {
        this.fastWriteRaw('&');
        this.writeName(name);
        this.fastWriteRaw(';');
    }

    @Override
    public void writeXmlDeclaration(String version, String encoding, String standalone) throws IOException, XMLStreamException {
        this.fastWriteRaw("<?xml version='");
        this.fastWriteRaw(version);
        this.fastWriteRaw('\'');
        if (encoding != null && encoding.length() > 0) {
            this.fastWriteRaw(" encoding='");
            this.fastWriteRaw(encoding);
            this.fastWriteRaw('\'');
        }
        if (standalone != null) {
            this.fastWriteRaw(" standalone='");
            this.fastWriteRaw(standalone);
            this.fastWriteRaw('\'');
        }
        this.fastWriteRaw('?', '>');
    }

    @Override
    public int writePI(WName target, String data2) throws IOException, XMLStreamException {
        this.fastWriteRaw('<', '?');
        this.writeName(target);
        if (data2 != null && data2.length() > 0) {
            int blen;
            int offset = 0;
            int cix = -1;
            this.fastWriteRaw(' ');
            for (int len = data2.length(); len > 0; len -= blen) {
                char[] buf = this._copyBuffer;
                blen = buf.length;
                if (blen > len) {
                    blen = len;
                }
                data2.getChars(offset, offset + blen, buf, 0);
                cix = this.writePIContents(buf, 0, blen);
                if (cix >= 0) break;
                offset += blen;
            }
            if (cix >= 0) {
                return offset + cix;
            }
        }
        this.fastWriteRaw('?', '>');
        return -1;
    }

    private int writePIContents(char[] cbuf, int offset, int len) throws IOException, XMLStreamException {
        len += offset;
        block6: while (offset < len) {
            char ch;
            int[] charTypes = this.mCharTypes.OTHER_CHARS;
            int limit = this.mTableCheckEnd;
            while ((ch = cbuf[offset]) < limit && charTypes[ch] == 0) {
                if (this._outputPtr >= this._outputBufferLen) {
                    this.flushBuffer();
                }
                this._outputBuffer[this._outputPtr++] = ch;
                if (++offset < len) continue;
                break block6;
            }
            if ((ch = cbuf[offset++]) < limit) {
                switch (charTypes[ch]) {
                    case 1: {
                        this.reportInvalidChar(ch);
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                    case 4: {
                        this.reportFailedEscaping("processing instruction", ch);
                    }
                    case 12: {
                        if (offset >= len || cbuf[offset] != '>') break;
                        return offset;
                    }
                }
            } else if (ch >= this.mEncHighChar) {
                this.reportFailedEscaping("processing instruction", ch);
            }
            if (this._outputPtr >= this._outputBufferLen) {
                this.flushBuffer();
            }
            this._outputBuffer[this._outputPtr++] = ch;
        }
        return -1;
    }

    @Override
    public void writeStartTagStart(WName name) throws IOException, XMLStreamException {
        int ptr = this._outputPtr;
        int len = name.serializedLength();
        if (ptr + len + 1 > this._outputBufferLen) {
            if (this._out == null) {
                return;
            }
            this.flushBuffer();
            if (len >= this._outputBufferLen) {
                this._out.write(60);
                name.writeChars(this._out);
                return;
            }
            ptr = this._outputPtr;
        }
        char[] buf = this._outputBuffer;
        buf[ptr++] = 60;
        name.appendChars(buf, ptr);
        this._outputPtr = ptr + len;
    }

    @Override
    public void writeStartTagEnd() throws IOException, XMLStreamException {
        this.fastWriteRaw('>');
    }

    @Override
    public void writeStartTagEmptyEnd() throws IOException {
        int ptr = this._outputPtr;
        if (ptr + 2 > this._outputBufferLen) {
            if (this._out == null) {
                return;
            }
            this.flushBuffer();
            ptr = this._outputPtr;
        }
        char[] buf = this._outputBuffer;
        buf[ptr++] = 47;
        buf[ptr++] = 62;
        this._outputPtr = ptr;
    }

    @Override
    public void writeEndTag(WName name) throws IOException, XMLStreamException {
        int ptr = this._outputPtr;
        int len = name.serializedLength();
        if (ptr + len + 3 > this._outputBufferLen) {
            this.flushBuffer();
            if (len + 3 > this._outputBufferLen) {
                this._out.write(60);
                this._out.write(47);
                name.writeChars(this._out);
                this._outputBuffer[this._outputPtr++] = 62;
                return;
            }
            ptr = this._outputPtr;
        }
        char[] buf = this._outputBuffer;
        buf[ptr++] = 60;
        buf[ptr++] = 47;
        name.appendChars(buf, ptr);
        ptr += len;
        buf[ptr++] = 62;
        this._outputPtr = ptr;
    }

    @Override
    public void writeAttribute(WName name, String value) throws IOException, XMLStreamException {
        int len;
        if (this._out == null) {
            return;
        }
        this.fastWriteRaw(' ');
        this.writeName(name);
        this.fastWriteRaw('=', '\"');
        int n = len = value == null ? 0 : value.length();
        if (len > 0) {
            this.writeAttrValue(value, len);
        }
        this.fastWriteRaw('\"');
    }

    @Override
    public void writeAttribute(WName name, char[] value, int offset, int vlen) throws IOException, XMLStreamException {
        if (this._out == null) {
            return;
        }
        this.fastWriteRaw(' ');
        this.writeName(name);
        this.fastWriteRaw('=', '\"');
        if (vlen > 0) {
            this.writeAttrValue(value, offset, vlen);
        }
        this.fastWriteRaw('\"');
    }

    private final void writeAttrValue(String value, int len) throws IOException, XMLStreamException {
        int offset = 0;
        while (len > 0) {
            char[] buf = this._copyBuffer;
            int blen = buf.length;
            int len2 = len < blen ? len : blen;
            value.getChars(offset, offset + len2, buf, 0);
            this.writeAttrValue(buf, 0, len2);
            offset += len2;
            len -= len2;
        }
    }

    private final void writeAttrValue(char[] cbuf, int offset, int len) throws IOException, XMLStreamException {
        if (this._out == null) {
            return;
        }
        if (this._outputPtr + len > this._outputBufferLen) {
            this.writeSplitAttrValue(cbuf, offset, len);
            return;
        }
        len += offset;
        block5: while (offset < len) {
            char ch;
            block11: {
                block10: {
                    int[] charTypes = this.mCharTypes.ATTR_CHARS;
                    int limit = this.mTableCheckEnd;
                    while ((ch = cbuf[offset]) < limit && charTypes[ch] == 0) {
                        this._outputBuffer[this._outputPtr++] = ch;
                        if (++offset < len) continue;
                        break block5;
                    }
                    if ((ch = cbuf[offset++]) >= limit) break block10;
                    switch (charTypes[ch]) {
                        case 1: {
                            this.reportInvalidChar(ch);
                        }
                        case 4: 
                        case 9: 
                        case 10: 
                        case 14: {
                            break block11;
                        }
                        case 2: 
                        case 3: {
                            break block11;
                        }
                        default: {
                            this._outputBuffer[this._outputPtr++] = ch;
                            break;
                        }
                    }
                    continue;
                }
                if (ch < this.mEncHighChar) {
                    this._outputBuffer[this._outputPtr++] = ch;
                    continue;
                }
            }
            this.writeAsEntity(ch);
            if (len - offset < this._outputBufferLen - this._outputPtr) continue;
            this.flushBuffer();
        }
    }

    private final void writeSplitAttrValue(char[] cbuf, int offset, int len) throws IOException, XMLStreamException {
        len += offset;
        block5: while (offset < len) {
            char ch;
            int[] charTypes = this.mCharTypes.ATTR_CHARS;
            int limit = this.mTableCheckEnd;
            while ((ch = cbuf[offset]) < limit && charTypes[ch] == 0) {
                if (this._outputPtr >= this._outputBufferLen) {
                    this.flushBuffer();
                }
                this._outputBuffer[this._outputPtr++] = ch;
                if (++offset < len) continue;
                break block5;
            }
            if ((ch = cbuf[offset++]) < limit) {
                switch (charTypes[ch]) {
                    case 1: {
                        this.reportInvalidChar(ch);
                    }
                    case 4: 
                    case 9: 
                    case 10: 
                    case 14: {
                        this.writeAsEntity(ch);
                        continue block5;
                    }
                    case 2: 
                    case 3: {
                        this.writeAsEntity(ch);
                        continue block5;
                    }
                }
            } else if (ch >= this.mEncHighChar) {
                this.writeAsEntity(ch);
                continue;
            }
            if (this._outputPtr >= this._outputBufferLen) {
                this.flushBuffer();
            }
            this._outputBuffer[this._outputPtr++] = ch;
        }
    }

    @Override
    public void writeTypedValue(AsciiValueEncoder enc) throws IOException, XMLStreamException {
        int free = this._outputBufferLen - this._outputPtr;
        if (enc.bufferNeedsFlush(free)) {
            this.flush();
        }
        while (true) {
            this._outputPtr = enc.encodeMore(this._outputBuffer, this._outputPtr, this._outputBufferLen);
            if (enc.isCompleted()) break;
            this.flushBuffer();
        }
    }

    @Override
    public final void writeAttribute(WName name, AsciiValueEncoder enc) throws IOException, XMLStreamException {
        if (this._out == null) {
            return;
        }
        this.fastWriteRaw(' ');
        this.writeName(name);
        this.fastWriteRaw('=', '\"');
        this.writeTypedValue(enc);
        this.fastWriteRaw('\"');
    }

    private final void flushBuffer() throws IOException {
        if (this._outputPtr > 0 && this._out != null) {
            int ptr = this._outputPtr;
            this._locPastChars += ptr;
            this._locRowStartOffset -= ptr;
            this._outputPtr = 0;
            this._out.write(this._outputBuffer, 0, ptr);
        }
    }

    protected final void writeName(WName name) throws IOException {
        int ptr = this._outputPtr;
        int len = name.serializedLength();
        if (ptr + len > this._outputBufferLen) {
            this.flushBuffer();
            if (len >= this._outputBufferLen) {
                name.writeChars(this._out);
                return;
            }
            ptr = this._outputPtr;
        }
        name.appendChars(this._outputBuffer, ptr);
        this._outputPtr += len;
    }

    private final void fastWriteRaw(char c) throws IOException {
        if (this._outputPtr >= this._outputBufferLen) {
            if (this._out == null) {
                return;
            }
            this.flushBuffer();
        }
        this._outputBuffer[this._outputPtr++] = c;
    }

    private final void fastWriteRaw(char c1, char c2) throws IOException {
        if (this._outputPtr + 1 >= this._outputBufferLen) {
            if (this._out == null) {
                return;
            }
            this.flushBuffer();
        }
        this._outputBuffer[this._outputPtr++] = c1;
        this._outputBuffer[this._outputPtr++] = c2;
    }

    private final void fastWriteRaw(String str) throws IOException {
        int ptr = this._outputPtr;
        int len = str.length();
        if (ptr + len >= this._outputBufferLen) {
            if (this._out == null) {
                return;
            }
            if (len > this._outputBufferLen) {
                this.writeRaw(str, 0, str.length());
                return;
            }
            this.flushBuffer();
            ptr = this._outputPtr;
        }
        str.getChars(0, len, this._outputBuffer, ptr);
        this._outputPtr = ptr + len;
    }

    protected int verifyCDataContent(String content) {
        int ix;
        if (content != null && content.length() >= 3 && (ix = content.indexOf(93)) >= 0) {
            return content.indexOf("]]>", ix);
        }
        return -1;
    }

    protected int verifyCDataContent(char[] c, int start, int end) {
        if (c != null) {
            start += 2;
            while (start < end) {
                char ch = c[start];
                if (ch == ']') {
                    ++start;
                    continue;
                }
                if (ch == '>' && c[start - 1] == ']' && c[start - 2] == ']') {
                    return start - 2;
                }
                start += 2;
            }
        }
        return -1;
    }

    protected int verifyCommentContent(String content) {
        int ix = content.indexOf(45);
        if (ix >= 0 && ix < content.length() - 1) {
            ix = content.indexOf("--", ix);
        }
        return ix;
    }

    protected void writeSegmentedCData(String content, int index) throws IOException {
        int start = 0;
        while (index >= 0) {
            this.fastWriteRaw("<![CDATA[");
            this.writeRaw(content, start, index + 2 - start);
            this.fastWriteRaw("]]>");
            start = index + 2;
            index = content.indexOf("]]>", start);
        }
        this.fastWriteRaw("<![CDATA[");
        this.writeRaw(content, start, content.length() - start);
        this.fastWriteRaw("]]>");
    }

    protected void writeSegmentedCData(char[] c, int start, int len, int index) throws IOException {
        int end = start + len;
        while (index >= 0) {
            this.fastWriteRaw("<![CDATA[");
            this.writeRaw(c, start, index + 2 - start);
            this.fastWriteRaw("]]>");
            start = index + 2;
            index = this.verifyCDataContent(c, start, end);
        }
        this.fastWriteRaw("<![CDATA[");
        this.writeRaw(c, start, end - start);
        this.fastWriteRaw("]]>");
    }

    protected void writeSegmentedComment(String content, int index) throws IOException {
        int len = content.length();
        if (index == len - 1) {
            this.fastWriteRaw("<!--");
            this.writeRaw(content, 0, content.length());
            this.fastWriteRaw(" -->");
            return;
        }
        this.fastWriteRaw("<!--");
        int start = 0;
        while (index >= 0) {
            this.writeRaw(content, start, index + 1 - start);
            this.fastWriteRaw(' ');
            start = index + 1;
            index = content.indexOf("--", start);
        }
        this.writeRaw(content, start, len - start);
        if (content.charAt(len - 1) == '-') {
            this.fastWriteRaw(' ');
        }
        this.fastWriteRaw("-->");
    }

    protected final void writeAsEntity(int c) throws IOException {
        int ptr = this._outputPtr;
        char[] buf = this._outputBuffer;
        if (ptr + 10 >= buf.length) {
            this.flushBuffer();
            ptr = this._outputPtr;
        }
        buf[ptr++] = 38;
        if (c < 256) {
            if (c == 38) {
                buf[ptr++] = 97;
                buf[ptr++] = 109;
                buf[ptr++] = 112;
            } else if (c == 60) {
                buf[ptr++] = 108;
                buf[ptr++] = 116;
            } else if (c == 62) {
                buf[ptr++] = 103;
                buf[ptr++] = 116;
            } else if (c == 39) {
                buf[ptr++] = 97;
                buf[ptr++] = 112;
                buf[ptr++] = 111;
                buf[ptr++] = 115;
            } else if (c == 34) {
                buf[ptr++] = 113;
                buf[ptr++] = 117;
                buf[ptr++] = 111;
                buf[ptr++] = 116;
            } else {
                buf[ptr++] = 35;
                buf[ptr++] = 120;
                if (c >= 16) {
                    int digit = c >> 4;
                    buf[ptr++] = (char)(digit < 10 ? 48 + digit : 87 + digit);
                    c &= 0xF;
                }
                buf[ptr++] = (char)(c < 10 ? 48 + c : 87 + c);
            }
        } else {
            buf[ptr++] = 35;
            buf[ptr++] = 120;
            int shift = 20;
            int origPtr = ptr;
            do {
                int digit;
                if ((digit = c >> shift & 0xF) <= 0 && ptr == origPtr) continue;
                buf[ptr++] = (char)(digit < 10 ? 48 + digit : 87 + digit);
            } while ((shift -= 4) > 0);
            buf[ptr++] = (char)((c &= 0xF) < 10 ? 48 + c : 87 + c);
        }
        buf[ptr++] = 59;
        this._outputPtr = ptr;
    }
}

