/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.impl;

import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.builders.BuildTarget;

public final class BuildTargetChunk {
    private final Set<? extends BuildTarget<?>> myTargets;

    public BuildTargetChunk(Set<? extends BuildTarget<?>> targets) {
        this.myTargets = targets;
    }

    public Set<? extends BuildTarget<?>> getTargets() {
        return this.myTargets;
    }

    public String toString() {
        return this.myTargets.toString();
    }

    public String getPresentableName() {
        String name = this.myTargets.iterator().next().getPresentableName();
        int size = this.myTargets.size();
        return size > 1 ? name + " and " + (size - 1) + " more" : name;
    }

    public static BuildTargetChunk forSingleTarget(@NotNull BuildTarget<?> target) {
        if (target == null) {
            BuildTargetChunk.$$$reportNull$$$0(0);
        }
        return new BuildTargetChunk(Collections.singleton(target));
    }

    public static BuildTargetChunk forModulesChunk(@NotNull ModuleChunk chunk) {
        if (chunk == null) {
            BuildTargetChunk.$$$reportNull$$$0(1);
        }
        return new BuildTargetChunk(chunk.getTargets());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunk";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/jps/builders/impl/BuildTargetChunk";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "forSingleTarget";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "forModulesChunk";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

