/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.cache.model;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.text.UniqueNameGenerator;
import org.jetbrains.annotations.NotNull;

public class DownloadableFileUrl {
    private final String myFileName;
    private final String myFileExtension;
    private final String myDownloadUrl;

    public DownloadableFileUrl(@NotNull String downloadUrl, @NotNull String fileName) {
        if (downloadUrl == null) {
            DownloadableFileUrl.$$$reportNull$$$0(0);
        }
        if (fileName == null) {
            DownloadableFileUrl.$$$reportNull$$$0(1);
        }
        String fileExtension = FileUtilRt.getExtension((String)fileName);
        this.myFileName = FileUtilRt.getNameWithoutExtension((String)fileName);
        this.myFileExtension = fileExtension.length() > 0 && !fileExtension.startsWith(".") ? "." + fileExtension : fileExtension;
        this.myDownloadUrl = downloadUrl;
    }

    @NotNull
    public String getDownloadUrl() {
        String string = this.myDownloadUrl;
        if (string == null) {
            DownloadableFileUrl.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getPresentableFileName() {
        String string = this.myFileName + this.myFileExtension;
        if (string == null) {
            DownloadableFileUrl.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getPresentableDownloadUrl() {
        String string = this.myDownloadUrl;
        if (string == null) {
            DownloadableFileUrl.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getDefaultFileName() {
        String string = this.generateFileName((Condition<? super String>)Conditions.alwaysTrue());
        if (string == null) {
            DownloadableFileUrl.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String generateFileName(@NotNull Condition<? super String> validator) {
        if (validator == null) {
            DownloadableFileUrl.$$$reportNull$$$0(6);
        }
        String string = UniqueNameGenerator.generateUniqueName((String)"", (String)this.myFileName, (String)this.myFileExtension, (String)"_", (String)"", validator);
        if (string == null) {
            DownloadableFileUrl.$$$reportNull$$$0(7);
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DownloadableFileUrl that = (DownloadableFileUrl)o;
        return this.myDownloadUrl.equals(that.myDownloadUrl);
    }

    public int hashCode() {
        return this.myDownloadUrl.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "downloadUrl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/cache/model/DownloadableFileUrl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/cache/model/DownloadableFileUrl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDownloadUrl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableFileName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableDownloadUrl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultFileName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "generateFileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "generateFileName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

