/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.storage;

import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;

final class MurmurHashingService {
    private static final ThreadLocal<ByteBuffer> THREAD_LOCAL_BUFFER = ThreadLocal.withInitial(() -> ByteBuffer.allocate(0x100000));
    static final int HASH_SIZE = 16;

    MurmurHashingService() {
    }

    static byte[] getStringHash(@NotNull String hashableString) {
        if (hashableString == null) {
            MurmurHashingService.$$$reportNull$$$0(0);
        }
        Hasher hasher = Hashing.murmur3_128().newHasher();
        hasher.putString((CharSequence)hashableString, StandardCharsets.UTF_8);
        return hasher.hash().asBytes();
    }

    static byte[] getFileHash(@NotNull File file) throws IOException {
        if (file == null) {
            MurmurHashingService.$$$reportNull$$$0(1);
        }
        Hasher hasher = Hashing.murmur3_128().newHasher();
        try (FileInputStream fis = new FileInputStream(file);
             FileChannel fileChannel = fis.getChannel();){
            ByteBuffer buffer = THREAD_LOCAL_BUFFER.get();
            while (fileChannel.read(buffer) > 0) {
                buffer.flip();
                hasher.putBytes(buffer);
                buffer.clear();
            }
        }
        return hasher.hash().asBytes();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashableString";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/jps/incremental/storage/MurmurHashingService";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getStringHash";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getFileHash";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

