/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.testng;

import com.intellij.rt.execution.junit.ComparisonFailureData;
import com.intellij.rt.execution.testFrameworks.AbstractExpectedPatterns;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

class TestNGExpectedPatterns
extends AbstractExpectedPatterns {
    private static final Pattern SOFT_ASSERT_PATTERN = Pattern.compile("expected \\[(.*)] but found \\[(.*)]", 34);
    private static final Pattern SOFT_ASSERT_CHAINED_PATTERN = Pattern.compile("but found \\[(.*)]", 34);
    private static final List<Pattern> PATTERNS = new ArrayList<Pattern>();
    private static final String[] PATTERN_STRINGS = new String[]{"expected same with:\\<(.*)\\> but was:\\<(.*)\\>", "expected:\\<(.*)\\> but was:\\<(.*)\\>", "expected \\[(.*)\\] but got \\[(.*)\\]", "expected not same with:\\<(.*)\\> but was same:\\<(.*)\\>", "expected \\[(.*)\\] but found \\[(.*)\\]", "\nexpected: .*?\"(.*)\"\n\\s*but: .*?\"(.*)\"", "assertion failed: expected (.*), found (.*)"};

    TestNGExpectedPatterns() {
    }

    public static ComparisonFailureData createExceptionNotification(String message) {
        ComparisonFailureData softAssertNotification = TestNGExpectedPatterns.createExceptionNotification((String)message, (Pattern)SOFT_ASSERT_PATTERN);
        if (softAssertNotification != null) {
            return SOFT_ASSERT_CHAINED_PATTERN.matcher(softAssertNotification.getExpected()).find() ? null : softAssertNotification;
        }
        return TestNGExpectedPatterns.createExceptionNotification((String)message, PATTERNS);
    }

    static {
        TestNGExpectedPatterns.registerPatterns((String[])PATTERN_STRINGS, PATTERNS);
    }
}

