/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.devkit.toolwindow;

import com.intellij.codeWithMe.ClientId;
import com.intellij.diagnostic.logging.LogConsoleBase;
import com.intellij.internal.statistic.StatisticsBundle;
import com.intellij.internal.statistic.devkit.actions.CleanupEventsTestSchemeAction;
import com.intellij.internal.statistic.devkit.actions.ConfigureEventsSchemeFileAction;
import com.intellij.internal.statistic.devkit.actions.GenerateEventsScheme;
import com.intellij.internal.statistic.devkit.actions.OpenEventLogFileAction;
import com.intellij.internal.statistic.devkit.actions.OpenEventsSchemeFileAction;
import com.intellij.internal.statistic.devkit.actions.RecordStateStatisticsEventLogAction;
import com.intellij.internal.statistic.devkit.actions.ShowChangedStateEventsAction;
import com.intellij.internal.statistic.devkit.actions.UpdateEventsSchemeAction;
import com.intellij.internal.statistic.devkit.actions.scheme.AddGroupToTestSchemeAction;
import com.intellij.internal.statistic.devkit.actions.scheme.EditEventsTestSchemeAction;
import com.intellij.internal.statistic.devkit.toolwindow.StatisticsEventLogConsole;
import com.intellij.internal.statistic.devkit.toolwindow.StatisticsEventLogMessageBuilder;
import com.intellij.internal.statistic.devkit.toolwindow.StatisticsEventLogToolWindow;
import com.intellij.internal.statistic.devkit.toolwindow.StatisticsLogFilterModel;
import com.intellij.internal.statistic.eventLog.EventLogListenersManager;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogListener;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.FilterComponent;
import com.intellij.ui.JBColor;
import com.jetbrains.fus.reporting.model.lion3.LogEvent;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00162\u00020\u00012\u00020\u0002:\u0001\u0016B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/internal/statistic/devkit/toolwindow/StatisticsEventLogToolWindow;", "Lcom/intellij/openapi/ui/SimpleToolWindowPanel;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "recorderId", "", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "consoleLog", "Lcom/intellij/internal/statistic/devkit/toolwindow/StatisticsEventLogConsole;", "eventLogListener", "Lcom/intellij/internal/statistic/eventLog/StatisticsEventLogListener;", "messageBuilder", "Lcom/intellij/internal/statistic/devkit/toolwindow/StatisticsEventLogMessageBuilder;", "createActionToolbar", "Ljavax/swing/JComponent;", "createFilter", "Lcom/intellij/ui/FilterComponent;", "model", "Lcom/intellij/internal/statistic/devkit/toolwindow/StatisticsLogFilterModel;", "dispose", "", "Companion", "intellij.platform.statistics.devkit"})
public final class StatisticsEventLogToolWindow
extends SimpleToolWindowPanel
implements Disposable {
    private final StatisticsEventLogConsole consoleLog;
    private final StatisticsEventLogMessageBuilder messageBuilder;
    private final StatisticsEventLogListener eventLogListener;
    private final String recorderId;
    @NotNull
    private static final Set<ValidationResultType> rejectedValidationTypes;
    @NotNull
    private static final Set<String> alertEvents;
    @NotNull
    public static final Companion Companion;

    private final JComponent createActionToolbar() {
        DefaultActionGroup topToolbarActions = new DefaultActionGroup();
        topToolbarActions.add((AnAction)new RecordStateStatisticsEventLogAction(this.recorderId, false));
        topToolbarActions.add((AnAction)new ShowChangedStateEventsAction(this.recorderId));
        topToolbarActions.add((AnAction)new OpenEventLogFileAction(this.recorderId));
        topToolbarActions.addSeparator(StatisticsBundle.message((String)"stats.events.scheme", (Object[])new Object[0]));
        topToolbarActions.add((AnAction)new ConfigureEventsSchemeFileAction(this.recorderId));
        topToolbarActions.add((AnAction)new UpdateEventsSchemeAction(this.recorderId));
        topToolbarActions.add((AnAction)new OpenEventsSchemeFileAction(this.recorderId));
        topToolbarActions.addSeparator(StatisticsBundle.message((String)"stats.events.test.scheme", (Object[])new Object[0]));
        topToolbarActions.add((AnAction)new AddGroupToTestSchemeAction(this.recorderId));
        topToolbarActions.add((AnAction)new CleanupEventsTestSchemeAction(this.recorderId));
        topToolbarActions.add((AnAction)new EditEventsTestSchemeAction(this.recorderId));
        topToolbarActions.add((AnAction)new GenerateEventsScheme(this.recorderId));
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("FusEventLogToolWindow", (ActionGroup)topToolbarActions, true);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"ActionManager.getInstanc\u2026 topToolbarActions, true)");
        ActionToolbar toolbar = actionToolbar;
        toolbar.setShowSeparatorTitles(true);
        toolbar.setTargetComponent((JComponent)((Object)this));
        JComponent jComponent = toolbar.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"toolbar.component");
        return jComponent;
    }

    private final FilterComponent createFilter(Project project, StatisticsLogFilterModel model) {
        return new FilterComponent(model, project, "STATISTICS_EVENT_LOG_FILTER_HISTORY", 5){
            final /* synthetic */ StatisticsLogFilterModel $model;
            final /* synthetic */ Project $project;

            public void filter() {
                Task.Backgroundable task2 = new Task.Backgroundable(this, this.$project, LogConsoleBase.getApplyingFilterTitle()){
                    final /* synthetic */ createFilter.1 this$0;

                    public void run(@NotNull ProgressIndicator indicator) {
                        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                        StatisticsLogFilterModel statisticsLogFilterModel = this.this$0.$model;
                        String string = this.this$0.getFilter();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"filter");
                        statisticsLogFilterModel.updateCustomFilter(string);
                    }
                    {
                        this.this$0 = this$0;
                        super($super_call_param$1, $super_call_param$2);
                    }
                };
                ProgressManager.getInstance().run((Task)task2);
            }
            {
                this.$model = $captured_local_variable$0;
                this.$project = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3);
            }
        };
    }

    public void dispose() {
        boolean $i$f$service = false;
        Class<EventLogListenersManager> serviceClass$iv = EventLogListenersManager.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        ((EventLogListenersManager)object).unsubscribe(this.eventLogListener, this.recorderId);
    }

    public StatisticsEventLogToolWindow(@NotNull Project project, @NotNull String recorderId) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        super(false, true);
        this.recorderId = recorderId;
        this.messageBuilder = new StatisticsEventLogMessageBuilder();
        StatisticsLogFilterModel model = new StatisticsLogFilterModel();
        this.consoleLog = new StatisticsEventLogConsole(project, model, this.recorderId);
        this.eventLogListener = new StatisticsEventLogListener(){

            public void onLogEvent(@NotNull LogEvent validatedEvent, @Nullable String rawEventId, @Nullable Map<String, ? extends Object> rawData) {
                Intrinsics.checkNotNullParameter((Object)validatedEvent, (String)"validatedEvent");
                consoleLog.addLogLine(messageBuilder.buildLogMessage(validatedEvent, rawEventId, rawData));
            }
        };
        JPanel topPanel = new JPanel(new FlowLayout(0));
        topPanel.add((Component)this.createFilter(project, model));
        topPanel.add(this.createActionToolbar());
        topPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, JBColor.border()));
        this.add(topPanel, "North");
        this.setContent(this.consoleLog.getComponent());
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("FusEventLogToolWindow", this.consoleLog.getOrCreateActions(), false);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"ActionManager.getInstanc\u2026g.orCreateActions, false)");
        ActionToolbar verticalToolbar = actionToolbar;
        verticalToolbar.setTargetComponent((JComponent)((Object)this));
        this.setToolbar(verticalToolbar.getComponent());
        Disposer.register((Disposable)this, (Disposable)((Disposable)this.consoleLog));
        boolean $i$f$service = false;
        Class<EventLogListenersManager> serviceClass$iv = EventLogListenersManager.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        ((EventLogListenersManager)object).subscribe(this.eventLogListener, this.recorderId);
    }

    static {
        Companion = new Companion(null);
        rejectedValidationTypes = SetsKt.setOf((Object[])new ValidationResultType[]{ValidationResultType.REJECTED, ValidationResultType.INCORRECT_RULE, ValidationResultType.UNDEFINED_RULE, ValidationResultType.UNREACHABLE_METADATA, ValidationResultType.PERFORMANCE_ISSUE});
        alertEvents = SetsKt.setOf((Object[])new String[]{"validation.too_many_events.alert", "validation.too_many_events"});
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lcom/intellij/internal/statistic/devkit/toolwindow/StatisticsEventLogToolWindow$Companion;", "", "()V", "alertEvents", "", "", "getAlertEvents", "()Ljava/util/Set;", "rejectedValidationTypes", "Lcom/intellij/internal/statistic/eventLog/validator/ValidationResultType;", "getRejectedValidationTypes", "intellij.platform.statistics.devkit"})
    public static final class Companion {
        @NotNull
        public final Set<ValidationResultType> getRejectedValidationTypes() {
            return rejectedValidationTypes;
        }

        @NotNull
        public final Set<String> getAlertEvents() {
            return alertEvents;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

