/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven;

import com.intellij.build.BuildProgressListener;
import com.intellij.build.BuildViewManager;
import com.intellij.build.SyncViewManager;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.OutputBuildEvent;
import com.intellij.ide.CommandLineInspectionProjectConfigurator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.autolink.ExternalSystemUnlinkedProjectAware;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfigurationViewManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ExceptionUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.idea.maven.MavenCommandLineInspectionProjectConfiguratorKt;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenArtifactUtil;
import org.jetbrains.idea.maven.utils.MavenArtifactUtilKt;
import org.jetbrains.idea.maven.utils.MavenUtil;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/idea/maven/MavenCommandLineInspectionProjectConfigurator;", "Lcom/intellij/ide/CommandLineInspectionProjectConfigurator;", "()V", "configureEnvironment", "", "context", "Lcom/intellij/ide/CommandLineInspectionProjectConfigurator$ConfiguratorContext;", "configureProject", "project", "Lcom/intellij/openapi/project/Project;", "getDescription", "", "getName", "LogBuildProgressListener", "intellij.maven"})
public final class MavenCommandLineInspectionProjectConfigurator
implements CommandLineInspectionProjectConfigurator {
    @NotNull
    public String getName() {
        return "maven";
    }

    @NotNull
    public String getDescription() {
        String string = MavenProjectBundle.message("maven.commandline.description", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MavenProjectBundle.messa\u2026commandline.description\")");
        return string;
    }

    public void configureEnvironment(@NotNull CommandLineInspectionProjectConfigurator.ConfiguratorContext context) {
        CommandLineInspectionProjectConfigurator.ConfiguratorContext configuratorContext;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        CommandLineInspectionProjectConfigurator.ConfiguratorContext $this$run = configuratorContext = context;
        boolean bl = false;
        Registry.get((String)"external.system.auto.import.disabled").setValue(true);
        Registry.get((String)"maven.create.dummy.module.on.first.import").setValue(false);
    }

    /*
     * WARNING - void declaration
     */
    public void configureProject(@NotNull Project project2, @NotNull CommandLineInspectionProjectConfigurator.ConfiguratorContext context) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Path path = context.getProjectPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"context.projectPath");
        Path path2 = path;
        String basePath = ((Object)path2).toString();
        String pomXmlFile = basePath + "/pom.xml";
        if (FileUtil.findFirstThatExist((String[])new String[]{pomXmlFile}) == null) {
            return;
        }
        ProjectSystemId projectSystemId = MavenUtil.SYSTEM_ID;
        Intrinsics.checkNotNullExpressionValue((Object)projectSystemId, (String)"MavenUtil.SYSTEM_ID");
        ExternalSystemUnlinkedProjectAware externalSystemUnlinkedProjectAware = ExternalSystemUnlinkedProjectAware.Companion.getInstance(projectSystemId);
        Intrinsics.checkNotNull((Object)externalSystemUnlinkedProjectAware);
        ExternalSystemUnlinkedProjectAware mavenProjectAware = externalSystemUnlinkedProjectAware;
        boolean isMavenProjectLinked = mavenProjectAware.isLinkedProject(project2, basePath);
        MavenCommandLineInspectionProjectConfiguratorKt.access$getLOG$p().info("maven project: " + project2.getName() + " is linked: " + isMavenProjectLinked);
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"Disposer.newDisposable()");
        Disposable disposable2 = disposable;
        LogBuildProgressListener progressListener = new LogBuildProgressListener();
        Project $this$service$iv = project2;
        boolean $i$f$service = false;
        Object object = $this$service$iv.getService(ExternalSystemRunConfigurationViewManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
        ExternalSystemRunConfigurationViewManager externalSystemRunConfigurationViewManager = (ExternalSystemRunConfigurationViewManager)object;
        Project $this$service$iv2 = project2;
        boolean $i$f$service2 = false;
        Object object2 = $this$service$iv2.getService(BuildViewManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getService(T::class.java)");
        BuildViewManager buildViewManager = (BuildViewManager)object2;
        Project $this$service$iv3 = project2;
        boolean $i$f$service3 = false;
        Object object3 = $this$service$iv3.getService(SyncViewManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"getService(T::class.java)");
        SyncViewManager syncViewManager = (SyncViewManager)object3;
        externalSystemRunConfigurationViewManager.addListener((BuildProgressListener)progressListener, disposable2);
        buildViewManager.addListener((BuildProgressListener)progressListener, disposable2);
        syncViewManager.addListener((BuildProgressListener)progressListener, disposable2);
        if (!isMavenProjectLinked) {
            ApplicationManager.getApplication().invokeAndWait(new Runnable(mavenProjectAware, project2, basePath){
                final /* synthetic */ ExternalSystemUnlinkedProjectAware $mavenProjectAware;
                final /* synthetic */ Project $project;
                final /* synthetic */ String $basePath;

                public final void run() {
                    this.$mavenProjectAware.linkAndLoadProject(this.$project, this.$basePath);
                }
                {
                    this.$mavenProjectAware = externalSystemUnlinkedProjectAware;
                    this.$project = project2;
                    this.$basePath = string;
                }
            });
        }
        MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance(project2);
        Promise<?> promise = mavenProjectsManager.waitForImportCompletion();
        while (true) {
            try {
                promise.blockingGet(10, TimeUnit.MILLISECONDS);
                break;
            }
            catch (TimeoutException timeoutException) {
            }
            catch (ExecutionException e) {
                ExceptionUtil.rethrow((Throwable)e);
            }
            ProgressManager.checkCanceled();
        }
        Disposer.dispose((Disposable)disposable2);
        MavenProjectsManager mavenProjectsManager2 = mavenProjectsManager;
        Intrinsics.checkNotNullExpressionValue((Object)mavenProjectsManager2, (String)"mavenProjectsManager");
        for (MavenProject mavenProject2 : mavenProjectsManager2.getProjects()) {
            void $this$filterNotTo$iv$iv;
            Iterable destination$iv$iv;
            Object object4;
            boolean hasReadingProblems = mavenProject2.hasReadingProblems();
            if (hasReadingProblems) {
                MavenProject mavenProject3 = mavenProject2;
                Intrinsics.checkNotNullExpressionValue((Object)mavenProject3, (String)"mavenProject");
                throw (Throwable)new IllegalStateException("Maven project " + mavenProject3.getName() + " has import problems:" + mavenProject2.getProblems());
            }
            boolean hasUnresolvedArtifacts = mavenProject2.hasUnresolvedArtifacts();
            if (hasUnresolvedArtifacts) {
                MavenArtifact it;
                Iterable $this$filterNotTo$iv$iv2;
                MavenProject mavenProject4 = mavenProject2;
                Intrinsics.checkNotNullExpressionValue((Object)mavenProject4, (String)"mavenProject");
                List<MavenArtifact> list = mavenProject4.getDependencies();
                Intrinsics.checkNotNullExpressionValue(list, (String)"mavenProject.dependencies");
                Iterable $this$filterNot$iv = list;
                boolean $i$f$filterNot = false;
                object4 = $this$filterNot$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterNotTo = false;
                for (Object element$iv$iv : $this$filterNotTo$iv$iv2) {
                    it = (MavenArtifact)element$iv$iv;
                    boolean bl = false;
                    MavenArtifact mavenArtifact = it;
                    Intrinsics.checkNotNullExpressionValue((Object)mavenArtifact, (String)"it");
                    if (MavenArtifactUtilKt.resolved(mavenArtifact)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Collection collection = (List)destination$iv$iv;
                List<MavenArtifact> list2 = mavenProject2.getExternalAnnotationProcessors();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"mavenProject.externalAnnotationProcessors");
                $this$filterNot$iv = list2;
                Collection collection2 = collection;
                $i$f$filterNot = false;
                $this$filterNotTo$iv$iv2 = $this$filterNot$iv;
                destination$iv$iv = new ArrayList();
                $i$f$filterNotTo = false;
                for (Object element$iv$iv : $this$filterNotTo$iv$iv2) {
                    it = (MavenArtifact)element$iv$iv;
                    boolean bl = false;
                    MavenArtifact mavenArtifact = it;
                    Intrinsics.checkNotNullExpressionValue((Object)mavenArtifact, (String)"it");
                    if (MavenArtifactUtilKt.resolved(mavenArtifact)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List list3 = (List)destination$iv$iv;
                List unresolvedArtifacts = CollectionsKt.plus((Collection)collection2, (Iterable)list3);
                throw (Throwable)new IllegalStateException("Maven project " + mavenProject2.getName() + " has unresolved artifacts: " + unresolvedArtifacts);
            }
            boolean hasUnresolvedPlugins = mavenProject2.hasUnresolvedPlugins();
            if (!hasUnresolvedPlugins) continue;
            MavenProject mavenProject5 = mavenProject2;
            Intrinsics.checkNotNullExpressionValue((Object)mavenProject5, (String)"mavenProject");
            List<MavenPlugin> list = mavenProject5.getDeclaredPlugins();
            Intrinsics.checkNotNullExpressionValue(list, (String)"mavenProject.declaredPlugins");
            Iterable $this$filterNot$iv = list;
            boolean $i$f$filterNot = false;
            destination$iv$iv = $this$filterNot$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                MavenPlugin plugin = (MavenPlugin)element$iv$iv;
                boolean bl = false;
                File file = mavenProject2.getLocalRepository();
                MavenPlugin mavenPlugin = plugin;
                Intrinsics.checkNotNullExpressionValue((Object)mavenPlugin, (String)"plugin");
                if (MavenArtifactUtil.hasArtifactFile(file, mavenPlugin.getMavenId())) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List unresolvedPlugins = (List)destination$iv$iv2;
            String errorMessage = "maven project: " + mavenProject2.getName() + " has unresolved plugins: " + unresolvedPlugins;
            object4 = System.getProperty("maven.command.line.configurator.exit.on.unresolved.plugins", "false");
            if (Boolean.parseBoolean((String)object4)) {
                throw (Throwable)new IllegalStateException(errorMessage);
            }
            MavenCommandLineInspectionProjectConfiguratorKt.access$getLOG$p().warn(errorMessage);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/idea/maven/MavenCommandLineInspectionProjectConfigurator$LogBuildProgressListener;", "Lcom/intellij/build/BuildProgressListener;", "()V", "onEvent", "", "buildId", "", "event", "Lcom/intellij/build/events/BuildEvent;", "intellij.maven"})
    public static final class LogBuildProgressListener
    implements BuildProgressListener {
        public void onEvent(@NotNull Object buildId, @NotNull BuildEvent event) {
            Intrinsics.checkNotNullParameter((Object)buildId, (String)"buildId");
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            BuildEvent buildEvent = event;
            if (!(buildEvent instanceof OutputBuildEvent)) {
                buildEvent = null;
            }
            OutputBuildEvent outputBuildEvent = (OutputBuildEvent)buildEvent;
            if (outputBuildEvent == null) {
                return;
            }
            OutputBuildEvent outputBuildEvent2 = outputBuildEvent;
            String prefix = outputBuildEvent2.isStdOut() ? "" : "stderr: ";
            MavenCommandLineInspectionProjectConfiguratorKt.access$getMAVEN_OUTPUT_LOG$p().debug(prefix + outputBuildEvent2.getMessage());
        }
    }
}

