/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import com.intellij.DynamicBundle;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.externalSystem.service.execution.cmd.ParametersListLexer;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.TextFieldCompletionProvider;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.execution.MavenArgumentsCompletionProvider;
import org.jetbrains.idea.maven.execution.MavenPomFileChooserDescriptor;
import org.jetbrains.idea.maven.execution.MavenRCSettingsWatcher;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.execution.MavenSelectProjectPopup;
import org.jetbrains.idea.maven.execution.MavenSettingsObservable;
import org.jetbrains.idea.maven.execution.RunnerBundle;
import org.jetbrains.idea.maven.project.MavenConfigurableBundle;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

public class MavenRunnerParametersPanel
implements PanelWithAnchor,
MavenSettingsObservable {
    private JPanel panel;
    protected LabeledComponent<TextFieldWithBrowseButton> workingDirComponent;
    protected LabeledComponent<EditorTextField> goalsComponent;
    private LabeledComponent<EditorTextField> profilesComponent;
    private JBLabel myFakeLabel;
    private JCheckBox myResolveToWorkspaceCheckBox;
    private FixedSizeButton showProjectTreeButton;
    private JComponent anchor;

    public MavenRunnerParametersPanel(final @NotNull Project project2) {
        if (project2 == null) {
            MavenRunnerParametersPanel.$$$reportNull$$$0(0);
        }
        this.$$$setupUI$$$();
        ((TextFieldWithBrowseButton)this.workingDirComponent.getComponent()).addBrowseFolderListener(RunnerBundle.message("maven.select.working.directory", new Object[0]), "", project2, (FileChooserDescriptor)new MavenPomFileChooserDescriptor(project2));
        if (!project2.isDefault()) {
            TextFieldCompletionProvider profilesCompletionProvider = new TextFieldCompletionProvider(true){

                protected void addCompletionVariants(@NotNull String text, int offset, @NotNull String prefix, @NotNull CompletionResultSet result) {
                    if (text == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (prefix == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (result == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    MavenProjectsManager manager = MavenProjectsManager.getInstance(project2);
                    for (String profile : manager.getAvailableProfiles()) {
                        result.addElement((LookupElement)LookupElementBuilder.create((String)ParametersListUtil.join((String[])new String[]{profile})));
                    }
                }

                @NotNull
                protected String getPrefix(@NotNull String currentTextPrefix) {
                    if (currentTextPrefix == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    ParametersListLexer lexer = new ParametersListLexer(currentTextPrefix);
                    while (lexer.nextToken()) {
                        if (lexer.getTokenEnd() != currentTextPrefix.length()) continue;
                        String prefix = lexer.getCurrentToken();
                        if (prefix.startsWith("-") || prefix.startsWith("!")) {
                            prefix = prefix.substring(1);
                        }
                        String string = prefix;
                        if (string == null) {
                            1.$$$reportNull$$$0(4);
                        }
                        return string;
                    }
                    return "";
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 4: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 4: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "text";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "prefix";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "result";
                            break;
                        }
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "currentTextPrefix";
                            break;
                        }
                        case 4: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "org/jetbrains/idea/maven/execution/MavenRunnerParametersPanel$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "org/jetbrains/idea/maven/execution/MavenRunnerParametersPanel$1";
                            break;
                        }
                        case 4: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getPrefix";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "addCompletionVariants";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray;
                            objectArray[2] = "getPrefix";
                            break;
                        }
                        case 4: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 4: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
            this.profilesComponent.setComponent((JComponent)profilesCompletionProvider.createEditor(project2));
            this.goalsComponent.setComponent((JComponent)new MavenArgumentsCompletionProvider(project2).createEditor(project2));
        }
        this.showProjectTreeButton.setIcon(AllIcons.Nodes.Module);
        MavenSelectProjectPopup.attachToWorkingDirectoryField(MavenProjectsManager.getInstance(project2), ((TextFieldWithBrowseButton)this.workingDirComponent.getComponent()).getTextField(), (JButton)this.showProjectTreeButton, this.goalsComponent.getComponent());
        this.setAnchor((JComponent)this.profilesComponent.getLabel());
    }

    public JComponent createComponent() {
        return this.panel;
    }

    public void disposeUIResources() {
    }

    public String getDisplayName() {
        return RunnerBundle.message("maven.runner.parameters.title", new Object[0]);
    }

    protected void setData(MavenRunnerParameters data) {
        data.setWorkingDirPath(((TextFieldWithBrowseButton)this.workingDirComponent.getComponent()).getText());
        List commandLine = ParametersListUtil.parse((String)((EditorTextField)this.goalsComponent.getComponent()).getText());
        int pomFileNameIndex = 1 + commandLine.indexOf("-f");
        if (pomFileNameIndex != 0) {
            if (pomFileNameIndex < commandLine.size()) {
                data.setPomFileName((String)commandLine.remove(pomFileNameIndex));
            }
            commandLine.remove(pomFileNameIndex - 1);
        }
        data.setGoals(commandLine);
        data.setResolveToWorkspace(this.myResolveToWorkspaceCheckBox.isEnabled() && this.myResolveToWorkspaceCheckBox.isSelected());
        LinkedHashMap<String, Boolean> profilesMap = new LinkedHashMap<String, Boolean>();
        List profiles2 = ParametersListUtil.parse((String)((EditorTextField)this.profilesComponent.getComponent()).getText());
        for (String profile : profiles2) {
            boolean isEnabled = true;
            if (profile.startsWith("-") || profile.startsWith("!")) {
                if ((profile = profile.substring(1)).isEmpty()) continue;
                isEnabled = false;
            }
            profilesMap.put(profile, isEnabled);
        }
        data.setProfilesMap(profilesMap);
    }

    protected void getData(MavenRunnerParameters data) {
        ((TextFieldWithBrowseButton)this.workingDirComponent.getComponent()).setText(data.getWorkingDirPath());
        Object commandLine = ParametersList.join(data.getGoals());
        if (data.getPomFileName() != null) {
            commandLine = (String)commandLine + " -f " + data.getPomFileName();
        }
        ((EditorTextField)this.goalsComponent.getComponent()).setText((String)commandLine);
        this.myResolveToWorkspaceCheckBox.setSelected(data.isResolveToWorkspace());
        ParametersList parametersList = new ParametersList();
        for (Map.Entry<String, Boolean> entry : data.getProfilesMap().entrySet()) {
            Object profileName = entry.getKey();
            if (!entry.getValue().booleanValue()) {
                profileName = "-" + (String)profileName;
            }
            parametersList.add((String)profileName);
        }
        ((EditorTextField)this.profilesComponent.getComponent()).setText(parametersList.getParametersString());
    }

    public JComponent getAnchor() {
        return this.anchor;
    }

    public void setAnchor(JComponent anchor) {
        this.anchor = anchor;
        this.workingDirComponent.setAnchor(anchor);
        this.goalsComponent.setAnchor(anchor);
        this.profilesComponent.setAnchor(anchor);
        this.myFakeLabel.setAnchor(anchor);
    }

    @ApiStatus.Internal
    void applyTargetEnvironmentConfiguration(@Nullable String targetName) {
        boolean localTarget = targetName == null;
        this.myResolveToWorkspaceCheckBox.setEnabled(localTarget);
        if (!localTarget) {
            this.myResolveToWorkspaceCheckBox.setSelected(false);
            this.myResolveToWorkspaceCheckBox.setToolTipText(MavenConfigurableBundle.message("maven.settings.on.targets.runner.resolve.workspace.artifacts.tooltip", new Object[0]));
        } else {
            this.myResolveToWorkspaceCheckBox.setToolTipText(MavenConfigurableBundle.message("maven.settings.runner.resolve.workspace.artifacts.tooltip", new Object[0]));
        }
    }

    @Override
    public void registerSettingsWatcher(@NotNull MavenRCSettingsWatcher watcher) {
        if (watcher == null) {
            MavenRunnerParametersPanel.$$$reportNull$$$0(1);
        }
        watcher.registerComponent("workingDir", (Component)this.workingDirComponent);
        watcher.registerComponent("goals", (Component)this.goalsComponent);
        watcher.registerComponent("profiles", (Component)this.profilesComponent);
        watcher.registerComponent("resolveToWorkspace", this.myResolveToWorkspaceCheckBox);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        FixedSizeButton fixedSizeButton;
        LabeledComponent labeledComponent;
        JCheckBox jCheckBox;
        JBLabel jBLabel;
        LabeledComponent labeledComponent2;
        LabeledComponent labeledComponent3;
        JPanel jPanel;
        this.panel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.goalsComponent = labeledComponent3 = new LabeledComponent();
        labeledComponent3.setComponentClass("com.intellij.ui.EditorTextField");
        labeledComponent3.setLabelInsets(new Insets(0, 0, 0, 0));
        labeledComponent3.setLabelLocation("West");
        labeledComponent3.setText(DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenRunnerParametersPanel.class).getString("maven.settings.command.line"));
        jPanel.add((Component)labeledComponent3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, 0, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.profilesComponent = labeledComponent2 = new LabeledComponent();
        labeledComponent2.setComponentClass("com.intellij.ui.EditorTextField");
        labeledComponent2.setLabelLocation("West");
        labeledComponent2.setText(DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenRunnerParametersPanel.class).getString("maven.settings.runner.profiles"));
        jPanel2.add((Component)labeledComponent2, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel2.setFontColor(UIUtil.FontColor.BRIGHTER);
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenRunnerParametersPanel.class).getString("maven.settings.runner.profiles.notes"));
        jPanel2.add((Component)jBLabel2, new GridConstraints(1, 1, 1, 1, 8, 0, 2, 0, null, null, null, 1));
        this.myFakeLabel = jBLabel = new JBLabel();
        jPanel2.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myResolveToWorkspaceCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenRunnerParametersPanel.class).getString("maven.settings.runner.resolve.workspace.artifacts"));
        jCheckBox.setToolTipText(ResourceBundle.getBundle("messages/MavenConfigurableBundle").getString("maven.settings.runner.resolve.workspace.artifacts.tooltip"));
        jPanel.add((Component)jCheckBox, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.workingDirComponent = labeledComponent = new LabeledComponent();
        labeledComponent.setComponentClass("com.intellij.openapi.ui.TextFieldWithBrowseButton");
        labeledComponent.setLabelLocation("West");
        labeledComponent.setText(DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenRunnerParametersPanel.class).getString("maven.settings.working.directory"));
        jPanel3.add((Component)labeledComponent, "Center");
        this.showProjectTreeButton = fixedSizeButton = new FixedSizeButton();
        fixedSizeButton.setToolTipText(ResourceBundle.getBundle("messages/MavenConfigurableBundle").getString("maven.settings.working.directory.tooltip"));
        jPanel3.add((Component)fixedSizeButton, "East");
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.panel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "watcher";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/execution/MavenRunnerParametersPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "registerSettingsWatcher";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

