/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerConfigurationImpl;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.execution.SyncBundle;
import org.jetbrains.idea.maven.importing.MavenAnnotationProcessorsModuleService;
import org.jetbrains.idea.maven.importing.MavenImporter;
import org.jetbrains.idea.maven.importing.MavenProjectImporter;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapter;
import org.jetbrains.idea.maven.model.MavenArtifactInfo;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorTask;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.project.MavenResolveResultProblemProcessor;
import org.jetbrains.idea.maven.project.ResolveContext;
import org.jetbrains.idea.maven.server.MavenArtifactResolveResult;
import org.jetbrains.idea.maven.server.MavenEmbedderWrapper;
import org.jetbrains.idea.maven.server.NativeMavenProjectHolder;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.java.compiler.ProcessorConfigProfile;
import org.jetbrains.jps.model.java.impl.compiler.ProcessorConfigProfileImpl;

public class MavenCompilerAnnotationProcessorPathsImporter
extends MavenImporter {
    public static final String PROFILE_PREFIX = "Annotation profile for ";
    public static final String MAVEN_DEFAULT_ANNOTATION_PROFILE = "Maven default annotation processors profile";
    public static final String DEFAULT_ANNOTATION_PATH_OUTPUT = "target/generated-sources/annotations";
    public static final String DEFAULT_TEST_ANNOTATION_OUTPUT = "target/generated-test-sources/test-annotations";
    public static final String MAVEN_BSC_DEFAULT_ANNOTATION_PROFILE = "Annotation profile for maven-processor-plugin default configuration";
    public static final String DEFAULT_BSC_ANNOTATION_PATH_OUTPUT = "target/generated-sources/apt";
    public static final String DEFAULT_BSC_TEST_ANNOTATION_OUTPUT = "target/generated-sources/apt-test";
    private final Logger LOG = Logger.getInstance(MavenCompilerAnnotationProcessorPathsImporter.class);

    public MavenCompilerAnnotationProcessorPathsImporter() {
        super("org.apache.maven.plugins", "maven-compiler-plugin");
    }

    @Override
    public boolean isApplicable(MavenProject mavenProject2) {
        return true;
    }

    @Override
    public void process(IdeModifiableModelsProvider modifiableModelsProvider, Module module, MavenRootModelAdapter rootModel, MavenProjectsTree mavenModel, MavenProject mavenProject2, MavenProjectChanges changes, Map<MavenProject, String> mavenProjectToModuleName, List<MavenProjectsProcessorTask> postTasks) {
        if (this.getConfig(mavenProject2, "annotationProcessorPaths") == null) {
            return;
        }
        String annotationTargetDir = mavenProject2.getAnnotationProcessorDirectory(false);
        new File(rootModel.toPath(annotationTargetDir).getPath()).mkdirs();
        rootModel.addGeneratedJavaSourceFolder(annotationTargetDir, JavaSourceRootType.SOURCE, false);
        Element config = this.getConfig(mavenProject2, "annotationProcessorPaths");
        this.LOG.assertTrue(config != null);
        List<MavenArtifactInfo> artifactsInfo = MavenCompilerAnnotationProcessorPathsImporter.getArtifactsInfo(config);
        if (artifactsInfo.isEmpty()) {
            return;
        }
        ArrayList<String> moduleNames = new ArrayList<String>();
        for (MavenArtifactInfo info : artifactsInfo) {
            MavenProject mavenArtifact = mavenModel.findProject(new MavenId(info.getGroupId(), info.getArtifactId(), info.getVersion()));
            if (mavenArtifact == null) continue;
            ContainerUtil.addIfNotNull(moduleNames, (Object)mavenProjectToModuleName.get(mavenArtifact));
        }
        moduleNames.trimToSize();
        MavenAnnotationProcessorsModuleService.getInstance(module).setAnnotationProcessorModules(moduleNames);
    }

    @Override
    public void postProcess(Module module, MavenProject mavenProject2, MavenProjectChanges changes, IdeModifiableModelsProvider modifiableModelsProvider) {
        if (!MavenCompilerAnnotationProcessorPathsImporter.isLevelMoreThan6(module)) {
            return;
        }
        Project project2 = module.getProject();
        CompilerConfigurationImpl compilerConfiguration = (CompilerConfigurationImpl)CompilerConfiguration.getInstance((Project)project2);
        MavenProject rootProject = (MavenProject)ObjectUtils.notNull((Object)MavenProjectsManager.getInstance(module.getProject()).findRootProject(mavenProject2), (Object)mavenProject2);
        if (MavenCompilerAnnotationProcessorPathsImporter.shouldEnableAnnotationProcessors(mavenProject2)) {
            boolean isDefault;
            Object moduleProfileName;
            String testAnnotationProcessorDirectory;
            String annotationProcessorDirectory = this.getAnnotationProcessorDirectory(mavenProject2, false, DEFAULT_ANNOTATION_PATH_OUTPUT);
            if (MavenCompilerAnnotationProcessorPathsImporter.isMavenDefaultAnnotationProcessorConfiguration(annotationProcessorDirectory, testAnnotationProcessorDirectory = this.getAnnotationProcessorDirectory(mavenProject2, true, DEFAULT_TEST_ANNOTATION_OUTPUT), mavenProject2, project2)) {
                moduleProfileName = MAVEN_DEFAULT_ANNOTATION_PROFILE;
                isDefault = true;
            } else if (MavenCompilerAnnotationProcessorPathsImporter.isMavenProcessorPluginDefaultConfiguration(annotationProcessorDirectory, testAnnotationProcessorDirectory, mavenProject2, project2)) {
                moduleProfileName = MAVEN_BSC_DEFAULT_ANNOTATION_PROFILE;
                isDefault = true;
            } else {
                moduleProfileName = PROFILE_PREFIX + module.getName();
                isDefault = false;
            }
            ProcessorConfigProfile moduleProfile = MavenCompilerAnnotationProcessorPathsImporter.getModuleProfile(module, mavenProject2, project2, compilerConfiguration, (String)moduleProfileName, annotationProcessorDirectory, testAnnotationProcessorDirectory);
            if (moduleProfile == null) {
                return;
            }
            MavenCompilerAnnotationProcessorPathsImporter.configureAnnotationProcessorPath(moduleProfile, mavenProject2, project2);
            WriteAction.runAndWait(() -> MavenCompilerAnnotationProcessorPathsImporter.cleanAndMergeModuleProfiles(rootProject, compilerConfiguration, moduleProfile, isDefault, module));
        } else {
            WriteAction.runAndWait(() -> MavenCompilerAnnotationProcessorPathsImporter.cleanAndMergeModuleProfiles(rootProject, compilerConfiguration, null, false, module));
        }
    }

    @Override
    public void resolve(Project project2, MavenProject mavenProject2, NativeMavenProjectHolder nativeMavenProject, MavenEmbedderWrapper embedder, ResolveContext context) throws MavenProcessCanceledException {
        if (this.getConfig(mavenProject2, "annotationProcessorPaths") == null) {
            return;
        }
        Element config = this.getConfig(mavenProject2, "annotationProcessorPaths");
        this.LOG.assertTrue(config != null);
        List<MavenArtifactInfo> artifactsInfo = MavenCompilerAnnotationProcessorPathsImporter.getArtifactsInfo(config);
        if (artifactsInfo.isEmpty()) {
            return;
        }
        MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(project2);
        ArrayList<MavenArtifactInfo> externalArtifacts = new ArrayList<MavenArtifactInfo>();
        for (MavenArtifactInfo info : artifactsInfo) {
            MavenProject mavenArtifact = projectsManager.findProject(new MavenId(info.getGroupId(), info.getArtifactId(), info.getVersion()));
            if (mavenArtifact != null) continue;
            externalArtifacts.add(info);
        }
        try {
            MavenArtifactResolveResult annotationProcessors = embedder.resolveArtifactTransitively(externalArtifacts, mavenProject2.getRemoteRepositories());
            if (annotationProcessors.problem != null) {
                MavenResolveResultProblemProcessor.notifySyncForProblem(project2, annotationProcessors.problem);
            } else {
                mavenProject2.addAnnotationProcessors(annotationProcessors.mavenResolvedArtifacts);
            }
        }
        catch (Exception e) {
            String message = e.getMessage() != null ? e.getMessage() : ExceptionUtil.getThrowableText((Throwable)e);
            MavenProjectsManager.getInstance(project2).getSyncConsole().addWarning(SyncBundle.message("maven.sync.annotation.processor.problem", new Object[0]), message);
        }
    }

    @NotNull
    private static List<MavenArtifactInfo> getArtifactsInfo(Element config) {
        ArrayList<MavenArtifactInfo> artifacts = new ArrayList<MavenArtifactInfo>();
        Consumer addToArtifacts = path -> {
            String groupId = path.getChildTextTrim("groupId");
            String artifactId = path.getChildTextTrim("artifactId");
            String version2 = path.getChildTextTrim("version");
            String classifier = path.getChildTextTrim("classifier");
            artifacts.add(new MavenArtifactInfo(groupId, artifactId, version2, "jar", classifier));
        };
        for (Element path2 : config.getChildren("path")) {
            addToArtifacts.consume((Object)path2);
        }
        for (Element dependency : config.getChildren("dependency")) {
            addToArtifacts.consume((Object)dependency);
        }
        for (Element annotationProcessorPath : config.getChildren("annotationProcessorPath")) {
            addToArtifacts.consume((Object)annotationProcessorPath);
        }
        ArrayList<MavenArtifactInfo> arrayList = artifacts;
        if (arrayList == null) {
            MavenCompilerAnnotationProcessorPathsImporter.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    private String getAnnotationProcessorDirectory(MavenProject mavenProject2, boolean isTest, String defaultTestAnnotationOutput) {
        String relativeAnotationProcessorDirectory = MavenCompilerAnnotationProcessorPathsImporter.getRelativeAnnotationProcessorDirectory(mavenProject2, isTest);
        if (relativeAnotationProcessorDirectory == null) {
            relativeAnotationProcessorDirectory = defaultTestAnnotationOutput;
        }
        return relativeAnotationProcessorDirectory;
    }

    @Nullable
    private static ProcessorConfigProfile getModuleProfile(Module module, MavenProject mavenProject2, Project project2, CompilerConfigurationImpl compilerConfiguration, String moduleProfileName, String annotationProcessorDirectory, String testAnnotationProcessorDirectory) {
        ProcessorConfigProfile moduleProfile = compilerConfiguration.findModuleProcessorProfile(moduleProfileName);
        if (moduleProfile == null) {
            moduleProfile = new ProcessorConfigProfileImpl(moduleProfileName);
            moduleProfile.setEnabled(true);
            compilerConfiguration.addModuleProcessorProfile(moduleProfile);
        }
        if (!moduleProfile.isEnabled()) {
            return null;
        }
        if (MavenProjectImporter.isImportToTreeStructureEnabled(project2)) {
            moduleProfile.setOutputRelativeToContentRoot(false);
        } else {
            moduleProfile.setOutputRelativeToContentRoot(true);
        }
        moduleProfile.setObtainProcessorsFromClasspath(true);
        moduleProfile.setGeneratedSourcesDirectoryName(annotationProcessorDirectory, false);
        moduleProfile.setGeneratedSourcesDirectoryName(testAnnotationProcessorDirectory, true);
        moduleProfile.clearProcessorOptions();
        for (Map.Entry<String, String> entry : mavenProject2.getAnnotationProcessorOptions().entrySet()) {
            moduleProfile.setOption(entry.getKey(), entry.getValue());
        }
        moduleProfile.clearProcessors();
        List<String> processors = mavenProject2.getDeclaredAnnotationProcessors();
        if (processors != null) {
            for (String processor : processors) {
                moduleProfile.addProcessor(processor);
            }
        }
        moduleProfile.addModuleName(module.getName());
        return moduleProfile;
    }

    private static boolean isLevelMoreThan6(Module module) {
        String versionString;
        LanguageLevel languageLevel2;
        Sdk sdk = (Sdk)ReadAction.compute(() -> ModuleRootManager.getInstance((Module)module).getSdk());
        return sdk == null || (languageLevel2 = LanguageLevel.parse((String)(versionString = sdk.getVersionString()))) == null || !languageLevel2.isLessThan(LanguageLevel.JDK_1_6);
    }

    private static void configureAnnotationProcessorPath(ProcessorConfigProfile profile, MavenProject mavenProject2, Project project2) {
        String annotationProcessorPath = mavenProject2.getAnnotationProcessorPath(project2);
        if (StringUtil.isNotEmpty((String)annotationProcessorPath)) {
            profile.setObtainProcessorsFromClasspath(false);
            profile.setProcessorPath(annotationProcessorPath);
        }
    }

    private static void cleanAndMergeModuleProfiles(@NotNull MavenProject rootProject, @NotNull CompilerConfigurationImpl compilerConfiguration, @Nullable ProcessorConfigProfile moduleProfile, boolean isDefault, @NotNull Module module) {
        if (rootProject == null) {
            MavenCompilerAnnotationProcessorPathsImporter.$$$reportNull$$$0(1);
        }
        if (compilerConfiguration == null) {
            MavenCompilerAnnotationProcessorPathsImporter.$$$reportNull$$$0(2);
        }
        if (module == null) {
            MavenCompilerAnnotationProcessorPathsImporter.$$$reportNull$$$0(3);
        }
        ArrayList profiles2 = new ArrayList(compilerConfiguration.getModuleProcessorProfiles());
        for (ProcessorConfigProfile p : profiles2) {
            if (p != moduleProfile) {
                p.removeModuleName(module.getName());
                if (p.getModuleNames().isEmpty() && p.getName().startsWith(PROFILE_PREFIX)) {
                    compilerConfiguration.removeModuleProcessorProfile(p);
                }
            }
            if (isDefault || moduleProfile == null || !MavenCompilerAnnotationProcessorPathsImporter.isSimilarProfiles(p, moduleProfile)) continue;
            moduleProfile.setEnabled(p.isEnabled());
            String mavenProjectRootProfileName = PROFILE_PREFIX + rootProject.getDisplayName();
            ProcessorConfigProfile mergedProfile = compilerConfiguration.findModuleProcessorProfile(mavenProjectRootProfileName);
            if (mergedProfile == null) {
                mergedProfile = new ProcessorConfigProfileImpl(moduleProfile);
                mergedProfile.setName(mavenProjectRootProfileName);
                compilerConfiguration.addModuleProcessorProfile(mergedProfile);
                mergedProfile.addModuleNames((Collection)p.getModuleNames());
                p.clearModuleNames();
                compilerConfiguration.removeModuleProcessorProfile(p);
                moduleProfile.clearModuleNames();
                compilerConfiguration.removeModuleProcessorProfile(moduleProfile);
                continue;
            }
            if (p != mergedProfile && !MavenCompilerAnnotationProcessorPathsImporter.isSimilarProfiles(mergedProfile, moduleProfile)) continue;
            if (moduleProfile != mergedProfile) {
                mergedProfile.addModuleNames((Collection)moduleProfile.getModuleNames());
                moduleProfile.clearModuleNames();
                compilerConfiguration.removeModuleProcessorProfile(moduleProfile);
            }
            if (p == mergedProfile) continue;
            mergedProfile.addModuleNames((Collection)p.getModuleNames());
            p.clearModuleNames();
            compilerConfiguration.removeModuleProcessorProfile(p);
        }
    }

    private static boolean isSimilarProfiles(@Nullable ProcessorConfigProfile profile1, @Nullable ProcessorConfigProfile profile2) {
        if (profile1 == null || profile2 == null) {
            return false;
        }
        ProcessorConfigProfileImpl p1 = new ProcessorConfigProfileImpl(profile1);
        p1.setName("tmp");
        p1.setEnabled(true);
        p1.clearModuleNames();
        ProcessorConfigProfileImpl p2 = new ProcessorConfigProfileImpl(profile2);
        p2.setName("tmp");
        p2.setEnabled(true);
        p2.clearModuleNames();
        return p1.equals((Object)p2);
    }

    private static boolean isMavenDefaultAnnotationProcessorConfiguration(@NotNull String annotationProcessorDirectory, @NotNull String testAnnotationProcessorDirectory, @NotNull MavenProject mavenProject2, @NotNull Project project2) {
        if (annotationProcessorDirectory == null) {
            MavenCompilerAnnotationProcessorPathsImporter.$$$reportNull$$$0(4);
        }
        if (testAnnotationProcessorDirectory == null) {
            MavenCompilerAnnotationProcessorPathsImporter.$$$reportNull$$$0(5);
        }
        if (mavenProject2 == null) {
            MavenCompilerAnnotationProcessorPathsImporter.$$$reportNull$$$0(6);
        }
        if (project2 == null) {
            MavenCompilerAnnotationProcessorPathsImporter.$$$reportNull$$$0(7);
        }
        Map<String, String> options = mavenProject2.getAnnotationProcessorOptions();
        List<String> processors = mavenProject2.getDeclaredAnnotationProcessors();
        return ContainerUtil.isEmpty(processors) && options.isEmpty() && StringUtil.isEmpty((String)mavenProject2.getAnnotationProcessorPath(project2)) && DEFAULT_ANNOTATION_PATH_OUTPUT.equals(annotationProcessorDirectory.replace('\\', '/')) && DEFAULT_TEST_ANNOTATION_OUTPUT.equals(testAnnotationProcessorDirectory.replace('\\', '/'));
    }

    private static boolean isMavenProcessorPluginDefaultConfiguration(@NotNull String annotationProcessorDirectory, @NotNull String testAnnotationProcessorDirectory, @NotNull MavenProject mavenProject2, @NotNull Project project2) {
        if (annotationProcessorDirectory == null) {
            MavenCompilerAnnotationProcessorPathsImporter.$$$reportNull$$$0(8);
        }
        if (testAnnotationProcessorDirectory == null) {
            MavenCompilerAnnotationProcessorPathsImporter.$$$reportNull$$$0(9);
        }
        if (mavenProject2 == null) {
            MavenCompilerAnnotationProcessorPathsImporter.$$$reportNull$$$0(10);
        }
        if (project2 == null) {
            MavenCompilerAnnotationProcessorPathsImporter.$$$reportNull$$$0(11);
        }
        Map<String, String> options = mavenProject2.getAnnotationProcessorOptions();
        List<String> processors = mavenProject2.getDeclaredAnnotationProcessors();
        return ContainerUtil.isEmpty(processors) && options.isEmpty() && StringUtil.isEmpty((String)mavenProject2.getAnnotationProcessorPath(project2)) && DEFAULT_BSC_ANNOTATION_PATH_OUTPUT.equals(annotationProcessorDirectory.replace('\\', '/')) && DEFAULT_BSC_TEST_ANNOTATION_OUTPUT.equals(testAnnotationProcessorDirectory.replace('\\', '/'));
    }

    @Nullable
    private static String getRelativeAnnotationProcessorDirectory(MavenProject mavenProject2, boolean isTest) {
        String annotationProcessorDirectory = mavenProject2.getAnnotationProcessorDirectory(isTest);
        Path annotationProcessorDirectoryFile = Path.of(annotationProcessorDirectory, new String[0]);
        if (!annotationProcessorDirectoryFile.isAbsolute()) {
            return annotationProcessorDirectory;
        }
        String absoluteProjectDirectory = mavenProject2.getDirectory();
        try {
            return Path.of(absoluteProjectDirectory, new String[0]).relativize(annotationProcessorDirectoryFile).toString();
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static boolean shouldEnableAnnotationProcessors(MavenProject mavenProject2) {
        if ("pom".equals(mavenProject2.getPackaging())) {
            return false;
        }
        return mavenProject2.getProcMode() != MavenProject.ProcMode.NONE || mavenProject2.findPlugin("org.bsc.maven", "maven-processor-plugin") != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/importing/MavenCompilerAnnotationProcessorPathsImporter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootProject";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerConfiguration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationProcessorDirectory";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testAnnotationProcessorDirectory";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenProject";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifactsInfo";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/importing/MavenCompilerAnnotationProcessorPathsImporter";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "cleanAndMergeModuleProfiles";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isMavenDefaultAnnotationProcessorConfiguration";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isMavenProcessorPluginDefaultConfiguration";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

