/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManagerImpl;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.importing.MavenImporter;
import org.jetbrains.idea.maven.model.MavenResource;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.utils.MavenLog;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J \u0010\t\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J(\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/idea/maven/importing/MavenEncodingImporter;", "Lorg/jetbrains/idea/maven/importing/MavenImporter;", "()V", "configure", "", "mavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "project", "Lcom/intellij/openapi/project/Project;", "fillResourceEncoding", "encodingCollector", "Lorg/jetbrains/idea/maven/importing/MavenEncodingImporter$EncodingCollector;", "fillSourceEncoding", "getCharset", "Ljava/nio/charset/Charset;", "name", "", "isApplicable", "", "postProcess", "module", "Lcom/intellij/openapi/module/Module;", "changes", "Lorg/jetbrains/idea/maven/project/MavenProjectChanges;", "modifiableModelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "EncodingCollector", "intellij.maven"})
public final class MavenEncodingImporter
extends MavenImporter {
    @Override
    public boolean isApplicable(@NotNull MavenProject mavenProject2) {
        Intrinsics.checkNotNullParameter((Object)mavenProject2, (String)"mavenProject");
        return true;
    }

    @Override
    public void postProcess(@NotNull Module module, @NotNull MavenProject mavenProject2, @NotNull MavenProjectChanges changes, @NotNull IdeModifiableModelsProvider modifiableModelsProvider) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)mavenProject2, (String)"mavenProject");
        Intrinsics.checkNotNullParameter((Object)changes, (String)"changes");
        Intrinsics.checkNotNullParameter((Object)modifiableModelsProvider, (String)"modifiableModelsProvider");
        Project project2 = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"module.project");
        this.configure(mavenProject2, project2);
    }

    private final void configure(MavenProject mavenProject2, Project project2) {
        EncodingCollector encodingCollector = new EncodingCollector(project2);
        ReadAction.compute((ThrowableComputable)new ThrowableComputable(this, mavenProject2, encodingCollector){
            final /* synthetic */ MavenEncodingImporter this$0;
            final /* synthetic */ MavenProject $mavenProject;
            final /* synthetic */ EncodingCollector $encodingCollector;

            public final void compute() {
                MavenEncodingImporter.access$fillSourceEncoding(this.this$0, this.$mavenProject, this.$encodingCollector);
            }
            {
                this.this$0 = mavenEncodingImporter;
                this.$mavenProject = mavenProject2;
                this.$encodingCollector = encodingCollector;
            }
        });
        ReadAction.compute((ThrowableComputable)new ThrowableComputable(this, project2, mavenProject2, encodingCollector){
            final /* synthetic */ MavenEncodingImporter this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ MavenProject $mavenProject;
            final /* synthetic */ EncodingCollector $encodingCollector;

            public final void compute() {
                MavenEncodingImporter.access$fillResourceEncoding(this.this$0, this.$project, this.$mavenProject, this.$encodingCollector);
            }
            {
                this.this$0 = mavenEncodingImporter;
                this.$project = project2;
                this.$mavenProject = mavenProject2;
                this.$encodingCollector = encodingCollector;
            }
        });
        encodingCollector.applyCollectedInfo();
    }

    /*
     * WARNING - void declaration
     */
    private final void fillResourceEncoding(Project project2, MavenProject mavenProject2, EncodingCollector encodingCollector) {
        Object object = mavenProject2.getResourceEncoding(project2);
        if (object != null) {
            Object object2 = object;
            MavenEncodingImporter mavenEncodingImporter = this;
            String p1 = object2;
            boolean bl = false;
            object = mavenEncodingImporter.getCharset(p1);
            if (object != null) {
                void $this$forEach$iv;
                void $this$mapTo$iv$iv;
                Object charset = object2 = object;
                boolean bl2 = false;
                List<MavenResource> list = mavenProject2.getResources();
                Intrinsics.checkNotNullExpressionValue(list, (String)"mavenProject.resources");
                Iterable $this$map$iv = list;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    MavenResource mavenResource = (MavenResource)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    void v2 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"it");
                    String string = v2.getDirectory();
                    collection.add(string);
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl4 = false;
                    String string = it;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it");
                    encodingCollector.processDir(string, (Charset)charset);
                }
            }
        }
    }

    private final void fillSourceEncoding(MavenProject mavenProject2, EncodingCollector encodingCollector) {
        Object object = mavenProject2.getSourceEncoding();
        if (object != null) {
            Object object2 = object;
            MavenEncodingImporter mavenEncodingImporter = this;
            String p1 = object2;
            boolean bl = false;
            object = mavenEncodingImporter.getCharset(p1);
            if (object != null) {
                Object charset = object2 = object;
                boolean bl2 = false;
                List<String> list = mavenProject2.getSources();
                Intrinsics.checkNotNullExpressionValue(list, (String)"mavenProject.sources");
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl3 = false;
                    String string = it;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it");
                    encodingCollector.processDir(string, (Charset)charset);
                }
            }
        }
    }

    private final Charset getCharset(String name) {
        try {
            return Charset.forName(name);
        }
        catch (UnsupportedCharsetException e) {
            MavenLog.LOG.warn("Charset " + name + " is not supported");
            return null;
        }
    }

    public MavenEncodingImporter() {
        super("", "");
    }

    public static final /* synthetic */ void access$fillSourceEncoding(MavenEncodingImporter $this, MavenProject mavenProject2, EncodingCollector encodingCollector) {
        $this.fillSourceEncoding(mavenProject2, encodingCollector);
    }

    public static final /* synthetic */ void access$fillResourceEncoding(MavenEncodingImporter $this, Project project2, MavenProject mavenProject2, EncodingCollector encodingCollector) {
        $this.fillResourceEncoding(project2, mavenProject2, encodingCollector);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/idea/maven/importing/MavenEncodingImporter$EncodingCollector;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "encodingManager", "Lcom/intellij/openapi/vfs/encoding/EncodingProjectManagerImpl;", "newPointerMappings", "Ljava/util/LinkedHashMap;", "Lcom/intellij/openapi/vfs/pointers/VirtualFilePointer;", "Ljava/nio/charset/Charset;", "Lkotlin/collections/LinkedHashMap;", "oldPointerMappings", "applyCollectedInfo", "", "processDir", "directory", "", "charset", "intellij.maven"})
    public static final class EncodingCollector {
        private final LinkedHashMap<VirtualFilePointer, Charset> newPointerMappings;
        private final LinkedHashMap<VirtualFilePointer, Charset> oldPointerMappings;
        private final EncodingProjectManagerImpl encodingManager;

        public final void processDir(@NotNull String directory, @NotNull Charset charset) {
            VirtualFilePointer virtualFilePointer;
            Class<VirtualFilePointerManager> serviceClass$iv;
            boolean $i$f$service;
            Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            VirtualFile dirVfile = LocalFileSystem.getInstance().findFileByIoFile(new File(directory));
            if (dirVfile != null) {
                $i$f$service = false;
                serviceClass$iv = VirtualFilePointerManager.class;
                Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (object == null) {
                    throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
                }
                virtualFilePointer = ((VirtualFilePointerManager)object).create(dirVfile, (Disposable)this.encodingManager, null);
            } else {
                $i$f$service = false;
                serviceClass$iv = VirtualFilePointerManager.class;
                Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (object == null) {
                    throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
                }
                virtualFilePointer = ((VirtualFilePointerManager)object).create(VfsUtilCore.fileToUrl((File)new File(directory).getAbsoluteFile()), (Disposable)this.encodingManager, null);
            }
            Intrinsics.checkNotNullExpressionValue((Object)virtualFilePointer, (String)"if (dirVfile != null) {\n\u2026ingManager, null)\n      }");
            VirtualFilePointer pointer = virtualFilePointer;
            ((Map)this.newPointerMappings).put(pointer, charset);
            Map map2 = this.encodingManager.getAllPointersMappings();
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"encodingManager.allPointersMappings");
            Map $this$forEach$iv = map2;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                VirtualFilePointer filePointer;
                Map.Entry element$iv;
                Map.Entry it = element$iv = iterator.next();
                boolean bl = false;
                VirtualFilePointer virtualFilePointer2 = filePointer = (VirtualFilePointer)it.getKey();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFilePointer2, (String)"filePointer");
                if (FileUtil.isAncestor((String)directory, (String)VfsUtilCore.urlToPath((String)virtualFilePointer2.getUrl()), (boolean)false) || this.newPointerMappings.containsKey(filePointer)) {
                    ((Map)this.newPointerMappings).put(filePointer, charset);
                    this.oldPointerMappings.remove(filePointer);
                    continue;
                }
                Map map3 = this.oldPointerMappings;
                Object v = it.getValue();
                Intrinsics.checkNotNullExpressionValue(v, (String)"it.value");
                map3.put(filePointer, v);
            }
        }

        public final void applyCollectedInfo() {
            if (this.newPointerMappings.isEmpty()) {
                return;
            }
            Map pointerMapping = MapsKt.plus((Map)this.newPointerMappings, (Map)this.oldPointerMappings);
            ApplicationManager.getApplication().invokeAndWait(new Runnable(this, pointerMapping){
                final /* synthetic */ EncodingCollector this$0;
                final /* synthetic */ Map $pointerMapping;

                public final void run() {
                    EncodingCollector.access$getEncodingManager$p(this.this$0).setPointerMapping(this.$pointerMapping);
                }
                {
                    this.this$0 = encodingCollector;
                    this.$pointerMapping = map2;
                }
            });
        }

        public EncodingCollector(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            this.newPointerMappings = new LinkedHashMap();
            this.oldPointerMappings = new LinkedHashMap();
            EncodingProjectManager encodingProjectManager = EncodingProjectManager.getInstance((Project)project2);
            if (encodingProjectManager == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.vfs.encoding.EncodingProjectManagerImpl");
            }
            this.encodingManager = (EncodingProjectManagerImpl)encodingProjectManager;
        }

        public static final /* synthetic */ EncodingProjectManagerImpl access$getEncodingManager$p(EncodingCollector $this) {
            return $this.encodingManager;
        }
    }
}

