/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.externalSystem.service.project.ExternalSystemModulePropertyManagerBridge;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.workspaceModel.ide.WorkspaceModel;
import com.intellij.workspaceModel.ide.legacyBridge.ModuleBridge;
import com.intellij.workspaceModel.storage.EntityStorage;
import com.intellij.workspaceModel.storage.MutableEntityStorage;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.importing.MavenProjectImporterBase;
import org.jetbrains.idea.maven.importing.ModuleModelProxy;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.utils.MavenUtil;

public abstract class MavenProjectImporterLegacyBase
extends MavenProjectImporterBase {
    protected final ModuleModelProxy myModuleModel;

    public MavenProjectImporterLegacyBase(Project project2, MavenProjectsTree projectsTree, MavenImportingSettings importingSettings, Map<MavenProject, MavenProjectChanges> projectsToImportWithChanges, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (modelsProvider == null) {
            MavenProjectImporterLegacyBase.$$$reportNull$$$0(0);
        }
        super(project2, projectsTree, importingSettings, projectsToImportWithChanges, modelsProvider);
        this.myModuleModel = this.myModelsProvider.getModuleModelProxy();
    }

    protected void finalizeImport(List<Module> obsoleteModules) {
        MavenUtil.invokeAndWaitWriteAction(this.myProject, () -> this.setMavenizedModules(obsoleteModules, false));
        MavenUtil.invokeAndWaitWriteAction(this.myProject, () -> this.myModelsProvider.dispose());
    }

    protected void setMavenizedModules(Collection<Module> modules2, boolean mavenized) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        EntityStorage initialStorage = WorkspaceModel.getInstance((Project)this.myProject).getEntityStorage().getCurrent();
        MutableEntityStorage storageBuilder = MutableEntityStorage.from((EntityStorage)initialStorage);
        for (Module module : modules2) {
            if (module.isDisposed()) continue;
            ExternalSystemModulePropertyManager modulePropertyManager = ExternalSystemModulePropertyManager.getInstance((Module)module);
            if (modulePropertyManager instanceof ExternalSystemModulePropertyManagerBridge && module instanceof ModuleBridge && ((ModuleBridge)module).getDiff() == null) {
                ((ExternalSystemModulePropertyManagerBridge)modulePropertyManager).setMavenized(mavenized, storageBuilder);
                continue;
            }
            modulePropertyManager.setMavenized(mavenized);
        }
        WorkspaceModel.getInstance((Project)this.myProject).updateProjectModel(builder -> {
            builder.addDiff(storageBuilder);
            return null;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "org/jetbrains/idea/maven/importing/MavenProjectImporterLegacyBase", "<init>"));
    }
}

