/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing.tree;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.project.ProjectCoordinate;
import com.intellij.openapi.externalSystem.model.project.ProjectId;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.importing.MavenModuleImporter;
import org.jetbrains.idea.maven.importing.MavenProjectImporterLegacyBase;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapter;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapterLegacyImpl;
import org.jetbrains.idea.maven.importing.ModifiableModelsProviderProxy;
import org.jetbrains.idea.maven.importing.tree.LegacyMavenProjectImportContextProvider;
import org.jetbrains.idea.maven.importing.tree.MavenModuleImportContext;
import org.jetbrains.idea.maven.importing.tree.MavenModuleImportData;
import org.jetbrains.idea.maven.importing.tree.MavenModuleType;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorTask;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenProjectTreeLegacyImporter
extends MavenProjectImporterLegacyBase {
    private static final Logger LOG = Logger.getInstance(MavenProjectTreeLegacyImporter.class);
    private final LegacyMavenProjectImportContextProvider contextProvider;
    private volatile MavenModuleImportContext myContext;

    public static boolean isAlwaysUseTreeImport() {
        return "true".equals(System.getProperty("maven.import.use.tree.import"));
    }

    public MavenProjectTreeLegacyImporter(@NotNull Project p, @NotNull MavenProjectsTree projectsTree, @NotNull Map<MavenProject, MavenProjectChanges> projectsToImportWithChanges, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull MavenImportingSettings importingSettings) {
        if (p == null) {
            MavenProjectTreeLegacyImporter.$$$reportNull$$$0(0);
        }
        if (projectsTree == null) {
            MavenProjectTreeLegacyImporter.$$$reportNull$$$0(1);
        }
        if (projectsToImportWithChanges == null) {
            MavenProjectTreeLegacyImporter.$$$reportNull$$$0(2);
        }
        if (modelsProvider == null) {
            MavenProjectTreeLegacyImporter.$$$reportNull$$$0(3);
        }
        if (importingSettings == null) {
            MavenProjectTreeLegacyImporter.$$$reportNull$$$0(4);
        }
        super(p, projectsTree, importingSettings, projectsToImportWithChanges, modelsProvider);
        this.myContext = new MavenModuleImportContext();
        this.contextProvider = new LegacyMavenProjectImportContextProvider(p, projectsTree, projectsToImportWithChanges, this.myModuleModel, importingSettings);
    }

    @Override
    @Nullable
    public List<MavenProjectsProcessorTask> importProject() {
        List<MavenProjectsProcessorTask> tasks = this.importProjectTree();
        return tasks;
    }

    @Nullable
    private List<MavenProjectsProcessorTask> importProjectTree() {
        this.myContext = this.contextProvider.getContext();
        boolean hasChanges = false;
        ArrayList<MavenProjectsProcessorTask> postTasks = new ArrayList<MavenProjectsProcessorTask>();
        if (this.myProject.isDisposed()) {
            return null;
        }
        ArrayList<MavenModuleImporter> importers = new ArrayList<MavenModuleImporter>();
        if (this.myContext.hasChanges) {
            hasChanges = true;
            TreeModuleConfigurer configurer = new TreeModuleConfigurer(this.myProjectsTree, this.myImportingSettings, this.myModelsProvider);
            importers.addAll(configurer.configModules(this.myContext.allModules, this.myContext.moduleNameByProject));
            this.scheduleRefreshResolvedArtifacts(postTasks);
        }
        List<Module> obsoleteModules = this.myContext.legacyObsoleteModules;
        boolean isDeleteObsoleteModules = MavenProjectTreeLegacyImporter.isDeleteObsoleteModules(obsoleteModules);
        hasChanges |= isDeleteObsoleteModules;
        if (this.myProject.isDisposed()) {
            return null;
        }
        if (hasChanges) {
            MavenUtil.invokeAndWaitWriteAction(this.myProject, () -> ProjectRootManagerEx.getInstanceEx((Project)this.myProject).mergeRootsChangesDuring(() -> {
                this.setMavenizedModules(obsoleteModules, false);
                if (isDeleteObsoleteModules) {
                    this.deleteModules(obsoleteModules);
                }
                this.removeUnusedProjectLibraries(this.myContext.changedModules);
                this.myModelsProvider.commit();
                if (this.myContext.hasChanges) {
                    this.removeOutdatedCompilerConfigSettings();
                    this.setMavenizedModules(ContainerUtil.map(this.myContext.changedModules, e -> e.getLegacyModuleData().getModule()), true);
                }
            }));
            this.configFacets(importers, postTasks);
        } else {
            this.finalizeImport(obsoleteModules);
        }
        return postTasks;
    }

    private static boolean isDeleteObsoleteModules(@NotNull List<Module> obsoleteModules) {
        if (obsoleteModules == null) {
            MavenProjectTreeLegacyImporter.$$$reportNull$$$0(5);
        }
        return !obsoleteModules.isEmpty();
    }

    private void deleteModules(@NotNull List<Module> modules2) {
        if (modules2 == null) {
            MavenProjectTreeLegacyImporter.$$$reportNull$$$0(6);
        }
        for (Module each : modules2) {
            if (each.isDisposed()) continue;
            this.myModuleModel.disposeModule(each);
        }
    }

    private void removeUnusedProjectLibraries(List<MavenModuleImportData> changedModuleImportData) {
        HashSet unusedLibraries = new HashSet();
        Collections.addAll(unusedLibraries, this.myModelsProvider.getAllLibraries());
        for (ModuleRootModel eachModel : this.collectModuleModels(changedModuleImportData)) {
            for (OrderEntry eachEntry : eachModel.getOrderEntries()) {
                if (!(eachEntry instanceof LibraryOrderEntry)) continue;
                unusedLibraries.remove(((LibraryOrderEntry)eachEntry).getLibrary());
            }
        }
        for (Library each : unusedLibraries) {
            if (MavenProjectTreeLegacyImporter.isDisposed(each) || !MavenRootModelAdapter.isMavenLibrary(each) || MavenRootModelAdapter.isChangedByUser(each)) continue;
            this.myModelsProvider.removeLibrary(each);
        }
    }

    private static boolean isDisposed(Library library) {
        return library instanceof LibraryEx && ((LibraryEx)library).isDisposed();
    }

    private Collection<ModuleRootModel> collectModuleModels(List<MavenModuleImportData> changedModuleImportData) {
        HashMap<Module, ModifiableRootModel> rootModels = new HashMap<Module, ModifiableRootModel>();
        for (MavenModuleImportData importData : changedModuleImportData) {
            Module module = importData.getLegacyModuleData().getModule();
            ModifiableRootModel rootModel = this.myModelsProvider.getModifiableRootModel(module);
            rootModels.put(module, rootModel);
        }
        for (Module each : this.myModuleModel.getModules()) {
            if (rootModels.containsKey(each)) continue;
            rootModels.put(each, this.myModelsProvider.getModifiableRootModel(each));
        }
        return rootModels.values();
    }

    @Override
    @NotNull
    public List<Module> createdModules() {
        List<Module> list = this.myContext.legacyCreatedModules;
        if (list == null) {
            MavenProjectTreeLegacyImporter.$$$reportNull$$$0(7);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectsTree";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectsToImportWithChanges";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importingSettings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obsoleteModules";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/importing/tree/MavenProjectTreeLegacyImporter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/importing/tree/MavenProjectTreeLegacyImporter";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createdModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isDeleteObsoleteModules";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "deleteModules";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class TreeModuleConfigurer {
        private final MavenProjectsTree myProjectsTree;
        private final MavenImportingSettings myImportingSettings;
        private final ModifiableModelsProviderProxy myModelsProvider;

        public TreeModuleConfigurer(MavenProjectsTree projectsTree, MavenImportingSettings importingSettings, ModifiableModelsProviderProxy modelsProvider) {
            this.myProjectsTree = projectsTree;
            this.myImportingSettings = importingSettings;
            this.myModelsProvider = modelsProvider;
        }

        public List<MavenModuleImporter> configModules(List<MavenModuleImportData> allModules, Map<MavenProject, String> moduleNameByProject) {
            ArrayList<MavenModuleImporter> importers = new ArrayList<MavenModuleImporter>();
            for (MavenModuleImportData importData : allModules) {
                MavenModuleImporter moduleImporter = this.createModuleImporter(importData, moduleNameByProject);
                importers.add(moduleImporter);
                if (!importData.hasChanges()) continue;
                MavenProject mavenProject2 = importData.getMavenProject();
                MavenId mavenId = mavenProject2.getMavenId();
                Module module = importData.getLegacyModuleData().getModule();
                this.myModelsProvider.registerModulePublication(module, (ProjectCoordinate)new ProjectId(mavenId.getGroupId(), mavenId.getArtifactId(), mavenId.getVersion()));
                MavenRootModelAdapterLegacyImpl delegate = new MavenRootModelAdapterLegacyImpl(mavenProject2, module, this.myModelsProvider);
                MavenRootModelAdapter rootModelAdapter = new MavenRootModelAdapter(delegate);
                TreeModuleConfigurer.configModule(importData, moduleImporter, rootModelAdapter);
            }
            return importers;
        }

        private static void configModule(@NotNull MavenModuleImportData importData, @NotNull MavenModuleImporter moduleImporter, @NotNull MavenRootModelAdapter rootModelAdapter) {
            if (importData == null) {
                TreeModuleConfigurer.$$$reportNull$$$0(0);
            }
            if (moduleImporter == null) {
                TreeModuleConfigurer.$$$reportNull$$$0(1);
            }
            if (rootModelAdapter == null) {
                TreeModuleConfigurer.$$$reportNull$$$0(2);
            }
            MavenModuleType type2 = importData.getModuleData().getType();
            rootModelAdapter.init(importData.getLegacyModuleData().isNewModule());
            if (type2 == MavenModuleType.AGGREGATOR || type2 == MavenModuleType.MAIN_TEST) {
                moduleImporter.config(rootModelAdapter, importData);
            } else if (type2 == MavenModuleType.AGGREGATOR_MAIN_TEST) {
                moduleImporter.configMainAndTestAggregator(rootModelAdapter, importData);
            } else {
                moduleImporter.configMainAndTest(rootModelAdapter, importData);
            }
        }

        private MavenModuleImporter createModuleImporter(MavenModuleImportData importData, Map<MavenProject, String> moduleNameByProject) {
            return new MavenModuleImporter(importData.getLegacyModuleData().getModule(), this.myProjectsTree, importData.getMavenProject(), importData.getChanges(), moduleNameByProject, this.myImportingSettings, this.myModelsProvider, importData.getModuleData().getType());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "importData";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "moduleImporter";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "rootModelAdapter";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/idea/maven/importing/tree/MavenProjectTreeLegacyImporter$TreeModuleConfigurer";
            objectArray[2] = "configModule";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

