/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing.tree.workspace;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\n\u001a\u00020\u00032\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0002J\u0006\u0010\u000b\u001a\u00020\fJ\b\u0010\r\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/idea/maven/importing/tree/workspace/SourceFolder;", "", "path", "", "sourceRootType", "Lorg/jetbrains/jps/model/module/JpsModuleSourceRootType;", "(Ljava/lang/String;Lorg/jetbrains/jps/model/module/JpsModuleSourceRootType;)V", "getPath", "()Ljava/lang/String;", "rootType", "getRootType", "isResource", "", "toString", "intellij.maven"})
public final class SourceFolder {
    @NotNull
    private final String rootType;
    @NotNull
    private final String path;

    @NotNull
    public final String getRootType() {
        return this.rootType;
    }

    public final boolean isResource() {
        return Intrinsics.areEqual((Object)"java-resource", (Object)this.rootType) || Intrinsics.areEqual((Object)"java-test-resource", (Object)this.rootType);
    }

    private final String getRootType(JpsModuleSourceRootType<?> sourceRootType) {
        String string;
        JpsModuleSourceRootType<?> jpsModuleSourceRootType = sourceRootType;
        if (Intrinsics.areEqual(jpsModuleSourceRootType, (Object)JavaSourceRootType.SOURCE)) {
            string = "java-source";
        } else if (Intrinsics.areEqual(jpsModuleSourceRootType, (Object)JavaSourceRootType.TEST_SOURCE)) {
            string = "java-test";
        } else if (Intrinsics.areEqual(jpsModuleSourceRootType, (Object)JavaResourceRootType.RESOURCE)) {
            string = "java-resource";
        } else if (Intrinsics.areEqual(jpsModuleSourceRootType, (Object)JavaResourceRootType.TEST_RESOURCE)) {
            string = "java-test-resource";
        } else {
            String string2 = sourceRootType + " not match to maven root item";
            throw new IllegalStateException(string2.toString());
        }
        return string;
    }

    @NotNull
    public String toString() {
        return "SourceFolder(path='" + this.path + "', rootType='" + this.rootType + "')";
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    public SourceFolder(@NotNull String path, @NotNull JpsModuleSourceRootType<?> sourceRootType) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(sourceRootType, (String)"sourceRootType");
        this.path = path;
        this.rootType = this.getRootType(sourceRootType);
    }
}

