/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.navigator;

import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.icons.AllIcons;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.UiUtils;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.pom.NavigatableAdapter;
import com.intellij.psi.xml.XmlElement;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.CachingSimpleNode;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleNodeVisitor;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.ui.treeStructure.SimpleTreeBuilder;
import com.intellij.ui.treeStructure.SimpleTreeStructure;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import icons.ExternalSystemIcons;
import icons.MavenIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.MavenPluginDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomProfile;
import org.jetbrains.idea.maven.dom.model.MavenDomProfiles;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.dom.model.MavenDomSettingsModel;
import org.jetbrains.idea.maven.dom.plugin.MavenDomMojo;
import org.jetbrains.idea.maven.dom.plugin.MavenDomPluginModel;
import org.jetbrains.idea.maven.execution.MavenRunConfiguration;
import org.jetbrains.idea.maven.execution.MavenRunConfigurationType;
import org.jetbrains.idea.maven.execution.MavenRunner;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenArtifactNode;
import org.jetbrains.idea.maven.model.MavenArtifactState;
import org.jetbrains.idea.maven.model.MavenConstants;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.model.MavenProfileKind;
import org.jetbrains.idea.maven.model.MavenProjectProblem;
import org.jetbrains.idea.maven.navigator.MavenNavigationUtil;
import org.jetbrains.idea.maven.navigator.MavenProjectsNavigator;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.statistics.MavenActionsUsagesCollector;
import org.jetbrains.idea.maven.tasks.MavenShortcutsManager;
import org.jetbrains.idea.maven.tasks.MavenTasksManager;
import org.jetbrains.idea.maven.utils.MavenArtifactUtil;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenPluginInfo;
import org.jetbrains.idea.maven.utils.MavenUIUtil;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenProjectsStructure
extends SimpleTreeStructure {
    private static final URL ERROR_ICON_URL = MavenProjectsStructure.class.getResource("/general/error.png");
    private static final Collection<String> BASIC_PHASES = MavenConstants.BASIC_PHASES;
    private static final Collection<String> PHASES = MavenConstants.PHASES;
    private static final Comparator<MavenSimpleNode> NODE_COMPARATOR = (o1, o2) -> StringUtil.compare((String)o1.getName(), (String)o2.getName(), (boolean)true);
    private final ExecutorService boundedUpdateService;
    private final Project myProject;
    private final MavenProjectsManager myProjectsManager;
    private final MavenTasksManager myTasksManager;
    private final MavenShortcutsManager myShortcutsManager;
    private final MavenProjectsNavigator myProjectsNavigator;
    private final SimpleTreeBuilder myTreeBuilder;
    private final RootNode myRoot = new RootNode();
    private volatile boolean isUnloading = false;
    private final Map<MavenProject, ProjectNode> myProjectToNodeMapping = new HashMap<MavenProject, ProjectNode>();

    public MavenProjectsStructure(Project project2, MavenProjectsManager projectsManager, MavenTasksManager tasksManager, MavenShortcutsManager shortcutsManager, MavenProjectsNavigator projectsNavigator, SimpleTree tree) {
        this.myProject = project2;
        this.myProjectsManager = projectsManager;
        this.myTasksManager = tasksManager;
        this.myShortcutsManager = shortcutsManager;
        this.myProjectsNavigator = projectsNavigator;
        this.boundedUpdateService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Maven Plugin Updater", (int)1);
        project2.getMessageBus().simpleConnect().subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

            public void beforePluginUnload(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ("org.jetbrains.idea.maven".equals(pluginDescriptor.getPluginId().getIdString())) {
                    MavenProjectsStructure.this.isUnloading = true;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "org/jetbrains/idea/maven/navigator/MavenProjectsStructure$1", "beforePluginUnload"));
            }
        });
        this.configureTree(tree);
        this.myTreeBuilder = new SimpleTreeBuilder((JTree)tree, (DefaultTreeModel)tree.getModel(), (AbstractTreeStructure)this, null){};
        Disposer.register((Disposable)projectsNavigator, (Disposable)this.myTreeBuilder);
        this.myTreeBuilder.initRoot();
        this.myTreeBuilder.expand((Object)this.myRoot, null);
    }

    private void configureTree(final SimpleTree tree) {
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        MavenUIUtil.installCheckboxRenderer(tree, new MavenUIUtil.CheckboxHandler(){

            @Override
            public void toggle(TreePath treePath, InputEvent e) {
                SimpleNode node2 = tree.getNodeFor(treePath);
                if (node2 != null) {
                    node2.handleDoubleClickOrEnter(tree, e);
                }
            }

            @Override
            public boolean isVisible(Object userObject) {
                return userObject instanceof ProfileNode;
            }

            @Override
            public MavenUIUtil.CheckBoxState getState(Object userObject) {
                MavenProfileKind state2 = ((ProfileNode)((Object)userObject)).getState();
                switch (state2) {
                    case NONE: {
                        return MavenUIUtil.CheckBoxState.UNCHECKED;
                    }
                    case EXPLICIT: {
                        return MavenUIUtil.CheckBoxState.CHECKED;
                    }
                    case IMPLICIT: {
                        return MavenUIUtil.CheckBoxState.PARTIAL;
                    }
                }
                MavenLog.LOG.error("unknown profile state: " + state2);
                return MavenUIUtil.CheckBoxState.UNCHECKED;
            }
        });
    }

    @NotNull
    public RootNode getRootElement() {
        RootNode rootNode = this.myRoot;
        if (rootNode == null) {
            MavenProjectsStructure.$$$reportNull$$$0(0);
        }
        return rootNode;
    }

    public void update() {
        List<MavenProject> projects = this.myProjectsManager.getProjects();
        HashSet<MavenProject> deleted = new HashSet<MavenProject>(this.myProjectToNodeMapping.keySet());
        deleted.removeAll(projects);
        this.updateProjects(projects, deleted);
    }

    private void updateFrom(SimpleNode node2) {
        if (node2 != null) {
            this.myTreeBuilder.addSubtreeToUpdateByElement((Object)node2);
        }
    }

    private void updateUpTo(SimpleNode node2) {
        for (SimpleNode each = node2; each != null; each = each.getParent()) {
            this.updateFrom(each);
        }
    }

    public void updateProjects(List<MavenProject> updated, Collection<MavenProject> deleted) {
        ProjectNode node2;
        for (MavenProject each : updated) {
            node2 = this.findNodeFor(each);
            if (node2 == null) {
                node2 = new ProjectNode(each);
                this.myProjectToNodeMapping.put(each, node2);
            }
            this.doUpdateProject(node2);
        }
        for (MavenProject each : deleted) {
            node2 = this.myProjectToNodeMapping.remove(each);
            if (node2 == null) continue;
            ProjectsGroupNode parent = node2.getGroup();
            parent.remove(node2);
        }
        this.myRoot.updateProfiles();
    }

    private void doUpdateProject(ProjectNode node2) {
        ProjectNode aggregatorNode;
        MavenProject aggregator;
        MavenProject project2 = node2.getMavenProject();
        ProjectsGroupNode newParentNode = this.myRoot;
        if (this.myProjectsNavigator.getGroupModules() && (aggregator = this.myProjectsManager.findAggregator(project2)) != null && (aggregatorNode = this.findNodeFor(aggregator)) != null && aggregatorNode.isVisible()) {
            newParentNode = aggregatorNode;
        }
        node2.updateProject();
        this.reconnectNode(node2, newParentNode);
        RootNode newModulesParentNode = this.myProjectsNavigator.getGroupModules() && node2.isVisible() ? node2 : this.myRoot;
        for (MavenProject each : this.myProjectsManager.getModules(project2)) {
            ProjectNode moduleNode = this.findNodeFor(each);
            if (moduleNode == null || moduleNode.getParent().equals((Object)newModulesParentNode)) continue;
            this.reconnectNode(moduleNode, newModulesParentNode);
        }
    }

    private void reconnectNode(ProjectNode node2, ProjectsGroupNode newParentNode) {
        ProjectsGroupNode oldParentNode = node2.getGroup();
        if (oldParentNode == null || !oldParentNode.equals((Object)newParentNode)) {
            if (oldParentNode != null) {
                oldParentNode.remove(node2);
            }
            newParentNode.add(node2);
        } else {
            newParentNode.sortProjects();
        }
    }

    public void updateProfiles() {
        this.myRoot.updateProfiles();
    }

    public void updateIgnored(List<MavenProject> projects) {
        for (MavenProject each : projects) {
            ProjectNode node2 = this.findNodeFor(each);
            if (node2 == null) continue;
            node2.updateIgnored();
        }
    }

    public void accept(SimpleNodeVisitor visitor) {
        ((SimpleTree)this.myTreeBuilder.getTree()).accept((AbstractTreeBuilder)this.myTreeBuilder, visitor);
    }

    public void updateGoals() {
        for (ProjectNode each : this.myProjectToNodeMapping.values()) {
            each.updateGoals();
        }
    }

    public void updateRunConfigurations() {
        for (ProjectNode each : this.myProjectToNodeMapping.values()) {
            each.updateRunConfigurations();
        }
    }

    public void select(MavenProject project2) {
        ProjectNode node2 = this.findNodeFor(project2);
        if (node2 != null) {
            this.select((SimpleNode)node2);
        }
    }

    public void select(SimpleNode node2) {
        this.myTreeBuilder.select((Object)node2, null);
    }

    private ProjectNode findNodeFor(MavenProject project2) {
        return this.myProjectToNodeMapping.get(project2);
    }

    private boolean isShown(Class aClass) {
        Class<? extends MavenSimpleNode>[] classes = this.getVisibleNodesClasses();
        if (classes == null) {
            return true;
        }
        for (Class<? extends MavenSimpleNode> c : classes) {
            if (c != aClass) continue;
            return true;
        }
        return false;
    }

    protected Class<? extends MavenSimpleNode>[] getVisibleNodesClasses() {
        return null;
    }

    protected boolean showDescriptions() {
        return true;
    }

    protected boolean showOnlyBasicPhases() {
        return this.myProjectsNavigator.getShowBasicPhasesOnly();
    }

    public static <T extends MavenSimpleNode> List<T> getSelectedNodes(SimpleTree tree, Class<T> nodeClass) {
        ArrayList<MavenSimpleNode> filtered = new ArrayList<MavenSimpleNode>();
        for (SimpleNode node2 : MavenProjectsStructure.getSelectedNodes(tree)) {
            if (nodeClass != null && !nodeClass.isInstance(node2)) {
                filtered.clear();
                break;
            }
            filtered.add((MavenSimpleNode)node2);
        }
        return filtered;
    }

    private static List<SimpleNode> getSelectedNodes(SimpleTree tree) {
        ArrayList<SimpleNode> nodes = new ArrayList<SimpleNode>();
        TreePath[] treePaths = tree.getSelectionPaths();
        if (treePaths != null) {
            for (TreePath treePath : treePaths) {
                nodes.add(tree.getNodeFor(treePath));
            }
        }
        return nodes;
    }

    @Nullable
    public static ProjectNode getCommonProjectNode(Collection<? extends MavenSimpleNode> nodes) {
        ProjectNode parent = null;
        for (MavenSimpleNode mavenSimpleNode : nodes) {
            ProjectNode nextParent = mavenSimpleNode.findParent(ProjectNode.class);
            if (parent == null) {
                parent = nextParent;
                continue;
            }
            if (parent == nextParent) continue;
            return null;
        }
        return parent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/navigator/MavenProjectsStructure", "getRootElement"));
    }

    private class UpdatePluginsTreeTask
    implements Runnable {
        @NotNull
        private final PluginsNode myParentNode;
        private final List<MavenPlugin> myPlugins;

        UpdatePluginsTreeTask(PluginsNode parentNode, List<MavenPlugin> plugins) {
            this.myParentNode = parentNode;
            this.myPlugins = plugins;
        }

        @Override
        public void run() {
            File localRepository = MavenProjectsStructure.this.myProjectsManager.getLocalRepository();
            ArrayList<PluginNode> pluginInfos = new ArrayList<PluginNode>();
            Iterator<MavenPlugin> iterator = this.myPlugins.iterator();
            while (!MavenProjectsStructure.this.isUnloading && iterator.hasNext()) {
                MavenPlugin next = iterator.next();
                pluginInfos.add(new PluginNode(this.myParentNode, next, MavenArtifactUtil.readPluginInfo(localRepository, next.getMavenId())));
            }
            this.updateNodesInEDT(pluginInfos);
        }

        private void updateNodesInEDT(List<PluginNode> pluginNodes) {
            ApplicationManager.getApplication().invokeLater(() -> {
                this.myParentNode.myPluginNodes.clear();
                if (MavenProjectsStructure.this.isUnloading) {
                    return;
                }
                this.myParentNode.myPluginNodes.addAll(pluginNodes);
                this.myParentNode.sort(this.myParentNode.myPluginNodes);
                this.myParentNode.childrenChanged();
            });
        }
    }

    public class RunConfigurationNode
    extends MavenSimpleNode {
        private final RunnerAndConfigurationSettings mySettings;

        public RunConfigurationNode(RunConfigurationsNode parent, RunnerAndConfigurationSettings settings) {
            super(parent);
            this.mySettings = settings;
            this.getTemplatePresentation().setIcon(ProgramRunnerUtil.getConfigurationIcon((RunnerAndConfigurationSettings)settings, (boolean)false));
        }

        public RunnerAndConfigurationSettings getSettings() {
            return this.mySettings;
        }

        public String getName() {
            return this.mySettings.getName();
        }

        @Override
        protected void doUpdate() {
            this.setNameAndTooltip(this.getName(), null, StringUtil.join(((MavenRunConfiguration)this.mySettings.getConfiguration()).getRunnerParameters().getGoals(), (String)" "));
        }

        @Override
        @Nullable
        String getMenuId() {
            return "Maven.RunConfigurationMenu";
        }

        public void updateRunConfiguration() {
        }

        @Override
        public void handleDoubleClickOrEnter(SimpleTree tree, InputEvent inputEvent) {
            MavenActionsUsagesCollector.trigger(this.myProject, MavenActionsUsagesCollector.EXECUTE_MAVEN_CONFIGURATION, "Maven tool window", false, null);
            ProgramRunnerUtil.executeConfiguration((RunnerAndConfigurationSettings)this.mySettings, (Executor)DefaultRunExecutor.getRunExecutorInstance());
        }
    }

    public class RunConfigurationsNode
    extends GroupNode {
        private final List<RunConfigurationNode> myChildren;

        public RunConfigurationsNode(ProjectNode parent) {
            super(parent);
            this.myChildren = new ArrayList<RunConfigurationNode>();
            this.getTemplatePresentation().setIcon(ExternalSystemIcons.Task);
        }

        public String getName() {
            return MavenProjectBundle.message("view.node.run.configurations", new Object[0]);
        }

        @Override
        protected List<? extends MavenSimpleNode> doGetChildren() {
            return this.myChildren;
        }

        public void updateRunConfigurations(MavenProject mavenProject2) {
            boolean childChanged = false;
            HashSet settings = new HashSet(RunManager.getInstance((Project)this.myProject).getConfigurationSettingsList((ConfigurationType)MavenRunConfigurationType.getInstance()));
            Iterator<RunConfigurationNode> itr = this.myChildren.iterator();
            while (itr.hasNext()) {
                RunConfigurationNode node2 = itr.next();
                if (settings.remove(node2.getSettings())) {
                    node2.updateRunConfiguration();
                    continue;
                }
                itr.remove();
                childChanged = true;
            }
            int oldSize = this.myChildren.size();
            for (RunnerAndConfigurationSettings cfg : settings) {
                MavenRunConfiguration mavenRunConfiguration = (MavenRunConfiguration)cfg.getConfiguration();
                if (!VfsUtilCore.pathEqualsTo((VirtualFile)mavenProject2.getDirectoryFile(), (String)mavenRunConfiguration.getRunnerParameters().getWorkingDirPath())) continue;
                this.myChildren.add(new RunConfigurationNode(this, cfg));
            }
            if (oldSize != this.myChildren.size()) {
                childChanged = true;
                this.sort(this.myChildren);
            }
            if (childChanged) {
                this.childrenChanged();
            }
        }
    }

    public class DependencyNode
    extends BaseDependenciesNode {
        private final MavenArtifact myArtifact;
        private final MavenArtifactNode myArtifactNode;
        private final boolean myUnresolved;

        public DependencyNode(MavenSimpleNode parent, MavenArtifactNode artifactNode, MavenProject mavenProject2, boolean unresolved) {
            super(parent, mavenProject2);
            this.myArtifactNode = artifactNode;
            this.myArtifact = artifactNode.getArtifact();
            this.myUnresolved = unresolved;
            this.getTemplatePresentation().setIcon(AllIcons.Nodes.PpLib);
        }

        public MavenArtifact getArtifact() {
            return this.myArtifact;
        }

        public boolean isUnresolved() {
            return this.myUnresolved;
        }

        public String getName() {
            return this.myArtifact.getDisplayStringForLibraryName();
        }

        private String getToolTip() {
            StringBuilder myToolTip = new StringBuilder();
            String scope = this.myArtifactNode.getOriginalScope();
            if (StringUtil.isNotEmpty((String)scope) && !"compile".equals(scope)) {
                myToolTip.append(scope).append(" ");
            }
            if (this.myArtifactNode.getState() == MavenArtifactState.CONFLICT) {
                myToolTip.append("omitted for conflict");
                if (this.myArtifactNode.getRelatedArtifact() != null) {
                    myToolTip.append(" with ").append(this.myArtifactNode.getRelatedArtifact().getVersion());
                }
            }
            if (this.myArtifactNode.getState() == MavenArtifactState.DUPLICATE) {
                myToolTip.append("omitted for duplicate");
            }
            return myToolTip.toString().trim();
        }

        @Override
        protected void doUpdate() {
            this.setNameAndTooltip(this.getName(), null, this.getToolTip());
        }

        @Override
        protected void setNameAndTooltip(String name, @Nullable String tooltip, SimpleTextAttributes attributes) {
            SimpleTextAttributes mergedAttributes = this.myArtifactNode.getState() == MavenArtifactState.CONFLICT || this.myArtifactNode.getState() == MavenArtifactState.DUPLICATE ? SimpleTextAttributes.merge((SimpleTextAttributes)attributes, (SimpleTextAttributes)SimpleTextAttributes.GRAYED_ATTRIBUTES) : attributes;
            super.setNameAndTooltip(name, tooltip, mergedAttributes);
        }

        private void updateDependency() {
            this.setErrorLevel(this.myUnresolved ? ErrorLevel.ERROR : ErrorLevel.NONE);
        }

        @Override
        public Navigatable getNavigatable() {
            MavenId id;
            MavenProject pr;
            MavenArtifactNode parent = this.myArtifactNode.getParent();
            VirtualFile file = parent == null ? this.getMavenProject().getFile() : ((pr = MavenProjectsStructure.this.myProjectsManager.findProject(id = parent.getArtifact().getMavenId())) == null ? MavenNavigationUtil.getArtifactFile(this.getProject(), id) : pr.getFile());
            return file == null ? null : MavenNavigationUtil.createNavigatableForDependency(this.getProject(), file, this.getArtifact());
        }

        @Override
        public boolean isVisible() {
            return this.getDisplayKind() != DisplayKind.NEVER;
        }
    }

    public class DependenciesNode
    extends BaseDependenciesNode {
        public DependenciesNode(ProjectNode parent, MavenProject mavenProject2) {
            super(parent, mavenProject2);
            this.getTemplatePresentation().setIcon(AllIcons.Nodes.PpLibFolder);
        }

        public String getName() {
            return MavenProjectBundle.message("view.node.dependencies", new Object[0]);
        }

        public void updateDependencies() {
            this.updateChildren(this.myMavenProject.getDependencyTree(), this.myMavenProject);
        }
    }

    public abstract class BaseDependenciesNode
    extends GroupNode {
        protected final MavenProject myMavenProject;
        private List<DependencyNode> myChildren;

        protected BaseDependenciesNode(MavenSimpleNode parent, MavenProject mavenProject2) {
            super(parent);
            this.myChildren = new ArrayList<DependencyNode>();
            this.myMavenProject = mavenProject2;
        }

        public MavenProject getMavenProject() {
            return this.myMavenProject;
        }

        @Override
        protected List<? extends MavenSimpleNode> doGetChildren() {
            return this.myChildren;
        }

        protected void updateChildren(List<MavenArtifactNode> children, MavenProject mavenProject2) {
            ArrayList<DependencyNode> newNodes = null;
            int validChildCount = 0;
            for (MavenArtifactNode each : children) {
                if (each.getState() != MavenArtifactState.ADDED && each.getState() != MavenArtifactState.CONFLICT && each.getState() != MavenArtifactState.DUPLICATE) continue;
                if (newNodes == null) {
                    if (validChildCount < this.myChildren.size()) {
                        DependencyNode currentValidNode = this.myChildren.get(validChildCount);
                        if (currentValidNode.myArtifact.equals((Object)each.getArtifact()) && currentValidNode.isUnresolved() == each.getArtifact().isFileUnresolved()) {
                            if (each.getState() == MavenArtifactState.ADDED) {
                                currentValidNode.updateChildren(each.getDependencies(), mavenProject2);
                            }
                            ++validChildCount;
                            continue;
                        }
                    }
                    newNodes = new ArrayList(children.size());
                    newNodes.addAll(this.myChildren.subList(0, validChildCount));
                }
                DependencyNode newNode = this.findOrCreateNodeFor(each, mavenProject2, validChildCount);
                newNodes.add(newNode);
                if (each.getState() == MavenArtifactState.ADDED) {
                    newNode.updateChildren(each.getDependencies(), mavenProject2);
                }
                newNode.updateDependency();
            }
            if (newNodes == null) {
                if (validChildCount == this.myChildren.size()) {
                    return;
                }
                assert (validChildCount < this.myChildren.size());
                newNodes = new ArrayList<DependencyNode>(this.myChildren.subList(0, validChildCount));
            }
            this.myChildren = newNodes;
            this.childrenChanged();
        }

        private DependencyNode findOrCreateNodeFor(MavenArtifactNode artifact, MavenProject mavenProject2, int from) {
            for (int i = from; i < this.myChildren.size(); ++i) {
                DependencyNode node2 = this.myChildren.get(i);
                if (!node2.myArtifact.equals((Object)artifact.getArtifact()) || node2.isUnresolved() != artifact.getArtifact().isFileUnresolved()) continue;
                return node2;
            }
            return new DependencyNode(this, artifact, mavenProject2, artifact.getArtifact().isFileUnresolved());
        }

        @Override
        String getMenuId() {
            return "Maven.DependencyMenu";
        }
    }

    public class PluginGoalNode
    extends GoalNode {
        private final String myUnqualifiedGoal;

        public PluginGoalNode(PluginNode parent, String goal, String unqualifiedGoal, String displayName) {
            super(parent, goal, displayName);
            this.getTemplatePresentation().setIcon(MavenIcons.PluginGoal);
            this.myUnqualifiedGoal = unqualifiedGoal;
        }

        @Override
        @Nullable
        public Navigatable getNavigatable() {
            PluginNode pluginNode = (PluginNode)this.getParent();
            MavenDomPluginModel pluginModel = MavenPluginDomUtil.getMavenPluginModel(this.myProject, pluginNode.getPlugin().getGroupId(), pluginNode.getPlugin().getArtifactId(), pluginNode.getPlugin().getVersion());
            if (pluginModel == null) {
                return null;
            }
            for (MavenDomMojo mojo2 : pluginModel.getMojos().getMojos()) {
                final XmlElement xmlElement = mojo2.getGoal().getXmlElement();
                if (!(xmlElement instanceof Navigatable) || !Objects.equals(this.myUnqualifiedGoal, mojo2.getGoal().getStringValue())) continue;
                return new NavigatableAdapter(){

                    public void navigate(boolean requestFocus) {
                        ((Navigatable)xmlElement).navigate(requestFocus);
                    }
                };
            }
            return null;
        }
    }

    public class PluginNode
    extends GoalsGroupNode {
        private final MavenPlugin myPlugin;
        private MavenPluginInfo myPluginInfo;

        public PluginNode(PluginsNode parent, MavenPlugin plugin, MavenPluginInfo pluginInfo) {
            super(parent);
            this.myPlugin = plugin;
            this.getTemplatePresentation().setIcon(MavenIcons.MavenPlugin);
            this.updatePlugin(pluginInfo);
        }

        public MavenPlugin getPlugin() {
            return this.myPlugin;
        }

        public String getName() {
            return this.myPluginInfo == null ? this.myPlugin.getDisplayString() : this.myPluginInfo.getGoalPrefix();
        }

        @Override
        protected void doUpdate() {
            this.setNameAndTooltip(this.getName(), null, this.myPluginInfo != null ? this.myPlugin.getDisplayString() : null);
        }

        public void updatePlugin(@Nullable MavenPluginInfo newPluginInfo) {
            boolean hadPluginInfo = this.myPluginInfo != null;
            this.myPluginInfo = newPluginInfo;
            boolean hasPluginInfo = this.myPluginInfo != null;
            this.setErrorLevel(this.myPluginInfo == null ? ErrorLevel.ERROR : ErrorLevel.NONE);
            if (hadPluginInfo == hasPluginInfo) {
                return;
            }
            this.myGoalNodes.clear();
            if (this.myPluginInfo != null) {
                for (MavenPluginInfo.Mojo mojo2 : this.myPluginInfo.getMojos()) {
                    this.myGoalNodes.add(new PluginGoalNode(this, mojo2.getQualifiedGoal(), mojo2.getGoal(), mojo2.getDisplayName()));
                }
            }
            this.sort(this.myGoalNodes);
            MavenProjectsStructure.this.updateFrom((SimpleNode)this);
            this.childrenChanged();
        }

        @Override
        public boolean isVisible() {
            return super.isVisible() || this.getDisplayKind() != DisplayKind.NEVER;
        }
    }

    public class PluginsNode
    extends GroupNode {
        private final List<PluginNode> myPluginNodes;

        public PluginsNode(ProjectNode parent) {
            super(parent);
            this.myPluginNodes = new ArrayList<PluginNode>();
            this.getTemplatePresentation().setIcon(AllIcons.Nodes.ConfigFolder);
        }

        public String getName() {
            return MavenProjectBundle.message("view.node.plugins", new Object[0]);
        }

        @Override
        protected List<? extends MavenSimpleNode> doGetChildren() {
            return this.myPluginNodes;
        }

        public void updatePlugins(MavenProject mavenProject2) {
            List<MavenPlugin> plugins = mavenProject2.getDeclaredPlugins();
            MavenProjectsStructure.this.boundedUpdateService.execute(new UpdatePluginsTreeTask(this, plugins));
        }
    }

    public class StandardGoalNode
    extends GoalNode {
        public StandardGoalNode(GoalsGroupNode parent, String goal) {
            super(parent, goal, goal);
        }

        @Override
        public boolean isVisible() {
            if (MavenProjectsStructure.this.showOnlyBasicPhases() && !BASIC_PHASES.contains(this.getGoal())) {
                return false;
            }
            return super.isVisible();
        }
    }

    public class LifecycleNode
    extends GoalsGroupNode {
        public LifecycleNode(ProjectNode parent) {
            super(parent);
            for (String goal : PHASES) {
                this.myGoalNodes.add(new StandardGoalNode(this, goal));
            }
            this.getTemplatePresentation().setIcon(AllIcons.Nodes.ConfigFolder);
        }

        public String getName() {
            return MavenProjectBundle.message("view.node.lifecycle", new Object[0]);
        }

        public void updateGoalsList() {
            this.childrenChanged();
        }
    }

    public abstract class GoalNode
    extends MavenSimpleNode {
        private final MavenProject myMavenProject;
        private final String myGoal;
        private final String myDisplayName;

        public GoalNode(GoalsGroupNode parent, String goal, String displayName) {
            super(parent);
            this.myMavenProject = this.findParent(ProjectNode.class).getMavenProject();
            this.myGoal = goal;
            this.myDisplayName = displayName;
            this.getTemplatePresentation().setIcon(ExternalSystemIcons.Task);
        }

        public MavenProject getMavenProject() {
            return this.myMavenProject;
        }

        public String getProjectPath() {
            return this.myMavenProject.getPath();
        }

        public String getGoal() {
            return this.myGoal;
        }

        public String getName() {
            return this.myDisplayName;
        }

        @Override
        protected void doUpdate() {
            String s1 = StringUtil.nullize((String)MavenProjectsStructure.this.myShortcutsManager.getDescription(this.myMavenProject, this.myGoal));
            String s2 = StringUtil.nullize((String)MavenProjectsStructure.this.myTasksManager.getDescription(this.myMavenProject, this.myGoal));
            Object hint = s1 == null ? s2 : (s2 == null ? s1 : s1 + ", " + s2);
            this.setNameAndTooltip(this.getName(), null, (String)hint);
        }

        protected SimpleTextAttributes getPlainAttributes() {
            SimpleTextAttributes original = super.getPlainAttributes();
            int style = original.getStyle();
            Color color = original.getFgColor();
            boolean custom = false;
            if ("test".equals(this.myGoal) && MavenRunner.getInstance(this.myProject).getSettings().isSkipTests()) {
                color = SimpleTextAttributes.GRAYED_ATTRIBUTES.getFgColor();
                style |= 4;
                custom = true;
            }
            if (this.myGoal.equals(this.myMavenProject.getDefaultGoal())) {
                style |= 1;
                custom = true;
            }
            if (custom) {
                return original.derive(style, color, null, null);
            }
            return original;
        }

        @Override
        @Nullable
        @NonNls
        protected String getActionId() {
            return "Maven.RunBuild";
        }

        @Override
        @Nullable
        @NonNls
        protected String getMenuId() {
            return "Maven.BuildMenu";
        }
    }

    public abstract class GoalsGroupNode
    extends GroupNode {
        protected final List<GoalNode> myGoalNodes;

        public GoalsGroupNode(MavenSimpleNode parent) {
            super(parent);
            this.myGoalNodes = new ArrayList<GoalNode>();
        }

        @Override
        protected List<? extends MavenSimpleNode> doGetChildren() {
            return this.myGoalNodes;
        }
    }

    public class ModulesNode
    extends ProjectsGroupNode {
        public ModulesNode(ProjectNode parent) {
            super(parent);
            this.getTemplatePresentation().setIcon(MavenIcons.ModulesClosed);
        }

        public String getName() {
            return MavenProjectBundle.message("view.node.modules", new Object[0]);
        }
    }

    public class ProjectNode
    extends ProjectsGroupNode {
        private final MavenProject myMavenProject;
        private final LifecycleNode myLifecycleNode;
        private final PluginsNode myPluginsNode;
        private final DependenciesNode myDependenciesNode;
        private final RunConfigurationsNode myRunConfigurationsNode;
        private @NlsContexts.Tooltip String myTooltipCache;

        public ProjectNode(MavenProject mavenProject2) {
            if (mavenProject2 == null) {
                ProjectNode.$$$reportNull$$$0(0);
            }
            super(null);
            this.myMavenProject = mavenProject2;
            this.myLifecycleNode = new LifecycleNode(this);
            this.myPluginsNode = new PluginsNode(this);
            this.myDependenciesNode = new DependenciesNode(this, mavenProject2);
            this.myRunConfigurationsNode = new RunConfigurationsNode(this);
            this.getTemplatePresentation().setIcon(MavenIcons.MavenProject);
        }

        public MavenProject getMavenProject() {
            return this.myMavenProject;
        }

        public ProjectsGroupNode getGroup() {
            return (ProjectsGroupNode)super.getParent();
        }

        @Override
        public boolean isVisible() {
            if (!MavenProjectsStructure.this.myProjectsNavigator.getShowIgnored() && MavenProjectsStructure.this.myProjectsManager.isIgnored(this.myMavenProject)) {
                return false;
            }
            return super.isVisible();
        }

        @Override
        protected List<? extends MavenSimpleNode> doGetChildren() {
            return ContainerUtil.concat(Arrays.asList(new GroupNode[]{this.myLifecycleNode, this.myPluginsNode, this.myRunConfigurationsNode, this.myDependenciesNode}), super.doGetChildren());
        }

        private void updateProject() {
            this.setErrorLevel(this.myMavenProject.getCacheProblems().isEmpty() ? ErrorLevel.NONE : ErrorLevel.ERROR);
            this.myLifecycleNode.updateGoalsList();
            this.myPluginsNode.updatePlugins(this.myMavenProject);
            if (MavenProjectsStructure.this.isShown(DependencyNode.class)) {
                this.myDependenciesNode.updateDependencies();
            }
            this.myRunConfigurationsNode.updateRunConfigurations(this.myMavenProject);
            this.myTooltipCache = this.makeDescription();
            MavenProjectsStructure.this.updateFrom(this.getParent());
        }

        public void updateIgnored() {
            this.getGroup().childrenChanged();
        }

        public void updateGoals() {
            MavenProjectsStructure.this.updateFrom((SimpleNode)this.myLifecycleNode);
            MavenProjectsStructure.this.updateFrom((SimpleNode)this.myPluginsNode);
        }

        public void updateRunConfigurations() {
            this.myRunConfigurationsNode.updateRunConfigurations(this.myMavenProject);
            MavenProjectsStructure.this.updateFrom((SimpleNode)this.myRunConfigurationsNode);
        }

        public String getName() {
            if (MavenProjectsStructure.this.myProjectsNavigator.getAlwaysShowArtifactId()) {
                return this.myMavenProject.getMavenId().getArtifactId();
            }
            return this.myMavenProject.getDisplayName();
        }

        @Override
        protected void doUpdate() {
            String hint = null;
            if (!MavenProjectsStructure.this.myProjectsNavigator.getGroupModules() && MavenProjectsStructure.this.myProjectsManager.findAggregator(this.myMavenProject) == null && MavenProjectsStructure.this.myProjectsManager.getProjects().size() > MavenProjectsStructure.this.myProjectsManager.getRootProjects().size()) {
                hint = "root";
            }
            this.setNameAndTooltip(this.getName(), this.myTooltipCache, hint);
        }

        protected SimpleTextAttributes getPlainAttributes() {
            if (MavenProjectsStructure.this.myProjectsManager.isIgnored(this.myMavenProject)) {
                return new SimpleTextAttributes(0, (Color)JBColor.GRAY);
            }
            return super.getPlainAttributes();
        }

        @NlsContexts.DetailedDescription
        private String makeDescription() {
            StringBuilder desc = new StringBuilder();
            desc.append("<html>").append("<table>");
            desc.append("<tr>").append("<td nowrap>").append("<table>").append("<tr>").append("<td nowrap>").append(MavenProjectBundle.message("detailed.description.project", new Object[0])).append("</td>").append("<td nowrap>").append(this.myMavenProject.getMavenId()).append("</td>").append("</tr>").append("<tr>").append("<td nowrap>").append(MavenProjectBundle.message("detailed.description.location", new Object[0])).append("</td>").append("<td nowrap>").append(UiUtils.getPresentablePath((String)this.myMavenProject.getPath())).append("</td>").append("</tr>").append("</table>").append("</td>").append("</tr>");
            this.appendProblems(desc);
            desc.append("</table>").append("</html>");
            return desc.toString();
        }

        private void appendProblems(StringBuilder desc) {
            List<MavenProjectProblem> problems = this.myMavenProject.getCacheProblems();
            if (problems.isEmpty()) {
                return;
            }
            desc.append("<tr><td nowrap><table>");
            boolean first = true;
            for (MavenProjectProblem each : problems) {
                desc.append("<tr>");
                if (first) {
                    desc.append("<td nowrap valign=top>").append(MavenUtil.formatHtmlImage(ERROR_ICON_URL)).append("</td>");
                    desc.append("<td nowrap valign=top>").append(MavenProjectBundle.message("detailed.description.problems", new Object[0])).append("</td>");
                    first = false;
                } else {
                    desc.append("<td nowrap colspan=2></td>");
                }
                desc.append("<td nowrap valign=top>").append(this.wrappedText(each)).append("</td>");
                desc.append("</tr>");
            }
            desc.append("</table></td></tr>");
        }

        private String wrappedText(MavenProjectProblem each) {
            String description = (String)ObjectUtils.chooseNotNull((Object)each.getDescription(), (Object)each.getPath());
            if (description == null) {
                return "";
            }
            String text = StringUtil.replace((String)description, Arrays.asList("<", ">"), Arrays.asList("&lt;", "&gt;"));
            StringBuilder result = new StringBuilder();
            int count = 0;
            for (int i = 0; i < text.length(); ++i) {
                char ch = text.charAt(i);
                result.append(ch);
                if (count++ <= 80 || ch != ' ') continue;
                count = 0;
                result.append("<br>");
            }
            return result.toString();
        }

        @Override
        public VirtualFile getVirtualFile() {
            return this.myMavenProject.getFile();
        }

        @Override
        protected void setNameAndTooltip(String name, @Nullable String tooltip, SimpleTextAttributes attributes) {
            super.setNameAndTooltip(name, tooltip, attributes);
            if (MavenProjectsStructure.this.myProjectsNavigator.getShowVersions()) {
                this.addColoredFragment(":" + this.myMavenProject.getMavenId().getVersion(), new SimpleTextAttributes(0, (Color)JBColor.GRAY));
            }
        }

        @Override
        @Nullable
        @NonNls
        protected String getMenuId() {
            return "Maven.NavigatorProjectMenu";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mavenProject", "org/jetbrains/idea/maven/navigator/MavenProjectsStructure$ProjectNode", "<init>"));
        }
    }

    public class ProfileNode
    extends MavenSimpleNode {
        private final String myProfileName;
        private MavenProfileKind myState;

        public ProfileNode(ProfilesNode parent, String profileName) {
            super(parent);
            this.myProfileName = profileName;
        }

        public String getName() {
            return this.myProfileName;
        }

        public String getProfileName() {
            return this.myProfileName;
        }

        public MavenProfileKind getState() {
            return this.myState;
        }

        private void setState(MavenProfileKind state2) {
            this.myState = state2;
        }

        @Override
        @Nullable
        @NonNls
        protected String getActionId() {
            return "Maven.ToggleProfile";
        }

        @Override
        @Nullable
        public Navigatable getNavigatable() {
            if (this.myProject == null) {
                return null;
            }
            ArrayList<MavenDomProfile> profiles2 = new ArrayList<MavenDomProfile>();
            for (VirtualFile virtualFile : MavenProjectsStructure.this.myProjectsManager.getGeneralSettings().getEffectiveSettingsFiles()) {
                MavenDomSettingsModel model2;
                if (virtualFile == null || (model2 = MavenDomUtil.getMavenDomModel(this.myProject, virtualFile, MavenDomSettingsModel.class)) == null) continue;
                this.addProfiles(profiles2, model2.getProfiles().getProfiles());
            }
            for (MavenProject mavenProject2 : MavenProjectsStructure.this.myProjectsManager.getProjects()) {
                MavenDomProjectModel projectModel;
                MavenDomProfiles profilesModel;
                VirtualFile mavenProjectFile = mavenProject2.getFile();
                VirtualFile profilesXmlFile = MavenUtil.findProfilesXmlFile(mavenProjectFile);
                if (profilesXmlFile != null && (profilesModel = MavenDomUtil.getMavenDomProfilesModel(this.myProject, profilesXmlFile)) != null) {
                    this.addProfiles(profiles2, profilesModel.getProfiles());
                }
                if ((projectModel = MavenDomUtil.getMavenDomProjectModel(this.myProject, mavenProjectFile)) == null) continue;
                this.addProfiles(profiles2, projectModel.getProfiles().getProfiles());
            }
            return this.getNavigatable(profiles2);
        }

        private Navigatable getNavigatable(final @NotNull List<MavenDomProfile> profiles2) {
            if (profiles2 == null) {
                ProfileNode.$$$reportNull$$$0(0);
            }
            if (profiles2.size() > 1) {
                return new NavigatableAdapter(){

                    public void navigate(boolean requestFocus) {
                        JBPopupFactory.getInstance().createPopupChooserBuilder(profiles2).setRenderer((ListCellRenderer)new DefaultListCellRenderer(){

                            @Override
                            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                                Component result = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                                MavenDomProfile mavenDomProfile = (MavenDomProfile)value;
                                XmlElement xmlElement = mavenDomProfile.getXmlElement();
                                if (xmlElement != null) {
                                    this.setText(xmlElement.getContainingFile().getVirtualFile().getPresentableUrl());
                                }
                                return result;
                            }
                        }).setTitle(MavenProjectBundle.message("maven.notification.choose.file.to.open", new Object[0])).setItemChosenCallback(value -> {
                            Navigatable navigatable = ProfileNode.this.getNavigatable((MavenDomProfile)value);
                            if (navigatable != null) {
                                navigatable.navigate(requestFocus);
                            }
                        }).createPopup().showInFocusCenter();
                    }
                };
            }
            return this.getNavigatable((MavenDomProfile)ContainerUtil.getFirstItem(profiles2));
        }

        @Nullable
        private Navigatable getNavigatable(@Nullable MavenDomProfile profile) {
            if (profile == null) {
                return null;
            }
            XmlElement xmlElement = profile.getId().getXmlElement();
            return xmlElement instanceof Navigatable ? (Navigatable)xmlElement : null;
        }

        private void addProfiles(@NotNull List<MavenDomProfile> result, @Nullable List<MavenDomProfile> profilesToAdd) {
            if (result == null) {
                ProfileNode.$$$reportNull$$$0(1);
            }
            if (profilesToAdd == null) {
                return;
            }
            for (MavenDomProfile profile : profilesToAdd) {
                if (!StringUtil.equals((CharSequence)((CharSequence)profile.getId().getValue()), (CharSequence)this.myProfileName)) continue;
                result.add(profile);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "profiles";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/idea/maven/navigator/MavenProjectsStructure$ProfileNode";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getNavigatable";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addProfiles";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public class ProfilesNode
    extends GroupNode {
        private List<ProfileNode> myProfileNodes;

        public ProfilesNode(MavenSimpleNode parent) {
            super(parent);
            this.myProfileNodes = new ArrayList<ProfileNode>();
            this.setUniformIcon(MavenIcons.ProfilesClosed);
        }

        @Override
        protected List<? extends MavenSimpleNode> doGetChildren() {
            return this.myProfileNodes;
        }

        public String getName() {
            return MavenProjectBundle.message("view.node.profiles", new Object[0]);
        }

        public void updateProfiles() {
            Collection<Pair<String, MavenProfileKind>> profiles2 = MavenProjectsStructure.this.myProjectsManager.getProfilesWithStates();
            ArrayList<ProfileNode> newNodes = new ArrayList<ProfileNode>(profiles2.size());
            for (Pair<String, MavenProfileKind> each : profiles2) {
                ProfileNode node2 = this.findOrCreateNodeFor((String)each.first);
                node2.setState((MavenProfileKind)each.second);
                newNodes.add(node2);
            }
            this.myProfileNodes = newNodes;
            this.sort(this.myProfileNodes);
            this.childrenChanged();
        }

        private ProfileNode findOrCreateNodeFor(String profileName) {
            for (ProfileNode each : this.myProfileNodes) {
                if (!each.getProfileName().equals(profileName)) continue;
                return each;
            }
            return new ProfileNode(this, profileName);
        }
    }

    public class RootNode
    extends ProjectsGroupNode {
        private final ProfilesNode myProfilesNode;

        public RootNode() {
            super(null);
            this.myProfilesNode = new ProfilesNode(this);
        }

        @Override
        public boolean isVisible() {
            return true;
        }

        @Override
        protected List<? extends MavenSimpleNode> doGetChildren() {
            return ContainerUtil.concat(Collections.singletonList(this.myProfilesNode), super.doGetChildren());
        }

        public void updateProfiles() {
            this.myProfilesNode.updateProfiles();
        }
    }

    public abstract class ProjectsGroupNode
    extends GroupNode {
        private final List<ProjectNode> myProjectNodes;

        public ProjectsGroupNode(MavenSimpleNode parent) {
            super(parent);
            this.myProjectNodes = new ArrayList<ProjectNode>();
            this.getTemplatePresentation().setIcon(MavenIcons.ModulesClosed);
        }

        @Override
        protected List<? extends MavenSimpleNode> doGetChildren() {
            return this.myProjectNodes;
        }

        @TestOnly
        public List<ProjectNode> getProjectNodesInTests() {
            return this.myProjectNodes;
        }

        protected void add(ProjectNode projectNode) {
            projectNode.setParent(this);
            this.insertSorted(this.myProjectNodes, projectNode);
            this.childrenChanged();
        }

        public void remove(ProjectNode projectNode) {
            projectNode.setParent(null);
            this.myProjectNodes.remove((Object)projectNode);
            this.childrenChanged();
        }

        public void sortProjects() {
            this.sort(this.myProjectNodes);
            this.childrenChanged();
        }
    }

    public abstract class GroupNode
    extends MavenSimpleNode {
        public GroupNode(MavenSimpleNode parent) {
            super(parent);
        }

        @Override
        public boolean isVisible() {
            if (this.getDisplayKind() == DisplayKind.ALWAYS) {
                return true;
            }
            for (SimpleNode each : this.getChildren()) {
                if (!((MavenSimpleNode)each).isVisible()) continue;
                return true;
            }
            return false;
        }

        protected <T extends MavenSimpleNode> void insertSorted(List<T> list, T newObject) {
            int pos = Collections.binarySearch(list, newObject, NODE_COMPARATOR);
            list.add(pos >= 0 ? pos : -pos - 1, newObject);
        }

        protected void sort(List<? extends MavenSimpleNode> list) {
            list.sort(NODE_COMPARATOR);
        }
    }

    public abstract class MavenSimpleNode
    extends CachingSimpleNode {
        private MavenSimpleNode myParent;
        private ErrorLevel myErrorLevel;
        private ErrorLevel myTotalErrorLevel;

        public MavenSimpleNode(MavenSimpleNode parent) {
            super(MavenProjectsStructure.this.myProject, null);
            this.myErrorLevel = ErrorLevel.NONE;
            this.myTotalErrorLevel = null;
            this.setParent(parent);
        }

        public void setParent(MavenSimpleNode parent) {
            this.myParent = parent;
        }

        public NodeDescriptor getParentDescriptor() {
            return this.myParent;
        }

        public <T extends MavenSimpleNode> T findParent(Class<T> parentClass) {
            return (T)((Object)((MavenSimpleNode)((Object)ObjectUtils.doIfNotNull((Object)((Object)this.myParent), it -> it.findNode(parentClass)))));
        }

        public <T extends MavenSimpleNode> T findNode(Class<T> parentClass) {
            MavenSimpleNode node2 = this;
            while (node2 != null && !parentClass.isInstance((Object)node2)) {
                node2 = node2.myParent;
            }
            return (T)((Object)node2);
        }

        public boolean isVisible() {
            return this.getDisplayKind() != DisplayKind.NEVER;
        }

        public DisplayKind getDisplayKind() {
            Class<? extends MavenSimpleNode>[] visibles = MavenProjectsStructure.this.getVisibleNodesClasses();
            if (visibles == null) {
                return DisplayKind.NORMAL;
            }
            for (Class<? extends MavenSimpleNode> each : visibles) {
                if (!each.isInstance((Object)this)) continue;
                return DisplayKind.ALWAYS;
            }
            return DisplayKind.NEVER;
        }

        protected SimpleNode[] buildChildren() {
            List<? extends MavenSimpleNode> children = this.doGetChildren();
            if (children.isEmpty()) {
                return NO_CHILDREN;
            }
            ArrayList<MavenSimpleNode> result = new ArrayList<MavenSimpleNode>();
            for (MavenSimpleNode mavenSimpleNode : children) {
                if (!mavenSimpleNode.isVisible()) continue;
                result.add(mavenSimpleNode);
            }
            return (SimpleNode[])result.toArray(new MavenSimpleNode[0]);
        }

        protected List<? extends MavenSimpleNode> doGetChildren() {
            return Collections.emptyList();
        }

        public void cleanUpCache() {
            super.cleanUpCache();
            this.myTotalErrorLevel = null;
        }

        protected void childrenChanged() {
            for (MavenSimpleNode each = this; each != null; each = (MavenSimpleNode)each.getParent()) {
                each.cleanUpCache();
            }
            MavenProjectsStructure.this.updateUpTo((SimpleNode)this);
        }

        public ErrorLevel getTotalErrorLevel() {
            if (this.myTotalErrorLevel == null) {
                this.myTotalErrorLevel = this.calcTotalErrorLevel();
            }
            return this.myTotalErrorLevel;
        }

        private ErrorLevel calcTotalErrorLevel() {
            ErrorLevel childrenErrorLevel = this.getChildrenErrorLevel();
            return childrenErrorLevel.compareTo(this.myErrorLevel) > 0 ? childrenErrorLevel : this.myErrorLevel;
        }

        public ErrorLevel getChildrenErrorLevel() {
            ErrorLevel result = ErrorLevel.NONE;
            for (SimpleNode each : this.getChildren()) {
                ErrorLevel eachLevel = ((MavenSimpleNode)each).getTotalErrorLevel();
                if (eachLevel.compareTo(result) <= 0) continue;
                result = eachLevel;
            }
            return result;
        }

        public void setErrorLevel(ErrorLevel level) {
            if (this.myErrorLevel == level) {
                return;
            }
            this.myErrorLevel = level;
            MavenProjectsStructure.this.updateUpTo((SimpleNode)this);
        }

        protected void doUpdate() {
            this.setNameAndTooltip(this.getName(), null);
        }

        protected void setNameAndTooltip(String name, @Nullable @NlsContexts.Tooltip String tooltip) {
            this.setNameAndTooltip(name, tooltip, (String)null);
        }

        protected void setNameAndTooltip(String name, @Nullable @NlsContexts.Tooltip String tooltip, @Nullable String hint) {
            this.setNameAndTooltip(name, tooltip, this.getPlainAttributes());
            if (MavenProjectsStructure.this.showDescriptions() && !StringUtil.isEmptyOrSpaces((String)hint)) {
                this.addColoredFragment(" (" + hint + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
        }

        protected void setNameAndTooltip(String name, @Nullable @NlsContexts.Tooltip String tooltip, SimpleTextAttributes attributes) {
            this.clearColoredText();
            this.addColoredFragment(name, this.prepareAttributes(attributes));
            this.getTemplatePresentation().setTooltip(tooltip);
        }

        private SimpleTextAttributes prepareAttributes(SimpleTextAttributes from) {
            ErrorLevel level = this.getTotalErrorLevel();
            JBColor waveColor = level == ErrorLevel.NONE ? null : JBColor.RED;
            int style = from.getStyle();
            if (waveColor != null) {
                style |= 8;
            }
            return new SimpleTextAttributes(from.getBgColor(), from.getFgColor(), (Color)waveColor, style);
        }

        @Nullable
        @NonNls
        String getActionId() {
            return null;
        }

        @Nullable
        @NonNls
        String getMenuId() {
            return null;
        }

        @Nullable
        public VirtualFile getVirtualFile() {
            return null;
        }

        @Nullable
        public Navigatable getNavigatable() {
            return MavenNavigationUtil.createNavigatableForPom(this.getProject(), this.getVirtualFile());
        }

        public void handleDoubleClickOrEnter(SimpleTree tree, InputEvent inputEvent) {
            String actionId = this.getActionId();
            if (actionId != null) {
                MavenUIUtil.executeAction(actionId, "Maven tool window", inputEvent);
            }
        }
    }

    public static enum ErrorLevel {
        NONE,
        ERROR;

    }

    static enum DisplayKind {
        ALWAYS,
        NEVER,
        NORMAL;

    }
}

