/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.tasks.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.tasks.MavenCompilerTask;
import org.jetbrains.idea.maven.tasks.MavenTasksManager;
import org.jetbrains.idea.maven.utils.MavenDataKeys;
import org.jetbrains.idea.maven.utils.actions.MavenActionUtil;
import org.jetbrains.idea.maven.utils.actions.MavenToggleAction;

public abstract class ToggleCompilerTasksAction
extends MavenToggleAction {
    private final MavenTasksManager.Phase myPhase;

    protected ToggleCompilerTasksAction(MavenTasksManager.Phase phase) {
        this.myPhase = phase;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ToggleCompilerTasksAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    @Override
    protected boolean isAvailable(@NotNull AnActionEvent e) {
        if (e == null) {
            ToggleCompilerTasksAction.$$$reportNull$$$0(1);
        }
        return super.isAvailable(e) && !ToggleCompilerTasksAction.getTasks(e.getDataContext()).isEmpty();
    }

    @Override
    protected boolean doIsSelected(AnActionEvent e) {
        DataContext context = e.getDataContext();
        return this.hasTask(ToggleCompilerTasksAction.getTasksManager(context), ToggleCompilerTasksAction.getTasks(context).get(0));
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state2) {
        if (e == null) {
            ToggleCompilerTasksAction.$$$reportNull$$$0(2);
        }
        DataContext context = e.getDataContext();
        MavenTasksManager tasksManager = ToggleCompilerTasksAction.getTasksManager(context);
        List<MavenCompilerTask> tasks = ToggleCompilerTasksAction.getTasks(context);
        if (tasksManager == null) {
            return;
        }
        if (state2) {
            this.addTasks(tasksManager, tasks);
        } else {
            this.removeTasks(tasksManager, tasks);
        }
    }

    protected static List<MavenCompilerTask> getTasks(DataContext context) {
        List goals2 = (List)MavenDataKeys.MAVEN_GOALS.getData(context);
        if (goals2 == null || goals2.isEmpty()) {
            return Collections.emptyList();
        }
        MavenProject project2 = MavenActionUtil.getMavenProject(context);
        if (project2 == null) {
            return Collections.emptyList();
        }
        ArrayList<MavenCompilerTask> result = new ArrayList<MavenCompilerTask>();
        for (String each : goals2) {
            result.add(new MavenCompilerTask(project2.getPath(), each));
        }
        return result;
    }

    protected boolean hasTask(@Nullable MavenTasksManager manager, MavenCompilerTask task) {
        if (manager == null) {
            return false;
        }
        return manager.isCompileTaskOfPhase(task, this.myPhase);
    }

    protected void addTasks(MavenTasksManager manager, List<MavenCompilerTask> tasks) {
        manager.addCompileTasks(tasks, this.myPhase);
    }

    protected void removeTasks(MavenTasksManager manager, List<MavenCompilerTask> tasks) {
        manager.removeCompileTasks(tasks, this.myPhase);
    }

    @Nullable
    private static MavenTasksManager getTasksManager(DataContext context) {
        Project project2 = MavenActionUtil.getProject(context);
        if (project2 == null) {
            return null;
        }
        return MavenTasksManager.getInstance(project2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/tasks/actions/ToggleCompilerTasksAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/tasks/actions/ToggleCompilerTasksAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setSelected";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

