/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner;

import com.intellij.build.BuildViewManager;
import com.intellij.build.BuildViewSettingsProvider;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.impl.OutputBuildEventImpl;
import com.intellij.execution.Platform;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.runner.SMTRunnerEventsListener;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.project.Project;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleConsoleProperties;

public class GradleTestsExecutionConsole
extends SMTRunnerConsoleView
implements BuildViewSettingsProvider {
    private final Map<String, SMTestProxy> testsMap;
    private final StringBuilder myBuffer;
    private final SMTRunnerEventsListener myEventPublisher;
    @Nullable
    private final BuildViewManager myBuildViewManager;
    @Nullable
    private final ExternalSystemTaskId myTaskId;
    private boolean lastMessageWasEmptyLine;

    public GradleTestsExecutionConsole(TestConsoleProperties consoleProperties, @Nullable String splitterProperty) {
        this(null, null, consoleProperties, splitterProperty);
    }

    public GradleTestsExecutionConsole(@Nullable Project project, @Nullable ExternalSystemTaskId taskId, @NotNull TestConsoleProperties consoleProperties, @Nullable String splitterProperty) {
        if (consoleProperties == null) {
            GradleTestsExecutionConsole.$$$reportNull$$$0(0);
        }
        super(consoleProperties, splitterProperty);
        this.testsMap = new HashMap<String, SMTestProxy>();
        this.myBuffer = new StringBuilder();
        this.myEventPublisher = (SMTRunnerEventsListener)consoleProperties.getProject().getMessageBus().syncPublisher(SMTRunnerEventsListener.TEST_STATUS);
        this.myBuildViewManager = project != null ? (BuildViewManager)project.getService(BuildViewManager.class) : null;
        this.myTaskId = taskId;
    }

    public SMTRunnerEventsListener getEventPublisher() {
        return this.myEventPublisher;
    }

    public Map<String, SMTestProxy> getTestsMap() {
        return this.testsMap;
    }

    public StringBuilder getBuffer() {
        return this.myBuffer;
    }

    public void dispose() {
        this.testsMap.clear();
        super.dispose();
    }

    public SMTestLocator getUrlProvider() {
        return GradleConsoleProperties.GRADLE_TEST_LOCATOR;
    }

    public boolean isExecutionViewHidden() {
        return true;
    }

    public void print(@NotNull String s, @NotNull ConsoleViewContentType contentType) {
        if (s == null) {
            GradleTestsExecutionConsole.$$$reportNull$$$0(1);
        }
        if (contentType == null) {
            GradleTestsExecutionConsole.$$$reportNull$$$0(2);
        }
        if (this.detectUnwantedEmptyLine(s)) {
            return;
        }
        super.print(s, contentType);
        if (this.myBuildViewManager != null && this.myTaskId != null) {
            OutputBuildEventImpl outputBuildEvent = new OutputBuildEventImpl((Object)this.myTaskId, s, contentType != ConsoleViewContentType.ERROR_OUTPUT);
            this.myBuildViewManager.onEvent((Object)this.myTaskId, (BuildEvent)outputBuildEvent);
        }
    }

    private boolean detectUnwantedEmptyLine(@NotNull String s) {
        if (s == null) {
            GradleTestsExecutionConsole.$$$reportNull$$$0(3);
        }
        if (Platform.current().lineSeparator.equals(s)) {
            if (this.lastMessageWasEmptyLine) {
                return true;
            }
            this.lastMessageWasEmptyLine = true;
        } else {
            this.lastMessageWasEmptyLine = false;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleProperties";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/gradle/execution/test/runner/GradleTestsExecutionConsole";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "print";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "detectUnwantedEmptyLine";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

