/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner.events;

import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.ui.SMTestRunnerResultsForm;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.config.AbstractProperty;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleConsoleProperties;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestLocationCustomizer;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestsExecutionConsole;
import org.jetbrains.plugins.gradle.execution.test.runner.events.TestEvent;

public abstract class AbstractTestEvent
implements TestEvent {
    private final GradleTestsExecutionConsole myExecutionConsole;

    public AbstractTestEvent(GradleTestsExecutionConsole executionConsole) {
        this.myExecutionConsole = executionConsole;
    }

    public GradleTestsExecutionConsole getExecutionConsole() {
        return this.myExecutionConsole;
    }

    protected SMTestRunnerResultsForm getResultsViewer() {
        return this.myExecutionConsole.getResultsViewer();
    }

    protected Project getProject() {
        return this.myExecutionConsole.getProperties().getProject();
    }

    protected GradleConsoleProperties getProperties() {
        return (GradleConsoleProperties)this.getExecutionConsole().getProperties();
    }

    @NotNull
    protected String findLocationUrl(@Nullable String name, @NotNull String fqClassName) {
        if (fqClassName == null) {
            AbstractTestEvent.$$$reportNull$$$0(0);
        }
        String string = name == null ? "java:test://" + fqClassName : "java:test://" + StringUtil.getQualifiedName((String)fqClassName, (String)StringUtil.trimEnd((String)name, (String)"()"));
        if (string == null) {
            AbstractTestEvent.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    protected SMTestProxy findTestProxy(String proxyId) {
        return this.getExecutionConsole().getTestsMap().get(proxyId);
    }

    protected void registerTestProxy(String proxyId, SMTestProxy testProxy) {
        this.myExecutionConsole.getTestsMap().put(proxyId, testProxy);
    }

    protected String decode(String s) {
        return new String(Base64.getDecoder().decode(s), StandardCharsets.UTF_8);
    }

    protected boolean showInternalTestNodes() {
        return GradleConsoleProperties.SHOW_INTERNAL_TEST_NODES.value((AbstractProperty.AbstractPropertyContainer)this.getProperties());
    }

    @NotNull
    protected final String computeLocationUrl(@Nullable SMTestProxy parentProxy, @NotNull String fqClassName, @Nullable String name, @Nullable String displayName) {
        if (fqClassName == null) {
            AbstractTestEvent.$$$reportNull$$$0(2);
        }
        if (parentProxy != null) {
            for (GradleTestLocationCustomizer customizer : GradleTestLocationCustomizer.EP_NAME.getExtensionList()) {
                GradleTestLocationCustomizer.GradleTestLocationInfo location = customizer.getLocationInfo(this.getProject(), parentProxy, fqClassName, name, displayName);
                if (location == null) continue;
                String string = this.findLocationUrl(location.getMethodName(), location.getFqClassName());
                if (string == null) {
                    AbstractTestEvent.$$$reportNull$$$0(3);
                }
                return string;
            }
        }
        String string = this.findLocationUrl(name, fqClassName);
        if (string == null) {
            AbstractTestEvent.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqClassName";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/execution/test/runner/events/AbstractTestEvent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/execution/test/runner/events/AbstractTestEvent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "findLocationUrl";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "computeLocationUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findLocationUrl";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "computeLocationUrl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

